/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.RulerColumnBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class SharedAccessColumn
extends RulerColumnBase {
    public static final int DEFAULT_WIDTH = 90;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_VMARGIN = 2;
    public static final String COLUMN_HEADER = "Shared Access";
    private static Color IDEAL_SHARED_TRANSACTIONS_COLOR = new Color(null, new RGB(0, 255, 0));
    private static Color NON_IDEAL_SHARED_TRANSACTIONS_COLOR = new Color(null, new RGB(255, 0, 0));

    public SharedAccessColumn() {
        this(90);
    }

    public SharedAccessColumn(int width) {
        this.setWidth(width);
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && this.viewer.getSharedTransactions(widgetLine) > 0L) {
            int barBorderY = linePixel + 2;
            int maxWidth = this.getWidth() - 10;
            int height = lineHeight - 4;
            int barWidth = this.getRelativeWidth(widgetLine, maxWidth);
            if (barWidth > 0) {
                int idealWidth = this.getIdealtoAchievedRatio(widgetLine, barWidth);
                gc.setBackground(IDEAL_SHARED_TRANSACTIONS_COLOR);
                gc.fillRectangle(5, barBorderY, idealWidth, height);
                int nonIdealWidth = barWidth - idealWidth;
                if (nonIdealWidth > 0) {
                    gc.setBackground(NON_IDEAL_SHARED_TRANSACTIONS_COLOR);
                    gc.fillRectangle(5 + idealWidth, barBorderY, nonIdealWidth, height);
                }
            }
            gc.setForeground(ViperColors.COLOR_EXEC_COUNT_BACKGROUND);
            gc.drawRectangle(5, barBorderY, maxWidth, height);
            this.drawMarkerAtEnd(widgetLine, gc, this.viewer, this.getWidth() - 1, lineHeight + linePixel, this.getWidth() - 1, barBorderY);
        }
    }

    private int getIdealtoAchievedRatio(int widgetLine, int maxWidth) {
        int barWidth = (int)((double)this.viewer.getTheoreticalSharedTransactions(widgetLine) * (double)maxWidth / (double)this.viewer.getSharedTransactions(widgetLine));
        return barWidth > maxWidth ? maxWidth : barWidth;
    }

    private int getRelativeWidth(int widgetLine, int maxWidth) {
        return (int)((double)this.viewer.getSharedTransactions(widgetLine) * (double)maxWidth / (double)this.viewer.getMaxSharedTransactions());
    }

    @Override
    protected void updateColumn() {
        this.redraw();
    }

    @Override
    public int getColumnIndex() {
        return 4;
    }

    @Override
    protected String getToolTipText(int lineNumber) {
        String tooltipFormat = "Shared Transactions/Access = %s, Ideal Transactions/Access = %s [%d transactions for %d total executions]\n";
        long sharedTransactions = this.viewer.getSharedTransactions(lineNumber);
        long instExecuted = this.viewer.getSharedInstExecuted(lineNumber);
        if (instExecuted > 0L) {
            int trans = (int)(sharedTransactions / instExecuted);
            int idealTrans = (int)(this.viewer.getTheoreticalSharedTransactions(lineNumber) / instExecuted);
            return String.format(tooltipFormat, trans, idealTrans, sharedTransactions, instExecuted);
        }
        return null;
    }

    @Override
    protected boolean isHotspotPresent() {
        return AnalysisResultSourceLevelKind.SHARED_ACCESS_KIND.equals((Object)this.viewer.getCurrentAnnotationKind());
    }
}

