/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.KernelFunctionUnitBusyGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisResultKernelUnitBusy
extends AnalysisResult {
    private final TimelineIntervalKernel kernel;
    private final Map<FunctionUnit, CuptiMetricValueUtilizationLevel> functionUnitBusy;

    public AnalysisResultKernelUnitBusy(TimelineIntervalKernel kernel) {
        super(AnalysisDescriptor.KERNEL_COMPUTE_PIPE_BUSY);
        this.kernel = kernel;
        this.functionUnitBusy = new HashMap<FunctionUnit, CuptiMetricValueUtilizationLevel>();
    }

    public void SetIsPerformanceLimiter(boolean isLimiter) {
        this.desc = !isLimiter ? AnalysisDescriptor.KERNEL_COMPUTE_PIPE_BUSY : AnalysisDescriptor.KERNEL_COMPUTE_PIPE_BUSY_LIMITER;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = String.valueOf(ViperMessages.KernelSM_PipeBusy_Desc) + " " + super.getDescription(otpt);
        Set<FunctionUnit> maxFus = this.getMaxBusyFunctionUnits();
        LinkedList<String> fuStrs = new LinkedList<String>();
        for (FunctionUnit fu : maxFus) {
            fuStrs.add(fu.toString());
        }
        desc = desc.replace("%FU%", StringUtils.join(fuStrs, ","));
        for (FunctionUnit fu : this.getFunctionUnits()) {
            desc = String.valueOf(desc) + "\n\t" + fu.getDescription();
        }
        return desc;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public List<FunctionUnit> getFunctionUnits() {
        LinkedList<FunctionUnit> fus = new LinkedList<FunctionUnit>();
        FunctionUnit[] functionUnitArray = FunctionUnit.getOrderedFunctionUnits();
        int n = functionUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionUnit fu = functionUnitArray[n2];
            if (this.functionUnitBusy.containsKey((Object)fu)) {
                fus.add(fu);
            }
            ++n2;
        }
        return fus;
    }

    public Set<FunctionUnit> getMaxBusyFunctionUnits() {
        int maxCode = 0;
        for (FunctionUnit fu : this.getFunctionUnits()) {
            maxCode = Math.max(maxCode, this.functionUnitBusy.get((Object)fu).getCode());
        }
        HashSet<FunctionUnit> max = new HashSet<FunctionUnit>();
        for (FunctionUnit fu : this.getFunctionUnits()) {
            int code = this.functionUnitBusy.get((Object)fu).getCode();
            if (code < maxCode) continue;
            max.add(fu);
        }
        return max;
    }

    public CuptiMetricValueUtilizationLevel getFunctionUnitMaxBusy() {
        Set<FunctionUnit> maxUnits = this.getMaxBusyFunctionUnits();
        if (maxUnits.isEmpty()) {
            return CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_IDLE;
        }
        return this.getFunctionUnitBusy(maxUnits.iterator().next());
    }

    public CuptiMetricValueUtilizationLevel getFunctionUnitBusy(FunctionUnit fu) {
        CuptiMetricValueUtilizationLevel busy = this.functionUnitBusy.get((Object)fu);
        return busy == null ? CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_IDLE : busy;
    }

    public void setFunctionUnitBusy(FunctionUnit fu, CuptiMetricValueUtilizationLevel busy) {
        this.functionUnitBusy.put(fu, busy);
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelFunctionUnitBusyGraphicFactory();
    }

    public static enum FunctionUnit {
        CF("Control-Flow", ViperMessages.KernelSM_PipeBusy_ControlFlowDesc, "cf_fu_utilization"),
        LDST("Load/Store", ViperMessages.KernelSM_PipeBusy_LdStDesc, "ldst_fu_utilization"),
        ALU("Arithmetic", ViperMessages.KernelSM_PipeBusy_ALUDesc, "alu_fu_utilization"),
        TEX("Texture", ViperMessages.KernelSM_PipeBusy_TextureDesc, "tex_fu_utilization"),
        LDST5("Load/Store", ViperMessages.KernelSM_PipeBusy_LdSt5Desc, "ldst_fu_utilization"),
        TEX5("Texture", ViperMessages.KernelSM_PipeBusy_Texture5Desc, "tex_fu_utilization"),
        SPECIAL("Special", ViperMessages.KernelSM_PipeBusy_SpecialDesc, "special_fu_utilization"),
        SINGLE("Single", ViperMessages.KernelSM_PipeBusy_SingleDesc, "single_precision_fu_utilization"),
        DOUBLE("Double", ViperMessages.KernelSM_PipeBusy_DoubleDesc, "double_precision_fu_utilization"),
        HALF("Half", ViperMessages.KernelSM_PipeBusy_HalfDesc, "half_precision_fu_utilization");

        private final String name;
        private final String desc;
        private final String utilMetricName;

        private FunctionUnit(String name, String desc, String utilMetricName) {
            this.name = name;
            this.desc = desc;
            this.utilMetricName = utilMetricName;
        }

        public String getUtilizationMetricName() {
            return this.utilMetricName;
        }

        public String getLegendName() {
            return "(" + this.name + ")";
        }

        public String toString() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean isMemory() {
            switch (this) {
                case LDST: 
                case TEX: 
                case LDST5: 
                case TEX5: {
                    return true;
                }
            }
            return false;
        }

        public AnalysisResultKernelBounds.MemBound getMemoryBound() {
            switch (this) {
                case TEX: 
                case TEX5: {
                    return AnalysisResultKernelBounds.MemBound.TEXUNIT;
                }
                case LDST: 
                case LDST5: {
                    return AnalysisResultKernelBounds.MemBound.LDSTUNIT;
                }
            }
            return AnalysisResultKernelBounds.MemBound.UNKNOWN;
        }

        public static FunctionUnit[] getFunctionUnits(int major, int minor) {
            if (major > 5 || major == 5 && minor == 3) {
                return new FunctionUnit[]{LDST5, TEX5, SINGLE, DOUBLE, SPECIAL, CF, HALF};
            }
            if (major == 5) {
                return new FunctionUnit[]{LDST5, TEX5, SINGLE, DOUBLE, SPECIAL, CF};
            }
            return new FunctionUnit[]{LDST, ALU, CF, TEX};
        }

        public static FunctionUnit[] getOrderedFunctionUnits() {
            return new FunctionUnit[]{LDST, LDST5, TEX5, ALU, HALF, SINGLE, DOUBLE, SPECIAL, CF, TEX};
        }
    }
}

