/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.ITimelineInterval;

public class CuptiActivitySourceLevelResultBase
extends CuptiActivityBase
implements ICuptiActivity,
ICuptiActivitySourceLevelResult {
    protected int sourceLocatorId;
    protected int correlationId;
    public int functionId;
    public int pcOffset;
    public int executed;
    public long threadsExecuted;

    public CuptiActivitySourceLevelResultBase() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivitySourceLevelResultBase(ITimelineInterval interval, boolean isNull) {
        this();
        if (isNull && interval.getPrimaryCorrelationId() != 0) {
            this.sourceLocatorId = 0;
            this.correlationId = interval.getPrimaryCorrelationId();
            this.functionId = 0;
            this.pcOffset = 0;
            this.executed = 0;
            this.threadsExecuted = 0L;
        }
    }

    @Override
    public boolean isNullResult() {
        return this.sourceLocatorId == 0 && this.pcOffset == 0 && this.executed == 0 && this.threadsExecuted == 0L && this.functionId == 0;
    }

    @Override
    public int getSourceLocatorId() {
        return this.sourceLocatorId;
    }

    @Override
    public void setSourceLocatorId(int id) {
        this.sourceLocatorId = id;
    }

    @Override
    public int getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(int id) {
        this.correlationId = id;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    @Override
    public int getFunctionId() {
        return this.functionId;
    }

    @Override
    public void setFunctionId(int id) {
        this.functionId = id;
    }

    @Override
    public long getPcOffset() {
        return this.pcOffset;
    }
}

