/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.timeFunction;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.timefunction.IParallelPeriod;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimeFunctionCreatorEngine;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.timeFunction.BaseTimeFunction;
import org.eclipse.birt.report.data.adapter.api.timeFunction.IArgumentInfo;
import org.eclipse.birt.report.data.adapter.api.timeFunction.ITimeFunction;
import org.eclipse.birt.report.data.adapter.api.timeFunction.TimeFunctionHandle;
import org.eclipse.birt.report.data.adapter.i18n.Message;
import org.eclipse.birt.report.model.api.CalculationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;

public class TimeFunctionManager {
    private static int[] quarterDay = new int[]{31, 30, 31, 31};
    private static int[] monthDay = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static List<ITimeFunction> getCalculationTypes(DimensionHandle dim, List<String> timeLevelsInXtab, boolean isStaticReferenceDate, ULocale locale) {
        ArrayList<ITimeFunction> availableFunctions = new ArrayList<ITimeFunction>();
        ArrayList<String> timeType = new ArrayList<String>();
        if (dim != null && dim.isTimeType()) {
            String startingLevels = null;
            if (!timeLevelsInXtab.isEmpty() && !isStaticReferenceDate) {
                startingLevels = timeLevelsInXtab.get(0).toString();
            }
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)dim.getDefaultHierarchy();
            List levels = hierhandle.getContents("levels");
            int i = 0;
            int j = 0;
            while (i < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(i);
                if (startingLevels != null && level.getName().equals(startingLevels) && !level.getDateTimeLevelType().equalsIgnoreCase("year")) {
                    return availableFunctions;
                }
                if (timeLevelsInXtab.isEmpty() || isStaticReferenceDate) {
                    timeType.add(level.getDateTimeLevelType());
                } else if (level.getName().equals(timeLevelsInXtab.get(j))) {
                    timeType.add(level.getDateTimeLevelType());
                    if (++j >= timeLevelsInXtab.size()) break;
                }
                ++i;
            }
            if (!timeType.contains("year")) {
                return availableFunctions;
            }
        } else {
            return availableFunctions;
        }
        ArrayList<IArgumentInfo.Period_Type> periodType = new ArrayList<IArgumentInfo.Period_Type>();
        ArrayList<IArgumentInfo.Period_Type> periodToDateType = new ArrayList<IArgumentInfo.Period_Type>();
        TimeFunctionHandle handle = TimeFunctionHandle.getInstance(locale);
        if (timeType.contains("year")) {
            availableFunctions.add(handle.getFunction("CURRENT YEAR"));
            availableFunctions.add(handle.getFunction("PREVIOUS YEAR"));
            availableFunctions.add(handle.getFunction("PREVIOUS YEAR TO DATE"));
            availableFunctions.add(handle.getFunction("YEAR TO DATE"));
            periodType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.YEAR, locale));
            periodToDateType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.YEAR, locale, true));
        }
        if (timeType.contains("quarter") || timeType.contains("week-of-year") || timeType.contains("day-of-year")) {
            availableFunctions.add(handle.getFunction("CURRENT QUARTER"));
            availableFunctions.add(handle.getFunction("PREVIOUS QUARTER"));
            availableFunctions.add(handle.getFunction("PREVIOUS QUARTER TO DATE"));
            availableFunctions.add(handle.getFunction("QUARTER TO DATE"));
            availableFunctions.add(handle.getFunction("QUARTER TO DATE LAST YEAR"));
            periodType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.QUARTER, locale));
            periodToDateType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.QUARTER, locale, true));
        }
        if (timeType.contains("month") || timeType.contains("week-of-year") || timeType.contains("day-of-year")) {
            availableFunctions.add(handle.getFunction("CURRENT MONTH"));
            availableFunctions.add(handle.getFunction("PREVIOUS MONTH"));
            availableFunctions.add(handle.getFunction("PREVIOUS MONTH TO DATE"));
            availableFunctions.add(handle.getFunction("MONTH TO DATE"));
            availableFunctions.add(handle.getFunction("MONTH TO DATE LAST YEAR"));
            availableFunctions.add(handle.getFunction("TRAILING N MONTHS"));
            periodType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.MONTH, locale));
            periodToDateType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.MONTH, locale, true));
        }
        if (timeLevelsInXtab.isEmpty() && timeType.contains("week-of-year")) {
            availableFunctions.add(handle.getFunction("WEEK TO DATE"));
            availableFunctions.add(handle.getFunction("PREVIOUS WEEK TO DATE"));
            availableFunctions.add(handle.getFunction("WEEK TO DATE LAST YEAR"));
            periodType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.WEEK, locale));
            periodToDateType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.WEEK, locale, true));
        }
        if (timeType.contains("day-of-year")) {
            availableFunctions.add(handle.getFunction("TRAILING N DAYS"));
            periodType.add(new IArgumentInfo.Period_Type(IArgumentInfo.Period_Type.Period_Type_ENUM.DAY, locale));
        }
        availableFunctions.add(new BaseTimeFunction(handle.getFunction("CURRENT PERIOD FROM N PERIODS AGO"), periodType));
        availableFunctions.add(new BaseTimeFunction(handle.getFunction("PERIOD TO DATE FROM N PERIODS AGO"), periodToDateType, periodType));
        availableFunctions.add(new BaseTimeFunction(handle.getFunction("TRAILING N PERIODS FROM N PERIODS AGO"), periodType));
        availableFunctions.add(new BaseTimeFunction(handle.getFunction("NEXT_N_PERIODS"), periodType));
        return availableFunctions;
    }

    public static List<ITimeFunction> getCalculationTypes(DimensionHandle dim, List<String> timeLevelsInXtab, boolean isStaticReferenceDate) {
        return TimeFunctionManager.getCalculationTypes(dim, timeLevelsInXtab, isStaticReferenceDate, ULocale.getDefault());
    }

    public static ITimeFunction getCalculationType(String name, ULocale locale) {
        TimeFunctionHandle handle = TimeFunctionHandle.getInstance(locale);
        if ("CURRENT QUARTER".equals(name)) {
            return handle.getFunction("CURRENT QUARTER");
        }
        if ("CURRENT MONTH".equals(name)) {
            return handle.getFunction("CURRENT MONTH");
        }
        if ("PREVIOUS MONTH".equals(name)) {
            return handle.getFunction("PREVIOUS MONTH");
        }
        if ("PREVIOUS WEEK TO DATE".equals(name)) {
            return handle.getFunction("PREVIOUS WEEK TO DATE");
        }
        if ("PREVIOUS MONTH TO DATE".equals(name)) {
            return handle.getFunction("PREVIOUS MONTH TO DATE");
        }
        if ("PREVIOUS QUARTER".equals(name)) {
            return handle.getFunction("PREVIOUS QUARTER");
        }
        if ("PREVIOUS QUARTER TO DATE".equals(name)) {
            return handle.getFunction("PREVIOUS QUARTER TO DATE");
        }
        if ("PREVIOUS YEAR".equals(name)) {
            return handle.getFunction("PREVIOUS YEAR");
        }
        if ("PREVIOUS QUARTER TO DATE".equals(name)) {
            return handle.getFunction("PREVIOUS QUARTER TO DATE");
        }
        if ("PREVIOUS YEAR".equals(name)) {
            return handle.getFunction("PREVIOUS YEAR");
        }
        if ("TRAILING 30 DAYS".equals(name)) {
            return handle.getFunction("TRAILING 30 DAYS");
        }
        if ("TRAILING 60 DAYS".equals(name)) {
            return handle.getFunction("TRAILING 60 DAYS");
        }
        if ("TRAILING 90 DAYS".equals(name)) {
            return handle.getFunction("TRAILING 90 DAYS");
        }
        if ("TRAILING 120 DAYS".equals(name)) {
            return handle.getFunction("TRAILING 120 DAYS");
        }
        if ("TRAILING 12 MONTHS".equals(name)) {
            return handle.getFunction("TRAILING 12 MONTHS");
        }
        if ("YEAR TO DATE".equals(name)) {
            return handle.getFunction("YEAR TO DATE");
        }
        if ("QUARTER TO DATE".equals(name)) {
            return handle.getFunction("QUARTER TO DATE");
        }
        if ("MONTH TO DATE".equals(name)) {
            return handle.getFunction("MONTH TO DATE");
        }
        if ("PREVIOUS YEAR TO DATE".equals(name)) {
            return handle.getFunction("PREVIOUS YEAR TO DATE");
        }
        if ("MONTH TO DATE LAST YEAR".equals(name)) {
            return handle.getFunction("MONTH TO DATE LAST YEAR");
        }
        if ("WEEK TO DATE LAST YEAR".equals(name)) {
            return handle.getFunction("WEEK TO DATE LAST YEAR");
        }
        if ("QUARTER TO DATE LAST YEAR".equals(name)) {
            return handle.getFunction("QUARTER TO DATE LAST YEAR");
        }
        if ("CURRENT YEAR".equals(name)) {
            return handle.getFunction("CURRENT YEAR");
        }
        if ("WEEK TO DATE".equals(name)) {
            return handle.getFunction("WEEK TO DATE");
        }
        if ("CURRENT PERIOD FROM N PERIODS AGO".equals(name)) {
            return handle.getFunction("CURRENT PERIOD FROM N PERIODS AGO");
        }
        if ("PERIOD TO DATE FROM N PERIODS AGO".equals(name)) {
            return handle.getFunction("PERIOD TO DATE FROM N PERIODS AGO");
        }
        if ("TRAILING N MONTHS".equals(name)) {
            return handle.getFunction("TRAILING N MONTHS");
        }
        if ("TRAILING N DAYS".equals(name)) {
            return handle.getFunction("TRAILING N DAYS");
        }
        if ("TRAILING N PERIODS FROM N PERIODS AGO".equals(name)) {
            return handle.getFunction("TRAILING N PERIODS FROM N PERIODS AGO");
        }
        if ("NEXT_N_PERIODS".equals(name)) {
            return handle.getFunction("NEXT_N_PERIODS");
        }
        return null;
    }

    public static ITimeFunction getCalculationType(String name) {
        return TimeFunctionManager.getCalculationType(name, ULocale.getDefault());
    }

    public static String[] getTimeType(ComputedColumnHandle handle) {
        if (handle == null) {
            return null;
        }
        String calculationType = handle.getCalculationType();
        if (calculationType == null) {
            return null;
        }
        if ("CURRENT YEAR".equals(calculationType) || "PREVIOUS YEAR".equals(calculationType) || "PREVIOUS YEAR TO DATE".equals(calculationType) || "YEAR TO DATE".equals(calculationType)) {
            return new String[]{"year"};
        }
        if ("CURRENT QUARTER".equals(calculationType) || "PREVIOUS QUARTER".equals(calculationType) || "PREVIOUS QUARTER TO DATE".equals(calculationType) || "QUARTER TO DATE".equals(calculationType) || "QUARTER TO DATE LAST YEAR".equals(calculationType)) {
            return new String[]{"quarter"};
        }
        if ("CURRENT MONTH".equals(calculationType) || "PREVIOUS MONTH".equals(calculationType) || "PREVIOUS MONTH TO DATE".equals(calculationType) || "MONTH TO DATE".equals(calculationType) || "TRAILING 12 MONTHS".equals(calculationType) || "MONTH TO DATE LAST YEAR".equals(calculationType) || "TRAILING N MONTHS".equals(calculationType)) {
            return new String[]{"month"};
        }
        if ("TRAILING 30 DAYS".equals(calculationType) || "TRAILING 60 DAYS".equals(calculationType) || "TRAILING 90 DAYS".equals(calculationType) || "TRAILING 120 DAYS".equals(calculationType) || "TRAILING N DAYS".equals(calculationType)) {
            return new String[]{"day-of-year"};
        }
        if ("WEEK TO DATE".equals(calculationType) || "PREVIOUS WEEK TO DATE".equals(calculationType) || "WEEK TO DATE LAST YEAR".equals(calculationType)) {
            return new String[]{"week-of-year"};
        }
        if ("CURRENT PERIOD FROM N PERIODS AGO".equals(calculationType)) {
            Iterator iter = handle.calculationArgumentsIterator();
            String period1 = null;
            String period2 = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if ("Period1".equals(argument.getName())) {
                    period1 = argument.getValue().getStringExpression();
                }
                if (!"Period2".equals(argument.getName())) continue;
                period2 = argument.getValue().getStringExpression();
            }
            return new String[]{DataAdapterUtil.toModelTimeType(DataAdapterUtil.toTimePeriodType(period1)), DataAdapterUtil.toModelTimeType(DataAdapterUtil.toTimePeriodType(period2))};
        }
        if ("PERIOD TO DATE FROM N PERIODS AGO".equals(calculationType) || "PERIOD TO DATE FROM N PERIODS AGO".equals(calculationType) || "TRAILING N PERIODS FROM N PERIODS AGO".equals(calculationType)) {
            Iterator iter = handle.calculationArgumentsIterator();
            String period1 = null;
            String period2 = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if ("Period1".equals(argument.getName())) {
                    period1 = argument.getValue().getStringExpression();
                }
                if (!"Period2".equals(argument.getName())) continue;
                period2 = argument.getValue().getStringExpression();
            }
            return new String[]{DataAdapterUtil.toModelTimeType(DataAdapterUtil.toTimePeriodType(period1)), DataAdapterUtil.toModelTimeType(DataAdapterUtil.toTimePeriodType(period2))};
        }
        if ("NEXT_N_PERIODS".equals(calculationType)) {
            Iterator iter = handle.calculationArgumentsIterator();
            String period1 = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"Period1".equals(argument.getName())) continue;
                period1 = argument.getValue().getStringExpression();
            }
            return new String[]{DataAdapterUtil.toModelTimeType(DataAdapterUtil.toTimePeriodType(period1))};
        }
        return new String[0];
    }

    private static int[] getValueFromCal(Calendar cal, String[] levelTypes) {
        int[] tmp = new int[levelTypes.length];
        int i = 0;
        while (i < levelTypes.length) {
            if (levelTypes[i].equals("year")) {
                tmp[i] = cal.get(1);
            } else if (levelTypes[i].equals("quarter")) {
                tmp[i] = cal.get(2) / 3 + 1;
            } else if (levelTypes[i].equals("month")) {
                tmp[i] = cal.get(2) + 1;
            } else if (levelTypes[i].equals("week-of-month")) {
                tmp[i] = cal.get(4);
            } else if (levelTypes[i].equals("week-of-year")) {
                tmp[i] = cal.get(3);
            } else if (levelTypes[i].equals("day-of-week")) {
                tmp[i] = cal.get(7);
            } else if (levelTypes[i].equals("day-of-month")) {
                tmp[i] = cal.get(5);
            } else if (levelTypes[i].equals("day-of-year")) {
                tmp[i] = cal.get(6);
            }
            ++i;
        }
        return tmp;
    }

    public static String getTooltipForTimeFunction(ComputedColumnHandle column, ULocale locale) throws BirtException {
        String desc = null;
        DataRequestSession session = DataRequestSession.newSession(new DataSessionContext(3));
        IBinding functionBinding = session.getModelAdaptor().adaptBinding(column);
        session.shutdown();
        if (functionBinding == null) {
            return TimeFunctionManager.getCalculationType(column.getCalculationType(), locale).getDisplayName();
        }
        ITimePeriod basePeriod = functionBinding.getTimeFunction().getBaseTimePeriod();
        ITimePeriod relativePeriod = functionBinding.getTimeFunction().getRelativeTimePeriod();
        java.util.Date date = functionBinding.getTimeFunction().getReferenceDate().getDate();
        Calendar cal = Calendar.getInstance((ULocale)locale);
        cal.setTime(date);
        int[] values = new int[3];
        String[] levelTypes = new String[]{"year", "month", "day-of-month"};
        values = TimeFunctionManager.getValueFromCal(cal, levelTypes);
        TimeMember member = new TimeMember(values, levelTypes);
        DesignElementHandle dHandle = column.getElementHandle();
        DimensionHandle dim = ((ReportItemHandle)dHandle).getCube().getDimension(functionBinding.getTimeFunction().getTimeDimension());
        int levelCount = dim.getDefaultHierarchy().getLevelCount();
        String type = dim.getDefaultHierarchy().getLevel(levelCount - 1).getDateTimeLevelType();
        IPeriodsFunction periodsFunction = null;
        String toDatelevelType = null;
        String paralevelType = null;
        toDatelevelType = TimeFunctionManager.toLevelType(basePeriod.getType());
        boolean reverse = false;
        if (basePeriod.countOfUnit() == 0) {
            periodsFunction = TimeFunctionCreatorEngine.newTimeFunctionCreator().createPeriodsToDateFunction(toDatelevelType, basePeriod.isCurrent());
        } else {
            periodsFunction = TimeFunctionCreatorEngine.newTimeFunctionCreator().createTrailingFunction(toDatelevelType, basePeriod.countOfUnit());
            if (basePeriod.countOfUnit() < 0) {
                reverse = true;
            }
        }
        List list = null;
        if (relativePeriod != null) {
            paralevelType = TimeFunctionManager.toLevelType(relativePeriod.getType());
            IParallelPeriod parallelPeriod = TimeFunctionCreatorEngine.newTimeFunctionCreator().createParallelPeriodFunction(paralevelType, relativePeriod.countOfUnit());
            list = periodsFunction.getResult(parallelPeriod.getResult(member));
        } else {
            list = periodsFunction.getResult(member);
        }
        TimeMember memberFrom = null;
        TimeMember memberTo = null;
        TimeMember tmpMember1 = null;
        TimeMember tmpMember2 = null;
        if (reverse) {
            tmpMember1 = (TimeMember)list.get(list.size() - 1);
            tmpMember2 = (TimeMember)list.get(0);
        } else {
            tmpMember1 = (TimeMember)list.get(0);
            tmpMember2 = (TimeMember)list.get(list.size() - 1);
        }
        int[] valuesFrom = (int[])tmpMember1.getMemberValue().clone();
        int[] valuesTo = (int[])tmpMember2.getMemberValue().clone();
        cal.clear();
        if (type.equals("year")) {
            valuesFrom[1] = 1;
            valuesFrom[2] = 2;
            valuesTo[1] = 12;
            valuesTo[2] = 31;
        } else if (type.equals("quarter")) {
            int quarter = (valuesFrom[1] - 1) / 3 + 1;
            valuesFrom[1] = (quarter - 1) * 3 + 1;
            valuesFrom[2] = 1;
            quarter = (valuesTo[1] - 1) / 3 + 1;
            valuesTo[1] = quarter * 3;
            valuesTo[2] = quarterDay[quarter - 1];
        } else if (type.equals("month")) {
            valuesFrom[2] = 1;
            valuesTo[2] = valuesTo[1] == 2 && ((GregorianCalendar)cal).isLeapYear(valuesTo[0]) ? 29 : monthDay[valuesTo[1] - 1];
        } else if (type.equals("week-of-month") || type.equals("week-of-year")) {
            cal.set(1, valuesFrom[0]);
            cal.set(2, valuesFrom[1] - 1);
            cal.set(5, valuesFrom[2]);
            int dayofweek = cal.get(7);
            cal.add(7, 1 - dayofweek);
            valuesFrom[0] = cal.get(1);
            valuesFrom[1] = cal.get(2) + 1;
            valuesFrom[2] = cal.get(5);
            cal.clear();
            cal.set(1, valuesTo[0]);
            cal.set(2, valuesTo[1] - 1);
            cal.set(5, valuesTo[2]);
            dayofweek = cal.get(7);
            cal.add(7, 7 - dayofweek);
            valuesTo[0] = cal.get(1);
            valuesTo[1] = cal.get(2) + 1;
            valuesTo[2] = cal.get(5);
        }
        memberFrom = new TimeMember(valuesFrom, (String[])levelTypes.clone());
        memberTo = new TimeMember(valuesTo, (String[])levelTypes.clone());
        desc = TimeFunctionManager.constructTimeFunctionToolTip(memberFrom, memberTo, TimeFunctionManager.getCalculationType(column.getCalculationType(), locale).getDisplayName(), locale);
        return desc;
    }

    private static String constructTimeFunctionToolTip(TimeMember from, TimeMember to, String funcName, ULocale locale) throws BirtException {
        StringBuffer result = new StringBuffer("");
        result.append(funcName).append(" ( ");
        result.append(TimeFunctionManager.getFormattedDateStringFromTimeMember(from, locale));
        result.append(" ").append(Message.getMessage("timeFunction.toolTip.to", locale)).append(" ");
        result.append(TimeFunctionManager.getFormattedDateStringFromTimeMember(to, locale));
        result.append(" )");
        return result.toString();
    }

    private static String getFormattedDateStringFromTimeMember(TimeMember member, ULocale locale) throws BirtException {
        Calendar calendar = Calendar.getInstance((ULocale)locale);
        calendar.clear();
        calendar.set(1, member.getMemberValue()[0]);
        calendar.set(2, member.getMemberValue()[1] - 1);
        calendar.set(5, member.getMemberValue()[2]);
        Date date = DataTypeUtil.toSqlDate((Object)calendar.getTime());
        DateFormatter formatter = new DateFormatter(locale);
        return formatter.format((java.util.Date)date);
    }

    private static String toLevelType(TimePeriodType timePeriodType) {
        if (timePeriodType == TimePeriodType.YEAR) {
            return "year";
        }
        if (timePeriodType == TimePeriodType.QUARTER) {
            return "quarter";
        }
        if (timePeriodType == TimePeriodType.MONTH) {
            return "month";
        }
        if (timePeriodType == TimePeriodType.WEEK) {
            return "week-of-year";
        }
        if (timePeriodType == TimePeriodType.DAY) {
            return "day-of-month";
        }
        return null;
    }
}

