/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class UNCPathConverterImpl
extends UNCPathConverter {
    private static String CLASS_ATTRIBUTE = "class";
    private static String EXTENSION_POINT = "org.eclipse.cdt.core.UNCPathConverter";
    private static UNCPathConverterImpl fInstance = new UNCPathConverterImpl();
    private volatile List<UNCPathConverter> fUNCPathConverters = null;

    public static UNCPathConverterImpl getInstance() {
        return fInstance;
    }

    private UNCPathConverterImpl() {
    }

    private void loadUNCPathConverters() {
        if (this.fUNCPathConverters == null) {
            ArrayList<UNCPathConverter> list = new ArrayList<UNCPathConverter>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
            if (extensionPoint != null) {
                IExtension[] iExtensionArray = extensionPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement ce = iConfigurationElementArray[n4];
                        if (ce.getAttribute(CLASS_ATTRIBUTE) != null) {
                            try {
                                UNCPathConverter converter = (UNCPathConverter)ce.createExecutableExtension(CLASS_ATTRIBUTE);
                                list.add(converter);
                            }
                            catch (Exception e) {
                                CCorePlugin.log(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            this.fUNCPathConverters = list;
        }
    }

    @Override
    public URI toURI(IPath path) {
        if (path.isUNC()) {
            this.loadUNCPathConverters();
            for (UNCPathConverter converter : this.fUNCPathConverters) {
                URI uri = converter.toURI(path);
                if (uri == null) continue;
                return uri;
            }
        }
        return URIUtil.toURI((IPath)path);
    }

    @Override
    public URI toURI(String path) {
        if (UNCPathConverterImpl.isUNC(path)) {
            this.loadUNCPathConverters();
            for (UNCPathConverter converter : this.fUNCPathConverters) {
                URI uri = converter.toURI(path);
                if (uri == null) continue;
                return uri;
            }
        }
        return URIUtil.toURI((String)path);
    }

    public static /* bridge */ /* synthetic */ UNCPathConverter getInstance() {
        return UNCPathConverterImpl.getInstance();
    }
}

