/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassMemberChecker;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.GetAnnotationChecker;
import proguard.GetEnclosingClassChecker;
import proguard.GetEnclosingMethodChecker;
import proguard.GetSignatureChecker;
import proguard.KeepClassSpecification;
import proguard.LibraryKeepChecker;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.EnumFieldReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.EmptyStringMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class Initializer {
    private final Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        int n15 = classPool2.size();
        WarningPrinter warningPrinter = new WarningPrinter(System.out, this.configuration.note);
        FullyQualifiedClassNameChecker fullyQualifiedClassNameChecker = new FullyQualifiedClassNameChecker(classPool, classPool2, warningPrinter);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.keep);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoExternalSideEffects);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoEscapingParameters);
        fullyQualifiedClassNameChecker.checkClassSpecifications(this.configuration.assumeNoExternalReturnValues);
        EmptyStringMatcher emptyStringMatcher = this.configuration.keepAttributes != null ? new ListParser(new NameParser()).parse(this.configuration.keepAttributes) : new EmptyStringMatcher();
        WarningPrinter warningPrinter2 = new WarningPrinter(System.out, this.configuration.note);
        if (!emptyStringMatcher.matches("RuntimeVisibleAnnotations")) {
            classPool.classesAccept(new AllConstantVisitor(new GetAnnotationChecker(warningPrinter2)));
        }
        WarningPrinter warningPrinter3 = new WarningPrinter(System.out, this.configuration.note);
        if (!emptyStringMatcher.matches("Signature")) {
            classPool.classesAccept(new AllConstantVisitor(new GetSignatureChecker(warningPrinter3)));
        }
        WarningPrinter warningPrinter4 = new WarningPrinter(System.out, this.configuration.note);
        if (!emptyStringMatcher.matches("InnerClasses")) {
            classPool.classesAccept(new AllConstantVisitor(new GetEnclosingClassChecker(warningPrinter4)));
        }
        WarningPrinter warningPrinter5 = new WarningPrinter(System.out, this.configuration.note);
        if (!emptyStringMatcher.matches("EnclosingMethod")) {
            classPool.classesAccept(new AllConstantVisitor(new GetEnclosingMethodChecker(warningPrinter5)));
        }
        ClassPool classPool3 = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningPrinter warningPrinter6 = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter7 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter6, null));
        classPool2.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, null, warningPrinter7));
        WarningPrinter warningPrinter8 = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter9 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassReferenceInitializer(classPool, classPool2, warningPrinter6, warningPrinter8, warningPrinter9, null));
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassPoolFiller(classPool3))));
            classPool3.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter6, null));
        }
        classPool.classesAccept(new AllAttributeVisitor(true, new AllElementValueVisitor(true, new EnumFieldReferenceInitializer())));
        WarningPrinter warningPrinter10 = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter11 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicClassReferenceInitializer(classPool, classPool2, warningPrinter10, null, warningPrinter11, this.createClassNoteExceptionMatcher(this.configuration.keep, true))))));
        WarningPrinter warningPrinter12 = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter13 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DynamicMemberReferenceInitializer(classPool, classPool2, warningPrinter13, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false)))));
        if (this.configuration.adaptClassStrings != null) {
            classPool.classesAccept(new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor(new StringReferenceInitializer(classPool, classPool2))));
        }
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool3))))));
            classPool3.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, null, warningPrinter7));
            classPool2.clear();
            classPool3.classesAccept(new MultiClassVisitor(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2))), new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2)))))));
        } else {
            classPool2.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, null, warningPrinter7));
        }
        classPool.classesAccept(new ClassSubHierarchyInitializer());
        classPool2.classesAccept(new ClassSubHierarchyInitializer());
        classPool.classesAccept(new StringSharer());
        classPool2.classesAccept(new StringSharer());
        WarningPrinter warningPrinter14 = new WarningPrinter(System.out, this.configuration.note);
        ClassMemberChecker classMemberChecker = new ClassMemberChecker(classPool, warningPrinter14);
        classMemberChecker.checkClassSpecifications(this.configuration.keep);
        classMemberChecker.checkClassSpecifications(this.configuration.assumeNoSideEffects);
        classMemberChecker.checkClassSpecifications(this.configuration.assumeNoExternalSideEffects);
        classMemberChecker.checkClassSpecifications(this.configuration.assumeNoEscapingParameters);
        classMemberChecker.checkClassSpecifications(this.configuration.assumeNoExternalReturnValues);
        WarningPrinter warningPrinter15 = new WarningPrinter(System.out, this.configuration.note);
        new DescriptorKeepChecker(classPool, classPool2, warningPrinter15).checkClassSpecifications(this.configuration.keep);
        WarningPrinter warningPrinter16 = new WarningPrinter(System.out, this.configuration.note);
        new LibraryKeepChecker(classPool, classPool2, warningPrinter16).checkClassSpecifications(this.configuration.keep);
        int n16 = warningPrinter.getWarningCount();
        if (n16 > 0) {
            System.out.println("Note: there were " + n16 + " references to unknown classes.");
            System.out.println("      You should check your configuration for typos.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#unknownclass)");
        }
        if ((n14 = warningPrinter14.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n14 + " references to unknown class members.");
            System.out.println("      You should check your configuration for typos.");
        }
        if ((n13 = warningPrinter2.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n13 + " classes trying to access annotations using reflection.");
            System.out.println("      You should consider keeping the annotation attributes");
            System.out.println("      (using '-keepattributes *Annotation*').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((n12 = warningPrinter3.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n12 + " classes trying to access generic signatures using reflection.");
            System.out.println("      You should consider keeping the signature attributes");
            System.out.println("      (using '-keepattributes Signature').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((n11 = warningPrinter4.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n11 + " classes trying to access enclosing classes using reflection.");
            System.out.println("      You should consider keeping the inner classes attributes");
            System.out.println("      (using '-keepattributes InnerClasses').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((n10 = warningPrinter5.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n10 + " classes trying to access enclosing methods using reflection.");
            System.out.println("      You should consider keeping the enclosing method attributes");
            System.out.println("      (using '-keepattributes InnerClasses,EnclosingMethod').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#attributes)");
        }
        if ((n9 = warningPrinter15.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n9 + " unkept descriptor classes in kept class members.");
            System.out.println("      You should consider explicitly keeping the mentioned classes");
            System.out.println("      (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#descriptorclass)");
        }
        if ((n8 = warningPrinter16.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n8 + " library classes explicitly being kept.");
            System.out.println("      You don't need to keep library classes; they are already left unchanged.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#libraryclass)");
        }
        if ((n7 = warningPrinter10.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n7 + " unresolved dynamic references to classes or interfaces.");
            System.out.println("      You should check if you need to specify additional program jars.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclass)");
        }
        if ((n6 = warningPrinter11.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n6 + " class casts of dynamically created class instances.");
            System.out.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.out.println("      their implementations (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclasscast)");
        }
        if ((n5 = warningPrinter13.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n5 + " accesses to class members by means of introspection.");
            System.out.println("      You should consider explicitly keeping the mentioned class members");
            System.out.println("      (using '-keep' or '-keepclassmembers').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclassmember)");
        }
        if ((n4 = warningPrinter6.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n4 + " unresolved references to classes or interfaces.");
            System.err.println("         You may need to add missing library jars or update their versions.");
            System.err.println("         If your code works fine without the missing classes, you can suppress");
            System.err.println("         the warnings with '-dontwarn' options.");
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedclass)");
        }
        if ((n3 = warningPrinter7.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n3 + " instances of library classes depending on program classes.");
            System.err.println("         You must avoid such dependencies, since the program classes will");
            System.err.println("         be processed, while the library classes will remain unchanged.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#dependency)");
        }
        if ((n2 = warningPrinter8.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n2 + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile the code.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedprogramclassmember)");
        }
        if ((n = warningPrinter9.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to library class members.");
            System.err.println("         You probably need to update the library versions.");
            if (!this.configuration.skipNonPublicLibraryClassMembers) {
                System.err.println("         Alternatively, you may have to specify the option ");
                System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
            }
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedlibraryclassmember)");
        }
        if (!(n4 <= 0 && n3 <= 0 && n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            System.out.println("Note: you're ignoring all warnings!");
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + n15);
            System.out.println("  Final number of library classes:    " + classPool2.size());
        }
    }

    private StringMatcher createClassNoteExceptionMatcher(List list, boolean bl) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                if (!keepClassSpecification.markClasses && bl) continue;
                String string2 = keepClassSpecification.className;
                if (string2 != null && !Initializer.containsWildCardReferences(string2)) {
                    arrayList.add(string2);
                }
                if ((string = keepClassSpecification.extendsClassName) == null || Initializer.containsWildCardReferences(string)) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(arrayList);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List list, boolean bl) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                List list2;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                List list3 = list2 = bl ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (list2 == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    MemberSpecification memberSpecification = (MemberSpecification)list2.get(j);
                    String string = memberSpecification.name;
                    if (string == null || Initializer.containsWildCardReferences(string)) continue;
                    arrayList.add(string);
                }
            }
            if (arrayList.size() > 0) {
                return new ListParser(new NameParser()).parse(arrayList);
            }
        }
        return null;
    }

    private static boolean containsWildCardReferences(String string) {
        int n = string.indexOf(60);
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(62, n + 1);
        if (n2 < 0) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

