/*
 * Copyright status: this file is in the public domain.
 *
 * Beware.  These values are known elsewhere.  Specifically,
 *
 * - editicon.c has ICON_W/ICON_H/ICON_SW/ICON_SH, which control the
 *  sizes of the icons it generates; they must match the PIC_W, PIC_H,
 *  PIC_SH, and PIC_SW defines here.
 *
 * - The number of colours and pictures and the order of the pictures
 *  are not known in code elsewhere, but they are "known" in that the
 *  icons contained in blockade-pix.ei must match them; careless use of
 *  editicon on blockade-pix.ei, without updating this file to match,
 *  will break things.
 *
 * - icontopix has the _H and _SH values wired into its awk code.
 */
#define B_NCOLOURS 21
#define B_NPIX 27
#define PIC_H 32
#define PIC_W 32
#define PIC_SH 8
#define PIC_SW 8

#define PIC_NSTARS 10
#define PIC_BLANK 0
#define PIC_Q_B 1
#define PIC_Q_Y 2
#define PIC_R_B 3
#define PIC_R_Y 4
#define PIC_P_B 5
#define PIC_P_Y 6
#define PIC_D_B 7
#define PIC_D_Y 8
#define PIC_COLOUR_B 9
#define PIC_COLOUR_Y 10
#define PIC_COLOUR_FLIP 11
#define PIC_WALL 12
#define PIC_MWALL 13
#define PIC_TELEPORT 14
#define PIC_MUTATE 15
#define PIC_PLAYER 16
#define PIC_STARS_A 17
#define PIC_STARS_B 18
#define PIC_STARS_C 19
#define PIC_STARS_D 20
#define PIC_STARS_E 21
#define PIC_STARS_F 22
#define PIC_STARS_G 23
#define PIC_STARS_H 24
#define PIC_STARS_I 25
#define PIC_STARS_J 26

extern unsigned short int b_p_colours[B_NCOLOURS][3];
extern unsigned char b_p_pix_colour[B_NPIX][PIC_H][PIC_W];
extern unsigned char b_p_pix_bw[B_NPIX][PIC_H][PIC_W];
extern unsigned char b_sp_pix_colour[B_NPIX][PIC_SH][PIC_SW];
extern unsigned char b_sp_pix_bw[B_NPIX][PIC_SH][PIC_SW];
