/*
 * Copyright status: These built-in scenes were lifted directly from
 *  Christer Ericson's Macintosh game.  Except that I received
 *  permission to build them into my reimplementation of the game, I do
 *  not know their legal status.  See the accompanying file COPYRIGHT
 *  for more.
 */

#include "blockade.h"
#include "blockade-pix.h"
#include "blockade-lev.h"

#define __ PIC_BLANK
#define QB PIC_Q_B
#define QY PIC_Q_Y
#define RB PIC_R_B
#define RY PIC_R_Y
#define DB PIC_D_B
#define DY PIC_D_Y
#define PB PIC_P_B
#define PY PIC_P_Y
#define CB PIC_COLOUR_B
#define CY PIC_COLOUR_Y
#define CF PIC_COLOUR_FLIP
#define WL PIC_WALL
#define MW PIC_MWALL
#define TL PIC_TELEPORT
#define MU PIC_MUTATE
#define PL PIC_PLAYER
#define SA PIC_STARS_A
#define SB PIC_STARS_B
#define SC PIC_STARS_C
#define SD PIC_STARS_D
#define SE PIC_STARS_E
#define SF PIC_STARS_F
#define SG PIC_STARS_G
#define SH PIC_STARS_H
#define SI PIC_STARS_I
#define SJ PIC_STARS_J

DEF_LEVEL b_l_builtin[N_DEF_LEVELS] = {
{	"Lesson: Blocks", /* KSSRSER */
	/* 0 0 0 */
   {	{ SA,SA,SA,SH,SA,SA,SA,SA,SA,SA,SB,SA,SA,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SD,WL,PL,__,__,__,__,__,__,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,QB,__,__,__,QY,QB,__,__,WL,SC }, /* 0 */
	{ SA,WL,__,__,QB,QB,__,__,__,QY,QY,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QY,QB,__,__,__,QY,QY,__,__,WL,SA }, /* 0 */
	{ SH,WL,__,__,__,__,__,__,__,__,__,__,__,WL,SD }, /* 0 */
	{ SF,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,SE,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA,SE,SH,SA }, /* 0 */
	/* 0 12 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lesson: More blocks", /* ER */
	/* 0 0 0 */
   {	{ SA,SA,SA,SH,SA,SA,SA,SA,SA,SA,SB,SA,SA,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SD,WL,__,__,DY,__,WL,__,__,__,RB,__,QB,WL,SA }, /* 0 */
	{ SA,WL,__,DB,PB,__,WL,__,__,DB,DY,PB,__,WL,SC }, /* 0 */
	{ SA,WL,RB,QY,__,__,WL,__,__,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,__,__,__,__,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SH,WL,__,__,__,__,WL,QB,RY,PB,DY,DB,PL,WL,SD }, /* 0 */
	{ SF,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SE,SH,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA,SE,SA,SA }, /* 0 */
	/* 0 15 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lesson: Colorizers", /* ERS */
	/* 0 0 0 */
   {	{ SA,SA,SA,SH,SA,SA,SA,SA,SA,SA,SB,SA,SA,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SD,WL,PL,__,__,CB,CF,CF,CF,CY,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,CB,CF,CF,CF,CY,QY,__,__,WL,SC }, /* 0 */
	{ SA,WL,__,__,QB,CB,CF,CF,CF,CY,QY,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,CB,CF,CF,CF,CY,QY,__,__,WL,SA }, /* 0 */
	{ SH,WL,__,__,__,CB,CF,CF,CF,CY,__,__,__,WL,SD }, /* 0 */
	{ SF,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SE,SH,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA,SE,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lesson: Movable walls", /*  */
	/* 0 0 0 */
   {	{ SA,SA,SA,SB,SA,SA,SA,SB,SA,SA,SB,SH,SE,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,WL,PL,__,__,__,MW,__,MW,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,MW,__,__,__,MW,QY,__,__,WL,SC }, /* 0 */
	{ SD,WL,__,__,QB,__,__,WL,__,__,QY,__,__,WL,SE }, /* 0 */
	{ SA,WL,__,__,QB,MW,__,__,__,MW,QY,__,__,WL,SH }, /* 0 */
	{ SA,WL,__,__,__,__,MW,__,MW,__,__,__,__,WL,SD }, /* 0 */
	{ SD,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SB,SA,SA,SB,SA,SB,SA,SE,SH,SA,SA,SA,SE,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lesson: Teleporters", /* ER */
	/* 0 0 0 */
   {	{ SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SC,WL,PL,__,__,__,__,WL,__,__,__,__,__,WL,SH }, /* 0 */
	{ SH,WL,__,TL,WL,TL,__,TL,__,TL,WL,TL,__,WL,SB }, /* 0 */
	{ SA,WL,__,QB,WL,QB,__,WL,__,QY,WL,QY,__,WL,SA }, /* 0 */
	{ SA,WL,__,TL,WL,TL,__,TL,__,TL,WL,TL,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,__,__,__,WL,__,__,__,__,__,WL,SD }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,SA,SA,SA,SA,SB,SA,SA,SA,SA,SA,SH,SF,SA,SA }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lesson: Mutator", /* TORTER */
	/* 0 0 0 */
   {	{ SA,SA,SA,SA,SH,SB,SA,SF,SA,SA,SH,SA,SA,SF,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SB,WL,PL,__,__,__,__,WL,__,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,WL,__,__,__,WL,QY,__,__,WL,SB }, /* 0 */
	{ SF,WL,__,__,QB,__,__,MU,__,__,QY,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QB,WL,__,__,__,WL,QY,__,__,WL,SA }, /* 0 */
	{ SB,WL,__,__,__,__,__,WL,__,__,__,__,__,WL,SD }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,SA,SA,SA,SA,SB,SA,SH,SA,SA,SA,SA,SB,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lite 'n' easy", /*  UP...90 */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,SA,SE,SA,SA,SB,SA,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SF,WL,WL,WL,WL,WL,WL,WL,SB,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,SA,WL,__,__,__,__,__,WL,SE,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,SA,WL,QB,QB,QB,QB,QY,WL,SF,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,SC,WL,__,__,PL,__,__,WL,SE,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,SA,WL,QY,QY,QY,QY,QB,WL,SA,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,SA,WL,__,__,__,__,__,WL,SA,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,WL,WL,WL,WL,WL,WL,WL,SC,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,SA,SB,SA,SA,SA,SA,SF,SA,SA,SE,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"It can be done", /* KNOWN0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ SA,SA,SH,WL,TL,TL,TL,TL,TL,TL,TL,WL,SA,SA,SH }, /* 0 */
	{ SF,SA,SA,WL,TL,QY,TL,TL,TL,TL,TL,WL,SA,SC,SE }, /* 0 */
	{ SA,SA,SB,WL,TL,TL,TL,TL,TL,TL,TL,WL,SA,SE,SA }, /* 0 */
	{ SA,SB,SA,WL,TL,TL,TL,PL,TL,TL,TL,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,WL,TL,TL,TL,TL,TL,TL,TL,WL,SA,SB,SC }, /* 0 */
	{ SH,SB,SE,WL,TL,TL,TL,TL,TL,QB,TL,WL,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,WL,TL,TL,TL,TL,TL,TL,TL,WL,SB,SA,SF }, /* 0 */
	{ SE,SA,SB,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 2 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Easy peasy", /* 1234567890 */
	/* 0 0 0 */
   {	{ SE,SA,SA,SA,SC,WL,WL,WL,WL,WL,SA,SA,SA,SB,SE }, /* 0 */
	{ SB,SA,SC,SA,SA,WL,QB,QY,QY,WL,SB,SA,SC,SA,SA }, /* 0 */
	{ SA,SA,SA,SA,SB,WL,QB,QY,QB,WL,SA,SF,SA,SA,SA }, /* 0 */
	{ SA,SA,SF,SA,SA,WL,QY,QY,QY,WL,SE,SA,SH,SA,SF }, /* 0 */
	{ SF,SA,SA,SA,SA,WL,QB,QY,QB,WL,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SB,SA,WL,PL,QB,QY,WL,SA,SA,SA,SA,SA }, /* 0 */
	{ SA,SH,SA,SA,SA,WL,QB,QB,QY,WL,SA,SE,SA,SF,SB }, /* 0 */
	{ SA,SA,SE,SF,SA,WL,QY,QB,QB,WL,SA,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,SC,WL,WL,WL,WL,WL,SB,SA,SA,SA,SE }, /* 0 */
	/* 0 20 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Oh thell oh", /* 234567890 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,SA,SC,__,QY,QY,QB,QY,QY,QB,QB,__,SC,SA,WL }, /* 0 */
	{ WL,SA,SA,__,QB,QY,QB,QY,QB,QB,QB,__,SA,SA,WL }, /* 0 */
	{ WL,SA,SF,__,QY,QB,QY,QY,QY,QY,QY,__,SH,SA,WL }, /* 0 */
	{ WL,SA,SA,__,QY,QB,QB,QY,QB,QB,QB,__,SA,SE,WL }, /* 0 */
	{ WL,SA,SA,__,QY,QY,PL,QB,QY,QY,QB,__,SA,SA,WL }, /* 0 */
	{ WL,SH,SA,__,QB,QB,QB,QB,QY,QY,QB,__,SA,SF,WL }, /* 0 */
	{ WL,SA,SE,__,QY,QY,QY,QB,QB,QB,QY,__,SA,SA,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 48 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Donut", /* AND FORTH(LISP? */
	/* 0 0 0 */
   {	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SE,SA,WL,__,QY,QY,QB,__,__,__,__,WL,SE,SH,SC }, /* 0 */
	{ SA,SF,WL,__,MW,__,__,QY,PL,MW,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,WL,WL,WL,WL,__,__,WL,SA,SE,SA }, /* 0 */
	{ SA,SA,WL,__,__,WL,SA,SA,WL,__,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SE,WL,QB,__,WL,WL,WL,WL,__,QB,WL,SA,SC,SE }, /* 0 */
	{ SA,SB,WL,__,QB,__,__,__,__,MW,__,WL,SA,SA,SA }, /* 0 */
	{ SH,SC,WL,__,__,QB,QY,QY,__,__,__,WL,SA,SB,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SF }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Zig zag", /* 8901234567890 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ SH,SA,SE,WL,__,QY,__,QY,__,QY,__,WL,SA,SA,SH }, /* 0 */
	{ SE,SA,SB,WL,QY,__,QY,__,QY,__,QY,WL,SA,SC,SE }, /* 0 */
	{ SA,SB,SA,WL,__,QB,WL,WL,WL,QY,__,WL,SA,SB,SA }, /* 0 */
	{ SB,SE,SA,WL,QB,__,__,PL,__,__,QY,WL,SA,SH,SB }, /* 0 */
	{ SA,SA,SA,WL,__,QB,WL,WL,WL,QY,__,WL,SB,SA,SA }, /* 0 */
	{ SB,SA,SB,WL,QB,__,QB,__,QB,__,QB,WL,SA,SA,SB }, /* 0 */
	{ SB,SB,SA,WL,__,QB,__,QB,__,QB,__,WL,SB,SA,SF }, /* 0 */
	{ SF,SE,SH,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 20 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Optimal cross", /* T TEST  */
	/* 0 0 0 */
   {	{ SA,SH,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SD,SA,SA }, /* 0 */
	{ SB,SC,SF,WL,WL,__,WL,WL,WL,__,WL,WL,SA,SF,SH }, /* 0 */
	{ SA,SA,SC,WL,__,__,MW,QY,MW,__,__,WL,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,WL,__,__,__,MW,__,__,__,WL,SH,SB,SA }, /* 0 */
	{ SA,SC,SA,WL,MW,WL,MW,MW,MW,WL,MW,WL,SA,SA,SA }, /* 0 */
	{ SD,SF,SA,WL,__,__,__,MW,__,PL,__,WL,SC,SA,SA }, /* 0 */
	{ SB,SA,SH,WL,__,__,MW,QB,MW,__,__,WL,SA,SH,SA }, /* 0 */
	{ SA,SA,SA,WL,WL,__,__,WL,__,__,WL,WL,SA,SF,SA }, /* 0 */
	{ SF,SE,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SB }, /* 0 */
	/* 0 2 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Extraction", /* TEST TEST  */
	/* 0 0 0 */
   {	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SF,SA,WL,__,__,MW,__,__,__,__,WL,SA,SF,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,QB,__,MW,__,__,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,__,__,WL,__,__,WL,SA,SH,SA,SF }, /* 0 */
	{ SD,SA,SA,SF,WL,WL,WL,WL,WL,QY,WL,SA,SD,SA,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,__,QB,WL,QY,PL,WL,WL,WL,WL,WL }, /* 0 */
	{ SA,SA,SA,SA,WL,__,__,QB,__,__,__,__,QB,__,WL }, /* 0 */
	{ SA,SF,SA,SA,WL,__,__,__,QY,__,QY,__,__,__,WL }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Shard", /* NATION UNKNOWN0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,SA,SC,SA,SA }, /* 0 */
	{ SA,SA,SH,WL,__,QB,__,__,__,QY,__,WL,SA,SA,SH }, /* 0 */
	{ SF,SA,SA,WL,__,QY,__,__,WL,__,__,WL,SA,SC,SE }, /* 0 */
	{ SA,SA,SA,WL,__,PL,MW,QY,QY,__,WL,SA,SA,SE,SA }, /* 0 */
	{ SA,SB,SA,SA,WL,__,QY,__,MW,QB,__,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,QB,__,QY,QB,WL,WL,SA,SA,SB,SC }, /* 0 */
	{ SH,SB,SE,SA,SA,WL,__,QB,WL,SA,SA,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,SA,WL,QB,WL,SA,SA,SA,SA,SB,SA,SF }, /* 0 */
	{ SE,SA,SB,SA,SA,SA,WL,SA,SA,SA,SA,SA,SA,SA,SA }, /* 0 */
	/* 0 12 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lovely black eyes", /* 890 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,TL,__,__,__,CB,__,__,WL }, /* 0 */
	{ WL,__,WL,__,WL,WL,WL,__,WL,WL,WL,RB,WL,__,WL }, /* 0 */
	{ WL,__,WL,__,WL,SF,WL,QY,WL,SD,WL,__,WL,__,WL }, /* 0 */
	{ WL,__,WL,__,WL,SG,WL,__,WL,SH,WL,__,WL,__,WL }, /* 0 */
	{ WL,__,WL,RY,WL,WL,WL,__,WL,WL,WL,__,WL,__,WL }, /* 0 */
	{ WL,__,WL,TL,CY,__,CB,TL,CY,__,CB,TL,WL,__,WL }, /* 0 */
	{ WL,TL,PL,__,__,__,__,WL,__,__,__,__,__,TL,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 3 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Blocked?", /*  DIFFICULT?0 */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SF,WL,MW,MW,__,MW,__,WL,SB,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,SA,WL,__,__,MW,__,QB,WL,SE,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,SA,WL,__,QB,MW,__,__,WL,SF,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,SC,WL,__,MW,__,MW,__,WL,SE,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,SA,WL,MW,__,MW,__,MW,WL,SA,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,SA,WL,__,QY,PL,__,__,WL,SA,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,WL,__,__,__,QY,__,WL,SC,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"H is for `hi there'", /* 0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,SA,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ SA,SA,SH,WL,QB,__,WL,SF,WL,__,QB,WL,SE,SA,SC }, /* 0 */
	{ SA,SC,SA,WL,__,__,WL,SA,WL,__,__,WL,SA,SA,SE }, /* 0 */
	{ SA,SA,SB,WL,__,__,WL,WL,WL,__,__,WL,SA,SE,SA }, /* 0 */
	{ SA,SB,SA,WL,__,QY,__,PL,__,QY,__,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,WL,__,QY,WL,WL,WL,QY,__,WL,SA,SB,SC }, /* 0 */
	{ SH,SB,SE,WL,__,__,WL,SA,WL,__,__,WL,SA,SH,SB }, /* 0 */
	{ SA,SA,SA,WL,QB,__,WL,SA,WL,__,QB,WL,SB,SA,SF }, /* 0 */
	{ SE,SA,SB,WL,WL,WL,WL,SA,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lock it up", /* Y DOG?7890 */
	/* 0 0 0 */
   {	{ SB,SA,SA,SB,SA,SA,SA,SA,SA,SA,SB,SA,SA,SA,SF }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SA,SC,WL,__,QB,__,QB,__,__,MW,__,WL,SA,SA,SA }, /* 0 */
	{ SH,SA,WL,QB,QB,PL,QB,__,__,MW,__,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,WL,WL,MW,MW,MW,MW,WL,SA,SH,SA }, /* 0 */
	{ SA,SA,WL,__,QY,QY,__,__,QY,__,__,WL,SA,SA,SA }, /* 0 */
	{ SC,SF,WL,__,__,QY,__,__,QY,__,__,WL,SA,SA,SE }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,SA,SA,SB,SA,SA,SA,SA,SA,SA,SB,SA,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Yin-yang", /* EASY UP...90 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,QY,QY,QY,QY,QB,__,__,__,__,WL }, /* 0 */
	{ WL,__,__,__,QY,QY,QB,QB,QY,QB,QB,__,__,__,WL }, /* 0 */
	{ WL,__,__,QY,QY,QY,QY,QY,QY,QB,QB,QB,__,__,WL }, /* 0 */
	{ WL,__,__,QY,QY,QY,QY,PL,QB,QB,QB,QB,__,__,WL }, /* 0 */
	{ WL,__,__,QY,QY,QY,QB,QB,QB,QB,QB,QB,__,__,WL }, /* 0 */
	{ WL,__,__,__,QY,QY,QB,QY,QY,QB,QB,__,__,__,WL }, /* 0 */
	{ WL,__,__,__,__,QY,QB,QB,QB,QB,__,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 50 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Slide puzzle", /* FICULT?0 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,WL,MW,MW,__,MW,__,MW,__,__,__,WL }, /* 0 */
	{ WL,__,MW,__,MW,__,__,MW,__,QB,MW,__,QB,MW,WL }, /* 0 */
	{ WL,MW,__,QY,MW,__,QB,MW,__,__,MW,__,MW,__,WL }, /* 0 */
	{ WL,__,__,__,MW,__,MW,__,MW,__,MW,__,__,__,WL }, /* 0 */
	{ WL,__,MW,WL,WL,MW,__,MW,__,MW,WL,WL,MW,__,WL }, /* 0 */
	{ WL,__,__,__,MW,__,QY,PL,__,__,MW,__,MW,__,WL }, /* 0 */
	{ WL,__,MW,__,MW,__,__,__,QY,__,MW,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Iron cross", /* IONND67890 */
	/* 0 0 0 */
   {	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA }, /* 0 */
	{ SE,SA,WL,__,__,__,WL,WL,WL,__,__,__,WL,SH,SC }, /* 0 */
	{ SA,SF,WL,__,RY,__,__,WL,__,__,RY,__,WL,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,__,MW,__,__,__,__,WL,SE,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,MW,WL,MW,WL,WL,WL,WL,SA,SA }, /* 0 */
	{ SA,SE,WL,__,__,__,__,MW,__,__,__,__,WL,SC,SE }, /* 0 */
	{ SA,SB,WL,__,RB,__,PL,WL,__,__,RB,__,WL,SA,SA }, /* 0 */
	{ SH,SC,WL,__,__,__,WL,WL,WL,__,__,__,WL,SB,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SF }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Black hole", /* N UNKNOWN0 */
	/* 0 0 0 */
   {	{ SF,WL,WL,__,__,__,__,PL,__,__,__,WL,WL,SA,SA }, /* 0 */
	{ SA,WL,__,WL,__,MW,MW,MW,MW,__,WL,__,WL,SH,SF }, /* 0 */
	{ SA,WL,__,__,__,QB,__,__,QB,__,__,__,WL,SA,SA }, /* 0 */
	{ SA,WL,__,MW,QB,TL,SA,SA,TL,QY,MW,__,WL,SA,SB }, /* 0 */
	{ SB,WL,WL,__,QY,SA,SA,SA,SA,QB,__,WL,WL,SA,SA }, /* 0 */
	{ SA,WL,__,MW,QB,TL,SA,SA,TL,QY,MW,__,WL,SA,SA }, /* 0 */
	{ SH,WL,__,__,__,QY,__,__,QY,__,__,__,WL,SD,SA }, /* 0 */
	{ SC,WL,__,WL,__,MW,MW,MW,MW,__,WL,__,WL,SF,SH }, /* 0 */
	{ SA,WL,WL,__,__,__,__,__,__,__,__,WL,WL,SA,SB }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"4x4x4", /*  WARSHIPND67890 */
	/* 0 0 0 */
   {	{ SD,SA,SH,SB,SA,SB,SA,SA,SA,SB,SA,SC,SA,SA,SB }, /* 0 */
	{ SA,SA,SB,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,WL,__,MW,__,__,__,__,WL,SB,SA,SH,SA }, /* 0 */
	{ SB,SF,SA,WL,__,__,QB,MW,QY,__,WL,SB,SF,SA,SB }, /* 0 */
	{ SD,SA,SB,WL,__,QB,PL,QB,MW,__,WL,SB,SA,SA,SA }, /* 0 */
	{ SA,SA,SB,WL,WL,QY,__,QB,__,QY,WL,SB,SA,SA,SB }, /* 0 */
	{ SB,SF,SA,WL,__,__,__,__,__,QY,WL,SA,SB,SA,SA }, /* 0 */
	{ SH,SA,SB,WL,WL,WL,WL,WL,WL,WL,WL,SA,SB,SA,SB }, /* 0 */
	{ SA,SA,SA,SC,SA,SB,SA,SD,SA,SA,SH,SA,SE,SA,SA }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Take me out", /* Y UP...90 */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,SA,MW,WL,WL,WL,MW,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SF,MW,WL,__,__,__,WL,MW,SB,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,MW,WL,__,RB,QB,RB,__,WL,MW,SE,SF,SA }, /* 0 */
	{ SA,SA,MW,__,__,QB,TL,__,TL,QB,__,__,MW,SA,SE }, /* 0 */
	{ SC,SA,WL,__,WL,WL,__,WL,__,WL,WL,__,WL,SA,SA }, /* 0 */
	{ SE,SF,MW,__,__,QY,TL,__,TL,QY,__,__,MW,SA,SH }, /* 0 */
	{ SA,SA,SE,MW,WL,__,RY,QY,RY,__,WL,MW,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,MW,WL,__,PL,__,WL,MW,SC,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,SA,MW,WL,WL,WL,MW,SF,SA,SA,SE,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Star gate", /* FORTH(LISP? */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,__,__,__,__,__,__,__,WL }, /* 0 */
	{ WL,MW,QB,__,__,__,__,__,__,__,__,__,__,MW,WL }, /* 0 */
	{ WL,__,QB,QB,MW,__,__,PL,__,__,MW,QY,__,__,WL }, /* 0 */
	{ WL,__,QB,__,__,WL,WL,WL,WL,WL,__,QY,QY,__,WL }, /* 0 */
	{ WL,WL,__,__,WL,WL,SA,SE,SA,WL,WL,__,QY,WL,WL }, /* 0 */
	{ WL,WL,__,QB,WL,WL,SH,SB,SB,WL,__,QY,QY,__,WL }, /* 0 */
	{ WL,__,QB,QB,__,WL,SA,SA,SA,WL,WL,__,__,WL,WL }, /* 0 */
	{ WL,__,__,__,__,WL,SB,SC,SD,WL,__,__,QY,__,WL }, /* 0 */
	/* 0 14 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Easy glider", /* ASE ME890 */
	/* 0 0 0 */
   {	{ SB,SA,SA,SF,SA,WL,WL,WL,WL,WL,WL,SC,SB,SA,SA }, /* 0 */
	{ SA,SA,SC,WL,WL,WL,__,MW,__,__,WL,SA,SA,SA,SH }, /* 0 */
	{ SA,SE,WL,WL,__,WL,WL,RB,RY,QY,WL,SA,SA,SE,SB }, /* 0 */
	{ SF,SA,WL,__,__,__,__,__,__,QB,WL,SB,SA,SA,SA }, /* 0 */
	{ SC,SH,WL,__,WL,__,__,__,RB,__,WL,SA,SA,SA,SC }, /* 0 */
	{ SA,SA,WL,__,__,RB,RY,__,WL,WL,WL,SA,SA,SF,SA }, /* 0 */
	{ SA,SB,WL,WL,__,QY,WL,QY,WL,WL,SA,SH,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,WL,__,RY,PL,__,QB,WL,SA,SA,SA,SA,SE }, /* 0 */
	{ SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,SB,SA,SF,SE,SA }, /* 0 */
	/* 0 11 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Additive", /*  ROUND567890 */
	/* 0 0 0 */
   {	{ SA,SC,SA,SF,WL,WL,WL,WL,WL,WL,WL,SA,SF,SE,SA }, /* 0 */
	{ SE,SA,SB,SA,WL,__,__,WL,__,__,WL,SH,SA,SA,SB }, /* 0 */
	{ WL,WL,WL,WL,WL,__,QY,WL,QY,__,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,WL,__,__,WL,__,__,WL,__,__,__,WL }, /* 0 */
	{ WL,__,QB,__,__,CF,CF,PL,CF,CF,__,__,QY,__,WL }, /* 0 */
	{ WL,__,__,__,WL,__,__,WL,__,__,WL,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,__,QB,WL,QB,__,WL,WL,WL,WL,WL }, /* 0 */
	{ SA,SB,SA,SE,WL,__,__,WL,__,__,WL,SA,SA,SB,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"In and out again", /* D DO */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,WL,WL,WL,WL,WL,WL,WL,__,__,WL,WL }, /* 0 */
	{ WL,__,RB,__,__,__,RB,__,__,__,__,__,__,WL,WL }, /* 0 */
	{ WL,CF,WL,WL,__,WL,WL,WL,WL,WL,WL,WL,__,__,WL }, /* 0 */
	{ WL,QB,WL,WL,PL,__,__,QY,__,__,__,MU,__,__,WL }, /* 0 */
	{ WL,CF,WL,WL,__,WL,WL,WL,WL,WL,WL,WL,__,__,WL }, /* 0 */
	{ WL,__,RB,__,__,__,RB,__,__,__,__,__,__,WL,WL }, /* 0 */
	{ WL,__,__,__,WL,WL,WL,WL,WL,WL,WL,__,__,WL,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Additive II", /* ASE ME890 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,SC,WL,QY,PL,QY,QY,QY,CF,QY,WL,SA,SA,SH }, /* 0 */
	{ SE,SE,SA,WL,CF,CF,CF,CF,CF,CF,CF,WL,SA,SE,SB }, /* 0 */
	{ SA,SA,SA,WL,CF,CF,CF,WL,CF,CF,CF,WL,SA,SA,SA }, /* 0 */
	{ SC,SH,SA,WL,WL,CF,CF,CF,CF,WL,CF,WL,SB,SA,SC }, /* 0 */
	{ SA,SA,SA,WL,CF,CF,WL,CF,CF,CF,CF,WL,SA,SF,SA }, /* 0 */
	{ SA,SB,SA,WL,QB,QB,QB,CF,WL,QB,QB,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,WL,CF,CF,CF,CF,CF,CF,CF,WL,SA,SA,SE }, /* 0 */
	{ SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SF,SE,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Lost in the forest", /* 90 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,PL,__,MW,__,__,MW,__,__,MW,__,__,MW,__,WL }, /* 0 */
	{ WL,__,MW,__,__,MW,__,__,MW,__,__,MW,QY,__,WL }, /* 0 */
	{ WL,MW,__,__,MW,__,__,MW,__,__,MW,__,__,MW,WL }, /* 0 */
	{ WL,__,__,MW,WL,WL,WL,WL,WL,WL,WL,__,MW,__,WL }, /* 0 */
	{ WL,__,MW,__,__,MW,__,__,MW,__,__,MW,__,__,WL }, /* 0 */
	{ WL,MW,QB,__,MW,__,__,MW,__,__,MW,__,__,MW,WL }, /* 0 */
	{ WL,__,__,MW,__,__,MW,__,__,MW,__,__,MW,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 2 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"King me", /*  OUT UNKNOWN0 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,CF,QY,CF,QY,CF,QY,PL,QY,CF,QY,CF,QY,CF,WL }, /* 0 */
	{ WL,__,CF,QY,CF,QY,CF,__,CF,QY,CF,QY,CF,__,WL }, /* 0 */
	{ WL,CF,__,CF,__,CF,__,CF,__,CF,__,CF,__,CF,WL }, /* 0 */
	{ WL,__,CF,__,CF,__,CF,MU,CF,__,CF,__,CF,__,WL }, /* 0 */
	{ WL,CF,__,CF,__,CF,__,CF,__,CF,__,CF,__,CF,WL }, /* 0 */
	{ WL,__,CF,__,CF,__,CF,__,CF,__,CF,__,CF,__,WL }, /* 0 */
	{ WL,CF,__,CF,__,CF,__,CF,__,CF,__,CF,__,CF,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,DY,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 11 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Tele-what?", /*  MEMIND DO */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,WL,WL,__,QB,__,QY,__,WL,WL,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,WL,__,__,WL,TL,WL,__,__,WL,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,WL,__,WL,WL,PB,WL,WL,__,WL,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,WL,QB,TL,PY,PL,QY,TL,QB,WL,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,WL,__,WL,WL,RY,WL,WL,__,WL,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,WL,__,__,WL,TL,WL,__,__,WL,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,WL,WL,__,QY,__,QB,__,WL,WL,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Go fish", /* O ROUND567890 */
	/* 0 0 0 */
   {	{ SA,SC,SA,SF,SH,WL,WL,WL,WL,WL,WL,SA,SF,SE,SA }, /* 0 */
	{ SE,SA,SB,SA,WL,__,__,__,QY,__,__,WL,SA,SA,SB }, /* 0 */
	{ WL,SA,SA,WL,__,__,__,QY,MU,__,QY,__,WL,SA,SA }, /* 0 */
	{ WL,SC,WL,__,MU,QY,MU,QY,__,QY,__,CF,__,WL,SE }, /* 0 */
	{ WL,WL,__,__,QY,MU,__,QY,__,QY,__,__,__,PL,WL }, /* 0 */
	{ WL,WL,__,__,QY,__,MU,QY,MU,__,QY,__,__,WL,SA }, /* 0 */
	{ WL,SA,WL,__,QY,__,__,MU,QY,WL,WL,__,WL,SA,SF }, /* 0 */
	{ WL,SB,SA,WL,__,QY,__,__,__,__,WL,WL,SA,SB,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	/* 0 15 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Teleport tales", /* 567890 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,TL,__,__,TL,__,__,TL,__,__,__,WL }, /* 0 */
	{ WL,__,QB,TL,__,MW,__,__,__,MW,__,TL,QB,__,WL }, /* 0 */
	{ WL,__,TL,__,__,WL,TL,__,TL,WL,__,__,TL,__,WL }, /* 0 */
	{ WL,__,__,QY,__,MW,__,__,__,MW,__,QB,__,__,WL }, /* 0 */
	{ WL,TL,__,__,TL,WL,__,TL,__,WL,TL,__,__,TL,WL }, /* 0 */
	{ WL,__,TL,__,__,MW,__,CF,__,MW,__,TL,__,__,WL }, /* 0 */
	{ WL,TL,__,__,__,WL,__,PL,__,WL,__,__,__,TL,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"The pyramid", /* ONND67890 */
	/* 0 0 0 */
   {	{ SA,SA,SA,SH,SA,SB,SA,WL,SA,SA,SB,SA,SA,SA,SA }, /* 0 */
	{ SE,SA,SA,SA,SA,SA,WL,QB,WL,SA,SA,SA,SB,SH,SC }, /* 0 */
	{ SA,SB,SA,SB,SA,WL,QB,QY,QY,WL,SA,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SB,SA,WL,QB,QB,QB,QY,QY,WL,SA,SA,SE,SD }, /* 0 */
	{ SA,SA,SA,WL,QY,QB,QB,QY,QY,QY,QB,WL,SA,SA,SA }, /* 0 */
	{ SH,SE,WL,QY,QY,QY,QB,QB,QY,QB,QB,QB,WL,SC,SE }, /* 0 */
	{ SA,WL,QB,QY,__,QB,QB,QY,__,QY,__,QY,QY,WL,SA }, /* 0 */
	{ WL,QB,QY,__,QB,__,QY,__,QB,__,QB,QY,QB,QY,WL }, /* 0 */
	{ QY,QB,QB,QY,QY,QB,__,PL,__,QY,QB,QB,QY,QY,QB }, /* 0 */
	/* 0 54 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"The spaceship", /* ND67890 */
	/* 0 0 0 */
   {	{ SD,SA,SA,SH,SA,SB,SA,SA,SA,SB,SA,SA,SA,SA,SB }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SC,SE }, /* 0 */
	{ SA,WL,__,__,__,__,__,WL,__,__,__,__,WL,SA,SA }, /* 0 */
	{ SB,SA,WL,__,QB,CY,WL,__,__,__,__,PB,__,WL,SA }, /* 0 */
	{ SF,SE,SD,WL,__,MW,MU,__,PL,RY,__,__,__,__,WL }, /* 0 */
	{ SC,SA,WL,__,QY,CB,WL,__,__,__,__,PY,__,WL,SB }, /* 0 */
	{ SA,WL,__,__,__,__,__,WL,__,__,__,__,WL,SC,SA }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE }, /* 0 */
	{ SA,SB,SA,SA,SA,SB,SA,SD,SA,SA,SH,SA,SE,SA,SA }, /* 0 */
	/* 0 5 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Warm-up", /*  EASY UP...90 */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,SA,SE,SA,SA,SB,SA,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,WL,__,__,__,__,__,__,__,WL,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,WL,__,QB,QB,QB,QB,QY,__,WL,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,WL,QY,RY,WL,PL,WL,RB,MW,WL,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,WL,__,QY,QY,QY,QY,QB,__,WL,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,WL,__,__,__,__,__,__,__,WL,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,SA,SB,SA,SA,SA,SA,SF,SA,SA,SE,SA }, /* 0 */
	/* 0 13 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"L-checker", /* PY DOG?7890 */
	/* 0 0 0 */
   {	{ SB,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SF }, /* 0 */
	{ SA,SA,WL,RB,__,__,__,__,__,__,PL,WL,SA,SA,SA }, /* 0 */
	{ SA,SC,WL,__,MW,__,MW,__,__,WL,__,WL,SA,SA,SA }, /* 0 */
	{ SH,SA,WL,__,__,MW,__,QY,WL,__,__,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,QY,MU,__,MW,__,WL,SA,SH,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,__,__,QB,WL,WL,SA,SA,SA }, /* 0 */
	{ SC,SF,SB,SC,SH,SF,WL,__,QB,__,__,WL,SA,SA,SE }, /* 0 */
	{ SA,SA,SD,SF,SC,SA,WL,__,__,__,RY,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,SA,SA,SB,WL,WL,WL,WL,WL,WL,SB,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Twister", /* ASY1234567890 */
	/* 0 0 0 */
   {	{ SE,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SB,SE }, /* 0 */
	{ SB,SA,SC,WL,TL,QY,__,__,__,RY,TL,WL,SC,SA,SA }, /* 0 */
	{ SA,SA,SA,WL,RY,WL,RB,__,__,WL,QY,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SF,WL,__,__,MW,QB,MW,RB,__,WL,SH,SA,SF }, /* 0 */
	{ SF,SA,SA,WL,__,__,QB,PL,QB,__,__,WL,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,WL,__,RB,MW,QB,MW,__,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SH,SA,WL,QY,WL,__,__,RB,WL,RY,WL,SA,SF,SB }, /* 0 */
	{ SA,SA,SE,WL,TL,RY,__,__,__,QY,TL,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SE }, /* 0 */
	/* 0 16 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Breakout", /* ATIONND67890 */
	/* 0 0 0 */
   {	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA }, /* 0 */
	{ SE,SA,WL,__,__,__,MW,__,MW,__,__,__,WL,SH,SC }, /* 0 */
	{ SA,SF,WL,__,QY,__,MW,__,MW,__,QY,__,WL,SA,SA }, /* 0 */
	{ SA,SA,WL,MW,MW,MW,MW,__,MW,MW,MW,MW,WL,SE,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,__,MU,__,__,__,__,WL,SA,SA }, /* 0 */
	{ SA,SE,WL,MW,MW,MW,__,__,MW,MW,MW,MW,WL,SC,SE }, /* 0 */
	{ SA,SB,WL,__,PL,__,MW,__,MW,__,QB,__,WL,SA,SA }, /* 0 */
	{ SH,SC,WL,__,__,__,MW,__,MW,__,QB,__,WL,SB,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SF }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Only two", /* T TEST TEST  */
	/* 0 0 0 */
   {	{ SA,SH,SA,SA,WL,WL,WL,WL,WL,WL,WL,SF,SD,SA,SA }, /* 0 */
	{ WL,WL,WL,WL,WL,__,__,__,__,__,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,WL,__,QY,QY,QY,__,WL,__,__,__,WL }, /* 0 */
	{ WL,__,__,__,QY,__,__,QY,__,__,QY,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,__,WL,WL,WL,WL,WL,WL,WL,__,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,QB,__,__,QB,__,__,QB,__,__,__,WL }, /* 0 */
	{ WL,__,__,__,WL,__,QB,QB,QB,__,WL,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,__,__,PL,__,__,WL,WL,WL,WL,WL }, /* 0 */
	{ SF,SE,SA,SA,WL,WL,WL,WL,WL,WL,WL,SE,SA,SA,SB }, /* 0 */
	/* 0 12 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Round up", /* UPY DOG?7890 */
	/* 0 0 0 */
   {	{ SA,SF,SA,SF,WL,WL,WL,WL,WL,WL,WL,SA,SA,SF,SA }, /* 0 */
	{ SA,SD,SH,WL,WL,__,__,MW,__,__,WL,WL,SD,SH,SD }, /* 0 */
	{ SA,SA,SC,WL,__,MW,QB,PL,__,MW,__,WL,SB,SD,SA }, /* 0 */
	{ SF,SA,SA,WL,__,__,QY,MW,__,QB,__,WL,SF,SA,SA }, /* 0 */
	{ SA,SD,SA,WL,MW,__,MW,WL,MW,__,MW,WL,SA,SC,SB }, /* 0 */
	{ SC,SD,SA,WL,__,RB,__,MW,RY,__,__,WL,SH,SA,SA }, /* 0 */
	{ SA,SH,SA,WL,__,MW,__,__,__,MW,__,WL,SC,SD,SH }, /* 0 */
	{ SA,SA,SF,WL,WL,__,__,MW,__,__,WL,WL,SA,SA,SA }, /* 0 */
	{ SD,SA,SC,SB,WL,WL,WL,WL,WL,WL,WL,SA,SD,SA,SA }, /* 0 */
	/* 0 5 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Teleport to town", /* LT?0 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,__,__,__,__,__,__,__,WL }, /* 0 */
	{ WL,QY,WL,QY,__,WL,__,QY,__,WL,__,QY,WL,QY,WL }, /* 0 */
	{ WL,TL,WL,__,TL,WL,__,PL,__,WL,TL,__,WL,TL,WL }, /* 0 */
	{ WL,CY,WL,CY,CY,WL,CY,CY,CY,WL,CY,CY,WL,CY,WL }, /* 0 */
	{ WL,QB,WL,__,QB,WL,__,QB,__,WL,__,QB,WL,QB,WL }, /* 0 */
	{ WL,__,WL,__,__,WL,__,__,__,WL,__,__,WL,__,WL }, /* 0 */
	{ WL,__,__,__,__,TL,__,__,__,TL,__,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Castle route", /* TH(LISP? */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,SC,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,WL,__,__,WL,SB,WL,__,__,WL,__,__,WL }, /* 0 */
	{ WL,__,__,WL,__,QY,WL,WL,WL,QB,__,WL,QB,__,WL }, /* 0 */
	{ WL,__,QY,WL,__,__,MU,MW,CF,__,__,MW,__,__,WL }, /* 0 */
	{ WL,__,MW,__,__,QY,WL,WL,WL,__,__,__,MW,__,WL }, /* 0 */
	{ WL,MW,__,__,__,__,WL,SF,WL,__,__,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,MW,QY,MW,WL,WL,WL,QB,MW,__,QB,__,WL }, /* 0 */
	{ WL,__,__,WL,__,__,__,PL,__,MW,__,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Globes", /* RACKUND4567890 */
	/* 0 0 0 */
   {	{ SA,SA,SA,SA,SB,SA,SH,SA,SA,SA,SC,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,WL,WL,SA,WL,WL,WL,SA,SA,SC,SA }, /* 0 */
	{ SA,SA,SD,WL,__,__,__,WL,__,__,__,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,WL,__,__,__,__,MW,MU,QY,__,__,WL,SD,SA }, /* 0 */
	{ SA,SA,WL,__,__,DB,DY,PL,QY,QB,__,__,WL,SD,SC }, /* 0 */
	{ SA,SA,WL,__,__,__,__,MW,__,__,__,__,WL,SA,SC }, /* 0 */
	{ SA,SC,SB,WL,__,__,QB,WL,QY,__,__,WL,SA,SD,SC }, /* 0 */
	{ SH,SA,SA,SA,WL,WL,WL,SA,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SA,SA,SA,SC,SA,SA,SB,SA,SF,SF,SA,SA }, /* 0 */
	/* 0 7 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Off center", /* TEST TEST  */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SD,SA,SA }, /* 0 */
	{ WL,__,__,__,MW,__,__,__,__,__,WL,WL,SA,SF,SH }, /* 0 */
	{ WL,__,DY,__,MW,__,PB,RB,PB,__,WL,WL,SA,SF,SA }, /* 0 */
	{ WL,__,__,__,MW,__,__,__,__,__,WL,WL,SH,SB,SA }, /* 0 */
	{ WL,WL,WL,WL,WL,MW,MW,MW,MW,MW,WL,WL,WL,WL,WL }, /* 0 */
	{ SD,SF,SA,WL,WL,__,__,__,__,__,MW,__,__,__,WL }, /* 0 */
	{ SB,SA,SH,WL,WL,__,PY,PY,PY,__,MW,__,DB,__,WL }, /* 0 */
	{ SA,SA,SA,WL,WL,__,__,PL,__,__,MW,__,__,__,WL }, /* 0 */
	{ SF,SE,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Where to go?", /* DOG?7890 */
	/* 0 0 0 */
   {	{ SF,WL,SD,SF,SE,SF,SF,SD,SF,SB,SH,SF,SF,SF,SH }, /* 0 */
	{ WL,QY,WL,SD,SB,SF,WL,WL,WL,WL,WL,WL,WL,WL,SF }, /* 0 */
	{ WL,TL,WL,SE,SH,WL,MU,__,MU,MU,__,__,MU,__,WL }, /* 0 */
	{ WL,__,WL,WL,WL,WL,__,PL,TL,__,__,TL,WL,QY,WL }, /* 0 */
	{ WL,CB,WL,CB,CB,CB,CB,CB,CB,CB,CB,CB,WL,TL,WL }, /* 0 */
	{ WL,MU,WL,MU,WL,__,TL,QY,QY,QY,TL,__,WL,QB,WL }, /* 0 */
	{ WL,MU,MU,MU,WL,MU,__,MU,WL,MU,__,__,__,MU,WL }, /* 0 */
	{ SF,WL,WL,WL,WL,WL,WL,WL,SF,WL,WL,WL,WL,WL,SF }, /* 0 */
	{ SH,SF,SB,SB,SF,SB,SB,SH,SF,SB,SB,SF,SF,SH,SB }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"The compleat journey", /*  */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,SC,WL,PL,__,PY,PB,RY,TL,QB,WL,SA,SA,SH }, /* 0 */
	{ SE,SE,SA,WL,DB,QY,QB,RY,RB,PB,__,WL,SA,SE,SB }, /* 0 */
	{ SA,SA,SA,WL,DY,RB,MU,RY,RB,QY,TL,WL,SA,SA,SA }, /* 0 */
	{ SC,SH,SA,WL,PB,PY,MW,QB,RY,RB,PY,WL,SB,SA,SC }, /* 0 */
	{ SA,SA,SA,WL,RY,PB,CF,PY,PB,RY,RB,WL,SA,SF,SA }, /* 0 */
	{ SA,SB,SA,WL,QB,MW,CY,QY,QB,MW,QY,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,WL,QY,QB,QB,QY,QB,QY,QB,WL,SA,SA,SE }, /* 0 */
	{ SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SF,SE,SA }, /* 0 */
	/* 0 38 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Maze", /* RWAY TO HEAVEN90 */
	/* 0 0 0 */
   {	{ SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SD,SA,SA,WL,QB,__,QY,__,QB,__,__,WL,SA,SF,SA }, /* 0 */
	{ SA,SA,SB,WL,RY,WL,WL,WL,QY,RY,__,WL,SA,SA,SB }, /* 0 */
	{ SF,SA,SA,WL,__,__,__,WL,__,__,__,WL,SB,SA,SA }, /* 0 */
	{ SA,SC,SA,WL,RB,WL,__,WL,WL,CF,WL,WL,SA,SA,SH }, /* 0 */
	{ SA,SA,SA,WL,TL,WL,TL,PY,PB,__,QB,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,WL,QB,WL,QY,WL,WL,WL,QY,WL,SA,SA,SF }, /* 0 */
	{ SH,SA,SA,WL,PL,QB,TL,QY,QB,QY,__,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,SF,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SB,SD }, /* 0 */
	/* 0 17 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Breakout II", /* ASE ME890 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,TL,MW,__,QB,TL,__,__,WL,TL,MW,__,WL }, /* 0 */
	{ WL,__,MW,WL,__,__,__,__,MW,__,__,WL,__,__,WL }, /* 0 */
	{ WL,__,__,WL,__,MW,MW,MW,MW,MW,__,WL,__,__,WL }, /* 0 */
	{ WL,QY,TL,CY,__,__,MW,PL,MW,__,__,CY,TL,QY,WL }, /* 0 */
	{ WL,__,__,WL,__,MW,MW,MW,MW,MW,__,WL,__,__,WL }, /* 0 */
	{ WL,__,__,WL,__,__,MW,__,__,__,__,WL,__,__,WL }, /* 0 */
	{ WL,__,MW,TL,WL,__,__,TL,QB,__,MW,TL,MW,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"The right slant", /* NOWN0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ SA,SA,SH,WL,WL,__,__,__,__,__,WL,WL,SA,SA,SH }, /* 0 */
	{ SF,SA,SA,WL,__,RY,RY,__,RY,RY,__,WL,SA,SC,SE }, /* 0 */
	{ SA,SA,SB,WL,__,RY,WL,__,__,RY,__,WL,SA,SE,SA }, /* 0 */
	{ SA,SB,SA,WL,__,__,__,MW,__,__,__,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,WL,__,RB,__,__,WL,RB,__,WL,SA,SB,SC }, /* 0 */
	{ SH,SB,SE,WL,__,RB,RB,__,RB,RB,__,WL,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,WL,WL,__,__,__,__,__,PL,WL,SB,SA,SF }, /* 0 */
	{ SE,SA,SB,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 12 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Beam me up, Scotty", /* T  */
	/* 0 0 0 */
   {	{ CY,CB,CY,CB,CY,SA,SC,SA,SA,SA,SA,SA,SA,SA,SA }, /* 0 */
	{ CB,SB,SA,SA,CB,SA,SA,SA,SB,SA,SA,SA,SH,SA,SA }, /* 0 */
	{ CY,SD,MW,MW,TL,MW,MW,SA,SA,WL,WL,WL,WL,SA,SH }, /* 0 */
	{ CB,SA,SA,SA,RY,SA,SA,SB,WL,SA,SA,SH,SA,SB,SA }, /* 0 */
	{ CY,SA,SA,SA,SH,WL,WL,WL,SA,SA,SA,SA,SA,SA,SA }, /* 0 */
	{ CB,SB,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SA,SH,SA }, /* 0 */
	{ CY,SA,SH,SA,SA,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA }, /* 0 */
	{ __,__,TL,QY,__,__,QY,TL,__,__,__,__,__,__,__ }, /* 0 */
	{ __,__,__,PL,TL,__,__,QB,__,QB,__,TL,MU,__,__ }, /* 0 */
	/* 0 5 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Back and forth", /* (LISP? */
	/* 0 0 0 */
   {	{ SA,SA,SA,WL,WL,WL,WL,SC,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SE,SA,SB,WL,__,__,WL,SB,WL,__,__,WL,SE,SH,SC }, /* 0 */
	{ SA,SF,WL,WL,__,QY,WL,WL,WL,QB,__,WL,WL,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,MU,__,CF,__,__,__,WL,SE,SA }, /* 0 */
	{ SA,SA,WL,__,__,QY,WL,WL,WL,QB,__,__,WL,SA,SA }, /* 0 */
	{ SA,SE,WL,__,__,__,WL,SF,WL,__,__,__,WL,SC,SE }, /* 0 */
	{ SA,SB,WL,__,QY,MW,WL,WL,WL,QB,MW,__,WL,SA,SA }, /* 0 */
	{ SH,SC,WL,WL,__,__,__,PL,__,MW,__,WL,WL,SB,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SF }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Please release me", /* 890 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,SC,WL,__,__,__,__,WL,QB,__,WL,SA,SA,SH }, /* 0 */
	{ SE,SE,SA,WL,__,QB,__,RB,QY,__,QY,WL,SA,SE,SB }, /* 0 */
	{ SA,SA,SA,WL,WL,__,__,PL,__,QY,__,WL,SA,SA,SA }, /* 0 */
	{ SC,SH,SA,WL,__,__,WL,WL,WL,__,__,WL,SB,SA,SC }, /* 0 */
	{ SA,SA,SA,WL,__,QB,QY,__,WL,__,QB,WL,SA,SF,SA }, /* 0 */
	{ SA,SB,SA,WL,__,QY,__,QY,WL,QB,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,WL,__,RY,__,__,WL,__,__,WL,SA,SA,SE }, /* 0 */
	{ SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SF,SE,SA }, /* 0 */
	/* 0 13 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Shut the door", /* ICULT?0 */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,SA,WL,SC,WL,SD,WL,SC,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SF,WL,__,WL,__,WL,__,WL,SB,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,WL,__,QB,__,MW,__,QY,__,WL,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,SA,WL,__,__,RY,__,__,WL,SF,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,WL,__,MW,RB,TL,RB,MW,__,WL,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,SA,WL,__,__,RY,__,__,WL,SA,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,WL,TL,QY,__,PL,__,QB,TL,WL,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,WL,__,WL,__,WL,__,WL,SC,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,SC,WL,SB,WL,SH,WL,SD,SA,SA,SE,SA }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Royal pain", /* HIPND67890 */
	/* 0 0 0 */
   {	{ SD,SA,SA,SH,WL,SB,SA,SA,SE,SB,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,WL,TL,WL,SC,SA,SA,WL,TL,WL,SA,SC,SE }, /* 0 */
	{ SF,SD,WL,__,__,__,WL,SH,WL,__,__,__,WL,SA,SA }, /* 0 */
	{ SB,WL,__,RB,RB,RB,__,WL,__,RY,RY,RY,__,WL,SA }, /* 0 */
	{ WL,TL,__,RB,__,RB,__,TL,__,RY,__,RY,__,TL,WL }, /* 0 */
	{ SC,WL,__,__,__,__,WL,WL,WL,__,__,__,__,WL,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,__,MU,__,__,__,__,WL,SF,SB }, /* 0 */
	{ SE,SA,SA,WL,PL,__,__,WL,__,__,__,WL,SA,SC,SA }, /* 0 */
	{ SA,SH,SB,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SD,SA }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Merry-go-round", /* 567890 */
	/* 0 0 0 */
   {	{ SA,SC,SA,SF,WL,WL,WL,WL,WL,WL,WL,SA,SF,SE,SA }, /* 0 */
	{ SE,SA,SB,SA,WL,PL,__,__,__,__,WL,SH,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,QY,__,MU,__,WL,SA,SC,SA,SA }, /* 0 */
	{ SB,SC,SB,SA,WL,__,QY,__,DB,__,WL,SB,SA,SH,SE }, /* 0 */
	{ SA,SA,SA,SC,WL,__,QY,__,DB,__,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,SA,WL,__,QY,__,DB,__,WL,SA,SB,SA,SA }, /* 0 */
	{ SH,SA,SA,SF,WL,__,QY,__,DB,__,WL,SE,SA,SA,SF }, /* 0 */
	{ SA,SB,SA,SE,WL,__,__,__,__,__,WL,SA,SA,SB,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	/* 0 9 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Quickie", /* TATIONND67890 */
	/* 0 0 0 */
   {	{ SA,SA,SA,SA,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA,SA }, /* 0 */
	{ SE,SA,SA,SA,WL,WL,WL,WL,WL,WL,SA,SA,SA,SD,SC }, /* 0 */
	{ SA,SF,SA,SA,WL,__,__,QB,__,WL,SA,SB,SH,SA,SA }, /* 0 */
	{ SA,SA,SA,SF,WL,__,MW,QY,__,WL,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,MW,TL,MW,__,WL,SF,SA,SB,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,WL,__,MW,MU,QY,WL,SA,SA,SA,SC,SE }, /* 0 */
	{ SA,SB,SA,SA,WL,__,PL,QB,TL,WL,SA,SF,SA,SA,SA }, /* 0 */
	{ SH,SC,SA,SA,WL,WL,WL,WL,WL,WL,SA,SH,SA,SB,SA }, /* 0 */
	{ SA,SA,SA,SA,SA,SB,SA,SA,SA,SA,SA,SA,SA,SA,SF }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"East and west", /* 4567890 */
	/* 0 0 0 */
   {	{ SA,SA,WL,WL,WL,WL,WL,SC,WL,WL,WL,WL,WL,SA,SA }, /* 0 */
	{ SE,SA,WL,__,__,__,WL,SB,WL,__,__,__,WL,SH,SC }, /* 0 */
	{ SA,SF,WL,__,QY,__,WL,SA,WL,__,QB,__,WL,SA,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,WL,WL,WL,__,__,__,WL,SE,SA }, /* 0 */
	{ SA,SA,WL,__,QY,__,__,MU,__,__,QB,__,WL,SA,SA }, /* 0 */
	{ SA,SB,WL,__,__,__,WL,WL,WL,__,__,__,WL,SA,SE }, /* 0 */
	{ SA,SA,WL,__,QY,__,WL,SE,WL,__,QB,__,WL,SA,SA }, /* 0 */
	{ SH,SA,WL,__,__,__,WL,SA,WL,PL,__,__,WL,SA,SA }, /* 0 */
	{ SA,SA,WL,WL,WL,WL,WL,SA,WL,WL,WL,WL,WL,SA,SF }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Destination unknown", /* 0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ SA,SA,SH,WL,__,QY,__,MU,TL,__,__,WL,SA,SA,SH }, /* 0 */
	{ SF,SA,SA,WL,__,__,QB,__,WL,__,__,WL,SA,SC,SE }, /* 0 */
	{ SA,SA,SB,WL,__,QY,__,MU,TL,__,__,WL,SA,SE,SA }, /* 0 */
	{ SA,SB,SA,WL,QY,__,QY,__,WL,__,__,WL,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,WL,__,QB,__,MU,TL,__,__,WL,SA,SB,SC }, /* 0 */
	{ SH,SB,SE,WL,__,PL,QB,__,WL,WL,WL,WL,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,WL,__,__,__,MU,TL,QB,QB,WL,SB,SA,SF }, /* 0 */
	{ SE,SA,SB,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 9 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Five foot square I", /* II */
	/* 0 0 0 */
   {	{ SB,SA,SA,SD,SA,SA,SA,SA,SA,SA,SA,SA,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SH,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,QY,TL,__,QY,__,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,QY,QY,__,TL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,__,TL,MU,TL,PL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SH,WL,TL,__,QB,QB,__,WL,SA,SA,SD,SB }, /* 0 */
	{ SA,SA,SB,SA,WL,__,QB,__,TL,QB,WL,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SD,SA,SA,SA,SH,SA,SF,SD,SA,SA,SB,SA }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Five foot square II", /* 0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,SD,SA,SA,SA,SA,SA,SA,SA,SA,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SH,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,QY,TL,__,QY,__,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,QY,MW,__,TL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,__,TL,MU,TL,PL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SH,WL,TL,__,MW,QB,__,WL,SA,SA,SD,SB }, /* 0 */
	{ SA,SA,SB,SA,WL,__,QB,__,TL,QB,WL,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SD,SA,SA,SA,SH,SA,SF,SD,SA,SA,SB,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Five foot square III", /*  */
	/* 0 0 0 */
   {	{ SB,SA,SA,SD,SA,SA,SA,SA,SA,SA,SA,SA,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SH,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,QY,TL,__,QY,__,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,MW,MW,__,TL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,__,TL,MU,TL,PL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SH,WL,TL,__,MW,MW,__,WL,SA,SA,SD,SB }, /* 0 */
	{ SA,SA,SB,SA,WL,__,QB,__,TL,QB,WL,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SD,SA,SA,SA,SH,SA,SF,SD,SA,SA,SB,SA }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Five foot square IV", /* 0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,SD,SA,SA,SA,SA,SA,SA,SA,SA,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SH,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,QB,TL,__,QB,__,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,MW,MW,__,TL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,__,TL,CF,TL,PL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SH,WL,TL,__,MW,MW,__,WL,SA,SA,SD,SB }, /* 0 */
	{ SA,SA,SB,SA,WL,__,QB,__,TL,QB,WL,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SD,SA,SA,SA,SH,SA,SF,SD,SA,SA,SB,SA }, /* 0 */
	/* 0 4 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Five foot square V", /* I0 */
	/* 0 0 0 */
   {	{ SB,SA,SA,SD,SA,SA,SA,SA,SA,SA,SA,SA,SA,SF,SA }, /* 0 */
	{ SA,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SH,SA }, /* 0 */
	{ SA,SH,SA,SA,WL,QY,TL,__,QY,__,WL,SA,SA,SA,SB }, /* 0 */
	{ SA,SA,SA,SA,WL,__,MW,QY,MW,TL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SF,SA,SA,WL,__,TL,MU,TL,PL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SH,WL,TL,MW,QB,MW,__,WL,SA,SA,SD,SB }, /* 0 */
	{ SA,SA,SB,SA,WL,__,QB,__,TL,QB,WL,SA,SA,SA,SA }, /* 0 */
	{ SB,SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	{ SA,SA,SA,SD,SA,SA,SA,SH,SA,SF,SD,SA,SA,SB,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Diamond mine", /* UNKNOWN0 */
	/* 0 0 0 */
   {	{ SF,SA,SD,SA,SB,SA,SA,SE,SA,SF,SD,SA,SB,SA,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SB }, /* 0 */
	{ SA,WL,QB,QY,QY,QB,QY,QB,__,DY,DB,PY,PB,WL,SA }, /* 0 */
	{ SE,WL,DY,DY,DB,DY,DB,__,__,DB,__,DB,DY,WL,SA }, /* 0 */
	{ SA,WL,DB,DB,DY,QB,QY,PL,DB,DY,QB,QY,__,WL,SF }, /* 0 */
	{ SH,WL,__,DY,__,DY,__,__,DY,DB,DY,DB,DB,WL,SA }, /* 0 */
	{ SB,WL,PY,PB,DY,DB,__,QY,QB,QB,QY,QB,QY,WL,SB }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,SD,SA,SC,SB,SF,SC,SA,SA,SA,SH,SB,SF,SA,SA }, /* 0 */
	/* 0 44 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Cells", /* T MY OWN COMPAR */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,MW,__,__,MW,__,__,MW,__,__,__,WL }, /* 0 */
	{ WL,__,QY,__,MW,__,MW,QY,MW,__,MW,__,QB,__,WL }, /* 0 */
	{ WL,__,__,__,MW,__,__,MW,__,__,MW,__,__,__,WL }, /* 0 */
	{ WL,MW,MW,MW,MW,MW,MW,MW,MW,MW,MW,MW,MW,MW,WL }, /* 0 */
	{ WL,__,__,__,MW,__,__,MW,__,PL,MW,__,__,__,WL }, /* 0 */
	{ WL,__,QY,__,MW,__,MW,QB,MW,__,MW,__,QB,__,WL }, /* 0 */
	{ WL,__,__,__,MW,__,__,MW,__,__,MW,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"NorWeSouthEast", /* ST,WES */
	/* 0 0 0 */
   {	{ SC,SD,SC,SD,WL,WL,WL,WL,WL,WL,WL,SA,SF,SA,SF }, /* 0 */
	{ WL,WL,WL,WL,WL,TL,__,__,__,__,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,PL,__,TL,WL,__,QB,__,QB,__,WL,__,__,__,WL }, /* 0 */
	{ WL,__,QB,__,WL,WL,WL,CF,WL,WL,WL,__,QY,__,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,MU,__,__,__,__,__,__,WL }, /* 0 */
	{ WL,__,QB,__,WL,WL,WL,CF,WL,WL,WL,__,QY,__,WL }, /* 0 */
	{ WL,__,__,__,WL,__,QY,__,QY,__,WL,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,__,__,__,__,__,WL,WL,WL,WL,WL }, /* 0 */
	{ SE,SA,SE,SA,WL,WL,WL,WL,WL,WL,WL,SC,SD,SC,SD }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Sliding blocks", /* EAT)DO */
	/* 0 0 0 */
   {	{ SF,WL,WL,WL,WL,WL,SA,SE,SA,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SA,WL,__,__,__,WL,WL,WL,WL,WL,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,QY,WL,__,__,__,WL,QB,__,__,WL,SB }, /* 0 */
	{ SA,WL,WL,__,__,QY,__,WL,__,QB,__,__,WL,WL,SC }, /* 0 */
	{ SA,WL,WL,__,WL,MW,__,PL,__,MW,WL,__,WL,WL,SA }, /* 0 */
	{ SH,WL,WL,__,__,QY,__,WL,__,QB,__,__,WL,WL,SA }, /* 0 */
	{ SB,WL,__,__,QY,WL,__,__,__,WL,QB,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,__,__,WL,WL,WL,WL,WL,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,SC,SA,SA,WL,WL,WL,WL,WL,SE }, /* 0 */
	/* 0 8 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Yellow brick road", /* WN0 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,__,__,__,__,__,__,__,WL }, /* 0 */
	{ WL,__,__,RB,__,RB,__,RB,__,RB,__,RB,__,__,WL }, /* 0 */
	{ WL,__,__,__,QY,QY,QY,QY,QY,QY,QY,__,__,__,WL }, /* 0 */
	{ WL,__,__,RB,QY,RB,__,RB,__,RB,QY,RB,__,__,WL }, /* 0 */
	{ WL,__,__,__,QY,QY,QY,QY,MU,__,QY,__,__,__,WL }, /* 0 */
	{ WL,__,__,RB,__,RB,__,RB,__,RB,QY,RB,__,__,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,__,__,__,PL,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 30 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Tea 'n' stones", /* NKNOWN0 */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,__,__,__,__,__,__,__,__,__,__,__,__,__,WL }, /* 0 */
	{ WL,TL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,__,WL }, /* 0 */
	{ WL,PB,WL,__,MW,__,__,WL,__,MW,__,__,WL,TL,WL }, /* 0 */
	{ WL,PL,WL,__,__,QY,__,WL,__,__,MW,__,WL,TL,WL }, /* 0 */
	{ WL,MU,MW,MU,QB,MW,__,WL,__,__,__,DB,DY,__,WL }, /* 0 */
	{ WL,DY,__,__,QB,QY,__,WL,__,__,MW,__,__,__,WL }, /* 0 */
	{ WL,DB,PY,__,__,WL,__,__,__,WL,__,__,__,__,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 10 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"T for trap", /* 2T TEST  */
	/* 0 0 0 */
   {	{ SB,SD,SH,SD,SB,SD,SA,SC,SH,SB,SD,SC,SB,SC,SB }, /* 0 */
	{ SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SB,WL,__,__,__,__,__,WL,__,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,TL,PY,TL,PY,__,WL,__,PB,TL,PB,TL,WL,SD }, /* 0 */
	{ SA,WL,__,WL,WL,MW,WL,TL,WL,MW,WL,WL,__,WL,SH }, /* 0 */
	{ SD,WL,__,__,__,__,__,WL,__,__,__,__,__,WL,SA }, /* 0 */
	{ SA,WL,__,RY,TL,WL,__,PL,__,WL,TL,RB,__,WL,SA }, /* 0 */
	{ SH,WL,__,__,MW,__,__,__,__,__,MW,__,__,WL,SB }, /* 0 */
	{ SC,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Flip flop", /* ASY UP...90 */
	/* 0 0 0 */
   {	{ SE,SA,WL,WL,WL,WL,WL,WL,SB,SA,SA,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,WL,__,__,__,__,WL,WL,WL,WL,WL,WL,SA,SA }, /* 0 */
	{ SF,SA,WL,__,MW,QB,TL,TL,__,__,MW,TL,WL,SF,SA }, /* 0 */
	{ SA,SA,SE,WL,RY,__,MW,MW,__,__,MW,__,WL,SA,SE }, /* 0 */
	{ SC,SA,SA,WL,__,QY,__,PL,WL,WL,WL,MU,WL,WL,SA }, /* 0 */
	{ SE,SF,SA,WL,__,__,TL,MW,QY,__,__,__,__,WL,SH }, /* 0 */
	{ SA,SA,SE,WL,__,__,__,__,__,__,MW,__,TL,WL,SA }, /* 0 */
	{ SA,SE,SA,WL,PB,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ SB,SA,SF,WL,WL,WL,SA,SA,SA,SA,SF,SA,SA,SE,SA }, /* 0 */
	/* 0 5 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Full house", /* HE BACK OF */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	{ WL,PL,RB,QY,WL,TL,CY,MW,CF,MW,WL,QB,QY,QB,WL }, /* 0 */
	{ WL,PY,RY,TL,WL,MU,MW,CB,MW,CY,WL,QY,QB,QY,WL }, /* 0 */
	{ WL,PB,RY,RB,WL,MW,CF,MW,CB,MW,WL,QB,RY,QB,WL }, /* 0 */
	{ WL,RY,RB,RY,WL,TL,MW,MU,MW,MU,WL,TL,RB,QY,WL }, /* 0 */
	{ WL,MU,RY,PB,WL,MW,CY,MW,CF,MW,WL,PB,QY,QB,WL }, /* 0 */
	{ WL,QB,QB,PY,WL,CF,WL,WL,WL,WL,WL,PY,QB,QY,WL }, /* 0 */
	{ WL,QY,DB,DY,PB,RY,QB,QY,QB,PY,PB,RY,QB,RB,WL }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL }, /* 0 */
	/* 0 45 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Forgotten transport", /* E */
	/* 0 0 0 */
   {	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SC,SA,SA }, /* 0 */
	{ WL,__,QB,__,__,QY,MU,MU,TL,__,__,WL,SA,SA,SH }, /* 0 */
	{ WL,__,__,__,QB,__,QB,MU,WL,__,__,WL,SA,SC,SE }, /* 0 */
	{ WL,__,__,QY,__,QY,MU,MU,TL,__,__,WL,SA,SE,SA }, /* 0 */
	{ WL,__,__,QB,QY,__,QY,MU,WL,__,__,WL,SA,SA,SA }, /* 0 */
	{ WL,__,QY,__,__,QB,MU,MU,TL,__,__,WL,SA,SB,SC }, /* 0 */
	{ WL,__,__,QY,QB,PL,QB,MU,WL,WL,WL,WL,SA,SA,SB }, /* 0 */
	{ WL,QB,__,__,__,__,MU,MU,TL,QB,QB,WL,SB,SA,SF }, /* 0 */
	{ WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	/* 0 17 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Walls with me", /* MIND DO */
	/* 0 0 0 */
   {	{ SE,SA,SH,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,SF,WL,QY,__,QB,__,__,WL,SB,SA,SA,SA }, /* 0 */
	{ SF,SA,SA,SA,WL,__,QY,MW,__,__,WL,SE,SE,SF,SA }, /* 0 */
	{ SA,SA,SE,SA,WL,__,MW,__,MW,__,WL,SF,SB,SA,SE }, /* 0 */
	{ SC,SA,SA,SC,WL,__,__,PL,__,QY,WL,SE,SA,SA,SA }, /* 0 */
	{ SE,SF,SA,SA,WL,QB,QB,QB,RB,QY,WL,SA,SA,SA,SH }, /* 0 */
	{ SA,SA,SE,SA,WL,QB,RY,QB,QY,__,WL,SA,SF,SA,SA }, /* 0 */
	{ SA,SE,SA,SB,WL,__,__,__,__,__,WL,SC,SH,SA,SA }, /* 0 */
	{ SB,SA,SF,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SE,SA }, /* 0 */
	/* 0 13 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Stalemate?", /* IMEHD67890 */
	/* 0 0 0 */
   {	{ SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA }, /* 0 */
	{ SE,SA,SC,WL,QB,WL,__,__,__,__,__,WL,SB,SH,SC }, /* 0 */
	{ SA,SF,SA,WL,__,WL,__,MW,__,DB,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SA,SE,WL,__,WL,__,__,WL,WL,WL,WL,SA,SE,SA }, /* 0 */
	{ SA,SA,SA,WL,__,WL,CF,MU,WL,PL,__,WL,SA,SA,SA }, /* 0 */
	{ SA,SB,SA,WL,__,WL,MW,MU,WL,QB,__,WL,SA,SA,SE }, /* 0 */
	{ SA,SA,SA,WL,__,MW,__,RB,__,QB,__,WL,SA,SA,SA }, /* 0 */
	{ SH,SA,SF,WL,__,__,__,__,__,__,__,WL,SB,SA,SA }, /* 0 */
	{ SA,SA,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SA,SA,SF }, /* 0 */
	/* 0 5 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"2-headed worm", /* T TEST  */
	/* 0 0 0 */
   {	{ SB,WL,WL,WL,WL,WL,SC,SA,SA,WL,WL,WL,WL,WL,SA }, /* 0 */
	{ WL,__,__,__,__,__,WL,SD,WL,__,__,__,__,__,WL }, /* 0 */
	{ WL,__,QB,__,QB,__,WL,SC,WL,__,DB,MU,DB,__,WL }, /* 0 */
	{ WL,__,__,TL,__,__,WL,SA,WL,__,__,TL,__,__,WL }, /* 0 */
	{ SA,WL,__,TL,__,WL,SA,SF,SE,WL,__,TL,__,WL,SB }, /* 0 */
	{ SB,WL,__,QB,__,WL,SB,SA,SA,WL,__,DB,__,WL,SA }, /* 0 */
	{ SH,SA,WL,CF,WL,WL,WL,WL,WL,WL,WL,__,WL,SC,SD }, /* 0 */
	{ SB,SD,WL,CF,__,__,__,PL,__,__,__,__,WL,SA,SF }, /* 0 */
	{ SA,SB,SA,WL,WL,WL,WL,WL,WL,WL,WL,WL,SF,SA,SA }, /* 0 */
	/* 0 6 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
{	"Turnabout is fair...", /*  */
	/* 0 0 0 */
   {	{ SA,SC,SA,SF,WL,WL,WL,WL,WL,WL,WL,SA,SF,SE,SA }, /* 0 */
	{ SE,SA,WL,WL,WL,MU,MU,MU,MU,MU,WL,WL,WL,WL,WL }, /* 0 */
	{ SA,SA,WL,MU,MU,DB,MU,DY,MU,DB,MU,MU,MU,MU,WL }, /* 0 */
	{ SB,SC,WL,MU,DB,MU,RY,MU,MU,MU,RY,MU,RB,MU,WL }, /* 0 */
	{ SA,SA,WL,PL,MU,MU,MU,MU,MU,MU,MU,MU,MU,MU,WL }, /* 0 */
	{ SA,SA,WL,MU,DY,MU,RB,MU,RY,MU,QB,MU,RY,MU,WL }, /* 0 */
	{ SH,SA,WL,MU,MU,MU,MU,DB,MU,DY,MU,MU,MU,MU,WL }, /* 0 */
	{ SA,SB,WL,WL,WL,MU,QB,RY,MU,MU,WL,WL,WL,WL,WL }, /* 0 */
	{ SA,SF,SA,SA,WL,WL,WL,WL,WL,WL,WL,SA,SA,SA,SA }, /* 0 */
	/* 0 16 3 231 3 231 8 32 32 32 32 32 32 32 32 0 */
   }
},
};
