#include<woo/pkg/gl/GlWooLogo.hpp>

namespace woo{
	/* data obtained from exporting the SVG from inkscape to POV, then hand-editing */

	AlignedBox2r getGlWooLogoRawBox(){ return AlignedBox2r(Vector2r(14.17,14.17),Vector2r(462.05,439.37)); }

	vector<vector<Vector2r>> getGlWooLogoRawData(){
		return {{
			Vector2r(14.17404750, 368.50459400),  
			Vector2r(14.17387020, 198.42491093),  
			Vector2r(15.90154426, 181.28652351),  
			Vector2r(20.85664416, 165.32377458),  
			Vector2r(28.69718663, 150.87861772),  
			Vector2r(39.08122802, 138.29301786),  
			Vector2r(51.66680602, 127.90895225),  
			Vector2r(66.11194235, 120.06836581),  
			Vector2r(82.07468594, 115.11324228),  
			Vector2r(99.21307305, 113.38552344),  
			Vector2r(113.98639826, 114.29941816), 
			Vector2r(128.31318181, 117.02509008), 
			Vector2r(141.82477789, 121.53849658), 
			Vector2r(154.15253808, 127.81559359), 
			Vector2r(164.92782812, 135.83231052), 
			Vector2r(173.78199763, 145.56461370), 
			Vector2r(180.34640723, 156.98844114), 
			Vector2r(184.25241465, 170.07974076)
		},{
			Vector2r(184.25241465, 170.07974076), 
			Vector2r(184.25234199, 85.03937152), 
			Vector2r(185.69207761, 70.75735347), 
			Vector2r(189.82133185, 57.45503055), 
			Vector2r(196.35513846, 45.41736974), 
			Vector2r(205.00853033, 34.92933755), 
			Vector2r(215.49653206, 26.27591879), 
			Vector2r(227.53417394, 19.74207844), 
			Vector2r(240.83648559, 15.61279265), 
			Vector2r(255.11850401, 14.17301877), 
			Vector2r(267.26153213, 14.77760524), 
			Vector2r(279.13754388, 16.62556829), 
			Vector2r(290.41080161, 19.76813347), 
			Vector2r(300.74556852, 24.25652682), 
			Vector2r(309.80609524, 30.14199021), 
			Vector2r(317.25664085, 37.47575885), 
			Vector2r(322.76146183, 46.30906643), 
			Vector2r(325.98482053, 56.69313851)
		},{
			Vector2r(320.31338713, 325.98190119), 
			Vector2r(318.00053792, 347.83597648), 
			Vector2r(311.37818174, 369.24563363), 
			Vector2r(300.92066525, 389.06671319), 
			Vector2r(287.10234246, 406.15508303), 
			Vector2r(270.01399167, 419.97344663), 
			Vector2r(250.19293851, 430.43101045), 
			Vector2r(228.78329647, 437.05341324), 
			Vector2r(206.92921867, 439.36630510), 
			Vector2r(185.18887846, 437.16720238), 
			Vector2r(163.96880709, 430.73441636), 
			Vector2r(144.18563922, 420.31481537), 
			Vector2r(126.75602817, 406.15525543), 
			Vector2r(112.59643970, 388.88685046), 
			Vector2r(102.17679186, 369.37234552), 
			Vector2r(95.74396556, 348.20600817), 
			Vector2r(93.54482342, 325.98214164), 
			Vector2r(95.74393750, 303.75826432), 
			Vector2r(102.17671706, 282.59191758), 
			Vector2r(112.59630677, 263.07738498), 
			Vector2r(126.75585077, 245.80894980), 
			Vector2r(144.02424871, 231.64935150), 
			Vector2r(163.53876528, 221.22971153), 
			Vector2r(184.70510386, 214.79688709), 
			Vector2r(206.92896956, 212.59773639), 
			Vector2r(229.15284742, 214.79683554), 
			Vector2r(250.31919847, 221.22962163), 
			Vector2r(269.83373313, 231.64922777), 
			Vector2r(287.10216006, 245.80878606), 
			Vector2r(301.26174756, 263.23836399), 
			Vector2r(311.68139468, 283.02151031), 
			Vector2r(318.11423034, 304.24156988), 
			Vector2r(320.31338713, 325.98190119)
		},{
			Vector2r(462.04578333, 212.59747574), 
			Vector2r(459.84667702, 234.82134600), 
			Vector2r(453.41388942, 255.98769965), 
			Vector2r(442.99429195, 275.50223931), 
			Vector2r(428.83473365, 292.77066624), 
			Vector2r(411.56632619, 306.93025904), 
			Vector2r(392.05182674, 317.34989735), 
			Vector2r(370.88548989, 323.78272279), 
			Vector2r(348.66162852, 325.98187599), 
			Vector2r(326.43774460, 323.78277334), 
			Vector2r(305.27139095, 317.34998575), 
			Vector2r(285.75685129, 306.93038827), 
			Vector2r(268.48842936, 292.77082132), 
			Vector2r(254.32884522, 275.50241885), 
			Vector2r(243.90919459, 255.98790074), 
			Vector2r(237.47635982, 234.82157005), 
			Vector2r(235.27720229, 212.59770619), 
			Vector2r(237.47630514, 190.37383393), 
			Vector2r(243.90908600, 169.20748794), 
			Vector2r(254.32869127, 149.69295278), 
			Vector2r(268.48825562, 132.42452935), 
			Vector2r(285.75665809, 118.26494521), 
			Vector2r(305.27117100, 107.84529158), 
			Vector2r(326.43749573, 101.41245914), 
			Vector2r(348.66137075, 99.21330228),
			Vector2r(370.88524101, 101.41240859), 
			Vector2r(392.05159967, 107.84518752), 
			Vector2r(411.56613432, 118.26479366), 
			Vector2r(428.83456125, 132.42435195), 
			Vector2r(442.99415405, 149.69275942), 
			Vector2r(453.41380103, 169.20726386), 
			Vector2r(459.84663512, 190.37360571), 
			Vector2r(462.04578333, 212.59747574)
		}};
	}

	vector<vector<Vector2r>> glLogoCache;

	const vector<vector<Vector2r>>& getGlWooLogo(){
		if(!glLogoCache.empty()) return glLogoCache;
		auto rawBox=getGlWooLogoRawBox();
		Real maxSize=rawBox.sizes().maxCoeff();
		const auto data=getGlWooLogoRawData();
		glLogoCache.reserve(data.size());
		for(const auto& polyRaw: data){
			vector<Vector2r> polyNorm; polyNorm.reserve(polyRaw.size());
			for(auto pt: polyRaw){ // make copy, since we flip
				pt[1]=rawBox.max()[1]-pt[1]; // y-flip because of opengl coords
				polyNorm.push_back((pt-rawBox.min())/maxSize);
			}
			glLogoCache.push_back(polyNorm);
		}
		return glLogoCache;
	}

}; /* namespace woo */
