/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.Molecule;
import WIMSchem.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogEdit
extends JDialog
implements ActionListener {
    Molecule mol;
    Molecule retMol = null;
    ArrayList<Integer> aselidx;
    ArrayList<Integer> bselidx;
    JTabbedPane tabs;
    JButton accept;
    JButton reject;
    JTable atoms;
    JTable bonds;
    static final String[] BOND_TYPES = new String[]{"Normal", "Inclined", "Declined", "Unknown"};

    public DialogEdit(Frame Parent, Molecule Mol, ArrayList<Integer> SelIdx) {
        super(Parent, "Edit Molecule", true);
        this.mol = Mol.clone();
        this.aselidx = SelIdx;
        this.bselidx = new ArrayList();
        for (int n = 1; n <= this.mol.numBonds(); ++n) {
            if (this.aselidx.indexOf(this.mol.bondFrom(n)) < 0 || this.aselidx.indexOf(this.mol.bondTo(n)) < 0) continue;
            this.bselidx.add(n);
        }
        this.setLayout(new BorderLayout());
        this.atoms = new JTable(this.compileAtomData(), new String[]{"#", "El", "X", "Y", "Charge", "Unpaired", "HExplicit", "MapNum"}){

            public boolean isCellEditable(int row, int column) {
                return column > 0;
            }
        };
        this.bonds = new JTable(this.compileBondData(), new String[]{"#", "From", "To", "Order", "Type"}){

            public boolean isCellEditable(int row, int column) {
                return column > 2;
            }
        };
        this.atoms.getColumnModel().getColumn(0).setCellEditor(null);
        JComboBox<String> bondTypes = new JComboBox<String>();
        for (int n = 0; n < BOND_TYPES.length; ++n) {
            bondTypes.addItem(BOND_TYPES[n]);
        }
        this.bonds.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(bondTypes));
        JPanel tabAtoms = new JPanel();
        JPanel tabBonds = new JPanel();
        tabAtoms.setLayout(new BorderLayout());
        tabBonds.setLayout(new BorderLayout());
        this.atoms.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this.bonds.setPreferredScrollableViewportSize(new Dimension(350, 200));
        tabAtoms.add(new JScrollPane(this.atoms));
        tabBonds.add(new JScrollPane(this.bonds));
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Atoms", tabAtoms);
        this.tabs.addTab("Bonds", tabBonds);
        this.add((Component)this.tabs, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        this.accept = new JButton("Accept");
        this.accept.addActionListener(this);
        this.accept.setMnemonic(65);
        this.reject = new JButton("Reject");
        this.reject.addActionListener(this);
        this.reject.setMnemonic(82);
        buttons.add(this.accept);
        buttons.add(this.reject);
        this.add((Component)buttons, "South");
        this.pack();
    }

    public Molecule exec() {
        this.setVisible(true);
        return this.retMol;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accept) {
            if (!this.ReadData()) {
                return;
            }
            this.retMol = this.mol;
            this.setVisible(false);
        }
        if (e.getSource() == this.reject) {
            this.setVisible(false);
        }
    }

    private Object[][] compileAtomData() {
        Object[][] data = new Object[this.aselidx.size()][];
        DecimalFormat fmt = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        for (int n = 0; n < this.aselidx.size(); ++n) {
            int i = this.aselidx.get(n);
            Object[] da = new Object[]{new Integer(i), new String(this.mol.atomElement(i)), fmt.format(this.mol.atomX(i)), fmt.format(this.mol.atomY(i)), String.valueOf(this.mol.atomCharge(i)), String.valueOf(this.mol.atomUnpaired(i)), this.mol.atomHExplicit(i) == -1 ? "?" : String.valueOf(this.mol.atomHExplicit(i)), String.valueOf(this.mol.atomMapNum(i))};
            data[n] = da;
        }
        return data;
    }

    private Object[][] compileBondData() {
        Object[][] data = new Object[this.bselidx.size()][];
        for (int n = 0; n < this.bselidx.size(); ++n) {
            int i = this.bselidx.get(n);
            Object[] db = new Object[]{new Integer(i), new Integer(this.mol.bondFrom(i)), new Integer(this.mol.bondTo(i)), String.valueOf(this.mol.bondOrder(i)), new String(BOND_TYPES[this.mol.bondType(i)])};
            data[n] = db;
        }
        return data;
    }

    private boolean ReadData() {
        int i;
        int n;
        for (n = 0; n < this.atoms.getRowCount(); ++n) {
            i = (Integer)this.atoms.getValueAt(n, 0);
            this.mol.setAtomElement(i, (String)this.atoms.getValueAt(n, 1));
            this.mol.setAtomPos(i, Util.safeDouble((String)this.atoms.getValueAt(n, 2)), Util.safeDouble((String)this.atoms.getValueAt(n, 3)));
            this.mol.setAtomCharge(i, Util.safeInt((String)this.atoms.getValueAt(n, 4)));
            this.mol.setAtomUnpaired(i, Util.safeInt((String)this.atoms.getValueAt(n, 5)));
            String hyStr = (String)this.atoms.getValueAt(n, 6);
            int hy = Util.safeInt(hyStr);
            this.mol.setAtomHExplicit(i, hyStr.compareTo("0") == 0 ? 0 : (hy > 0 ? hy : -1));
            this.mol.setAtomMapNum(i, Util.safeInt((String)this.atoms.getValueAt(n, 7)));
        }
        block1: for (n = 0; n < this.bonds.getRowCount(); ++n) {
            i = (Integer)this.bonds.getValueAt(n, 0);
            this.mol.setBondOrder(i, new Integer((String)this.bonds.getValueAt(n, 3)));
            for (int j = BOND_TYPES.length - 1; j >= 0; --j) {
                if (BOND_TYPES[j].compareTo((String)this.bonds.getValueAt(n, 4)) != 0) continue;
                this.mol.setBondType(i, j);
                continue block1;
            }
        }
        return true;
    }
}

