/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public class Backbone
extends BioShapeCollection {
    BitSet bsSelected;

    public void initShape() {
        super.initShape();
        this.madOn = 1;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)2000;
        this.isActive = true;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("bitset" == string) {
            this.bsSelected = (BitSet)object;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public void setSize(int n, BitSet bitSet) {
        boolean bl;
        short s = (short)n;
        this.initialize();
        boolean bl2 = bl = this.bsSelected != null;
        if (bl) {
            bitSet = this.bsSelected;
        }
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            boolean bl3;
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount == 0) continue;
            boolean bl4 = this.viewer.getBondSelectionModeOr();
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            boolean bl5 = bl3 = s != 0;
            if (bioShape.bsSizeSet == null) {
                bioShape.bsSizeSet = new BitSet();
            }
            bioShape.isActive = true;
            int n3 = bioShape.monomerCount - 1;
            while (--n3 >= 0) {
                boolean bl6;
                int n4 = nArray[n3];
                int n5 = nArray[n3 + 1];
                boolean bl7 = bitSet.get(n4);
                boolean bl8 = bitSet.get(n5);
                if (!(bl7 && bl8 || bl && bl7) && (!bl4 || !bl7 && !bl8)) continue;
                bioShape.monomers[n3].setShapeVisibility(this.myVisibilityFlag, bl3);
                Atom atom = this.modelSet.getAtomAt(n4);
                Atom atom2 = this.modelSet.getAtomAt(n5);
                boolean bl9 = bl6 = bioShape.mads[n3] != 0;
                if (bl6 != bl3) {
                    atom.addDisplayedBackbone(this.myVisibilityFlag, bl3);
                    atom2.addDisplayedBackbone(this.myVisibilityFlag, bl3);
                }
                bioShape.mads[n3] = s;
                bioShape.bsSizeSet.set(n3, bl3);
                bioShape.bsSizeDefault.set(n3, s == -1);
            }
        }
        if (bl) {
            this.bsSelected = null;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            int[] nArray = bioShape.bioPolymer.getLeadAtomIndices();
            int n2 = bioShape.monomerCount;
            while (--n2 >= 0) {
                Atom atom = this.modelSet.getAtomAt(nArray[n2]);
                if (atom.getNBackbonesDisplayed() <= 0 || this.modelSet.isAtomHidden(n2)) continue;
                atom.setClickable(this.myVisibilityFlag);
            }
        }
    }
}

