/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainApplet;
import WIMSchem.MainPanel;
import WIMSchem.SVGFont;
import WIMSchem.Util;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;

public class SVGBuilder {
    DecimalFormat df = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    public static final int NOCOLOUR = -1;
    public static final int TXTSTYLE_NORMAL = 0;
    public static final int TXTSTYLE_BOLD = 1;
    public static final int TXTSTYLE_ITALIC = 2;
    public static final int TXTALIGN_CENTRE = 0;
    public static final int TXTALIGN_LEFT = 1;
    public static final int TXTALIGN_RIGHT = 2;
    public String g_id = "g_SVG_1000000";
    public String svg_id = "SVG_1000000";
    private boolean fresh = true;
    private double lowX = 0.0;
    private double lowY = 0.0;
    private double highX = 0.0;
    private double highY = 0.0;
    private boolean[] charMask = new boolean[96];
    private static final int ATOM_LINE = 1;
    private static final int ATOM_RECT = 2;
    private static final int ATOM_OVAL = 3;
    private static final int ATOM_PATH = 4;
    private static final int ATOM_TEXT = 5;
    private ArrayList<Atom> atoms = new ArrayList();
    private ArrayList<LineType> lineTypes = new ArrayList();
    private ArrayList<RectType> rectTypes = new ArrayList();
    private ArrayList<OvalType> ovalTypes = new ArrayList();
    private ArrayList<PathType> pathTypes = new ArrayList();
    private ArrayList<TextType> textTypes = new ArrayList();

    public SVGBuilder() {
        for (int n = 0; n < 96; ++n) {
            this.charMask[n] = false;
        }
    }

    public double lowX() {
        return this.lowX;
    }

    public double lowY() {
        return this.lowY;
    }

    public double highX() {
        return this.highX;
    }

    public double highY() {
        return this.highY;
    }

    public void drawLine(double X1, double Y1, double X2, double Y2, int Colour, double Thickness) {
        this.updateBounds(X1 - Thickness, Y1 - Thickness);
        this.updateBounds(X1 + Thickness, Y1 + Thickness);
        this.updateBounds(X2 - Thickness, Y2 - Thickness);
        this.updateBounds(X2 + Thickness, Y2 + Thickness);
        LineType type = new LineType();
        type.Thickness = Thickness;
        type.Colour = Colour;
        LineAtom atom = new LineAtom();
        atom.AtomClass = 1;
        atom.X1 = X1;
        atom.Y1 = Y1;
        atom.X2 = X2;
        atom.Y2 = Y2;
        atom.TypeRef = this.registerLineType(type);
        this.atoms.add(atom);
    }

    public void drawRect(double X, double Y, double W, double H, int EdgeCol, double Thickness, int FillCol) {
        this.updateBounds(X - Thickness, Y - Thickness);
        this.updateBounds(X + W + Thickness, Y + H + Thickness);
        RectType type = new RectType();
        type.EdgeCol = EdgeCol;
        type.Thickness = Thickness;
        type.FillCol = FillCol;
        RectAtom atom = new RectAtom();
        atom.AtomClass = 2;
        atom.X = X;
        atom.Y = Y;
        atom.W = W;
        atom.H = H;
        atom.TypeRef = this.registerRectType(type);
        this.atoms.add(atom);
    }

    public void drawOval(double CX, double CY, double RW, double RH, int EdgeCol, double Thickness, int FillCol) {
        this.updateBounds(CX - RW - Thickness, CY - RH - Thickness);
        this.updateBounds(CX + RW + Thickness, CY + RH + Thickness);
        OvalType type = new OvalType();
        type.EdgeCol = EdgeCol;
        type.Thickness = Thickness;
        type.FillCol = FillCol;
        OvalAtom atom = new OvalAtom();
        atom.AtomClass = 3;
        atom.CX = CX;
        atom.CY = CY;
        atom.RW = RW;
        atom.RH = RH;
        atom.TypeRef = this.registerOvalType(type);
        this.atoms.add(atom);
    }

    public void drawPoly(double[] X, double[] Y, int EdgeCol, double Thickness, int FillCol, boolean Closed) {
        PathType type = new PathType();
        type.EdgeCol = EdgeCol;
        type.FillCol = FillCol;
        type.Thickness = Thickness;
        type.HardEdge = true;
        PathAtom atom = new PathAtom();
        atom.AtomClass = 4;
        atom.N = X.length;
        atom.X = new double[atom.N];
        atom.Y = new double[atom.N];
        atom.Ctrl = new boolean[atom.N];
        atom.Closed = Closed;
        for (int n = 0; n < atom.N; ++n) {
            this.updateBounds(X[n] - Thickness, Y[n] - Thickness);
            this.updateBounds(X[n] + Thickness, Y[n] + Thickness);
            atom.X[n] = X[n];
            atom.Y[n] = Y[n];
            atom.Ctrl[n] = false;
        }
        atom.TypeRef = this.registerPathType(type);
        this.atoms.add(atom);
    }

    public void drawCurve(double[] X, double[] Y, boolean[] Ctrl, int EdgeCol, double Thickness, int FillCol, boolean Closed) {
        PathType type = new PathType();
        type.EdgeCol = EdgeCol;
        type.FillCol = FillCol;
        type.Thickness = Thickness;
        type.HardEdge = false;
        PathAtom atom = new PathAtom();
        atom.AtomClass = 4;
        atom.N = X.length;
        atom.X = new double[atom.N];
        atom.Y = new double[atom.N];
        atom.Ctrl = new boolean[atom.N];
        atom.Closed = Closed;
        for (int n = 0; n < atom.N; ++n) {
            this.updateBounds(X[n] - Thickness, Y[n] - Thickness);
            this.updateBounds(X[n] + Thickness, Y[n] + Thickness);
            atom.X[n] = X[n];
            atom.Y[n] = Y[n];
            atom.Ctrl[n] = Ctrl[n];
        }
        atom.TypeRef = this.registerPathType(type);
        this.atoms.add(atom);
    }

    public void drawText(double X, double Y, String Txt, double Sz, int Colour, int Style2, int Align) {
        for (int n = 0; n < Txt.length(); ++n) {
            char i = Txt.charAt(n);
            if (i < ' ' || i > '\u007f') continue;
            this.charMask[i - 32] = true;
        }
        double[] metrics = this.measureText(Txt, Sz, Style2);
        if (Align == 0) {
            this.updateBounds(X - 0.5 * metrics[0], Y - metrics[1]);
            this.updateBounds(X + 0.5 * metrics[0], Y + metrics[2]);
        } else if (Align == 1) {
            this.updateBounds(X, Y - metrics[1]);
            this.updateBounds(X + metrics[0], Y + metrics[2]);
        } else if (Align == 2) {
            this.updateBounds(X - metrics[0], Y - metrics[1]);
            this.updateBounds(X, Y + metrics[2]);
        }
        Txt = Txt.replace("&", "&amp;");
        Txt = Txt.replace("<", "&lt;");
        Txt = Txt.replace(">", "&gt;");
        TextType type = new TextType();
        type.Sz = Sz;
        type.Colour = Colour;
        type.Style = Style2;
        type.Align = Align;
        TextAtom atom = new TextAtom();
        atom.AtomClass = 5;
        atom.X = X;
        atom.Y = Y;
        atom.Txt = Txt;
        atom.TypeRef = this.registerTextType(type);
        this.atoms.add(atom);
    }

    public double[] measureText(String Txt, double Sz, int Style2) {
        int w = 0;
        block0: for (int n = 0; n < Txt.length(); ++n) {
            int i = Txt.charAt(n) - 32;
            w = i >= 0 && i < 96 ? (w += SVGFont.HORIZ_ADV_X[i]) : (w += 2048);
            if (n >= Txt.length() - 1) continue;
            int j = Txt.charAt(n + 1) - 32;
            for (int k = 0; k < SVGFont.KERN_K.length; ++k) {
                if ((SVGFont.KERN_G1[k] != i || SVGFont.KERN_G2[k] != j) && (SVGFont.KERN_G1[k] != j || SVGFont.KERN_G2[k] != i)) continue;
                w += SVGFont.KERN_K[k];
                continue block0;
            }
        }
        double[] ret = new double[]{Sz * (double)w / 2048.0, Sz * 2059.0 / 2048.0, Sz * 430.0 / 2048.0};
        return ret;
    }

    public void build(PrintWriter Out, int W, int H, double OX, double OY, double SW, double SH) {
        int sz;
        int n;
        int n2;
        if (MainPanel.appletMode) {
            this.g_id = MainApplet.g_id;
            this.svg_id = MainApplet.svg_id;
            Out.println("<svg onclick=\"javascript:SVG_zoom('" + this.svg_id + "','" + this.g_id + "','" + W + "','" + H + "');\" id=\"" + this.svg_id + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
            Out.println(" version=\"1\" x=\"0\" y=\"0\" width=\"" + W + "\" height=\"" + H + "\" viewBox=\"0 0 " + W + " " + H + "\"><g id=\"" + this.g_id + "\" transform=\"matrix(1 0 0 1 0 0)\">");
        } else {
            Out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            Out.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20010904//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
            Out.println("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
            Out.println(" version=\"1\" x=\"0\" y=\"0\" width=\"" + W + "\" height=\"" + H + "\" viewBox=\"0 0 " + W + " " + H + "\"><g transform=\"matrix(1 0 0 1 0 0)\">");
        }
        Out.println();
        Out.println("<defs><font id=\"Verdana\" horiz-adv-x=\"1041\">");
        Out.println("<font-face font-family=\"Verdana\" units-per-em=\"2048\"  panose-1=\"2 11 6 4 3 5 4 4 2 4\" ascent=\"2059\" descent=\"-430\" alphabetic=\"0\"/>");
        Out.println("<missing-glyph horiz-adv-x=\"2048\" d=\"M256 0V1536H1792V0H256ZM384 128H1664V1408H384V128Z\"/>");
        for (n2 = 0; n2 < 96; ++n2) {
            if (!this.charMask[n2]) continue;
            Out.print("<glyph unicode=\"" + SVGFont.UNICODE[n2] + "\" glyph-name=\"" + SVGFont.GLYPH_NAME[n2] + "\"" + " horiz-adv-x=\"" + SVGFont.HORIZ_ADV_X[n2] + "\"");
            if (SVGFont.GLYPH_DATA[n2].length() > 0) {
                Out.print(" d=\"" + SVGFont.GLYPH_DATA[n2] + "\"");
            }
            Out.println("/>");
        }
        for (n2 = 0; n2 < SVGFont.KERN_K.length; ++n2) {
            if (!this.charMask[SVGFont.KERN_G1[n2]] || !this.charMask[SVGFont.KERN_G2[n2]]) continue;
            Out.println("<hkern g1=\"" + SVGFont.KERN_G1[n2] + "\" g2=\"" + SVGFont.KERN_G2[n2] + "\" k=\"" + SVGFont.KERN_K[n2] + "\"/>");
        }
        Out.println("</font></defs>");
        Out.println();
        for (n2 = 0; n2 < this.atoms.size(); ++n2) {
            Atom a = this.atoms.get(n2);
            if (a.AtomClass == 1) {
                LineAtom la = (LineAtom)a;
                la.X1 = OX + ((la.X1 - this.lowX) * SW + this.lowX);
                la.Y1 = OY + ((la.Y1 - this.lowY) * SH + this.lowY);
                la.X2 = OX + ((la.X2 - this.lowX) * SW + this.lowX);
                la.Y2 = OY + ((la.Y2 - this.lowY) * SH + this.lowY);
                continue;
            }
            if (a.AtomClass == 2) {
                RectAtom ra = (RectAtom)a;
                ra.X = OX + ((ra.X - this.lowX) * SW + this.lowX);
                ra.Y = OY + ((ra.Y - this.lowY) * SH + this.lowY);
                ra.W *= SW;
                ra.H *= SH;
                continue;
            }
            if (a.AtomClass == 3) {
                OvalAtom oa = (OvalAtom)a;
                oa.CX = OX + ((oa.CX - this.lowX) * SW + this.lowX);
                oa.CY = OY + ((oa.CY - this.lowY) * SH + this.lowY);
                oa.RW *= SW;
                oa.RH *= SH;
                continue;
            }
            if (a.AtomClass == 4) {
                PathAtom pa = (PathAtom)a;
                for (int i = 0; i < pa.N; ++i) {
                    pa.X[i] = OX + ((pa.X[i] - this.lowX) * SW + this.lowX);
                    pa.Y[i] = OY + ((pa.Y[i] - this.lowY) * SH + this.lowY);
                }
                continue;
            }
            if (a.AtomClass != 5) continue;
            TextAtom ta = (TextAtom)a;
            ta.X = OX + ((ta.X - this.lowX) * SW + this.lowX);
            ta.Y = OY + ((ta.Y - this.lowY) * SH + this.lowY);
        }
        double swsh = 0.5 * (SW + SH);
        for (n = 0; n < this.lineTypes.size(); ++n) {
            this.lineTypes.get((int)n).Thickness *= swsh;
        }
        for (n = 0; n < this.rectTypes.size(); ++n) {
            this.rectTypes.get((int)n).Thickness *= swsh;
        }
        for (n = 0; n < this.ovalTypes.size(); ++n) {
            this.ovalTypes.get((int)n).Thickness *= swsh;
        }
        for (n = 0; n < this.pathTypes.size(); ++n) {
            this.pathTypes.get((int)n).Thickness *= swsh;
        }
        for (n = 0; n < this.textTypes.size(); ++n) {
            this.textTypes.get((int)n).Sz *= swsh;
        }
        for (int p = 0; p < this.atoms.size(); p += sz) {
            Atom a = this.atoms.get(p);
            sz = 1;
            if (a.AtomClass != 4) {
                int n3 = p + 1;
                while (n3 < this.atoms.size()) {
                    Atom ax = this.atoms.get(n3);
                    if (a.TypeRef != ax.TypeRef || a.AtomClass != ax.AtomClass) break;
                    ++n3;
                    ++sz;
                }
            }
            if (a.AtomClass == 1) {
                if (sz == 1) {
                    this.outputLine1(Out, (LineAtom)a);
                    continue;
                }
                this.outputLineN(Out, (LineAtom)a, p, sz);
                continue;
            }
            if (a.AtomClass == 2) {
                if (sz == 1) {
                    this.outputRect1(Out, (RectAtom)a);
                    continue;
                }
                this.outputRectN(Out, (RectAtom)a, p, sz);
                continue;
            }
            if (a.AtomClass == 3) {
                if (sz == 1) {
                    this.outputOval1(Out, (OvalAtom)a);
                    continue;
                }
                this.outputOvalN(Out, (OvalAtom)a, p, sz);
                continue;
            }
            if (a.AtomClass == 4) {
                this.outputPath(Out, (PathAtom)a);
                continue;
            }
            if (a.AtomClass != 5) continue;
            if (sz == 1) {
                this.outputText1(Out, (TextAtom)a);
                continue;
            }
            this.outputTextN(Out, (TextAtom)a, p, sz);
        }
        Out.println("</g></svg>");
        Out.flush();
    }

    public int[] build(PrintWriter Out) {
        int w = (int)Math.ceil(this.highX - this.lowX) + 2;
        int h = (int)Math.ceil(this.highY - this.lowY) + 2;
        double ox = 1.0 - this.lowX;
        double oy = 1.0 - this.lowY;
        this.build(Out, w, h, ox, oy, 1.0, 1.0);
        return new int[]{w, h};
    }

    private void updateBounds(double X, double Y) {
        if (this.fresh) {
            this.lowX = this.highX = X;
            this.lowY = this.highY = Y;
            this.fresh = false;
        }
        this.lowX = Math.min(this.lowX, X);
        this.lowY = Math.min(this.lowY, Y);
        this.highX = Math.max(this.highX, X);
        this.highY = Math.max(this.highY, Y);
    }

    private int registerLineType(LineType T) {
        for (int n = 0; n < this.lineTypes.size(); ++n) {
            LineType tx = this.lineTypes.get(n);
            if (!Util.dblEqual(T.Thickness, tx.Thickness) || T.Colour != tx.Colour) continue;
            return n;
        }
        this.lineTypes.add(T);
        return this.lineTypes.size() - 1;
    }

    private int registerRectType(RectType T) {
        for (int n = 0; n < this.rectTypes.size(); ++n) {
            RectType tx = this.rectTypes.get(n);
            if (T.EdgeCol != tx.EdgeCol || !Util.dblEqual(T.Thickness, tx.Thickness) || T.FillCol != tx.FillCol) continue;
            return n;
        }
        this.rectTypes.add(T);
        return this.rectTypes.size() - 1;
    }

    private int registerOvalType(OvalType T) {
        for (int n = 0; n < this.ovalTypes.size(); ++n) {
            OvalType tx = this.ovalTypes.get(n);
            if (T.EdgeCol != tx.EdgeCol || !Util.dblEqual(T.Thickness, tx.Thickness) || T.FillCol != tx.FillCol) continue;
            return n;
        }
        this.ovalTypes.add(T);
        return this.ovalTypes.size() - 1;
    }

    private int registerPathType(PathType T) {
        for (int n = 0; n < this.pathTypes.size(); ++n) {
            PathType tx = this.pathTypes.get(n);
            if (T.EdgeCol != tx.EdgeCol || T.FillCol != tx.FillCol || !Util.dblEqual(T.Thickness, tx.Thickness) || T.HardEdge != tx.HardEdge) continue;
            return n;
        }
        this.pathTypes.add(T);
        return this.pathTypes.size() - 1;
    }

    private int registerTextType(TextType T) {
        for (int n = 0; n < this.textTypes.size(); ++n) {
            TextType tx = this.textTypes.get(n);
            if (!Util.dblEqual(T.Sz, tx.Sz) || T.Colour != tx.Colour || T.Style != tx.Style || T.Align != tx.Align) continue;
            return n;
        }
        this.textTypes.add(T);
        return this.textTypes.size() - 1;
    }

    private void outputLine1(PrintWriter Out, LineAtom A) {
        LineType type = this.lineTypes.get(A.TypeRef);
        Out.println("<line x1=\"" + this.df.format(A.X1) + "\" y1=\"" + this.df.format(A.Y1) + "\" x2=\"" + this.df.format(A.X2) + "\" y2=\"" + this.df.format(A.Y2) + "\"" + " stroke=\"" + Util.colourHTML(type.Colour) + "\" stroke-width=\"" + type.Thickness + "\"  stroke-linecap=\"round\"/>");
    }

    private void outputLineN(PrintWriter Out, LineAtom A, int N, int Sz) {
        LineType type = this.lineTypes.get(A.TypeRef);
        Out.println("<g stroke=\"" + Util.colourHTML(type.Colour) + "\" stroke-width=\"" + type.Thickness + "\" stroke-linecap=\"round\">");
        for (int n = 0; n < Sz; ++n) {
            LineAtom a = n == 0 ? A : (LineAtom)this.atoms.get(N + n);
            Out.println("<line x1=\"" + this.df.format(a.X1) + "\" y1=\"" + this.df.format(a.Y1) + "\" x2=\"" + this.df.format(a.X2) + "\" y2=\"" + this.df.format(a.Y2) + "\"/>");
        }
        Out.println("</g>");
    }

    private void outputRect1(PrintWriter Out, RectAtom A) {
        RectType type = this.rectTypes.get(A.TypeRef);
        String edge = type.EdgeCol == -1 ? "none" : Util.colourHTML(type.EdgeCol);
        String fill = type.FillCol == -1 ? "none" : Util.colourHTML(type.FillCol);
        Out.println("<rect x=\"" + this.df.format(A.X) + "\" y=\"" + this.df.format(A.Y) + "\" width=\"" + this.df.format(A.W) + "\" height=\"" + this.df.format(A.H) + "\"" + " stroke=\"" + edge + "\" stroke-width=\"" + type.Thickness + "\"fill=\"" + fill + "\"/>");
    }

    private void outputRectN(PrintWriter Out, RectAtom A, int N, int Sz) {
        RectType type = this.rectTypes.get(A.TypeRef);
        String edge = type.EdgeCol == -1 ? "none" : Util.colourHTML(type.EdgeCol);
        String fill = type.FillCol == -1 ? "none" : Util.colourHTML(type.FillCol);
        Out.println("<g stroke=\"" + edge + "\" stroke-width=\"" + type.Thickness + "\" fill=\"" + fill + "\">");
        for (int n = 0; n < Sz; ++n) {
            RectAtom a = n == 0 ? A : (RectAtom)this.atoms.get(N + n);
            Out.println("<rect x=\"" + this.df.format(a.X) + "\" y=\"" + this.df.format(a.Y) + "\" width=\"" + this.df.format(a.W) + "\" height=\"" + this.df.format(a.H) + "\"/>");
        }
        Out.println("</g>");
    }

    private void outputOval1(PrintWriter Out, OvalAtom A) {
        OvalType type = this.ovalTypes.get(A.TypeRef);
        String edge = type.EdgeCol == -1 ? "none" : Util.colourHTML(type.EdgeCol);
        String fill = type.FillCol == -1 ? "none" : Util.colourHTML(type.FillCol);
        Out.println("<ellipse cx=\"" + this.df.format(A.CX) + "\" cy=\"" + this.df.format(A.CY) + "\" rx=\"" + this.df.format(A.RW) + "\" ry=\"" + this.df.format(A.RH) + "\"" + " stroke=\"" + edge + "\" stroke-width=\"" + type.Thickness + "\" fill=\"" + fill + "\"/>");
    }

    private void outputOvalN(PrintWriter Out, OvalAtom A, int N, int Sz) {
        OvalType type = this.ovalTypes.get(A.TypeRef);
        String edge = type.EdgeCol == -1 ? "none" : Util.colourHTML(type.EdgeCol);
        String fill = type.FillCol == -1 ? "none" : Util.colourHTML(type.FillCol);
        Out.println("<g stroke=\"" + edge + "\" stroke-width=\"" + type.Thickness + "\" fill=\"" + fill + "\">");
        for (int n = 0; n < Sz; ++n) {
            OvalAtom a = n == 0 ? A : (OvalAtom)this.atoms.get(N + n);
            Out.println("<ellipse cx=\"" + this.df.format(a.CX) + "\" cy=\"" + this.df.format(a.CY) + "\" rx=\"" + this.df.format(a.RW) + "\" ry=\"" + this.df.format(a.RH) + "\"/>");
        }
        Out.println("</g>");
    }

    private void outputPath(PrintWriter Out, PathAtom A) {
        PathType type = this.pathTypes.get(A.TypeRef);
        String edge = type.EdgeCol == -1 ? "none" : Util.colourHTML(type.EdgeCol);
        String fill = type.FillCol == -1 ? "none" : Util.colourHTML(type.FillCol);
        String join = type.HardEdge ? "miter" : "round";
        String cap = type.HardEdge ? "square" : "round";
        String shape = "M " + A.X[0] + " " + A.Y[0];
        int n = 1;
        while (n < A.N) {
            if (!A.Ctrl[n]) {
                shape = shape + " L " + A.X[n] + " " + A.Y[n];
                ++n;
                continue;
            }
            if (A.Ctrl[n] && n < A.N - 1 && !A.Ctrl[n + 1]) {
                shape = shape + " Q " + A.X[n] + " " + A.Y[n] + " " + A.X[n + 1] + " " + A.Y[n + 1];
                n += 2;
                continue;
            }
            if (A.Ctrl[n] && n < A.N - 2 && A.Ctrl[n + 1] && !A.Ctrl[n + 2]) {
                shape = shape + " C " + A.X[n] + " " + A.Y[n] + " " + A.X[n + 1] + " " + A.Y[n + 1] + " " + A.X[n + 2] + " " + A.Y[n + 2];
                n += 3;
                continue;
            }
            ++n;
        }
        if (A.Closed) {
            shape = shape + " Z";
        }
        Out.println("<path d=\"" + shape + "\" stroke=\"" + edge + "\" fill=\"" + fill + "\" stroke-width=\"" + type.Thickness + "\"" + " stroke-linejoin=\"" + join + "\" stroke-linecap=\"" + cap + "\"/>");
    }

    private void outputText1(PrintWriter Out, TextAtom A) {
        TextType type = this.textTypes.get(A.TypeRef);
        String anchor = type.Align == 1 ? "start" : (type.Align == 2 ? "end" : "middle");
        Out.println("<text x=\"" + this.df.format(A.X) + "\" y=\"" + this.df.format(A.Y) + "\" font-family=\"Verdana\" font-size=\"" + type.Sz + "\"" + " text-anchor=\"" + anchor + "\" fill=\"" + Util.colourHTML(type.Colour) + "\">" + A.Txt + "</text>");
    }

    private void outputTextN(PrintWriter Out, TextAtom A, int N, int Sz) {
        TextType type = this.textTypes.get(A.TypeRef);
        String anchor = type.Align == 1 ? "start" : (type.Align == 2 ? "end" : "middle");
        Out.println("<g font-family=\"Verdana\" font-size=\"" + type.Sz + "\"" + " text-anchor=\"" + anchor + "\" fill=\"" + Util.colourHTML(type.Colour) + "\">");
        for (int n = 0; n < Sz; ++n) {
            TextAtom a = n == 0 ? A : (TextAtom)this.atoms.get(N + n);
            Out.println("<text x=\"" + this.df.format(a.X) + "\" y=\"" + this.df.format(a.Y) + "\">" + a.Txt + "</text>");
        }
        Out.println("</g>");
    }

    class TextType {
        double Sz;
        int Colour;
        int Style;
        int Align;

        TextType() {
        }
    }

    class TextAtom
    extends Atom {
        double X;
        double Y;
        String Txt;

        TextAtom() {
        }
    }

    class PathType {
        int EdgeCol;
        int FillCol;
        double Thickness;
        boolean HardEdge;

        PathType() {
        }
    }

    class PathAtom
    extends Atom {
        int N;
        double[] X;
        double[] Y;
        boolean[] Ctrl;
        boolean Closed;

        PathAtom() {
        }
    }

    class OvalType {
        int EdgeCol;
        int FillCol;
        double Thickness;

        OvalType() {
        }
    }

    class OvalAtom
    extends Atom {
        double CX;
        double CY;
        double RW;
        double RH;

        OvalAtom() {
        }
    }

    class RectType {
        int EdgeCol;
        int FillCol;
        double Thickness;

        RectType() {
        }
    }

    class RectAtom
    extends Atom {
        double X;
        double Y;
        double W;
        double H;

        RectAtom() {
        }
    }

    class LineType {
        double Thickness;
        int Colour;

        LineType() {
        }
    }

    class LineAtom
    extends Atom {
        double X1;
        double Y1;
        double X2;
        double Y2;

        LineAtom() {
        }
    }

    abstract class Atom {
        int AtomClass;
        int TypeRef;

        Atom() {
        }
    }
}

