/*
  Copyright (c) 2007 Paolo Capriotti <p.capriotti@gmail.com>
            (c) 2007 Maurizio Monge <maurizio.monge@kdemail.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#ifndef HLVARIANTS__VARIANTDATA_H
#define HLVARIANTS__VARIANTDATA_H

template <typename Variant>
struct VariantData {
  typedef typename Variant::TheMoveGenerator MoveGenerator;
  typedef typename MoveGenerator::TheLegalityCheck LegalityCheck;
  typedef typename LegalityCheck::GameState GameState;
  typedef typename GameState::Board Board;
  typedef typename GameState::GSPool VDPool;
  typedef typename GameState::Move Move;
  typedef typename Board::Piece Piece;
  typedef typename Variant::TheAnimator Animator;  
  typedef typename Variant::TheSerializer Serializer;
  typedef typename Variant::TheMoveFactory MoveFactory;
};

#endif // HLVARIANTS__VARIANTDATA_H

