use super::*;

#[derive(Debug, PartialEq, Clone, Copy, Ord, PartialOrd, Eq)]
pub(crate) enum TokenKind {
  AmpersandAmpersand,
  Asterisk,
  At,
  Backtick,
  BangEquals,
  BangTilde,
  BarBar,
  BraceL,
  BraceR,
  BracketL,
  BracketR,
  ByteOrderMark,
  Colon,
  ColonColon,
  ColonEquals,
  Comma,
  Comment,
  Dedent,
  Dollar,
  Eof,
  Eol,
  Equals,
  EqualsEquals,
  EqualsTilde,
  FormatStringContinue,
  FormatStringEnd,
  FormatStringStart,
  Identifier,
  Indent,
  InterpolationEnd,
  InterpolationStart,
  ParenL,
  ParenR,
  Plus,
  QuestionMark,
  Slash,
  StringToken,
  Text,
  Unspecified,
  Whitespace,
}

impl Display for TokenKind {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    use TokenKind::*;
    write!(
      f,
      "{}",
      match *self {
        AmpersandAmpersand => "'&&'",
        Asterisk => "'*'",
        At => "'@'",
        Backtick => "backtick",
        BangEquals => "'!='",
        BangTilde => "'!~'",
        BarBar => "'||'",
        BraceL => "'{'",
        BraceR => "'}'",
        BracketL => "'['",
        BracketR => "']'",
        ByteOrderMark => "byte order mark",
        Colon => "':'",
        ColonColon => "'::'",
        ColonEquals => "':='",
        Comma => "','",
        Comment => "comment",
        Dedent => "dedent",
        Dollar => "'$'",
        Eof => "end of file",
        Eol => "end of line",
        Equals => "'='",
        EqualsEquals => "'=='",
        EqualsTilde => "'=~'",
        FormatStringContinue | FormatStringEnd | FormatStringStart => "format string",
        Identifier => "identifier",
        Indent => "indent",
        InterpolationEnd => "'}}'",
        InterpolationStart => "'{{'",
        ParenL => "'('",
        ParenR => "')'",
        Plus => "'+'",
        QuestionMark => "?",
        Slash => "'/'",
        StringToken => "string",
        Text => "command text",
        Unspecified => "unspecified",
        Whitespace => "whitespace",
      }
    )
  }
}
