# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # WebSite Management Client
  #
  class AppServicePlans
    include MsRestAzure

    #
    # Creates and initializes a new instance of the AppServicePlans class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param detailed [Boolean] Specify <code>true</code> to return all App Service
    # plan properties. The default is <code>false</code>, which returns a subset of
    # the properties.
    # Retrieval of all properties may increase the API latency.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AppServicePlan>] operation results.
    #
    def list(detailed = nil, custom_headers = nil)
      first_page = list_as_lazy(detailed, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param detailed [Boolean] Specify <code>true</code> to return all App Service
    # plan properties. The default is <code>false</code>, which returns a subset of
    # the properties.
    # Retrieval of all properties may increase the API latency.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(detailed = nil, custom_headers = nil)
      list_async(detailed, custom_headers).value!
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param detailed [Boolean] Specify <code>true</code> to return all App Service
    # plan properties. The default is <code>false</code>, which returns a subset of
    # the properties.
    # Retrieval of all properties may increase the API latency.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(detailed = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'detailed' => detailed,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AppServicePlan>] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get an App Service plan.
    #
    # Get an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlan] operation results.
    #
    def get(resource_group_name, name, custom_headers = nil)
      response = get_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get an App Service plan.
    #
    # Get an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, name, custom_headers = nil)
      get_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get an App Service plan.
    #
    # Get an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlan.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates an App Service Plan.
    #
    # Creates or updates an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param app_service_plan [AppServicePlan] Details of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlan] operation results.
    #
    def create_or_update(resource_group_name, name, app_service_plan, custom_headers = nil)
      response = create_or_update_async(resource_group_name, name, app_service_plan, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param app_service_plan [AppServicePlan] Details of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, name, app_service_plan, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, name, app_service_plan, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::AppServicePlan.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete an App Service plan.
    #
    # Delete an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, name, custom_headers = nil)
      response = delete_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Delete an App Service plan.
    #
    # Delete an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Delete an App Service plan.
    #
    # Delete an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List all capabilities of an App Service plan.
    #
    # List all capabilities of an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_capabilities(resource_group_name, name, custom_headers = nil)
      response = list_capabilities_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all capabilities of an App Service plan.
    #
    # List all capabilities of an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_capabilities_with_http_info(resource_group_name, name, custom_headers = nil)
      list_capabilities_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List all capabilities of an App Service plan.
    #
    # List all capabilities of an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_capabilities_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'CapabilityElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'Capability'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def get_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # Retrieve a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      nil
    end

    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # Delete a Hybrid Connection in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Service Bus namespace.
    # @param relay_name [String] Name of the Service Bus relay.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] The name of the Service Bus namespace.
    # @param relay_name [String] The name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionKey] operation results.
    #
    def list_hybrid_connection_keys(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] The name of the Service Bus namespace.
    # @param relay_name [String] The name of the Service Bus relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connection_keys_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # Get the send key name and value of a Hybrid Connection.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] The name of the Service Bus namespace.
    # @param relay_name [String] The name of the Service Bus relay.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionKey.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Hybrid Connection namespace.
    # @param relay_name [String] Name of the Hybrid Connection relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<String>] operation results.
    #
    def list_web_apps_by_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      first_page = list_web_apps_by_hybrid_connection_as_lazy(resource_group_name, name, namespace_name, relay_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Hybrid Connection namespace.
    # @param relay_name [String] Name of the Hybrid Connection relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_by_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      list_web_apps_by_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Hybrid Connection namespace.
    # @param relay_name [String] Name of the Hybrid Connection relay.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_by_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionLimits] operation results.
    #
    def get_hybrid_connection_plan_limit(resource_group_name, name, custom_headers = nil)
      response = get_hybrid_connection_plan_limit_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_plan_limit_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hybrid_connection_plan_limit_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # Get the maximum number of Hybrid Connections allowed in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_plan_limit_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionLimits.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HybridConnection>] operation results.
    #
    def list_hybrid_connections(resource_group_name, name, custom_headers = nil)
      first_page = list_hybrid_connections_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_metric_defintions(resource_group_name, name, custom_headers = nil)
      first_page = list_metric_defintions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_defintions_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metric_defintions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_defintions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restart all apps in an App Service plan.
    #
    # Restart all apps in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param soft_restart [Boolean] Specify <code>true</code> to performa a soft
    # restart, applies the configuration settings and restarts the apps if
    # necessary. The default is <code>false</code>, which always restarts and
    # reprovisions the apps
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def restart_web_apps(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      response = restart_web_apps_async(resource_group_name, name, soft_restart, custom_headers).value!
      nil
    end

    #
    # Restart all apps in an App Service plan.
    #
    # Restart all apps in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param soft_restart [Boolean] Specify <code>true</code> to performa a soft
    # restart, applies the configuration settings and restarts the apps if
    # necessary. The default is <code>false</code>, which always restarts and
    # reprovisions the apps
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_web_apps_with_http_info(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      restart_web_apps_async(resource_group_name, name, soft_restart, custom_headers).value!
    end

    #
    # Restart all apps in an App Service plan.
    #
    # Restart all apps in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param soft_restart [Boolean] Specify <code>true</code> to performa a soft
    # restart, applies the configuration settings and restarts the apps if
    # necessary. The default is <code>false</code>, which always restarts and
    # reprovisions the apps
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_web_apps_async(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param skip_token [String] Skip to a web app in the list of webapps
    # associated with app service plan. If specified, the resulting list will
    # contain web apps starting from (including) the skipToken. Otherwise, the
    # resulting list contains web apps from the start of the list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_web_apps(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      first_page = list_web_apps_as_lazy(resource_group_name, name, skip_token, filter, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param skip_token [String] Skip to a web app in the list of webapps
    # associated with app service plan. If specified, the resulting list will
    # contain web apps starting from (including) the skipToken. Otherwise, the
    # resulting list contains web apps from the start of the list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_with_http_info(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      list_web_apps_async(resource_group_name, name, skip_token, filter, top, custom_headers).value!
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param skip_token [String] Skip to a web app in the list of webapps
    # associated with app service plan. If specified, the resulting list will
    # contain web apps starting from (including) the skipToken. Otherwise, the
    # resulting list contains web apps from the start of the list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_async(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$skipToken' => skip_token,'$top' => top,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_vnets(resource_group_name, name, custom_headers = nil)
      response = list_vnets_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vnets_with_http_info(resource_group_name, name, custom_headers = nil)
      list_vnets_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # Get all Virtual Networks associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vnets_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_from_server_farm(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_from_server_farm_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # Get a Virtual Network associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a Virtual Network gateway.
    #
    # Get a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def get_vnet_gateway(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      response = get_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a Virtual Network gateway.
    #
    # Get a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      get_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
    end

    #
    # Get a Virtual Network gateway.
    #
    # Get a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update a Virtual Network gateway.
    #
    # Update a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param connection_envelope [VnetGateway] Definition of the gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_vnet_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = update_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update a Virtual Network gateway.
    #
    # Update a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param connection_envelope [VnetGateway] Definition of the gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      update_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Update a Virtual Network gateway.
    #
    # Update a Virtual Network gateway.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param connection_envelope [VnetGateway] Definition of the gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_routes_for_vnet(resource_group_name, name, vnet_name, custom_headers = nil)
      response = list_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_routes_for_vnet_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      list_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # Get all routes that are associated with a Virtual Network in an App Service
    # plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetRouteElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetRoute'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a Virtual Network route in an App Service plan.
    #
    # Get a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_route_for_vnet(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      response = get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a Virtual Network route in an App Service plan.
    #
    # Get a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_route_for_vnet_with_http_info(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
    end

    #
    # Get a Virtual Network route in an App Service plan.
    #
    # Get a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetRouteElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetRoute'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetRoute] operation results.
    #
    def create_or_update_vnet_route(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      response = create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, 'route is nil' if route.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetRoute.mapper()
      request_content = @client.serialize(request_mapper,  route)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 400 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetRoute.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_vnet_route(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      response = delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
      nil
    end

    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
    end

    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # Delete a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetRoute] operation results.
    #
    def update_vnet_route(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      response = update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
    end

    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # Create or update a Virtual Network route in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param vnet_name [String] Name of the Virtual Network.
    # @param route_name [String] Name of the Virtual Network route.
    # @param route [VnetRoute] Definition of the Virtual Network route.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, 'route is nil' if route.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::VnetRoute.mapper()
      request_content = @client.serialize(request_mapper,  route)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 400 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::VnetRoute.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reboot a worker machine in an App Service plan.
    #
    # Reboot a worker machine in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param worker_name [String] Name of worker machine, which typically starts
    # with RD.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def reboot_worker(resource_group_name, name, worker_name, custom_headers = nil)
      response = reboot_worker_async(resource_group_name, name, worker_name, custom_headers).value!
      nil
    end

    #
    # Reboot a worker machine in an App Service plan.
    #
    # Reboot a worker machine in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param worker_name [String] Name of worker machine, which typically starts
    # with RD.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reboot_worker_with_http_info(resource_group_name, name, worker_name, custom_headers = nil)
      reboot_worker_async(resource_group_name, name, worker_name, custom_headers).value!
    end

    #
    # Reboot a worker machine in an App Service plan.
    #
    # Reboot a worker machine in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param worker_name [String] Name of worker machine, which typically starts
    # with RD.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reboot_worker_async(resource_group_name, name, worker_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_name is nil' if worker_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerName' => worker_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates or updates an App Service Plan.
    #
    # Creates or updates an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param app_service_plan [AppServicePlan] Details of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlan] operation results.
    #
    def begin_create_or_update(resource_group_name, name, app_service_plan, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, name, app_service_plan, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates an App Service Plan.
    #
    # Creates or updates an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param app_service_plan [AppServicePlan] Details of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, name, app_service_plan, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, name, app_service_plan, custom_headers).value!
    end

    #
    # Creates or updates an App Service Plan.
    #
    # Creates or updates an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param app_service_plan [AppServicePlan] Details of the App Service plan.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, name, app_service_plan, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_service_plan is nil' if app_service_plan.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::AppServicePlan.mapper()
      request_content = @client.serialize(request_mapper,  app_service_plan)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlan.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlan.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceCollection] operation results.
    #
    def list_web_apps_by_hybrid_connection_next(next_page_link, custom_headers = nil)
      response = list_web_apps_by_hybrid_connection_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_by_hybrid_connection_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_apps_by_hybrid_connection_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_by_hybrid_connection_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionCollection] operation results.
    #
    def list_hybrid_connections_next(next_page_link, custom_headers = nil)
      response = list_hybrid_connections_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_next_with_http_info(next_page_link, custom_headers = nil)
      list_hybrid_connections_next_async(next_page_link, custom_headers).value!
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HybridConnectionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] operation results.
    #
    def list_metric_defintions_next(next_page_link, custom_headers = nil)
      response = list_metric_defintions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_defintions_next_with_http_info(next_page_link, custom_headers = nil)
      list_metric_defintions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_defintions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_metrics_next(next_page_link, custom_headers = nil)
      response = list_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def list_web_apps_next(next_page_link, custom_headers = nil)
      response = list_web_apps_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_apps_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service plans for a subcription.
    #
    # Get all App Service plans for a subcription.
    #
    # @param detailed [Boolean] Specify <code>true</code> to return all App Service
    # plan properties. The default is <code>false</code>, which returns a subset of
    # the properties.
    # Retrieval of all properties may increase the API latency.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(detailed = nil, custom_headers = nil)
      response = list_async(detailed, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all App Service plans in a resource group.
    #
    # Get all App Service plans in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] which provide lazy access to pages of the
    # response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # Get all apps that use a Hybrid Connection in an App Service Plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param namespace_name [String] Name of the Hybrid Connection namespace.
    # @param relay_name [String] Name of the Hybrid Connection relay.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceCollection] which provide lazy access to pages of the
    # response.
    #
    def list_web_apps_by_hybrid_connection_as_lazy(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = list_web_apps_by_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_apps_by_hybrid_connection_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # Retrieve all Hybrid Connections in use in an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnectionCollection] which provide lazy access to pages of
    # the response.
    #
    def list_hybrid_connections_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_hybrid_connections_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # Get metrics that can be queried for an App Service plan, and their
    # definitions.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] which provide lazy access to
    # pages of the response.
    #
    def list_metric_defintions_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_metric_defintions_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_metric_defintions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for an App Serice plan.
    #
    # Get metrics for an App Serice plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_metrics_as_lazy(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      response = list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all apps associated with an App Service plan.
    #
    # Get all apps associated with an App Service plan.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service plan.
    # @param skip_token [String] Skip to a web app in the list of webapps
    # associated with app service plan. If specified, the resulting list will
    # contain web apps starting from (including) the skipToken. Otherwise, the
    # resulting list contains web apps from the start of the list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] which provide lazy access to pages of the
    # response.
    #
    def list_web_apps_as_lazy(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      response = list_web_apps_async(resource_group_name, name, skip_token, filter, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_apps_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
