# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # Filters to list items that can be backed up.
    #
    class BMSPOQueryObject

      include MsRestAzure

      include MsRest::JSONable
      # @return [BackupManagementType] Backup management type. Possible values
      # include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM', 'AzureBackupServer',
      # 'AzureSql'
      attr_accessor :backup_management_type

      # @return [String] Backup status query parameter.
      attr_accessor :status

      # @return [String] Friendly name.
      attr_accessor :friendly_name


      #
      # Mapper for BMSPOQueryObject class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'BMSPOQueryObject',
          type: {
            name: 'Composite',
            class_name: 'BMSPOQueryObject',
            model_properties: {
              backup_management_type: {
                required: false,
                serialized_name: 'backupManagementType',
                type: {
                  name: 'String'
                }
              },
              status: {
                required: false,
                serialized_name: 'status',
                type: {
                  name: 'String'
                }
              },
              friendly_name: {
                required: false,
                serialized_name: 'friendlyName',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
