/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000,2001 James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000,2001 Christopher Lightfoot.
 *                      All rights reserved
 *
 * NetBSD and BPF support by Takashi YAMAMOTO
 * Copyright (C) 2001 YAMAMOTO Takashi <yamt@netbsd.org>.
 *
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: util.c,v 1.9 2001/11/01 15:24:26 root Exp $";

/*
 * $Log: util.c,v $
 * Revision 1.9  2001/11/01 15:24:26  root
 * #
 *
 * Revision 1.8  2001/11/01 15:23:59  root
 * #
 *
 * Revision 1.7  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.6  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.5  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.4  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.3  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"


unsigned char ethtoaret[1024];

unsigned char *
ethtoa (void *in)
{
  unsigned char *p = (unsigned char *) in;
  int i = ETH_ALEN;
  int len = 0;

  len += sprintf (ethtoaret + len, "%02x", *(p++));

  while (--i)
    len += sprintf (ethtoaret + len, ":%02x", *(p++));

  return (ethtoaret);
}

#ifdef __NetBSD__
void
daemonize (void)
{
  if (daemon (1, 0) == -1)
    {
      openlog ("rpld", LOG_PID, LOG_DAEMON);
      syslog (LOG_ERR, "fork failed: %m");
      exit (1);
    }
}
#else
void
daemonize (void)
{
  int fd;

  switch (fork ())
    {
    case 0:
      break;
    case -1:
      openlog ("rpld", LOG_PID, LOG_DAEMON);
      syslog (LOG_ERR, "fork failed: %m");
      exit (1);
    default:
      exit (0);
    }

  setpgrp ();

  fd = open ("/dev/null", O_RDWR);
  dup2 (fd, 0);
  dup2 (fd, 1);
  dup2 (fd, 2);
  close (fd);
}
#endif
