% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_empty.R
\name{is_empty}
\alias{is_empty}
\title{Check whether string, list or vector is empty}
\usage{
is_empty(x, first.only = TRUE, all.na.empty = TRUE)
}
\arguments{
\item{x}{String, character vector, list, data.frame or numeric vector or factor.}

\item{first.only}{Logical, if \code{FALSE} and \code{x} is a character
vector, each element of \code{x} will be checked if empty. If
\code{TRUE}, only the first element of \code{x} will be checked.}

\item{all.na.empty}{Logical, if \code{x} is a vector with \code{NA}-values
only, \code{is_empty} will return \code{FALSE} if \code{all.na.empty = FALSE},
and will return \code{TRUE} if \code{all.na.empty = TRUE} (default).}
}
\value{
Logical, \code{TRUE} if \code{x} is a character vector or string and
          is empty, \code{TRUE} if \code{x} is a vector or list and of length 0,
          \code{FALSE} otherwise.
}
\description{
This function checks whether a string or character vector (of
               length 1), a list or any vector (numeric, atomic) is empty or not.
}
\note{
\code{NULL}- or \code{NA}-values are also considered as "empty" (see
        'Examples') and will return \code{TRUE}, unless \code{all.na.empty==FALSE}.
}
\examples{
is_empty("test")
is_empty("")
is_empty(NA)
is_empty(NULL)

# string is not empty
is_empty(" ")

# however, this trimmed string is
is_empty(trim(" "))

# numeric vector
x <- 1
is_empty(x)
x <- x[-1]
is_empty(x)

# check multiple elements of character vectors
is_empty(c("", "a"))
is_empty(c("", "a"), first.only = FALSE)

# empty data frame
d <- data.frame()
is_empty(d)

# empty list
is_empty(list(NULL))

# NA vector
x <- rep(NA,5)
is_empty(x)
is_empty(x, all.na.empty = FALSE)
}
