% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onevent.R
\name{onevent}
\alias{onevent}
\alias{onclick}
\title{Run R code when an event is triggered on an element}
\usage{
onclick(id, expr, add = FALSE, asis = FALSE)

onevent(event, id, expr, add = FALSE, properties = NULL, asis = FALSE)
}
\arguments{
\item{id}{The id of the element/Shiny tag}

\item{expr}{The R expression or function to run after the event is triggered.
If a function with an argument is provided, it will be called with the
JavaScript Event properties as its argument. Using a function can be useful
when you want to know, for example, what key was pressed on a "keypress" event
or the mouse coordinates in a mouse event. See below for a list of properties.}

\item{add}{If \code{TRUE}, then add \code{expr} to be executed after any
other code that was previously set using \code{onevent} or \code{onclick}; otherwise
\code{expr} will overwrite any previous expressions. Note that this parameter
works well in web browsers but is buggy when using the RStudio Viewer.}

\item{asis}{If \code{TRUE}, use the ID as-is even when inside a module
(instead of adding the namespace prefix to the ID).}

\item{event}{The event that needs to be triggered to run the code. See below
for a list of event types.}

\item{properties}{A list of JavaScript Event properties that should be available
to the argument of the \code{expr} function. See below for more information about
Event properties.}
}
\description{
\code{onclick} runs an R expression (either a \code{shinyjs} function or any other code)
when an element is clicked.\cr\cr
\code{onevent} is similar, but can be used when any event is triggered on the element,
not only a mouse click. See below for a list of possible event types. Using "click"
results in the same behaviour as calling \code{onclick}.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\section{Event types}{

Any standard \href{https://api.jquery.com/category/events/mouse-events/}{mouse} or
\href{https://api.jquery.com/category/events/keyboard-events/}{keyboard} events
that are supported by JQuery can be used. The standard list of events that can be used is:
\code{click}, \code{dblclick}, \code{hover}, \code{mousedown}, \code{mouseenter},
\code{mouseleave}, \code{mousemove}, \code{mouseout}, \code{mouseover}, \code{mouseup},
\code{keydown}, \code{keypress}, \code{keyup}. You can also use any other non
standard events that your browser supports or with the use of plugins (for
example, there is a \href{https://github.com/jquery/jquery-mousewheel}{mousewheel}
plugin that you can use to listen to mousewheel events).
}

\section{Event properties}{

If a function is provided to \code{expr}, the function will receive a list
of JavaScript Event properties describing the current event as an argument.
Different properties are available for different event types. The full list
of porperties that can be returned is: \code{altKey}, \code{button},
\code{buttons}, \code{clientX}, \code{clientY}, \code{ctrlKey}, \code{pageX},
\code{pageY}, \code{screenX}, \code{screenY}, \code{shiftKey}, \code{which},
\code{charCode}, \code{key}, \code{keyCode}, \code{offsetX}, \code{offsetY}.
If you want to retrieve any additional properties that are available in
JavaScript for your event type, you can use the \code{properties} parameter.
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      p(id = "date", "Click me to see the date"),
      p(id = "coords", "Click me to see the mouse coordinates"),
      p(id = "disappear", "Move your mouse here to make the text below disappear"),
      p(id = "text", "Hello")
    ),
    server = function(input, output) {
      onclick("date", alert(date()))
      onclick("coords", function(event) { alert(event) })
      onevent("mouseenter", "disappear", hide("text"))
      onevent("mouseleave", "disappear", show("text"))
    }
  )
}
\dontrun{
  # The shinyjs function call in the above app can be replaced by
  # any of the following examples to produce similar Shiny apps
  onclick("disappear", toggle("text"))
  onclick(expr = text("date", date()), id = "date")
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}
