% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsurv.R
\name{popsurv}
\alias{popsurv}
\title{Calculate the expected (population) survival}
\usage{
popsurv(sex, year = as.Date("1970-01-01"), age = 0, ratetable, times)
}
\arguments{
\item{sex}{Either character ('male'/'female'), or integer (1/2).}

\item{year}{The year from which the individual is followed. Either a Date or POSIXt object. Default is as.Date('1970-01-01').}

\item{age}{The age from which the individual is followed. Must be in days.}

\item{ratetable}{a table of event rates, organized as a \code{ratetable}
object, such as \code{slopop}.}

\item{times}{The times at which the expected (population) survival should be calculated. Must be in days.}
}
\value{
A vector containing the survival estimate at the supplied times.
}
\description{
For a given individual with sex, year, and age, calculate the expected (population) survival at the supplied time points based on the mortality tables.
}
\details{
The follow-up time and age must be specified in days. The calendar year can be in any date format
(Date and POSIXt are allowed)
}
\examples{

library(relsurv)
# Estimate P(T>2000 days) for a newborn:
popsurv(sex='male', year=as.Date('1970-01-01'), age=0, ratetable=slopop, times=2000)
# P(T>300 days) for a 50-year old:
popsurv(sex='male', year=as.Date('1970-01-01'), age=50*365.241, ratetable=slopop, times=300)
}
\seealso{
\code{\link{expprep2}}
}
