#' Measures for Comparing Clusterings
#'
#' Given a set of data points \eqn{D}, a clustering \eqn{C = (C_1,C_2,...,C_k)} is
#' a partition where each pair of sets \eqn{C_i} and \eqn{C_j} has no overlapping
#' elements. \pkg{mclustcomp} package provides a collection of methods that play a
#' role similar to \emph{distance} or \emph{metric}
#' in that measures similarity of two clusterings (or,
#' partitions) \eqn{C} and \eqn{C'}. For a more detailed description,
#' see Meila, M. (2005) <doi:10.1145/1102351.1102424>.
#'
#' @docType package
#' @name mclustcomp-package
#' @import Rdpack
#' @importFrom Rcpp evalCpp
#' @useDynLib mclustcomp
NULL


