% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_lintr.R
\name{use_lintr}
\alias{use_lintr}
\title{Use lintr in your project}
\usage{
use_lintr(path = ".", type = c("tidyverse", "full"))
}
\arguments{
\item{path}{Path to project root, where a \code{.lintr} file should be created.
If the \code{.lintr} file already exists, an error will be thrown.}

\item{type}{What kind of configuration to create?
\itemize{
\item \code{tidyverse} creates a minimal lintr config, based on the default linters (\code{\link[=linters_with_defaults]{linters_with_defaults()}}).
These are suitable for following \href{https://style.tidyverse.org/}{the tidyverse style guide}.
\item \code{full} creates a lintr config using all available linters via \code{\link[=all_linters]{all_linters()}}.
}}
}
\value{
Path to the generated configuration, invisibly.
}
\description{
Create a minimal lintr config file as a starting point for customization
}
\examples{
if (FALSE) {
  # use the default set of linters
  lintr::use_lintr()
  # or try all linters
  lintr::use_lintr(type = "full")

  # then
  lintr::lint_dir()
}
}
\seealso{
\code{vignette("lintr")} for detailed introduction to using and configuring lintr.
}
