% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{theme_pdf}
\alias{theme_pdf}
\title{Pretty theme}
\usage{
theme_pdf(show.ticks = TRUE, legend.pos = NULL)
}
\arguments{
\item{show.ticks}{boolean Whether to show x- and y-ticks (default=TRUE).}

\item{legend.pos}{Vector with x and y position of the legend (default=NULL).}
}
\value{
ggplot2 with plot ticks and positioned legend
}
\description{
Pretty theme
}
\examples{
library(ggplot2)
library(ggrastr)

data = rnorm(100)
colors = (1:100/100)
ggplot() + geom_point(aes(x=data, y=data, color=colors)) + theme_pdf(FALSE, legend.pos=c(1, 1))

}
