% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{Extract}
\alias{Extract}
\alias{[[.bit}
\alias{[[<-.bit}
\alias{[.bit}
\alias{[<-.bit}
\alias{[[.bitwhich}
\alias{[[<-.bitwhich}
\alias{[.bitwhich}
\alias{[<-.bitwhich}
\title{Extract or replace part of an boolean vector}
\usage{
\method{[[}{bit}(x, i)

\method{[[}{bit}(x, i) <- value

\method{[}{bit}(x, i)

\method{[}{bit}(x, i) <- value

\method{[[}{bitwhich}(x, i)

\method{[[}{bitwhich}(x, i) <- value

\method{[}{bitwhich}(x, i)

\method{[}{bitwhich}(x, i) <- value
}
\arguments{
\item{x}{a \code{\link{bit}} or \code{\link{bitwhich}} object}

\item{i}{preferrably a positive integer subscript or a \code{\link{ri}}, see text}

\item{value}{new logical or integer values}
}
\value{
The extractors \code{[[} and \code{[} return a logical scalar or
vector.  The replacment functions return an object of \code{class(x)}.
}
\description{
Operators acting on \code{\link{bit}} or \code{\link{bitwhich}} objects to extract or replace parts.
}
\details{
The typical usecase for for '[' and '[<-' is subscripting with positive integers, 
negative integers are allowed but slower, 
as logical subscripts only scalars are allowed. 
The subscript can be given as a \code{\link{bitwhich}} object.
Also \code{\link{ri}} can be used as subscript.

Extracting from \code{\link{bit}} and \code{\link{bitwhich}} is faster than from  \code{\link{logical}} if positive subscripts are used.
integer subscripts make sense.  Negative subscripts are converted to
positive ones, beware the RAM consumption.
}
\examples{

  x <- as.bit(c(FALSE, NA, TRUE))
  x[] <- c(FALSE, NA, TRUE)
  x[1:2]
  x[-3]
  x[ri(1,2)]
  x[as.bitwhich(c(TRUE,TRUE,FALSE))]
  x[[1]]
  x[] <- TRUE
  x[1:2] <- FALSE
  x[[1]] <- TRUE

}
\seealso{
\code{\link{bit}}, \code{\link[base]{Extract}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
