# Copyright (c) 2020-present, Facebook, Inc.
# All rights reserved.
#
# This source code is licensed under the license found in the LICENSE file in
# the root directory of this source tree.
#
from typing import Any, Dict, List, Tuple

class DbusMessage:
    body: Any
    headers: Dict[str, Any]
    def process_reply(self, with_headers: bool): ...
    def is_empty(self) -> bool: ...
    def is_signal(self, interface: bytes, member: bytes) -> bool: ...

class DBus:
    user_mode: bool
    def __init__(self, user_mode: bool = False) -> None: ...
    def __enter__(self) -> "DBus": ...
    def __exit__(self, *errs) -> None: ...
    def open(self) -> None: ...
    def close(self) -> None: ...
    def process(self) -> DbusMessage: ...
    def call_method(
        self,
        destination: bytes,
        path: bytes,
        interface: bytes,
        method: bytes,
        args: Any,
    ) -> Any: ...
    def get_property(
        self,
        destination: bytes,
        path: bytes,
        interface: bytes,
        property: bytes,
        rtype: bytes,
    ) -> Any: ...
    def match_signal(
        self, sender, path, interface, member, callback, userdata=None
    ) -> None: ...
    def wait(self, timeout: int) -> None: ...
    def get_fd(self) -> int: ...
    def get_allow_interactive_authorization(self) -> bool: ...
    def set_allow_interactive_authorization(self, interactive: bool) -> None: ...

class DBusMachine(DBus):
    def __init__(self, machine: bytes) -> None: ...

class DBusRemote(DBus):
    def __init__(self, host: bytes) -> None: ...

class DBusAddress(DBus):
    def __init__(self, address: bytes, peer_to_peer: bool) -> None: ...

def apply_signature(signature: bytes, values: List[Any]) -> list[Tuple[int, Any]]: ...
def path_encode(prefix: bytes, external_id: bytes) -> bytes: ...
def path_decode(path: bytes, prefix: bytes) -> bytes: ...
