%feature("docstring") PERSALYS::CopulaInferenceAnalysis
"Perform a dependence inference analysis.

Parameters
----------
name : str
    Name
design : :class:`~persalys.DesignOfExperiment`
    Design of experiments

Examples
--------
Create the model:

>>> import openturns as ot
>>> import persalys
>>> filename = 'data.csv'
>>> ot.RandomGenerator.SetSeed(0)
>>> sample = ot.Normal(3).getSample(100)
>>> sample.exportToCSVFile(filename)
>>> model = persalys.DataModel('myDataModel', 'data.csv', [0, 1, 2])

Create the dependence inference analysis:

>>> analysis = persalys.CopulaInferenceAnalysis('analysis', model)
>>> analysis.run()

Get the result:

>>> result = analysis.getResult()
>>> resultForSet = result.getCopulaInferenceSetResultCollection()"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::CopulaInferenceAnalysis::getDistributionsFactories
"Get the sequence of distributions to test for a set of variables.

Parameters
----------
variables : sequence of str
    Names of the variables

Returns
-------
factories : sequence of :py:class:`openturns.DistributionFactory`
    Distributions to test for the given set of variables"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::CopulaInferenceAnalysis::setDistributionsFactories
"Set the sequence of distributions to test for a set of variables.

Parameters
----------
variables : sequence of str
    Names of the variables
factories : sequence of :py:class:`openturns.DistributionFactory`
    Distributions to test"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::CopulaInferenceAnalysis::getResult
"Result accessor.

Returns
-------
result : :class:`~persalys.CopulaInferenceResult`
    Result."

