// This software is released into the Public Domain.  See copying.txt for details.
package org.openstreetmap.osmosis.apidb.v0_6;


/**
 * Defines constants specific to the specific schema version.
 * 
 * @author Brett Henderson
 */
public final class ApidbVersionConstants {
	
	/**
	 * Defines the schema migrations expected to be in the database.
	 */
	public static final String[] SCHEMA_MIGRATIONS = {
		"1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
		"11", "12", "13", "14", "15", "16", "17", "18", "19", "20",
		"21", "22", "23", "24", "25", "26", "27", "28", "29", "30",
		"31", "32", "33", "34", "35", "36", "37", "38", "39", "40",
		"41", "42", "43", "44", "45", "46", "47", "48", "49", "50",
		"51", "52", "53", "54", "55", "56", "57", "20100513171259",
		"20100516124737", "20100910084426", "20101114011429",
		"20110322001319", "20110508145337", "20110521142405",
		"20110925112722", "20111116184519", "20111212183945",
		"20120123184321", "20120208122334", "20120208194454",
		"20120214210114", "20120219161649", "20120318201948",
		"20120328090602", "20120404205604", "20120808231205",
		"20121005195010", "20121012044047", "20121119165817",
		"20121202155309", "20121203124841", "20130328184137",
		"20131212124700", "20140115192822", "20140117185510",
		"20140210003018", "20140507110937", "20140519141742",
		"20150110152606", "20150111192335", "20150222101847",
		"20150818224516", "20160822153055", "20161002153425",
		"20161011010929", "20170222134109", "20180204153242",
		"20181020114000", "20181031113522", "20190518115041",
		"20190623093642", "20190702193519", "20190716173946",
		"20191120140058"
	};

	/**
	 * This class cannot be instantiated.
	 */
	private ApidbVersionConstants() {
	}
}
