function fetchData (cb) {
    return new Promise((resolve,reject) => {
      setTimeout(() => {
        resolve(cb('peanut butter'));
      }, 300);
    });
}

test('the data is peanut butter', done => {
  function callback(data) {
    try {
      expect(data).toBe('peanut butter');
      done();
    } catch (error) {
      done(error);
    }
  }

  fetchData(callback);
});

function fetchData2 () {
    return new Promise((resolve,reject) => {
      setTimeout(() => {
        resolve('peanut butter');
      }, 300);
    });
}

test('the data is peanut butter', () => {
  return fetchData2().then(data => {
    expect(data).toBe('peanut butter');
  });
});

test('the data is peanut butter', () => {
  return expect(fetchData2()).resolves.toBe('peanut butter');
});

test('the data is peanut butter', async () => {
  const data = await fetchData2();
  expect(data).toBe('peanut butter');
});

function fetchData3 () {
    return new Promise((resolve,reject) => {
      setTimeout(() => {
        reject('error');
      }, 300);
    });
}

test('the fetch fails with an error', () => {
  expect.assertions(1);
  return fetchData3().catch(e => expect(e).toMatch('error'));
});

test('the fetch fails with an error', async () => {
  expect.assertions(1);
  try {
    await fetchData3();
  } catch (e) {
    expect(e).toMatch('error');
  }
});

