dnl This is intended to be extensible, by just adding candidate C preprocessor
dnl options to be checked in the for loop.  The first candidate is empty, in
dnl case none are needed.  Also, the test program can be readily augmented.
dnl
dnl On glibc we need to define at least the '_XOPEN_SOURCE' level of features,
dnl or wchar.h doesn't declare a prototype for wcwidth(). But if we only define
dnl that level then db.h won't compile. So we define _GNU_SOURCE which turns
dnl on everything. Perhaps other OSes need some feature switch set to get
dnl wcwidth() declared; if so they should have an entry added to this case
dnl statement.  NB that we must define this on the compiler command line, not
dnl in config.h, because it must be set before any system header is included
dnl and there's no portable way to make sure that files generated by lex
dnl include config.h before system header files.
dnl
dnl Setting AM_CPPFLAGS directly is like DEFS, but doesn't get stomped on by
dnl configure when using config.h.

AC_DEFUN([NMH_ADDL_CPPFLAGS],
    [AC_CACHE_CHECK([platform-specific additional CPPFLAGS],
                    [nmh_cv_addl_cppflags], [
    dnl Turn warnings into errors.
    AC_LANG_WERROR

    nmh_saved_cppflags="$CPPFLAGS"
    dnl autoconf doesn't look at AM_CFLAGS, so merge it into CFLAGS.
    nmh_saved_cflags="$CFLAGS"
    CFLAGS="$AM_CFLAGS $CFLAGS"
    dnl On successful compilation, break out of loop with the AM_CPPFLAGS.
    dnl Try without any additional defines on the first iteration.
    for nmh_cv_addl_cppflags in "" "-D_GNU_SOURCE"; do
        dnl Reload initial CPPFLAGS so candidates aren't accumulated.
        CPPFLAGS="$nmh_saved_cppflags"
        dnl Only add non-empty nmh_cv_addl_cppflags to CPPFLAGS.
        AS_IF([test x"${nmh_cv_addl_cppflags}" != x],
              [CPPFLAGS="${CPPFLAGS:+$CPPFLAGS }$nmh_cv_addl_cppflags"])
        AS_IF([test ${MULTIBYTE_ENABLED} = 1],
              [AC_COMPILE_IFELSE(
                  [AC_LANG_PROGRAM([#include <string.h>
                                    #include <wchar.h>],
                                   [return strdup("x") == 0
                                             ? -wcwidth(0) : wcwidth(0)])],
                  [AM_CPPFLAGS="${nmh_cv_addl_cppflags}"; break;])],
              [AC_COMPILE_IFELSE(
                  [AC_LANG_PROGRAM([#include <string.h>],
                                   [return strdup("x") == 0])],
                  [AM_CPPFLAGS="${nmh_cv_addl_cppflags}"; break;])])
    done
    CFLAGS="$nmh_saved_cflags"
    CPPFLAGS="$nmh_saved_cppflags"
    ])

    dnl autoconf doesn't currently provide a macro to disable AC_LANG_WERROR,
    dnl so do it this way:
    AS_UNSET(ac_c_werror_flag)

    AC_SUBST([AM_CPPFLAGS])
])
