/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.widgets;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import net.claribole.zvtm.widgets.TranslucentWidget;

public class TranslucentButton
extends JButton
implements TranslucentWidget {
    AlphaComposite bgAC = AB_08;
    AlphaComposite bgACro = AlphaComposite.getInstance(3, 0.8f);
    AlphaComposite fgAC = AB_10;
    Color bgColro = Color.GRAY;
    Color fgColsel = Color.LIGHT_GRAY;
    Color fgCol = Color.WHITE;
    Color bgCol = Color.BLACK;
    boolean cursorInside = false;
    boolean buttonPressed = false;

    public TranslucentButton() {
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    public TranslucentButton(Action a) {
        super(a);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    public TranslucentButton(Icon icon) {
        super(icon);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    public TranslucentButton(String text) {
        super(text);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    public TranslucentButton(String text, Icon icon) {
        super(text, icon);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    void initColors() {
        this.setForeground(this.fgCol);
        this.setBackground(this.bgCol);
    }

    void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TranslucentButton.this.cursorInside = true;
                TranslucentButton.this.setBackground(TranslucentButton.this.bgColro);
                TranslucentButton.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TranslucentButton.this.cursorInside = false;
                TranslucentButton.this.setBackground(TranslucentButton.this.bgCol);
                TranslucentButton.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                TranslucentButton.this.buttonPressed = true;
                TranslucentButton.this.setForeground(TranslucentButton.this.fgColsel);
                TranslucentButton.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                TranslucentButton.this.buttonPressed = false;
                TranslucentButton.this.setForeground(TranslucentButton.this.fgCol);
                TranslucentButton.this.repaint();
            }
        });
    }

    public void setBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setForegroundTranslucence(float alpha) {
        this.fgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setRolloverBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.cursorInside) {
            g2d.setComposite(this.bgACro);
        } else {
            g2d.setComposite(this.bgAC);
        }
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(this.fgAC);
        g2d.setColor(this.getForeground());
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g2d);
    }
}

