/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.statistics.BufForTimeAveBoxes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import viewer.common.Const;

public class StatBoxStatusPanel
extends JPanel {
    private static final long serialVersionUID = 12500L;
    private static final String DRAW_STATES = "States Only";
    private static final String DRAW_ARROWS = "Arrows Only";
    private static final String DRAW_ALL = "All";
    private JComboBox combobox;
    private BufForTimeAveBoxes buf4statboxes;
    private JButton canvas_redraw_btn;

    public StatBoxStatusPanel(BufForTimeAveBoxes bufForTimeAveBoxes) {
        this.buf4statboxes = bufForTimeAveBoxes;
        super.setLayout(new BoxLayout(this, 0));
        this.combobox = new JComboBox();
        this.combobox.setFont(Const.FONT);
        this.combobox.setEditable(false);
        this.combobox.addItem(DRAW_STATES);
        this.combobox.addItem(DRAW_ARROWS);
        this.combobox.addItem(DRAW_ALL);
        this.combobox.setToolTipText("Display options for the Histogram");
        this.canvas_redraw_btn = null;
        super.add(this.combobox);
    }

    public void addRedrawListener(JButton jButton) {
        this.canvas_redraw_btn = jButton;
        this.combobox.addActionListener(new DisplayModeActionListener());
    }

    public void init() {
        this.combobox.setSelectedItem(DRAW_STATES);
    }

    private class DisplayModeActionListener
    implements ActionListener {
        private DisplayModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)StatBoxStatusPanel.this.combobox.getSelectedItem();
            if (string.equals(StatBoxStatusPanel.DRAW_STATES)) {
                StatBoxStatusPanel.this.buf4statboxes.setDrawingStates(true);
                StatBoxStatusPanel.this.buf4statboxes.setDrawingArrows(false);
            } else if (string.equals(StatBoxStatusPanel.DRAW_ARROWS)) {
                StatBoxStatusPanel.this.buf4statboxes.setDrawingStates(false);
                StatBoxStatusPanel.this.buf4statboxes.setDrawingArrows(true);
            } else if (string.equals(StatBoxStatusPanel.DRAW_ALL)) {
                StatBoxStatusPanel.this.buf4statboxes.setDrawingStates(true);
                StatBoxStatusPanel.this.buf4statboxes.setDrawingArrows(true);
            } else {
                StatBoxStatusPanel.this.buf4statboxes.setDrawingStates(true);
                StatBoxStatusPanel.this.buf4statboxes.setDrawingArrows(false);
            }
            StatBoxStatusPanel.this.canvas_redraw_btn.doClick();
        }
    }
}

