functor

import

   FD

   Search

export
   Return
define

% See Sidebottom page 60; Schur lemma problem
% Integers 1..n to be colored with three colors. If x+y=Z, the three integers 
% must not have the same color.

   Schur =
   proc {$  M N}
      local
	 And = FD.conj
	 Not = FD.nega
      in
	 M={MakeTuple f N*3}
      % M_i^j : integer i has color j
	 {For 1 N*3 1 proc{$ I} M.I :: 0#1 end}
      
      % Each integer has  exact one color
	 {For 1 N 1 proc{$ I} 
			 % M.I + M.I2 + M.I3 = 1
			    M.I + M.(I+N) + M.(I+N+N) =: 1
			 end}
      
      % if x+y=z then not the same color
      % ~(Mxj /\ Myj /\ Mzj)   for j in 1,2,3
	 {For 1 (N+1) div 2 1 
	  proc {$ I1} 
	     {For I1 N-I1 1
	      proc {$ I2}
		 local I3=!I1+!I2 in
		    cond  I1=I2 
		    then skip
		    else
		       {Not {And M.I1 {And M.I2 M.I3}} 1}
		       {Not {And M.(I1+N) {And M.(I2+N) M.(I3+N)}} 1}
		       local T =!N+!N in
			  {Not {And M.(I1+T) {And M.(I2+T) M.(I3+T)}} 1}
		       end
		       /*
		       {Or {Or {Not M.I1} {Not M.I2}} {Not M.I3} 1}
		       {Or {Or {Not M.(I1+N)} {Not M.(I2+N)}} 
			{Not M.(I3+N)} 1}
		       exists T =!N+!N in
		       {Or {Or {Not M.(I1+T)}{Not M.(I2+T)}}
			{Not M.(I3+T)} 1}
		       */
		    end
		 end
	      end} end}
	 {FD.distribute ff M}
      end
   end

   SchurSol = [f(0 0 0 0 0 0 0 1 0 1 1 1 0 1 0)
	       f(0 0 0 0 0 0 0 1 1 0 1 1 0 0 1)
	       f(0 0 0 0 0 0 0 1 1 1 1 1 0 0 0)
	       f(0 0 0 0 0 0 1 0 1 0 1 0 1 0 1)
	       f(0 0 0 0 0 0 1 0 1 1 1 0 1 0 0)
 
	       f(0 0 0 0 0 0 1 1 1 0 1 0 0 0 1)
	       f(0 0 0 0 0 1 0 0 0 1 0 1 1 1 0)
	       f(0 0 0 0 0 1 0 1 0 0 0 1 0 1 1)
	       f(0 0 0 0 0 1 0 1 0 1 0 1 0 1 0)
	       f(0 0 0 0 0 1 1 0 0 0 0 0 1 1 1)
 
	       f(0 0 0 0 0 1 1 0 0 1 0 0 1 1 0)
	       f(0 0 0 0 0 1 1 0 1 0 0 0 1 0 1)
	       f(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0)
	       f(0 0 0 0 1 0 0 1 1 0 1 1 0 0 0)
	       f(0 0 0 0 1 0 1 0 1 0 1 0 1 0 0)
 
	       f(0 0 0 0 1 0 1 1 0 0 1 0 0 1 0)
	       f(0 0 0 0 1 0 1 1 1 0 1 0 0 0 0)
	       f(0 0 0 0 1 1 0 0 0 0 0 1 1 1 0)
	       f(0 0 0 0 1 1 0 0 1 0 0 1 1 0 0)
	       f(0 0 0 0 1 1 0 1 0 0 0 1 0 1 0)
 
	       f(0 0 0 0 1 1 1 0 0 0 0 0 1 1 0)
	       f(0 0 0 0 1 1 1 0 1 0 0 0 1 0 0)
	       f(0 0 0 1 0 0 0 1 0 0 1 1 0 0 1)
	       f(0 0 0 1 0 0 0 1 0 1 1 1 0 0 0)
	       f(0 0 0 1 0 0 1 0 0 0 1 0 1 0 1)
 
	       f(0 0 0 1 0 0 1 0 0 1 1 0 1 0 0)
	       f(0 0 0 1 0 0 1 1 0 0 1 0 0 0 1)
	       f(0 0 0 1 0 1 0 0 0 1 0 1 1 0 0)
	       f(0 0 0 1 0 1 0 1 0 0 0 1 0 0 1)
	       f(0 0 0 1 0 1 0 1 0 1 0 1 0 0 0)
 
	       f(0 0 0 1 0 1 1 0 0 0 0 0 1 0 1)
	       f(0 0 0 1 0 1 1 0 0 1 0 0 1 0 0)
	       f(0 0 0 1 1 0 0 1 0 0 1 1 0 0 0)
	       f(0 0 0 1 1 0 1 0 0 0 1 0 1 0 0)
	       f(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0)
 
	       f(0 0 0 1 1 1 0 0 0 0 0 1 1 0 0)
	       f(0 0 0 1 1 1 0 1 0 0 0 1 0 0 0)
	       f(0 0 0 1 1 1 1 0 0 0 0 0 1 0 0)
	       f(0 0 1 0 0 0 0 0 0 1 1 1 0 1 0)
	       f(0 0 1 0 0 0 0 0 1 0 1 1 0 0 1)
 
	       f(0 0 1 0 0 0 0 0 1 1 1 1 0 0 0)
	       f(0 0 1 0 0 0 1 0 0 1 1 0 0 1 0)
	       f(0 0 1 0 0 0 1 0 1 0 1 0 0 0 1)
	       f(0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)
	       f(0 0 1 0 0 1 0 0 0 0 0 1 0 1 1)
 
	       f(0 0 1 0 0 1 0 0 0 1 0 1 0 1 0)
	       f(0 0 1 0 0 1 0 0 1 0 0 1 0 0 1)
	       f(0 0 1 0 0 1 1 0 0 0 0 0 0 1 1)
	       f(0 0 1 0 0 1 1 0 0 1 0 0 0 1 0)
	       f(0 0 1 0 0 1 1 0 1 0 0 0 0 0 1)
 
	       f(0 0 1 0 1 0 0 0 0 0 1 1 0 1 0)
	       f(0 0 1 0 1 0 0 0 1 0 1 1 0 0 0)
	       f(0 0 1 0 1 0 1 0 0 0 1 0 0 1 0)
	       f(0 0 1 0 1 0 1 0 1 0 1 0 0 0 0)
	       f(0 0 1 0 1 1 0 0 0 0 0 1 0 1 0)
 
	       f(0 0 1 0 1 1 0 0 1 0 0 1 0 0 0)
	       f(0 0 1 0 1 1 1 0 0 0 0 0 0 1 0)
	       f(0 0 1 0 1 1 1 0 1 0 0 0 0 0 0)
	       f(0 0 1 1 0 0 0 0 0 0 1 1 0 0 1)
	       f(0 0 1 1 0 0 0 0 0 1 1 1 0 0 0)
 
	       f(0 0 1 1 0 0 1 0 0 0 1 0 0 0 1)
	       f(0 0 1 1 0 0 1 0 0 1 1 0 0 0 0)
	       f(0 0 1 1 0 1 0 0 0 0 0 1 0 0 1)
	       f(0 0 1 1 0 1 0 0 0 1 0 1 0 0 0)
	       f(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1)
 
	       f(0 0 1 1 0 1 1 0 0 1 0 0 0 0 0)
	       f(0 0 1 1 1 0 0 0 0 0 1 1 0 0 0)
	       f(0 0 1 1 1 0 1 0 0 0 1 0 0 0 0)
	       f(0 0 1 1 1 1 0 0 0 0 0 1 0 0 0)
	       f(0 0 1 1 1 1 1 0 0 0 0 0 0 0 0)
 
	       f(0 1 0 0 0 0 0 0 1 0 1 0 1 0 1)
	       f(0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)
	       f(0 1 0 0 0 0 0 1 0 1 1 0 0 1 0)
	       f(0 1 0 0 0 0 0 1 1 0 1 0 0 0 1)
	       f(0 1 0 0 0 0 0 1 1 1 1 0 0 0 0)
 
	       f(0 1 0 0 0 1 0 0 0 0 0 0 1 1 1)
	       f(0 1 0 0 0 1 0 0 0 1 0 0 1 1 0)
	       f(0 1 0 0 0 1 0 0 1 0 0 0 1 0 1)
	       f(0 1 0 0 0 1 0 1 0 0 0 0 0 1 1)
	       f(0 1 0 0 0 1 0 1 0 1 0 0 0 1 0)
 
	       f(0 1 0 0 1 0 0 0 1 0 1 0 1 0 0)
	       f(0 1 0 0 1 0 0 1 0 0 1 0 0 1 0)
	       f(0 1 0 0 1 0 0 1 1 0 1 0 0 0 0)
	       f(0 1 0 0 1 1 0 0 0 0 0 0 1 1 0)
	       f(0 1 0 0 1 1 0 0 1 0 0 0 1 0 0)
 
	       f(0 1 0 0 1 1 0 1 0 0 0 0 0 1 0)
	       f(0 1 0 1 0 0 0 0 0 0 1 0 1 0 1)
	       f(0 1 0 1 0 0 0 0 0 1 1 0 1 0 0)
	       f(0 1 0 1 0 0 0 1 0 0 1 0 0 0 1)
	       f(0 1 0 1 0 0 0 1 0 1 1 0 0 0 0)
 
	       f(0 1 0 1 0 1 0 0 0 0 0 0 1 0 1)
	       f(0 1 0 1 0 1 0 0 0 1 0 0 1 0 0)
	       f(0 1 0 1 0 1 0 1 0 0 0 0 0 0 1)
	       f(0 1 0 1 0 1 0 1 0 1 0 0 0 0 0)
	       f(0 1 0 1 1 0 0 0 0 0 1 0 1 0 0)
 
	       f(0 1 0 1 1 0 0 1 0 0 1 0 0 0 0)
	       f(0 1 0 1 1 1 0 0 0 0 0 0 1 0 0)
	       f(0 1 0 1 1 1 0 1 0 0 0 0 0 0 0)
	       f(0 1 1 0 0 0 0 0 0 1 1 0 0 1 0)
	       f(0 1 1 0 0 0 0 0 1 0 1 0 0 0 1)
 
	       f(0 1 1 0 0 0 0 0 1 1 1 0 0 0 0)
	       f(0 1 1 0 0 1 0 0 0 0 0 0 0 1 1)
	       f(0 1 1 0 0 1 0 0 0 1 0 0 0 1 0)
	       f(0 1 1 0 0 1 0 0 1 0 0 0 0 0 1)
	       f(0 1 1 1 0 0 0 0 0 0 1 0 0 0 1)
 
	       f(0 1 1 1 0 0 0 0 0 1 1 0 0 0 0)
	       f(0 1 1 1 0 1 0 0 0 0 0 0 0 0 1)
	       f(0 1 1 1 0 1 0 0 0 1 0 0 0 0 0)
	       f(1 0 0 0 0 0 0 0 0 1 0 1 1 1 0)
	       f(1 0 0 0 0 0 0 0 1 1 0 1 1 0 0)
 
	       f(1 0 0 0 0 0 0 1 0 0 0 1 0 1 1)
	       f(1 0 0 0 0 0 0 1 0 1 0 1 0 1 0)
	       f(1 0 0 0 0 0 0 1 1 0 0 1 0 0 1)
	       f(1 0 0 0 0 0 0 1 1 1 0 1 0 0 0)
	       f(1 0 0 0 0 0 1 0 0 0 0 0 1 1 1)
 
	       f(1 0 0 0 0 0 1 0 0 1 0 0 1 1 0)
	       f(1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
	       f(1 0 0 0 0 0 1 0 1 1 0 0 1 0 0)
	       f(1 0 0 0 0 0 1 1 0 0 0 0 0 1 1)
	       f(1 0 0 0 0 0 1 1 1 0 0 0 0 0 1)
 
	       f(1 0 0 0 1 0 0 0 0 0 0 1 1 1 0)
	       f(1 0 0 0 1 0 0 0 1 0 0 1 1 0 0)
	       f(1 0 0 0 1 0 0 1 0 0 0 1 0 1 0)
	       f(1 0 0 0 1 0 0 1 1 0 0 1 0 0 0)
	       f(1 0 0 0 1 0 1 0 0 0 0 0 1 1 0)
 
	       f(1 0 0 0 1 0 1 0 1 0 0 0 1 0 0)
	       f(1 0 0 0 1 0 1 1 0 0 0 0 0 1 0)
	       f(1 0 0 0 1 0 1 1 1 0 0 0 0 0 0)
	       f(1 0 0 1 0 0 0 0 0 1 0 1 1 0 0)
	       f(1 0 0 1 0 0 0 1 0 0 0 1 0 0 1)
 
	       f(1 0 0 1 0 0 0 1 0 1 0 1 0 0 0)
	       f(1 0 0 1 0 0 1 0 0 0 0 0 1 0 1)
	       f(1 0 0 1 0 0 1 0 0 1 0 0 1 0 0)
	       f(1 0 0 1 0 0 1 1 0 0 0 0 0 0 1)
	       f(1 0 1 0 0 0 0 0 0 0 0 1 0 1 1)
 
	       f(1 0 1 0 0 0 0 0 0 1 0 1 0 1 0)
	       f(1 0 1 0 0 0 0 0 1 0 0 1 0 0 1)
	       f(1 0 1 0 0 0 0 0 1 1 0 1 0 0 0)
	       f(1 0 1 0 0 0 1 0 0 0 0 0 0 1 1)
	       f(1 0 1 0 0 0 1 0 0 1 0 0 0 1 0)
 
	       f(1 0 1 0 0 0 1 0 1 0 0 0 0 0 1)
	       f(1 0 1 0 0 0 1 0 1 1 0 0 0 0 0)
	       f(1 0 1 0 1 0 0 0 0 0 0 1 0 1 0)
	       f(1 0 1 0 1 0 0 0 1 0 0 1 0 0 0)
	       f(1 0 1 0 1 0 1 0 0 0 0 0 0 1 0)
 
	       f(1 0 1 0 1 0 1 0 1 0 0 0 0 0 0)
	       f(1 1 0 0 0 0 0 0 0 0 0 0 1 1 1)
	       f(1 1 0 0 0 0 0 0 0 1 0 0 1 1 0)
	       f(1 1 0 0 0 0 0 0 1 0 0 0 1 0 1)
	       f(1 1 0 0 0 0 0 0 1 1 0 0 1 0 0)
 
	       f(1 1 0 0 0 0 0 1 0 0 0 0 0 1 1)
	       f(1 1 0 0 0 0 0 1 0 1 0 0 0 1 0)
	       f(1 1 0 0 0 0 0 1 1 0 0 0 0 0 1)
	       f(1 1 0 0 0 0 0 1 1 1 0 0 0 0 0)
	       f(1 1 0 0 1 0 0 0 0 0 0 0 1 1 0)
 
	       f(1 1 0 0 1 0 0 0 1 0 0 0 1 0 0)
	       f(1 1 0 0 1 0 0 1 0 0 0 0 0 1 0)
	       f(1 1 0 0 1 0 0 1 1 0 0 0 0 0 0)
	       f(1 1 0 1 0 0 0 0 0 0 0 0 1 0 1)
	       f(1 1 0 1 0 0 0 0 0 1 0 0 1 0 0)
 
	       f(1 1 0 1 0 0 0 1 0 0 0 0 0 0 1)
	       f(1 1 0 1 0 0 0 1 0 1 0 0 0 0 0)
	      ]

   Return=
   fd([schur([
	      all(equal(fun {$} {Search.base.all proc{$ X} {Schur X 5} end} end
			SchurSol)


		  keys: [fd])
	      all_entailed(entailed(proc {$}
				       {Search.base.all proc{$ X} {Schur X 5} end _}
				    end)
		  keys: [fd entailed])
	     ])
      ])
end

