/*
 * Author: Thomas Dubois, <thomas _at_ flowplayer org>
 * This file is part of Flowplayer, http://flowplayer.org
 *
 * Copyright (c) 2011 Flowplayer Ltd
 *
 * Released under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 */
package org.flowplayer.controls.controllers {
    
	import org.flowplayer.view.Flowplayer;
	import org.flowplayer.model.PlayerEvent;
	import org.flowplayer.model.ClipEvent;
	import org.flowplayer.model.Clip;
	import org.flowplayer.model.PlayerEventType;
	
	import org.flowplayer.ui.buttons.ToggleButtonConfig;
	import org.flowplayer.ui.controllers.AbstractToggleButtonController;

	import org.flowplayer.ui.buttons.ButtonEvent;
	import org.flowplayer.ui.buttons.ToggleButton;
	
	import org.flowplayer.controls.Controlbar;
	import org.flowplayer.controls.SkinClasses;

	import flash.display.DisplayObjectContainer;
	
	public class ToggleFullScreenButtonController extends AbstractToggleButtonController {
		
		public function ToggleFullScreenButtonController() {
			super();
		}
		
		override public function get name():String {
			return "fullscreen";
		}

		override public function get defaults():Object {
			return {
				tooltipEnabled: false,
				tooltipLabel: "Fullscreen",
				visible: true,
				enabled: true
			};
		}
		
		override public function get downName():String {
			return "fullscreenExit";
		}
		
		override public function get downDefaults():Object {
			return {
				tooltipEnabled: false,
				tooltipLabel: "Exit Fullscreen",
				visible: true,
				enabled: true
			};
		}

		override protected function get faceClass():Class {
			return SkinClasses.getClass("fp.FullScreenOnButton");
		}
		
		override protected function get downFaceClass():Class {
			return SkinClasses.getClass("fp.FullScreenOffButton");
		}		
		
		// TODO : this guy might need to be moved
		protected function doEnable(clip:Clip):void {
			var shouldEnable:Boolean = clip && (clip.originalWidth > 0 || ! clip.useHWScaling) && _config.config.enabled;
			_widget.enabled 	= shouldEnable;
		}
		
		// Fullscreen related stuff
		override protected function addPlayerListeners():void {
			super.addPlayerListeners();
			
			_player.onFullscreen(onPlayerFullscreen);
            _player.onFullscreenExit(onPlayerFullscreen);
		}
		
		protected function onPlayerFullscreen(event:PlayerEvent):void {
            isDown = event.eventType == PlayerEventType.FULLSCREEN;
        }

		override protected function onPlayStarted(event:ClipEvent):void {
			doEnable(event.target as Clip);
		}


		override protected function onButtonClicked(event:ButtonEvent):void {
			_player.toggleFullscreen();
		}
	}
}
