/*
 * Please edit these settings to match your system.
 * When you're done, type 'make' to compile and link.
 * Then you may install with 'make install'.
 */
#ifndef _MCDP_PARAMS_H
#define _MCDP_PARAMS_H

#define CDDB_CREATMODE  0644 /* used, for new entries */

/* max size a titlename may have
 * 62 is correct for terminals <= 80 !
 */
#define CDDB_TITLEMAX     62

#define MCDP_INTRO_TIME   10 /* seconds for the intro */
#define MCDP_CDAUDIO_MAX  99 /* maxtracks of the cd (RedBook) */

#define FW_FAST 30 /* FF (sec. ffast forward) */
#define FW_SLOW 6  /* FW (sec. fslow forward) */
#define RW_FAST 30 /* RF (sec. rfast rewind) */
#define RW_SLOW 6  /* RW (sec. rslow rewind) */

/*
 * ESC seqences, you may change some of them ...
 * (these are vt100, xterm, linux, xterm-color compatible)
 * The eterm-boxes looks ugly :(
 */

/* needed */
#define T_NORMAL   "\033[0m"     /* normal mode */
#define T_BOLD     "\033[1m"     /* bold mode */
#define T_HOME     "\033[H"      /* goto 0,0 */
#define T_CLEAR    "\033[2J"     /* clear screen */
#define T_GOTO_XY  "\033[%d;%dH" /* goto x,y position (%d=int) */

/* box drawing */
#if 1 /* if you have some ugly old terminals, define it to 0 */
#define AC_TL      "\016l\017"   /* top left */
#define AC_TR      "\016k\017"   /* top right */
#define AC_BL      "\016m\017"   /* bottom left */
#define AC_BR      "\016j\017"   /* bottom right */
#define AC_MT      "\016v\017"   /* top 2middle */
#define AC_MB      "\016w\017"   /* bottom 2middle */
#define AC_ML      "\016t\017"   /* left 2middle */
#define AC_MR      "\016u\017"   /* right 2middle */
#define AC_MM      "\016n\017"   /* middle + */
#define AC_HL      "\016q\017"   /* hline - */
#define AC_VL      "\016x\017"   /* vline | */
#else
#define AC_TL      ","           /* top left */
#define AC_TR      "."           /* top right */
#define AC_BL      "`"           /* bottom left */
#define AC_BR      "'"           /* bottom right */
#define AC_MT      "^"           /* top 2middle */
#define AC_MB      "v"           /* bottom 2middle */
#define AC_ML      ">"           /* left 2middle */
#define AC_MR      "<"           /* right 2middle */
#define AC_MM      "+"           /* middle + */
#define AC_HL      "-"           /* hline - */
#define AC_VL      "|"           /* vline | */
#endif

/* colors */
#define C_BOX      "\033[0;34m"  /* blue   - boxdrawing */
#define C_NORMAL   "\033[0;37m"  /* grey   - normal/default/tracks */
#define C_STATUS   "\033[0;31m"  /* red    - stausline (track++) */
#define C_DESCRIPT "\033[1;33m"  /* yellow - descriptions */
#define C_HEADLINE "\033[0;33m"  /* brown  - version, headlines */
/* style: 00=none 01=bold 04=underscore 05=blink 07=reverse 08=concealed
 * fg: 30=black 31=red 32=green 33=yellow 34=blue 35=magenta 36=cyan 37=grey
 * bg: 40=black 41=red 42=green 43=yellow 44=blue 45=magenta 46=cyan 47=grey
 */

#endif /* _MCDP_PARAMS_H */
