# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set import DataSet


class ImageData(DataSet):
    r"""
    ImageData - topologically and geometrically regular array of data
    
    Superclass: DataSet
    
    ImageData is a data object that is a concrete implementation of
    DataSet. ImageData represents a geometric structure that is a
    topological and geometrical regular array of points. Examples include
    volumes (voxel data) and pixmaps. This representation supports images
    up to three dimensions. The image may also be oriented (see the
    direction_matrices and related transformation methods). Note however,
    that not all filters support oriented images.
    
    @sa
    ImageTransform
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageData, obj, update, **traits)
    
    def get_axis_update_extent(self, *args):
        """
        get_axis_update_extent(self, axis:int, min:int, max:int,
            updateExtent:(int, ...)) -> None
        C++: virtual void get_axis_update_extent(int axis, int &min,
            int &max, const int *updateExtent)"""
        ret = self._wrap_call(self._vtk_obj.GetAxisUpdateExtent, *args)
        return ret

    def set_axis_update_extent(self, *args):
        """
        set_axis_update_extent(self, axis:int, min:int, max:int,
            updateExtent:(int, ...), axisUpdateExtent:[int, ...]) -> None
        C++: virtual void set_axis_update_extent(int axis, int min, int max,
            const int *updateExtent, int *axisUpdateExtent)
        Set / Get the extent on just one axis
        """
        ret = self._wrap_call(self._vtk_obj.SetAxisUpdateExtent, *args)
        return ret

    dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(0, 0, 0), cols=3, desc=\
        r"""
        Same as set_extent(0, i-1, 0, j-1, 0, k-1)
        """
    )

    def _dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensions,
                        self.dimensions)

    def _get_direction_matrix(self):
        return wrap_vtk(self._vtk_obj.GetDirectionMatrix())
    def _set_direction_matrix(self, arg):
        old_val = self._get_direction_matrix()
        self._wrap_call(self._vtk_obj.SetDirectionMatrix,
                        deref_vtk(arg))
        self.trait_property_changed('direction_matrix', old_val, arg)
    direction_matrix = traits.Property(_get_direction_matrix, _set_direction_matrix, desc=\
        r"""
        Set/Get the direction transform of the dataset. The direction
        matrix is a 3x3 transformation matrix supporting scaling and
        rotation.
        """
    )

    extent = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="int", value=(0, -1, 0, -1, 0, -1), cols=3, desc=\
        r"""
        Set/Get the extent. On each axis, the extent is defined by the
        index of the first point and the index of the last point.  The
        extent should be set before the "Scalars" are set or allocated. 
        The Extent is stored in the order (X, Y, Z). The dataset extent
        does not have to start at (0,0,0). (0,0,0) is just the extent of
        the origin. The first point (the one with Id=0) is at extent
        (Extent[0],Extent[2],Extent[4]). As for any dataset, a data array
        on point data starts at Id=0.
        """
    )

    def _extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtent,
                        self.extent)

    number_of_scalar_components = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of scalar components for points. As with the
        set_scalar_type method this is setting pipeline info.
        """
    )

    def _number_of_scalar_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfScalarComponents,
                        self.number_of_scalar_components)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    spacing = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        
        """
    )

    def _spacing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpacing,
                        self.spacing)

    def get_array_increments(self, *args):
        """
        get_array_increments(self, array:DataArray, increments:[int, int,
             int]) -> None
        C++: void get_array_increments(DataArray *array,
            IdType increments[3])
        Since various arrays have different number of components, the
        will have different increments.
        """
        my_args = deref_array(args, [('vtkDataArray', ['int', 'int', 'int'])])
        ret = self._wrap_call(self._vtk_obj.GetArrayIncrements, *my_args)
        return ret

    def get_array_pointer(self, *args):
        """
        get_array_pointer(self, array:DataArray, coordinates:[int, int,
            int]) -> Pointer
        C++: void *get_array_pointer(DataArray *array,
            int coordinates[3])"""
        my_args = deref_array(args, [('vtkDataArray', ['int', 'int', 'int'])])
        ret = self._wrap_call(self._vtk_obj.GetArrayPointer, *my_args)
        return ret

    def get_array_pointer_for_extent(self, *args):
        """
        get_array_pointer_for_extent(self, array:DataArray, extent:[int,
            int, int, int, int, int]) -> Pointer
        C++: void *get_array_pointer_for_extent(DataArray *array,
            int extent[6])
        These are convenience methods for getting a pointer from any
        filed array.  It is a start at expanding image filters to process
        any array (not just scalars).
        """
        my_args = deref_array(args, [('vtkDataArray', ['int', 'int', 'int', 'int', 'int', 'int'])])
        ret = self._wrap_call(self._vtk_obj.GetArrayPointerForExtent, *my_args)
        return ret

    def get_cell_dims(self, *args):
        """
        get_cell_dims(self, cellDims:[int, int, int]) -> None
        C++: void get_cell_dims(int cellDims[3])
        Given the node dimensions of this grid instance, this method
        computes the node dimensions. The value in each dimension can
        will have a lowest value of "1" such that computing the total
        number of cells can be achieved by simply by
        cellDims[0]*cellDims[1]*cellDims[2].
        """
        ret = self._wrap_call(self._vtk_obj.GetCellDims, *args)
        return ret

    def get_continuous_increments(self, *args):
        """
        get_continuous_increments(self, extent:[int, int, int, int, int,
            int], incX:int, incY:int, incZ:int) -> None
        C++: virtual void get_continuous_increments(int extent[6],
            IdType &incX, IdType &incY, IdType &incZ)
        get_continuous_increments(self, scalars:DataArray, extent:[int,
            int, int, int, int, int], incX:int, incY:int, incZ:int)
            -> None
        C++: virtual void get_continuous_increments(DataArray *scalars,
            int extent[6], IdType &incX, IdType &incY,
            IdType &incZ)
        Different ways to get the increments for moving around the data.
        incX is always returned with 0.  incY is returned with the
        increment needed to move from the end of one X scanline of data
        to the start of the next line.  incZ is filled in with the
        increment needed to move from the end of one image to the start
        of the next.  The proper way to use these values is to for a loop
        over Z, Y, X, C, incrementing the pointer by 1 after each
        component.  When the end of the component is reached, the pointer
        is set to the beginning of the next pixel, thus incX is properly
        set to 0. The first form of get_continuous_increments uses the
        active scalar field while the second form allows the scalar array
        to be passed in.
        """
        my_args = deref_array(args, [(['int', 'int', 'int', 'int', 'int', 'int'], 'int', 'int', 'int'), ('vtkDataArray', ['int', 'int', 'int', 'int', 'int', 'int'], 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetContinuousIncrements, *my_args)
        return ret

    def _get_data_dimension(self):
        return self._vtk_obj.GetDataDimension()
    data_dimension = traits.Property(_get_data_dimension, desc=\
        r"""
        Return the dimensionality of the data.
        """
    )

    def _get_increments(self):
        return self._vtk_obj.GetIncrements()
    increments = traits.Property(_get_increments, desc=\
        r"""
        Different ways to get the increments for moving around the data.
        get_increments() calls compute_increments() to ensure the
        increments are up to date.  The first three methods compute the
        increments based on the active scalar field while the next three,
        the scalar field is passed in.
        """
    )

    def get_increments(self, *args):
        """
        get_increments(self) -> (int, int, int)
        C++: virtual IdType *get_increments()
        get_increments(self, incX:int, incY:int, incZ:int) -> None
        C++: virtual void get_increments(IdType &incX, IdType &incY,
            IdType &incZ)
        get_increments(self, inc:[int, int, int]) -> None
        C++: virtual void get_increments(IdType inc[3])
        get_increments(self, scalars:DataArray) -> (int, int, int)
        C++: virtual IdType *get_increments(DataArray *scalars)
        get_increments(self, scalars:DataArray, incX:int, incY:int,
            incZ:int) -> None
        C++: virtual void get_increments(DataArray *scalars,
            IdType &incX, IdType &incY, IdType &incZ)
        get_increments(self, scalars:DataArray, inc:[int, int, int])
            -> None
        C++: virtual void get_increments(DataArray *scalars,
            IdType inc[3])
        Different ways to get the increments for moving around the data.
        get_increments() calls compute_increments() to ensure the
        increments are up to date.  The first three methods compute the
        increments based on the active scalar field while the next three,
        the scalar field is passed in.
        """
        my_args = deref_array(args, [None, ('int', 'int', 'int'), (['int', 'int', 'int'],), ['vtkDataArray'], ('vtkDataArray', 'int', 'int', 'int'), ('vtkDataArray', ['int', 'int', 'int'])])
        ret = self._wrap_call(self._vtk_obj.GetIncrements, *my_args)
        return ret

    def _get_index_to_physical_matrix(self):
        return wrap_vtk(self._vtk_obj.GetIndexToPhysicalMatrix())
    index_to_physical_matrix = traits.Property(_get_index_to_physical_matrix, desc=\
        r"""
        Get the transformation matrix from the index space to the
        physical space coordinate system of the dataset. The transform is
        a 4 by 4 matrix.
        """
    )

    def _get_physical_to_index_matrix(self):
        return wrap_vtk(self._vtk_obj.GetPhysicalToIndexMatrix())
    physical_to_index_matrix = traits.Property(_get_physical_to_index_matrix, desc=\
        r"""
        Get the transformation matrix from the physical space to the
        index space coordinate system of the dataset. The transform is a
        4 by 4 matrix.
        """
    )

    def get_point_gradient(self, *args):
        """
        get_point_gradient(self, i:int, j:int, k:int, s:DataArray,
            g:[float, float, float]) -> None
        C++: virtual void get_point_gradient(int i, int j, int k,
            DataArray *s, double g[3])
        Given structured coordinates (i,j,k) for a point in a structured
        point dataset, compute the gradient vector from the scalar data
        at that point. The scalars s are the scalars from which the
        gradient is to be computed. This method will treat structured
        point datasets of any dimension.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'vtkDataArray', ['float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.GetPointGradient, *my_args)
        return ret

    def get_scalar_component_as_double(self, *args):
        """
        get_scalar_component_as_double(self, x:int, y:int, z:int,
            component:int) -> float
        C++: virtual double get_scalar_component_as_double(int x, int y,
            int z, int component)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarComponentAsDouble, *args)
        return ret

    def get_scalar_component_as_float(self, *args):
        """
        get_scalar_component_as_float(self, x:int, y:int, z:int,
            component:int) -> float
        C++: virtual float get_scalar_component_as_float(int x, int y, int z,
            int component)
        For access to data from wrappers
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarComponentAsFloat, *args)
        return ret

    def get_scalar_index(self, *args):
        """
        get_scalar_index(self, coordinates:[int, int, int]) -> int
        C++: virtual IdType get_scalar_index(int coordinates[3])
        get_scalar_index(self, x:int, y:int, z:int) -> int
        C++: virtual IdType get_scalar_index(int x, int y, int z)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarIndex, *args)
        return ret

    def get_scalar_index_for_extent(self, *args):
        """
        get_scalar_index_for_extent(self, extent:[int, int, int, int, int,
            int]) -> int
        C++: virtual IdType get_scalar_index_for_extent(int extent[6])
        Access the index for the scalar data
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarIndexForExtent, *args)
        return ret

    def _get_scalar_pointer(self):
        return self._vtk_obj.GetScalarPointer()
    scalar_pointer = traits.Property(_get_scalar_pointer, desc=\
        r"""
        
        """
    )

    def get_scalar_pointer(self, *args):
        """
        get_scalar_pointer(self, coordinates:[int, int, int]) -> Pointer
        C++: virtual void *get_scalar_pointer(int coordinates[3])
        get_scalar_pointer(self, x:int, y:int, z:int) -> Pointer
        C++: virtual void *get_scalar_pointer(int x, int y, int z)
        get_scalar_pointer(self) -> Pointer
        C++: virtual void *get_scalar_pointer()"""
        ret = self._wrap_call(self._vtk_obj.GetScalarPointer, *args)
        return ret

    def get_scalar_pointer_for_extent(self, *args):
        """
        get_scalar_pointer_for_extent(self, extent:[int, int, int, int, int,
            int]) -> Pointer
        C++: virtual void *get_scalar_pointer_for_extent(int extent[6])
        Access the native pointer for the scalar data
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarPointerForExtent, *args)
        return ret

    def _get_scalar_size(self):
        return self._vtk_obj.GetScalarSize()
    scalar_size = traits.Property(_get_scalar_size, desc=\
        r"""
        Get the size of the scalar type in bytes.
        """
    )

    def get_scalar_size(self, *args):
        """
        get_scalar_size(self, meta_data:Information) -> int
        C++: virtual int get_scalar_size(Information *meta_data)
        get_scalar_size(self) -> int
        C++: virtual int get_scalar_size()
        Get the size of the scalar type in bytes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetScalarSize, *my_args)
        return ret

    def _get_scalar_type_as_string(self):
        return self._vtk_obj.GetScalarTypeAsString()
    scalar_type_as_string = traits.Property(_get_scalar_type_as_string, desc=\
        r"""
        
        """
    )

    def _get_scalar_type_max(self):
        return self._vtk_obj.GetScalarTypeMax()
    scalar_type_max = traits.Property(_get_scalar_type_max, desc=\
        r"""
        
        """
    )

    def get_scalar_type_max(self, *args):
        """
        get_scalar_type_max(self, meta_data:Information) -> float
        C++: virtual double get_scalar_type_max(Information *meta_data)
        get_scalar_type_max(self) -> float
        C++: virtual double get_scalar_type_max()"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetScalarTypeMax, *my_args)
        return ret

    def _get_scalar_type_min(self):
        return self._vtk_obj.GetScalarTypeMin()
    scalar_type_min = traits.Property(_get_scalar_type_min, desc=\
        r"""
        These returns the minimum and maximum values the scalar_type can
        hold without overflowing.
        """
    )

    def get_scalar_type_min(self, *args):
        """
        get_scalar_type_min(self, meta_data:Information) -> float
        C++: virtual double get_scalar_type_min(Information *meta_data)
        get_scalar_type_min(self) -> float
        C++: virtual double get_scalar_type_min()
        These returns the minimum and maximum values the scalar_type can
        hold without overflowing.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetScalarTypeMin, *my_args)
        return ret

    def get_tuple_index(self, *args):
        """
        get_tuple_index(self, array:DataArray, coordinates:[int, int,
            int]) -> int
        C++: IdType get_tuple_index(DataArray *array,
            int coordinates[3])
        Given a data array and a coordinate, return the index of the
        tuple in the array corresponding to that coordinate.
        
        This method is analogous to get_array_pointer(), but it conforms to
        the API of GenericDataArray.
        """
        my_args = deref_array(args, [('vtkDataArray', ['int', 'int', 'int'])])
        ret = self._wrap_call(self._vtk_obj.GetTupleIndex, *my_args)
        return ret

    def get_voxel_gradient(self, *args):
        """
        get_voxel_gradient(self, i:int, j:int, k:int, s:DataArray,
            g:DataArray) -> None
        C++: virtual void get_voxel_gradient(int i, int j, int k,
            DataArray *s, DataArray *g)
        Given structured coordinates (i,j,k) for a voxel cell, compute
        the eight gradient values for the voxel corners. The order in
        which the gradient vectors are arranged corresponds to the
        ordering of the voxel points. Gradient vector is computed by
        central differences (except on edges of volume where forward
        difference is used). The scalars s are the scalars from which the
        gradient is to be computed. This method will treat only 3D
        structured point datasets (i.e., volumes).
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.GetVoxelGradient, *my_args)
        return ret

    def allocate_scalars(self, *args):
        """
        allocate_scalars(self, dataType:int, numComponents:int) -> None
        C++: virtual void allocate_scalars(int dataType, int numComponents)
        allocate_scalars(self, pipeline_info:Information) -> None
        C++: virtual void allocate_scalars(Information *pipeline_info)
        Allocate the point scalars for this dataset. The data type
        determines the type of the array (VTK_FLOAT, VTK_INT etc.) where
        as numComponents determines its number of components.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AllocateScalars, *my_args)
        return ret

    def compute_cell_id(self, *args):
        """
        compute_cell_id(self, ijk:[int, int, int]) -> int
        C++: virtual IdType compute_cell_id(int ijk[3])
        Given a location in structured coordinates (i-j-k), return the
        cell id.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeCellId, *args)
        return ret

    def compute_index_to_physical_matrix(self, *args):
        """
        compute_index_to_physical_matrix(origin:(float, float, float),
            spacing:(float, float, float), direction:(float, float, float,
             float, float, float, float, float, float), result:[float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float]) -> None
        C++: static void compute_index_to_physical_matrix(
            double const origin[3], double const spacing[3],
            double const direction[9], double result[16])"""
        ret = self._wrap_call(self._vtk_obj.ComputeIndexToPhysicalMatrix, *args)
        return ret

    def compute_internal_extent(self, *args):
        """
        compute_internal_extent(self, intExt:[int, ...], tgtExt:[int, ...],
            bnds:[int, ...]) -> None
        C++: void compute_internal_extent(int *intExt, int *tgtExt,
            int *bnds)
        Given how many pixel are required on a side for bounrary
        conditions (in bnds), the target extent to traverse, compute the
        internal extent (the extent for this image_data that does not
        suffer from any boundary conditions) and place it in intExt
        """
        ret = self._wrap_call(self._vtk_obj.ComputeInternalExtent, *args)
        return ret

    def compute_point_id(self, *args):
        """
        compute_point_id(self, ijk:[int, int, int]) -> int
        C++: virtual IdType compute_point_id(int ijk[3])
        Given a location in structured coordinates (i-j-k), return the
        point id.
        """
        ret = self._wrap_call(self._vtk_obj.ComputePointId, *args)
        return ret

    def compute_structured_coordinates(self, *args):
        """
        compute_structured_coordinates(self, x:(float, float, float),
            ijk:[int, int, int], pcoords:[float, float, float]) -> int
        C++: virtual int compute_structured_coordinates(const double x[3],
            int ijk[3], double pcoords[3])
        Convenience function computes the structured coordinates for a
        point x[3]. The voxel is specified by the array ijk[3], and the
        parametric coordinates in the cell are specified with pcoords[3].
        The function returns a 0 if the point x is outside of the volume,
        and a 1 if inside the volume.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeStructuredCoordinates, *args)
        return ret

    def copy_and_cast_from(self, *args):
        """
        copy_and_cast_from(self, inData:ImageData, extent:[int, int, int,
            int, int, int]) -> None
        C++: virtual void copy_and_cast_from(ImageData *inData,
            int extent[6])
        copy_and_cast_from(self, inData:ImageData, x0:int, x1:int, y0:int,
             y1:int, z0:int, z1:int) -> None
        C++: virtual void copy_and_cast_from(ImageData *inData, int x0,
            int x1, int y0, int y1, int z0, int z1)
        This method is passed a input and output region, and executes the
        filter algorithm to fill the output from the input. It just
        executes a switch statement to call the correct function for the
        regions data types.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyAndCastFrom, *my_args)
        return ret

    def extended_new(self):
        """
        extended_new() -> ImageData
        C++: static ImageData *extended_new()"""
        ret = wrap_vtk(self._vtk_obj.ExtendedNew())
        return ret
        

    def has_number_of_scalar_components(self, *args):
        """
        has_number_of_scalar_components(meta_data:Information) -> bool
        C++: static bool has_number_of_scalar_components(
            Information *meta_data)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasNumberOfScalarComponents, *my_args)
        return ret

    def has_scalar_type(self, *args):
        """
        has_scalar_type(meta_data:Information) -> bool
        C++: static bool has_scalar_type(Information *meta_data)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasScalarType, *my_args)
        return ret

    def is_cell_visible(self, *args):
        """
        is_cell_visible(self, cellId:int) -> int
        C++: unsigned char is_cell_visible(IdType cellId)
        Return non-zero value if specified point is visible. These
        methods should be called only after the dimensions of the grid
        are set.
        """
        ret = self._wrap_call(self._vtk_obj.IsCellVisible, *args)
        return ret

    def is_point_visible(self, *args):
        """
        is_point_visible(self, ptId:int) -> int
        C++: unsigned char is_point_visible(IdType ptId)
        Return non-zero value if specified point is visible. These
        methods should be called only after the dimensions of the grid
        are set.
        """
        ret = self._wrap_call(self._vtk_obj.IsPointVisible, *args)
        return ret

    def set_scalar_component_from_double(self, *args):
        """
        set_scalar_component_from_double(self, x:int, y:int, z:int,
            component:int, v:float) -> None
        C++: virtual void set_scalar_component_from_double(int x, int y,
            int z, int component, double v)"""
        ret = self._wrap_call(self._vtk_obj.SetScalarComponentFromDouble, *args)
        return ret

    def set_scalar_component_from_float(self, *args):
        """
        set_scalar_component_from_float(self, x:int, y:int, z:int,
            component:int, v:float) -> None
        C++: virtual void set_scalar_component_from_float(int x, int y, int z,
             int component, float v)"""
        ret = self._wrap_call(self._vtk_obj.SetScalarComponentFromFloat, *args)
        return ret

    def transform_continuous_index_to_physical_point(self, *args):
        """
        transform_continuous_index_to_physical_point(self, i:float, j:float,
            k:float, xyz:[float, float, float]) -> None
        C++: virtual void transform_continuous_index_to_physical_point(
            double i, double j, double k, double xyz[3])
        transform_continuous_index_to_physical_point(self, ijk:(float, float,
            float), xyz:[float, float, float]) -> None
        C++: virtual void transform_continuous_index_to_physical_point(
            const double ijk[3], double xyz[3])
        transform_continuous_index_to_physical_point(i:float, j:float, k:float,
             origin:(float, float, float), spacing:(float, float, float),
            direction:(float, float, float, float, float, float, float,
            float, float), xyz:[float, float, float]) -> None
        C++: static void transform_continuous_index_to_physical_point(double i,
             double j, double k, double const origin[3],
            double const spacing[3], double const direction[9],
            double xyz[3])
        Convert coordinates from index space (ijk) to physical space
        (xyz).
        """
        ret = self._wrap_call(self._vtk_obj.TransformContinuousIndexToPhysicalPoint, *args)
        return ret

    def transform_index_to_physical_point(self, *args):
        """
        transform_index_to_physical_point(self, i:int, j:int, k:int,
            xyz:[float, float, float]) -> None
        C++: virtual void transform_index_to_physical_point(int i, int j,
            int k, double xyz[3])
        transform_index_to_physical_point(self, ijk:(int, int, int),
            xyz:[float, float, float]) -> None
        C++: virtual void transform_index_to_physical_point(const int ijk[3],
            double xyz[3])"""
        ret = self._wrap_call(self._vtk_obj.TransformIndexToPhysicalPoint, *args)
        return ret

    def transform_physical_normal_to_continuous_index(self, *args):
        """
        transform_physical_normal_to_continuous_index(self, xyz:(float, float,
            float), ijk:[float, float, float]) -> None
        C++: virtual void transform_physical_normal_to_continuous_index(
            const double xyz[3], double ijk[3])
        Convert normal from physical space (xyz) to index space (ijk).
        """
        ret = self._wrap_call(self._vtk_obj.TransformPhysicalNormalToContinuousIndex, *args)
        return ret

    def transform_physical_plane_to_continuous_index(self, *args):
        """
        transform_physical_plane_to_continuous_index(self, pplane:(float,
            float, float, float), iplane:[float, float, float, float])
            -> None
        C++: virtual void transform_physical_plane_to_continuous_index(
            double const pplane[4], double iplane[4])
        Convert a plane from physical to a continuous index. The plane is
        represented as n(x-xo)=0; or using a four component normal:
        pplane=( nx,ny,nz,-(n(x0)) ).
        """
        ret = self._wrap_call(self._vtk_obj.TransformPhysicalPlaneToContinuousIndex, *args)
        return ret

    def transform_physical_point_to_continuous_index(self, *args):
        """
        transform_physical_point_to_continuous_index(self, x:float, y:float,
            z:float, ijk:[float, float, float]) -> None
        C++: virtual void transform_physical_point_to_continuous_index(
            double x, double y, double z, double ijk[3])
        transform_physical_point_to_continuous_index(self, xyz:(float, float,
            float), ijk:[float, float, float]) -> None
        C++: virtual void transform_physical_point_to_continuous_index(
            const double xyz[3], double ijk[3])
        Convert coordinates from physical space (xyz) to index space
        (ijk).
        """
        ret = self._wrap_call(self._vtk_obj.TransformPhysicalPointToContinuousIndex, *args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('dimensions', 'GetDimensions'), ('extent', 'GetExtent'),
    ('number_of_scalar_components', 'GetNumberOfScalarComponents'),
    ('origin', 'GetOrigin'), ('spacing', 'GetSpacing'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'dimensions', 'extent', 'number_of_scalar_components', 'origin',
    'spacing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageData, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['dimensions', 'extent',
            'number_of_scalar_components', 'origin', 'spacing']),
            title='Edit ImageData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

