/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.CommentNode;
import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.ElementNode;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.ProcessingInstructionNode;
import com.jclark.xsl.dom.TextNode;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;

class SiblingNodeIterator
implements SafeNodeIterator {
    ContainerNode parent;
    int childIndex;
    NodeBase node;
    org.w3c.dom.Node domNode;
    int preserveSpace = -1;

    SiblingNodeIterator(ContainerNode parent, int childIndex, org.w3c.dom.Node domNode) {
        this.parent = parent;
        this.childIndex = childIndex;
        this.domNode = domNode;
    }

    private static final boolean hasNonWhitespaceChar(String str) {
        int len = str.length();
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    final void advance() {
        while (true) {
            org.w3c.dom.Node tem;
            if ((tem = this.domNode.getNextSibling()) != null) {
                this.domNode = tem;
                break;
            }
            tem = this.domNode.getParentNode();
            if (tem.equals(this.parent.domNode)) {
                this.domNode = null;
                break;
            }
            this.domNode = tem;
        }
    }

    static int computeChildIndex(ContainerNode parent, org.w3c.dom.Node domNode) {
        int preserveSpace = -1;
        boolean ignoreText = false;
        int childIndex = 0;
        block7: while (true) {
            org.w3c.dom.Node tem;
            switch (domNode.getNodeType()) {
                case 1: {
                    ++childIndex;
                    ignoreText = false;
                    break;
                }
                case 8: {
                    if (!parent.root.includeComments) break;
                    ignoreText = false;
                    ++childIndex;
                    break;
                }
                case 7: {
                    if (!parent.root.includeProcessingInstructions) break;
                    ignoreText = false;
                    ++childIndex;
                    break;
                }
                case 3: 
                case 4: {
                    if (ignoreText) break;
                    if (preserveSpace == -1) {
                        int n = preserveSpace = parent.getPreserveSpace() ? 1 : 0;
                    }
                    if (preserveSpace != 1 && !SiblingNodeIterator.hasNonWhitespaceChar(domNode.getNodeValue())) break;
                    ignoreText = true;
                    ++childIndex;
                    break;
                }
                case 5: {
                    tem = domNode.getLastChild();
                    if (tem == null) break;
                    domNode = tem;
                    continue block7;
                }
                default: {
                    ignoreText = false;
                }
            }
            do {
                if ((tem = domNode.getPreviousSibling()) == null) continue;
                domNode = tem;
                continue block7;
            } while (!(domNode = domNode.getParentNode()).equals(parent.domNode));
            break;
        }
        return childIndex;
    }

    public Node next() {
        ++this.childIndex;
        block13: while (this.domNode != null) {
            switch (this.domNode.getNodeType()) {
                case 1: {
                    ElementNode tem = new ElementNode(this.domNode, this.parent, this.childIndex);
                    this.advance();
                    return tem;
                }
                case 8: {
                    if (this.parent.root.includeComments) {
                        CommentNode tem = new CommentNode(this.domNode, this.parent, this.childIndex);
                        this.advance();
                        return tem;
                    }
                    this.advance();
                    continue block13;
                }
                case 7: {
                    if (this.parent.root.includeProcessingInstructions) {
                        ProcessingInstructionNode tem = new ProcessingInstructionNode(this.domNode, this.parent, this.childIndex);
                        this.advance();
                        return tem;
                    }
                    this.advance();
                    continue block13;
                }
                case 3: 
                case 4: {
                    if (this.preserveSpace == -1) {
                        this.preserveSpace = this.parent.getPreserveSpace() ? 1 : 0;
                    }
                    boolean keepThisNode = this.preserveSpace == 1;
                    TextNode textNode = new TextNode(this.domNode, this.parent, this.childIndex);
                    if (!keepThisNode && SiblingNodeIterator.hasNonWhitespaceChar(this.domNode.getNodeValue())) {
                        keepThisNode = true;
                    }
                    this.advance();
                    block14: while (this.domNode != null) {
                        switch (this.domNode.getNodeType()) {
                            case 3: 
                            case 4: {
                                String value = this.domNode.getNodeValue();
                                if (!keepThisNode && SiblingNodeIterator.hasNonWhitespaceChar(value)) {
                                    keepThisNode = true;
                                }
                                textNode.merge(value);
                                this.advance();
                                continue block14;
                            }
                            case 5: {
                                org.w3c.dom.Node tem = this.domNode.getFirstChild();
                                if (tem == null) {
                                    this.advance();
                                    continue block14;
                                }
                                this.domNode = tem;
                                continue block14;
                            }
                            case 7: {
                                if (this.parent.root.includeProcessingInstructions) break block14;
                                this.advance();
                                continue block14;
                            }
                            case 8: {
                                if (this.parent.root.includeComments) break block14;
                                this.advance();
                                continue block14;
                            }
                        }
                    }
                    if (!keepThisNode) continue block13;
                    return textNode;
                }
                case 5: {
                    org.w3c.dom.Node tem = this.domNode.getFirstChild();
                    if (tem == null) {
                        this.advance();
                        continue block13;
                    }
                    this.domNode = tem;
                    continue block13;
                }
            }
            this.advance();
        }
        return null;
    }
}

