;; VR4100 and VR4120 pipeline description.
;;   Copyright (C) 2004-2024 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.

(define_insn_reservation "r4100_load" 2
  (and (eq_attr "cpu" "r4100,r4120")
       (eq_attr "type" "load,fpload,fpidxload,mfc,mtc"))
  "alu")

(define_insn_reservation "r4100_imul_si" 1
  (and (eq_attr "cpu" "r4100,r4120")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "SI")))
  "imuldiv")

(define_insn_reservation "r4100_imul_di" 4
  (and (eq_attr "cpu" "r4100,r4120")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "DI")))
  "imuldiv*4")

(define_insn_reservation "r4100_idiv_si" 35
  (and (eq_attr "cpu" "r4100,r4120")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "imuldiv*35")

(define_insn_reservation "r4100_idiv_di" 67
  (and (eq_attr "cpu" "r4100,r4120")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "imuldiv*67")
