/*
 * @(#)TestLogger.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import net.sourceforge.groboutils.codecoverage.v2.compiler.ParseCoverageLogger;


/**
 * Replacement logger.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     January 27, 2003
 */
public class TestLogger
{
    public static class MarkData
    {
        public String classSig;
        public short measureIndex;
        public short methodIndex;
        public short markIndex;
        
        public MarkData( String sig, short meaI, short metI, short marI )
        {
            this.classSig = sig;
            this.measureIndex = meaI;
            this.methodIndex = metI;
            this.markIndex = marI;
        }
        
        public String toString()
        {
            return "[Class Sig="+this.classSig+";measure="+
                this.measureIndex+";method="+this.methodIndex+
                ";mark="+this.markIndex+"]";
        }
    }
    
    private static HashMap marksPerThread = new HashMap();
    
    public static ParseCoverageLogger createPCL()
    {
        return new ParseCoverageLogger( TestLogger.class, "cover" );
    }
        
        
    public static void cover( String classSig,
            short methodIndex, short channel, short markIndex )
    {
        //DOC.getLog().info( "Inside cover" );
        List list = getThreadList();
        MarkData md = new MarkData( classSig, channel, methodIndex,
            markIndex );
        synchronized( list )
        {
            //DOC.getLog().info( "adding mark: "+md );
            list.add( md );
        }
    }
        
        
    public static void reset()
    {
        List list = getThreadList();
        synchronized( list )
        {
            list.clear();
        }
    }
    
    
    public static int size()
    {
        return getThreadList().size();
    }
    
    
    public static Iterator getMarkData()
    {
        return getThreadList().iterator();
    }
    
    
    private static List getThreadList()
    {
        List list;
        synchronized( TestLogger.class )
        {
            list = (List)marksPerThread.get( Thread.currentThread() );
            if (list == null)
            {
                list = new ArrayList();
                marksPerThread.put( Thread.currentThread(), list );
            }
        }
        return list;
    }
}

