/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by the gen-test-libm.sh script.
 * Do not edit! */

check_double ("acos (0.0)", acos (0.0), 1.57079632679489655800E+00);
check_double ("acos (-0.0)", acos (-0.0), 1.57079632679489655800E+00);
check_double ("acos (1.0)", acos (1.0), 0.00000000000000000000E+00);
check_double ("acos (-1.0)", acos (-1.0), 3.14159265358979311600E+00);
check_double ("acos (0.5)", acos (0.5), 1.04719755119659785336E+00);
check_double ("acos (-0.5)", acos (-0.5), 2.09439510239319570672E+00);
check_double ("acos (INFINITY)", acos (INFINITY), NAN);
check_double ("acos (-INFINITY)", acos (-INFINITY), NAN);
check_double ("acos (NAN)", acos (NAN), NAN);
check_double ("acos (6.9e-18)", acos (6.9e-18), 1.57079632679489655800E+00);
check_double ("acos (-6.9e-18)", acos (-6.9e-18), 1.57079632679489655800E+00);
check_double ("acos (7.0e-18)", acos (7.0e-18), 1.57079632679489655800E+00);
check_double ("acos (-7.0e-18)", acos (-7.0e-18), 1.57079632679489655800E+00);
check_double ("acos (7.4e-9)", acos (7.4e-9), 1.57079631939489661185E+00);
check_double ("acos (-7.4e-9)", acos (-7.4e-9), 1.57079633419489672619E+00);
check_double ("acos (7.5e-9)", acos (7.5e-9), 1.57079631929489660358E+00);
check_double ("acos (-7.5e-9)", acos (-7.5e-9), 1.57079633429489651242E+00);
check_double ("acos (0.1)", acos (0.1), 1.47062890563333681371E+00);
check_double ("acos (-0.1)", acos (-0.1), 1.67096374795645652434E+00);
check_double ("acos (0.4)", acos (0.4), 1.15927948072740849561E+00);
check_double ("acos (-0.4)", acos (-0.4), 1.98231317286238462039E+00);
check_double ("acos (0.6)", acos (0.6), 9.27295218001612298053E-01);
check_double ("acos (-0.6)", acos (-0.6), 2.21429743558818081794E+00);
check_double ("acos (0.99)", acos (0.99), 1.41539473324427289569E-01);
check_double ("acos (-0.99)", acos (-0.99), 3.00005318026536604847E+00);
check_double ("acos (1.1)", acos (1.1), NAN);
check_double ("acos (-1.1)", acos (-1.1), NAN);
check_double ("acos (0.7)", acos (0.7), 7.95398830184143590394E-01);
check_double ("asin (0.0)", asin (0.0), 0.00000000000000000000E+00);
check_double ("asin (-0.0)", asin (-0.0), -0.00000000000000000000E+00);
check_double ("asin (1.0)", asin (1.0), 1.57079632679489655800E+00);
check_double ("asin (-1.0)", asin (-1.0), -1.57079632679489655800E+00);
check_double ("asin (0.5)", asin (0.5), 5.23598775598298926681E-01);
check_double ("asin (-0.5)", asin (-0.5), -5.23598775598298926681E-01);
check_double ("asin (0.98)", asin (0.98), 1.37046148447177684737E+00);
check_double ("asin (-0.98)", asin (-0.98), -1.37046148447177684737E+00);
check_double ("asin (INFINITY)", asin (INFINITY), NAN);
check_double ("asin (-INFINITY)", asin (-INFINITY), NAN);
check_double ("asin (NAN)", asin (NAN), NAN);
check_double ("asin (6.9e-18)", asin (6.9e-18), 6.90000000000000026253E-18);
check_double ("asin (-6.9e-18)", asin (-6.9e-18), -6.90000000000000026253E-18);
check_double ("asin (7.0e-18)", asin (7.0e-18), 6.99999999999999973042E-18);
check_double ("asin (-7.0e-18)", asin (-7.0e-18), -6.99999999999999973042E-18);
check_double ("asin (7.4e-9)", asin (7.4e-9), 7.40000000000000008865E-09);
check_double ("asin (-7.4e-9)", asin (-7.4e-9), -7.40000000000000008865E-09);
check_double ("asin (7.5e-9)", asin (7.5e-9), 7.49999999999999932974E-09);
check_double ("asin (-7.5e-9)", asin (-7.5e-9), -7.49999999999999932974E-09);
check_double ("asin (0.1)", asin (0.1), 1.00167421161559799803E-01);
check_double ("asin (-0.1)", asin (-0.1), -1.00167421161559799803E-01);
check_double ("asin (0.4)", asin (0.4), 4.11516846067488062388E-01);
check_double ("asin (-0.4)", asin (-0.4), -4.11516846067488062388E-01);
check_double ("asin (0.6)", asin (0.6), 6.43501108793284370968E-01);
check_double ("asin (-0.6)", asin (-0.6), -6.43501108793284370968E-01);
check_double ("asin (0.97)", asin (0.97), 1.32523080927960457132E+00);
check_double ("asin (-0.97)", asin (-0.97), -1.32523080927960457132E+00);
check_double ("asin (0.99)", asin (0.99), 1.42925685347046926843E+00);
check_double ("asin (-0.99)", asin (-0.99), -1.42925685347046926843E+00);
check_double ("asin (1.1)", asin (1.1), NAN);
check_double ("asin (-1.1)", asin (-1.1), NAN);
check_double ("asin (0.7)", asin (0.7), 7.75397496610752967605E-01);
check_double ("atan (0.0)", atan (0.0), 0.00000000000000000000E+00);
check_double ("atan (-0.0)", atan (-0.0), -0.00000000000000000000E+00);
check_double ("atan (7.0 / 16.0)", atan (7.0 / 16.0), 4.12410441597387322776E-01);
check_double ("atan (-7.0 / 16.0)", atan (-7.0 / 16.0), -4.12410441597387322776E-01);
check_double ("atan (11.0 / 16.0)", atan (11.0 / 16.0), 6.02287346134964152178E-01);
check_double ("atan (-11.0 / 16.0)", atan (-11.0 / 16.0), -6.02287346134964152178E-01);
check_double ("atan (19.0 / 16.0)", atan (19.0 / 16.0), 8.70903457075652975838E-01);
check_double ("atan (-19.0 / 16.0)", atan (-19.0 / 16.0), -8.70903457075652975838E-01);
check_double ("atan (39.0 / 16.0)", atan (39.0 / 16.0), 1.18147960496175574718E+00);
check_double ("atan (-39.0 / 16.0)", atan (-39.0 / 16.0), -1.18147960496175574718E+00);
check_double ("atan (1.0)", atan (1.0), 7.85398163397448278999E-01);
check_double ("atan (-1.0)", atan (-1.0), -7.85398163397448278999E-01);
check_double ("atan (INFINITY)", atan (INFINITY), 1.57079632679489655800E+00);
check_double ("atan (-INFINITY)", atan (-INFINITY), -1.57079632679489655800E+00);
check_double ("atan (NAN)", atan (NAN), NAN);
check_double ("atan (6.9 / 16.0)", atan (6.9 / 16.0), 4.07152520941509277197E-01);
check_double ("atan (-6.9 / 16.0)", atan (-6.9 / 16.0), -4.07152520941509277197E-01);
check_double ("atan (7.1 / 16.0)", atan (7.1 / 16.0), 4.17644283240569735849E-01);
check_double ("atan (-7.1 / 16.0)", atan (-7.1 / 16.0), -4.17644283240569735849E-01);
check_double ("atan (10.9 / 16.0)", atan (10.9 / 16.0), 5.98030920656102416011E-01);
check_double ("atan (-10.9 / 16.0)", atan (-10.9 / 16.0), -5.98030920656102416011E-01);
check_double ("atan (11.1 / 16.0)", atan (11.1 / 16.0), 6.06519005615576589641E-01);
check_double ("atan (-11.1 / 16.0)", atan (-11.1 / 16.0), -6.06519005615576589641E-01);
check_double ("atan (18.9 / 16.0)", atan (18.9 / 16.0), 8.68302259886018612534E-01);
check_double ("atan (-18.9 / 16.0)", atan (-18.9 / 16.0), -8.68302259886018612534E-01);
check_double ("atan (19.1 / 16.0)", atan (19.1 / 16.0), 8.73488683179258762479E-01);
check_double ("atan (-19.1 / 16.0)", atan (-19.1 / 16.0), -8.73488683179258762479E-01);
check_double ("atan (38.9 / 16.0)", atan (38.9 / 16.0), 1.18057723083411603149E+00);
check_double ("atan (-38.9 / 16.0)", atan (-38.9 / 16.0), -1.18057723083411603149E+00);
check_double ("atan (39.1 / 16.0)", atan (39.1 / 16.0), 1.18237802686613768799E+00);
check_double ("atan (-39.1 / 16.0)", atan (-39.1 / 16.0), -1.18237802686613768799E+00);
check_double ("atan (0.99)", atan (0.99), 7.80373080066635860241E-01);
check_double ("atan (-0.99)", atan (-0.99), -7.80373080066635860241E-01);
check_double ("atan (1.1)", atan (1.1), 8.32981266674431730657E-01);
check_double ("atan (-1.1)", atan (-1.1), -8.32981266674431730657E-01);
check_double ("atan (7.37e+19)", atan (7.37e+19), 1.57079632679489655800E+00);
check_double ("atan (-7.37e+19)", atan (-7.37e+19), -1.57079632679489655800E+00);
check_double ("atan (7.38e+19)", atan (7.38e+19), 1.57079632679489655800E+00);
check_double ("atan (-7.38e+19)", atan (-7.38e+19), -1.57079632679489655800E+00);
check_double ("atan (0.7)", atan (0.7), 6.10725964389208564320E-01);
check_double ("atan2 (NAN, NAN)", atan2 (NAN, NAN), NAN);
check_double ("atan2 (0.0, NAN)", atan2 (0.0, NAN), NAN);
check_double ("atan2 (-0.0, NAN)", atan2 (-0.0, NAN), NAN);
check_double ("atan2 (1.0, NAN)", atan2 (1.0, NAN), NAN);
check_double ("atan2 (-1.0, NAN)", atan2 (-1.0, NAN), NAN);
check_double ("atan2 (INFINITY, NAN)", atan2 (INFINITY, NAN), NAN);
check_double ("atan2 (-INFINITY, NAN)", atan2 (-INFINITY, NAN), NAN);
check_double ("atan2 (NAN, 0.0)", atan2 (NAN, 0.0), NAN);
check_double ("atan2 (NAN, -0.0)", atan2 (NAN, -0.0), NAN);
check_double ("atan2 (NAN, 1.0)", atan2 (NAN, 1.0), NAN);
check_double ("atan2 (NAN, -1.0)", atan2 (NAN, -1.0), NAN);
check_double ("atan2 (NAN, INFINITY)", atan2 (NAN, INFINITY), NAN);
check_double ("atan2 (NAN, -INFINITY)", atan2 (NAN, -INFINITY), NAN);
check_double ("atan2 (0.0, 0.0)", atan2 (0.0, 0.0), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -0.0)", atan2 (0.0, -0.0), 3.14159265358979311600E+00);
check_double ("atan2 (-0.0, 0.0)", atan2 (-0.0, 0.0), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -0.0)", atan2 (-0.0, -0.0), -3.14159265358979311600E+00);
check_double ("atan2 (0.0, 1.0)", atan2 (0.0, 1.0), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -1.0)", atan2 (0.0, -1.0), 3.14159265358979311600E+00);
check_double ("atan2 (0.0, INFINITY)", atan2 (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -INFINITY)", atan2 (0.0, -INFINITY), 3.14159265358979311600E+00);
check_double ("atan2 (-0.0, 1.0)", atan2 (-0.0, 1.0), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -1.0)", atan2 (-0.0, -1.0), -3.14159265358979311600E+00);
check_double ("atan2 (-0.0, INFINITY)", atan2 (-0.0, INFINITY), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -INFINITY)", atan2 (-0.0, -INFINITY), -3.14159265358979311600E+00);
check_double ("atan2 (1.0, 0.0)", atan2 (1.0, 0.0), 1.57079632679489655800E+00);
check_double ("atan2 (1.0, -0.0)", atan2 (1.0, -0.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, 0.0)", atan2 (INFINITY, 0.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, -0.0)", atan2 (INFINITY, -0.0), 1.57079632679489655800E+00);
check_double ("atan2 (-1.0, 0.0)", atan2 (-1.0, 0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-1.0, -0.0)", atan2 (-1.0, -0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, 0.0)", atan2 (-INFINITY, 0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, -0.0)", atan2 (-INFINITY, -0.0), -1.57079632679489655800E+00);
check_double ("atan2 (1.0, INFINITY)", atan2 (1.0, INFINITY), 0.00000000000000000000E+00);
check_double ("atan2 (-1.0, INFINITY)", atan2 (-1.0, INFINITY), -0.00000000000000000000E+00);
check_double ("atan2 (1.0, -INFINITY)", atan2 (1.0, -INFINITY), 3.14159265358979311600E+00);
check_double ("atan2 (-1.0, -INFINITY)", atan2 (-1.0, -INFINITY), -3.14159265358979311600E+00);
check_double ("atan2 (INFINITY, INFINITY)", atan2 (INFINITY, INFINITY), 7.85398163397448278999E-01);
check_double ("atan2 (INFINITY, -INFINITY)", atan2 (INFINITY, -INFINITY), 2.35619449019234483700E+00);
check_double ("atan2 (-INFINITY, INFINITY)", atan2 (-INFINITY, INFINITY), -7.85398163397448278999E-01);
check_double ("atan2 (-INFINITY, -INFINITY)", atan2 (-INFINITY, -INFINITY), -2.35619449019234483700E+00);
check_double ("atan2 (INFINITY, 1.0)", atan2 (INFINITY, 1.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, -1.0)", atan2 (INFINITY, -1.0), 1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, 1.0)", atan2 (-INFINITY, 1.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, -1.0)", atan2 (-INFINITY, -1.0), -1.57079632679489655800E+00);
check_double ("atan2 (0.7, 1.0)", atan2 (0.7, 1.0), 6.10725964389208564320E-01);
check_double ("atan2 (-0.7, 1.0)", atan2 (-0.7, 1.0), -6.10725964389208564320E-01);
check_double ("atan2 (0.7, -1.0)", atan2 (0.7, -1.0), 2.53086668920058466270E+00);
check_double ("atan2 (-0.7, -1.0)", atan2 (-0.7, -1.0), -2.53086668920058466270E+00);
check_double ("atan2 (0.4, 0.0003)", atan2 (0.4, 0.0003), 1.57004632693552159672E+00);
check_double ("atan2 (1.4, -0.93)", atan2 (1.4, -0.93), 2.15714876682378431383E+00);
check_double ("acosh (0.0)", acosh (0.0), -NAN);
check_double ("acosh (-0.0)", acosh (-0.0), -NAN);
check_double ("acosh (1.0)", acosh (1.0), 0.00000000000000000000E+00);
check_double ("acosh (-1.0)", acosh (-1.0), -NAN);
check_double ("acosh (INFINITY)", acosh (INFINITY), INF);
check_double ("acosh (-INFINITY)", acosh (-INFINITY), -NAN);
check_double ("acosh (NAN)", acosh (NAN), NAN);
check_double ("acosh (7.08e+02)", acosh (7.08e+02), 7.25559077551410425144E+00);
check_double ("acosh (7.10e+02)", acosh (7.10e+02), 7.25841165466159132791E+00);
check_double ("acosh (-7.40e+02)", acosh (-7.40e+02), -NAN);
check_double ("acosh (-7.50e+02)", acosh (-7.50e+02), -NAN);
check_double ("acosh (0.34)", acosh (0.34), -NAN);
check_double ("acosh (-0.34)", acosh (-0.34), -NAN);
check_double ("acosh (0.35)", acosh (0.35), -NAN);
check_double ("acosh (-0.35)", acosh (-0.35), -NAN);
check_double ("acosh (1.03)", acosh (1.03), 2.44340698822827606662E-01);
check_double ("acosh (-1.03)", acosh (-1.03), -NAN);
check_double ("acosh (1.04)", acosh (1.04), 2.81908289054146887764E-01);
check_double ("acosh (-1.04)", acosh (-1.04), -NAN);
check_double ("acosh (3.72e-09)", acosh (3.72e-09), -NAN);
check_double ("acosh (-3.72e-09)", acosh (-3.72e-09), -NAN);
check_double ("acosh (3.73e-09)", acosh (3.73e-09), -NAN);
check_double ("acosh (-3.73e-09)", acosh (-3.73e-09), -NAN);
check_double ("acosh (2.0)", acosh (2.0), 1.31695789692481679545E+00);
check_double ("acosh (3.0)", acosh (3.0), 1.76274717403908609548E+00);
check_double ("acosh (0.7)", acosh (0.7), -NAN);
check_double ("acosh (38.0)", acosh (38.0), 4.33056016511402308566E+00);
check_double ("asinh (0.0)", asinh (0.0), 0.00000000000000000000E+00);
check_double ("asinh (-0.0)", asinh (-0.0), -0.00000000000000000000E+00);
check_double ("asinh (1.0)", asinh (1.0), 8.81373587019543047738E-01);
check_double ("asinh (-1.0)", asinh (-1.0), -8.81373587019543047738E-01);
check_double ("asinh (INFINITY)", asinh (INFINITY), INF);
check_double ("asinh (-INFINITY)", asinh (-INFINITY), -INF);
check_double ("asinh (NAN)", asinh (NAN), NAN);
check_double ("asinh (7.08e+02)", asinh (7.08e+02), 7.25559177299247970439E+00);
check_double ("asinh (7.10e+02)", asinh (7.10e+02), 7.25841264652828410675E+00);
check_double ("asinh (-7.40e+02)", asinh (-7.40e+02), -7.29979782329546722508E+00);
check_double ("asinh (-7.50e+02)", asinh (-7.50e+02), -7.31322083153444957304E+00);
check_double ("asinh (0.34)", asinh (0.34), 3.33768351645882199730E-01);
check_double ("asinh (-0.34)", asinh (-0.34), -3.33768351645882199730E-01);
check_double ("asinh (0.35)", asinh (0.35), 3.43221555085943930141E-01);
check_double ("asinh (-0.35)", asinh (-0.35), -3.43221555085943930141E-01);
check_double ("asinh (1.03)", asinh (1.03), 9.02428495530461671770E-01);
check_double ("asinh (-1.03)", asinh (-1.03), -9.02428495530461671770E-01);
check_double ("asinh (1.04)", asinh (1.04), 9.09376928017844976537E-01);
check_double ("asinh (-1.04)", asinh (-1.04), -9.09376928017844976537E-01);
check_double ("asinh (3.72e-09)", asinh (3.72e-09), 3.71999999999999997526E-09);
check_double ("asinh (-3.72e-09)", asinh (-3.72e-09), -3.71999999999999997526E-09);
check_double ("asinh (3.73e-09)", asinh (3.73e-09), 3.73000000000000014752E-09);
check_double ("asinh (-3.73e-09)", asinh (-3.73e-09), -3.73000000000000014752E-09);
check_double ("asinh (2.0)", asinh (2.0), 1.44363547517881030124E+00);
check_double ("asinh (3.0)", asinh (3.0), 1.81844645923206682525E+00);
check_double ("asinh (0.7)", asinh (0.7), 6.52666566082355736889E-01);
check_double ("asinh (38.0)", asinh (38.0), 4.33090642553643068169E+00);
check_double ("atanh (0.0)", atanh (0.0), 0.00000000000000000000E+00);
check_double ("atanh (-0.0)", atanh (-0.0), -0.00000000000000000000E+00);
check_double ("atanh (1.0)", atanh (1.0), INF);
check_double ("atanh (-1.0)", atanh (-1.0), -INF);
check_double ("atanh (INFINITY)", atanh (INFINITY), -NAN);
check_double ("atanh (-INFINITY)", atanh (-INFINITY), -NAN);
check_double ("atanh (NAN)", atanh (NAN), NAN);
check_double ("atanh (7.08e+02)", atanh (7.08e+02), -NAN);
check_double ("atanh (7.10e+02)", atanh (7.10e+02), -NAN);
check_double ("atanh (-7.40e+02)", atanh (-7.40e+02), -NAN);
check_double ("atanh (-7.50e+02)", atanh (-7.50e+02), -NAN);
check_double ("atanh (0.34)", atanh (0.34), 3.54092528962242913959E-01);
check_double ("atanh (-0.34)", atanh (-0.34), -3.54092528962242913959E-01);
check_double ("atanh (0.35)", atanh (0.35), 3.65443754271396137323E-01);
check_double ("atanh (-0.35)", atanh (-0.35), -3.65443754271396137323E-01);
check_double ("atanh (1.03)", atanh (1.03), -NAN);
check_double ("atanh (-1.03)", atanh (-1.03), -NAN);
check_double ("atanh (1.04)", atanh (1.04), -NAN);
check_double ("atanh (-1.04)", atanh (-1.04), -NAN);
check_double ("atanh (3.72e-09)", atanh (3.72e-09), 3.71999999999999997526E-09);
check_double ("atanh (-3.72e-09)", atanh (-3.72e-09), -3.71999999999999997526E-09);
check_double ("atanh (3.73e-09)", atanh (3.73e-09), 3.73000000000000014752E-09);
check_double ("atanh (-3.73e-09)", atanh (-3.73e-09), -3.73000000000000014752E-09);
check_double ("atanh (2.0)", atanh (2.0), -NAN);
check_double ("atanh (3.0)", atanh (3.0), -NAN);
check_double ("atanh (0.7)", atanh (0.7), 8.67300527694053080552E-01);
check_double ("atanh (38.0)", atanh (38.0), -NAN);
check_double ("ceil (0.0)", ceil (0.0), 0.00000000000000000000E+00);
check_double ("ceil (-0.0)", ceil (-0.0), -0.00000000000000000000E+00);
check_double ("ceil (INFINITY)", ceil (INFINITY), INF);
check_double ("ceil (-INFINITY)", ceil (-INFINITY), -INF);
check_double ("ceil (NAN)", ceil (NAN), NAN);
check_double ("ceil (3.14)", ceil (3.14), 4.00000000000000000000E+00);
check_double ("ceil (-3.14)", ceil (-3.14), -3.00000000000000000000E+00);
check_double ("ceil (3.72e-09)", ceil (3.72e-09), 1.00000000000000000000E+00);
check_double ("ceil (-3.72e-09)", ceil (-3.72e-09), -0.00000000000000000000E+00);
check_double ("ceil (7.37e+19)", ceil (7.37e+19), 7.37000000000000000000E+19);
check_double ("ceil (-7.37e+19)", ceil (-7.37e+19), -7.37000000000000000000E+19);
check_double ("exp (0.0)", exp (0.0), 1.00000000000000000000E+00);
check_double ("exp (-0.0)", exp (-0.0), 1.00000000000000000000E+00);
check_double ("exp (1.0)", exp (1.0), 2.71828182845904509080E+00);
check_double ("exp (-1.0)", exp (-1.0), 3.67879441171442334024E-01);
check_double ("exp (INFINITY)", exp (INFINITY), INF);
check_double ("exp (-INFINITY)", exp (-INFINITY), 0.00000000000000000000E+00);
check_double ("exp (NAN)", exp (NAN), NAN);
check_double ("exp (7.08e+02)", exp (7.08e+02), 3.02338314427605515848E+307);
check_double ("exp (7.10e+02)", exp (7.10e+02), INF);
check_double ("exp (-7.40e+02)", exp (-7.40e+02), 4.19955798965059562550E-322);
check_double ("exp (-7.50e+02)", exp (-7.50e+02), 0.00000000000000000000E+00);
check_double ("exp (0.34)", exp (0.34), 1.40494759056359375116E+00);
check_double ("exp (-0.34)", exp (-0.34), 7.11770322762609652933E-01);
check_double ("exp (0.35)", exp (0.35), 1.41906754859325712204E+00);
check_double ("exp (-0.35)", exp (-0.35), 7.04688089718713439602E-01);
check_double ("exp (1.03)", exp (1.03), 2.80106583469907910455E+00);
check_double ("exp (-1.03)", exp (-1.03), 3.57006960569147380191E-01);
check_double ("exp (1.04)", exp (1.04), 2.82921701435155981130E+00);
check_double ("exp (-1.04)", exp (-1.04), 3.53454681958780159157E-01);
check_double ("exp (3.72e-09)", exp (3.72e-09), 1.00000000372000008575E+00);
check_double ("exp (-3.72e-09)", exp (-3.72e-09), 9.99999996280000025273E-01);
check_double ("exp (3.73e-09)", exp (3.73e-09), 1.00000000373000008658E+00);
check_double ("exp (-3.73e-09)", exp (-3.73e-09), 9.99999996270000024445E-01);
check_double ("exp (2.0)", exp (2.0), 7.38905609893065040694E+00);
check_double ("exp (3.0)", exp (3.0), 2.00855369231876679237E+01);
check_double ("exp (0.7)", exp (0.7), 2.01375270747047663278E+00);
check_double ("exp (38.0)", exp (38.0), 3.18559317571137560000E+16);
check_double ("expm1 (0.0)", expm1 (0.0), 0.00000000000000000000E+00);
check_double ("expm1 (-0.0)", expm1 (-0.0), -0.00000000000000000000E+00);
check_double ("expm1 (1.0)", expm1 (1.0), 1.71828182845904531284E+00);
check_double ("expm1 (-1.0)", expm1 (-1.0), -6.32120558828557665976E-01);
check_double ("expm1 (INFINITY)", expm1 (INFINITY), INF);
check_double ("expm1 (-INFINITY)", expm1 (-INFINITY), -1.00000000000000000000E+00);
check_double ("expm1 (NAN)", expm1 (NAN), NAN);
check_double ("expm1 (7.08e+02)", expm1 (7.08e+02), 3.02338314427605515848E+307);
check_double ("expm1 (7.10e+02)", expm1 (7.10e+02), INF);
check_double ("expm1 (-7.40e+02)", expm1 (-7.40e+02), -1.00000000000000000000E+00);
check_double ("expm1 (-7.50e+02)", expm1 (-7.50e+02), -1.00000000000000000000E+00);
check_double ("expm1 (0.34)", expm1 (0.34), 4.04947590563593806667E-01);
check_double ("expm1 (-0.34)", expm1 (-0.34), -2.88229677237390291555E-01);
check_double ("expm1 (0.35)", expm1 (0.35), 4.19067548593257233058E-01);
check_double ("expm1 (-0.35)", expm1 (-0.35), -2.95311910281286560398E-01);
check_double ("expm1 (1.03)", expm1 (1.03), 1.80106583469907910455E+00);
check_double ("expm1 (-1.03)", expm1 (-1.03), -6.42993039430852619809E-01);
check_double ("expm1 (1.04)", expm1 (1.04), 1.82921701435155958926E+00);
check_double ("expm1 (-1.04)", expm1 (-1.04), -6.46545318041219840843E-01);
check_double ("expm1 (3.72e-09)", expm1 (3.72e-09), 3.72000000691919994955E-09);
check_double ("expm1 (-3.72e-09)", expm1 (-3.72e-09), -3.71999999308080000097E-09);
check_double ("expm1 (3.73e-09)", expm1 (3.73e-09), 3.73000000695645013275E-09);
check_double ("expm1 (-3.73e-09)", expm1 (-3.73e-09), -3.72999999304355016230E-09);
check_double ("expm1 (2.0)", expm1 (2.0), 6.38905609893065040694E+00);
check_double ("expm1 (3.0)", expm1 (3.0), 1.90855369231876679237E+01);
check_double ("expm1 (0.7)", expm1 (0.7), 1.01375270747047641073E+00);
check_double ("expm1 (38.0)", expm1 (38.0), 3.18559317571137560000E+16);
check_double ("fabs (0.0)", fabs (0.0), 0.00000000000000000000E+00);
check_double ("fabs (-0.0)", fabs (-0.0), 0.00000000000000000000E+00);
check_double ("fabs (1.0)", fabs (1.0), 1.00000000000000000000E+00);
check_double ("fabs (-1.0)", fabs (-1.0), 1.00000000000000000000E+00);
check_double ("fabs (INFINITY)", fabs (INFINITY), INF);
check_double ("fabs (-INFINITY)", fabs (-INFINITY), INF);
check_double ("fabs (NAN)", fabs (NAN), NAN);
check_double ("fabs (3.14)", fabs (3.14), 3.14000000000000012434E+00);
check_double ("fabs (-3.14)", fabs (-3.14), 3.14000000000000012434E+00);
check_double ("fabs (0.7)", fabs (0.7), 6.99999999999999955591E-01);
check_double ("fabs (-0.7)", fabs (-0.7), 6.99999999999999955591E-01);
check_double ("fabs (3.72e-09)", fabs (3.72e-09), 3.71999999999999997526E-09);
check_double ("fabs (-3.72e-09)", fabs (-3.72e-09), 3.71999999999999997526E-09);
check_double ("fabs (7.37e+19)", fabs (7.37e+19), 7.37000000000000000000E+19);
check_double ("fabs (-7.37e+19)", fabs (-7.37e+19), 7.37000000000000000000E+19);
check_double ("floor (0.0)", floor (0.0), 0.00000000000000000000E+00);
check_double ("floor (-0.0)", floor (-0.0), -0.00000000000000000000E+00);
check_double ("floor (INFINITY)", floor (INFINITY), INF);
check_double ("floor (-INFINITY)", floor (-INFINITY), -INF);
check_double ("floor (NAN)", floor (NAN), NAN);
check_double ("floor (3.14)", floor (3.14), 3.00000000000000000000E+00);
check_double ("floor (-3.14)", floor (-3.14), -4.00000000000000000000E+00);
check_double ("floor (3.72e-09)", floor (3.72e-09), 0.00000000000000000000E+00);
check_double ("floor (-3.72e-09)", floor (-3.72e-09), -1.00000000000000000000E+00);
check_double ("floor (7.37e+19)", floor (7.37e+19), 7.37000000000000000000E+19);
check_double ("floor (-7.37e+19)", floor (-7.37e+19), -7.37000000000000000000E+19);
check_double ("fmod (0.0, 0.0)", fmod (0.0, 0.0), -NAN);
check_double ("fmod (0.0, -0.0)", fmod (0.0, -0.0), -NAN);
check_double ("fmod (-0.0, 0.0)", fmod (-0.0, 0.0), -NAN);
check_double ("fmod (-0.0, -0.0)", fmod (-0.0, -0.0), -NAN);
check_double ("fmod (0.0, 3.0)", fmod (0.0, 3.0), 0.00000000000000000000E+00);
check_double ("fmod (0.0, -3.0)", fmod (0.0, -3.0), 0.00000000000000000000E+00);
check_double ("fmod (-0.0, 3.0)", fmod (-0.0, 3.0), -0.00000000000000000000E+00);
check_double ("fmod (-0.0, -3.0)", fmod (-0.0, -3.0), -0.00000000000000000000E+00);
check_double ("fmod (0.0, INFINITY)", fmod (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("fmod (0.0, -INFINITY)", fmod (0.0, -INFINITY), 0.00000000000000000000E+00);
check_double ("fmod (-0.0, INFINITY)", fmod (-0.0, INFINITY), -0.00000000000000000000E+00);
check_double ("fmod (-0.0, -INFINITY)", fmod (-0.0, -INFINITY), -0.00000000000000000000E+00);
check_double ("fmod (0.0, NAN)", fmod (0.0, NAN), NAN);
check_double ("fmod (-0.0, NAN)", fmod (-0.0, NAN), NAN);
check_double ("fmod (3.0, 0.0)", fmod (3.0, 0.0), -NAN);
check_double ("fmod (3.0, -0.0)", fmod (3.0, -0.0), -NAN);
check_double ("fmod (-3.0, 0.0)", fmod (-3.0, 0.0), -NAN);
check_double ("fmod (-3.0, -0.0)", fmod (-3.0, -0.0), -NAN);
check_double ("fmod (3.0, 3.0)", fmod (3.0, 3.0), 0.00000000000000000000E+00);
check_double ("fmod (3.0, -3.0)", fmod (3.0, -3.0), 0.00000000000000000000E+00);
check_double ("fmod (-3.0, 3.0)", fmod (-3.0, 3.0), -0.00000000000000000000E+00);
check_double ("fmod (-3.0, -3.0)", fmod (-3.0, -3.0), -0.00000000000000000000E+00);
check_double ("fmod (3.0, INFINITY)", fmod (3.0, INFINITY), 3.00000000000000000000E+00);
check_double ("fmod (3.0, -INFINITY)", fmod (3.0, -INFINITY), 3.00000000000000000000E+00);
check_double ("fmod (-3.0, INFINITY)", fmod (-3.0, INFINITY), -3.00000000000000000000E+00);
check_double ("fmod (-3.0, -INFINITY)", fmod (-3.0, -INFINITY), -3.00000000000000000000E+00);
check_double ("fmod (3.0, NAN)", fmod (3.0, NAN), NAN);
check_double ("fmod (-3.0, NAN)", fmod (-3.0, NAN), NAN);
check_double ("fmod (INFINITY, 0.0)", fmod (INFINITY, 0.0), -NAN);
check_double ("fmod (INFINITY, -0.0)", fmod (INFINITY, -0.0), -NAN);
check_double ("fmod (-INFINITY, 0.0)", fmod (-INFINITY, 0.0), -NAN);
check_double ("fmod (-INFINITY, -0.0)", fmod (-INFINITY, -0.0), -NAN);
check_double ("fmod (INFINITY, 3.0)", fmod (INFINITY, 3.0), -NAN);
check_double ("fmod (INFINITY, -3.0)", fmod (INFINITY, -3.0), -NAN);
check_double ("fmod (-INFINITY, 3.0)", fmod (-INFINITY, 3.0), -NAN);
check_double ("fmod (-INFINITY, -3.0)", fmod (-INFINITY, -3.0), -NAN);
check_double ("fmod (INFINITY, INFINITY)", fmod (INFINITY, INFINITY), -NAN);
check_double ("fmod (INFINITY, -INFINITY)", fmod (INFINITY, -INFINITY), -NAN);
check_double ("fmod (-INFINITY, INFINITY)", fmod (-INFINITY, INFINITY), -NAN);
check_double ("fmod (-INFINITY, -INFINITY)", fmod (-INFINITY, -INFINITY), -NAN);
check_double ("fmod (INFINITY, NAN)", fmod (INFINITY, NAN), NAN);
check_double ("fmod (-INFINITY, NAN)", fmod (-INFINITY, NAN), NAN);
check_double ("fmod (NAN, 0.0)", fmod (NAN, 0.0), NAN);
check_double ("fmod (NAN, -0.0)", fmod (NAN, -0.0), NAN);
check_double ("fmod (NAN, 3.0)", fmod (NAN, 3.0), NAN);
check_double ("fmod (NAN, -3.0)", fmod (NAN, -3.0), NAN);
check_double ("fmod (NAN, INFINITY)", fmod (NAN, INFINITY), NAN);
check_double ("fmod (NAN, -INFINITY)", fmod (NAN, -INFINITY), NAN);
check_double ("fmod (NAN, NAN)", fmod (NAN, NAN), NAN);
check_double ("fmod (3.0, 1.0)", fmod (3.0, 1.0), 0.00000000000000000000E+00);
check_double ("fmod (3.0, -1.0)", fmod (3.0, -1.0), 0.00000000000000000000E+00);
check_double ("fmod (-3.0, 1.0)", fmod (-3.0, 1.0), -0.00000000000000000000E+00);
check_double ("fmod (-3.0, -1.0)", fmod (-3.0, -1.0), -0.00000000000000000000E+00);
check_double ("fmod (6.5, 2.3)", fmod (6.5, 2.3), 1.90000000000000035527E+00);
check_double ("fmod (6.5, -2.3)", fmod (6.5, -2.3), 1.90000000000000035527E+00);
check_double ("fmod (-6.5, 2.3)", fmod (-6.5, 2.3), -1.90000000000000035527E+00);
check_double ("fmod (-6.5, -2.3)", fmod (-6.5, -2.3), -1.90000000000000035527E+00);
check_int ("isnan (0.0)", isnan (0.0), 0);
check_int ("isnan (-0.0)", isnan (-0.0), 0);
check_int ("isnan (1.0)", isnan (1.0), 0);
check_int ("isnan (-1.0)", isnan (-1.0), 0);
check_int ("isnan (INFINITY)", isnan (INFINITY), 0);
check_int ("isnan (-INFINITY)", isnan (-INFINITY), 0);
check_int ("isnan (NAN)", isnan (NAN), 1);
check_int ("isnan (3.14)", isnan (3.14), 0);
check_int ("isnan (-3.14)", isnan (-3.14), 0);
check_int ("isnan (0.7)", isnan (0.7), 0);
check_int ("isnan (-0.7)", isnan (-0.7), 0);
check_int ("isnan (3.72e-09)", isnan (3.72e-09), 0);
check_int ("isnan (-3.72e-09)", isnan (-3.72e-09), 0);
check_int ("isnan (7.37e+19)", isnan (7.37e+19), 0);
check_int ("isnan (-7.37e+19)", isnan (-7.37e+19), 0);
check_double ("log (0.0)", log (0.0), -INF);
check_double ("log (-0.0)", log (-0.0), -INF);
check_double ("log (1.0)", log (1.0), 0.00000000000000000000E+00);
check_double ("log (-1.0)", log (-1.0), NAN);
check_double ("log (INFINITY)", log (INFINITY), INF);
check_double ("log (-INFINITY)", log (-INFINITY), NAN);
check_double ("log (NAN)", log (NAN), NAN);
check_double ("log (M_E)", log (M_E), 1.00000000000000000000E+00);
check_double ("log (1.0 / M_E)", log (1.0 / M_E), -1.00000000000000000000E+00);
check_double ("log (2)", log (2), 6.93147180559945286227E-01);
check_double ("log (10)", log (10), 2.30258509299404590109E+00);
check_double ("log (0.7)", log (0.7), -3.56674943938732447180E-01);
check_double ("log (2.22e-308)", log (2.22e-308), -7.08398701446281847893E+02);
check_double ("log (2.23e-308)", log (2.23e-308), -7.08394207056694085622E+02);
check_double ("log (0.17)", log (0.17), -1.77195684193187519284E+00);
check_double ("log (0.18)", log (0.18), -1.71479842809192661868E+00);
check_double ("log (1999.0)", log (1999.0), 7.60040233450039970364E+00);
check_double ("log (2000.0)", log (2000.0), 7.60090245954208221235E+00);
check_double ("log (2001.0)", log (2001.0), 7.60140233458373337783E+00);
check_double ("log1p (0.0)", log1p (0.0), 0.00000000000000000000E+00);
check_double ("log1p (-0.0)", log1p (-0.0), -0.00000000000000000000E+00);
check_double ("log1p (1.0)", log1p (1.0), 6.93147180559945286227E-01);
check_double ("log1p (-1.0)", log1p (-1.0), -INF);
check_double ("log1p (INFINITY)", log1p (INFINITY), INF);
check_double ("log1p (-INFINITY)", log1p (-INFINITY), -NAN);
check_double ("log1p (NAN)", log1p (NAN), NAN);
check_double ("log1p (M_E)", log1p (M_E), 1.31326168751822280889E+00);
check_double ("log1p (1.0 / M_E)", log1p (1.0 / M_E), 3.13261687518222864401E-01);
check_double ("log1p (2)", log1p (2), 1.09861228866810978211E+00);
check_double ("log1p (10)", log1p (10), 2.39789527279837066942E+00);
check_double ("log1p (0.7)", log1p (0.7), 5.30628251062170375185E-01);
check_double ("log1p (2.22e-308)", log1p (2.22e-308), 2.22000000000000013467E-308);
check_double ("log1p (2.23e-308)", log1p (2.23e-308), 2.23000000000000010412E-308);
check_double ("log1p (0.17)", log1p (0.17), 1.57003748809664750441E-01);
check_double ("log1p (0.18)", log1p (0.18), 1.65514438477573383457E-01);
check_double ("log1p (1999.0)", log1p (1999.0), 7.60090245954208221235E+00);
check_double ("log1p (2000.0)", log1p (2000.0), 7.60140233458373337783E+00);
check_double ("log1p (2001.0)", log1p (2001.0), 7.60190195987516581511E+00);
check_double ("log2 (0.0)", log2 (0.0), -INF);
check_double ("log2 (-0.0)", log2 (-0.0), -INF);
check_double ("log2 (1.0)", log2 (1.0), 0.00000000000000000000E+00);
check_double ("log2 (-1.0)", log2 (-1.0), NAN);
check_double ("log2 (INFINITY)", log2 (INFINITY), INF);
check_double ("log2 (-INFINITY)", log2 (-INFINITY), NAN);
check_double ("log2 (NAN)", log2 (NAN), NAN);
check_double ("log2 (M_E)", log2 (M_E), 1.44269504088896338700E+00);
check_double ("log2 (1.0 / M_E)", log2 (1.0 / M_E), -1.44269504088896338700E+00);
check_double ("log2 (2)", log2 (2), 1.00000000000000000000E+00);
check_double ("log2 (10)", log2 (10), 3.32192809488736218171E+00);
check_double ("log2 (0.7)", log2 (0.7), -5.14573172829758340718E-01);
check_double ("log2 (2.22e-308)", log2 (2.22e-308), -1.02200329354873224474E+03);
check_double ("log2 (2.23e-308)", log2 (2.23e-308), -1.02199680951516199912E+03);
check_double ("log2 (0.17)", log2 (0.17), -2.55639334852438526724E+00);
check_double ("log2 (0.18)", log2 (0.18), -2.47393118833241221211E+00);
check_double ("log2 (1999.0)", log2 (1999.0), 1.09650627567446274924E+01);
check_double ("log2 (2000.0)", log2 (2000.0), 1.09657842846620869892E+01);
check_double ("log2 (2001.0)", log2 (2001.0), 1.09665054519057409976E+01);
check_double ("log10 (0.0)", log10 (0.0), -INF);
check_double ("log10 (-0.0)", log10 (-0.0), -INF);
check_double ("log10 (1.0)", log10 (1.0), 0.00000000000000000000E+00);
check_double ("log10 (-1.0)", log10 (-1.0), NAN);
check_double ("log10 (INFINITY)", log10 (INFINITY), INF);
check_double ("log10 (-INFINITY)", log10 (-INFINITY), NAN);
check_double ("log10 (NAN)", log10 (NAN), NAN);
check_double ("log10 (M_E)", log10 (M_E), 4.34294481903251816668E-01);
check_double ("log10 (1.0 / M_E)", log10 (1.0 / M_E), -4.34294481903251816668E-01);
check_double ("log10 (2)", log10 (2), 3.01029995663981198017E-01);
check_double ("log10 (10)", log10 (10), 1.00000000000000000000E+00);
check_double ("log10 (0.7)", log10 (0.7), -1.54901959985743187254E-01);
check_double ("log10 (2.22e-308)", log10 (2.22e-308), -3.07653647025549389582E+02);
check_double ("log10 (2.23e-308)", log10 (2.23e-308), -3.07651695136951843779E+02);
check_double ("log10 (0.17)", log10 (0.17), -7.69551078621726003526E-01);
check_double ("log10 (0.18)", log10 (0.18), -7.44727494896693986703E-01);
check_double ("log10 (1999.0)", log10 (1999.0), 3.30081279411811712166E+00);
check_double ("log10 (2000.0)", log10 (2000.0), 3.30102999566398125353E+00);
check_double ("log10 (2001.0)", log10 (2001.0), 3.30124708863621130206E+00);
check_double ("pow (0.0, 0.0)", pow (0.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (0.0, -0.0)", pow (0.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-0.0, 0.0)", pow (-0.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-0.0, -0.0)", pow (-0.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (0.0, 1.0)", pow (0.0, 1.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -1.0)", pow (0.0, -1.0), INF);
check_double ("pow (-0.0, 1.0)", pow (-0.0, 1.0), -0.00000000000000000000E+00);
check_double ("pow (-0.0, -1.0)", pow (-0.0, -1.0), -INF);
check_double ("pow (0.0, INFINITY)", pow (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.0, -INFINITY)", pow (0.0, -INFINITY), INF);
check_double ("pow (-0.0, INFINITY)", pow (-0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -INFINITY)", pow (-0.0, -INFINITY), INF);
check_double ("pow (0.0, NAN)", pow (0.0, NAN), NAN);
check_double ("pow (-0.0, NAN)", pow (-0.0, NAN), NAN);
check_double ("pow (1.0, 0.0)", pow (1.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, -0.0)", pow (1.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 0.0)", pow (-1.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, -0.0)", pow (-1.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, 1.0)", pow (1.0, 1.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, -1.0)", pow (1.0, -1.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 1.0)", pow (-1.0, 1.0), -1.00000000000000000000E+00);
check_double ("pow (-1.0, -1.0)", pow (-1.0, -1.0), -1.00000000000000000000E+00);
check_double ("pow (1.0, INFINITY)", pow (1.0, INFINITY), 1.00000000000000000000E+00);
check_double ("pow (1.0, -INFINITY)", pow (1.0, -INFINITY), 1.00000000000000000000E+00);
check_double ("pow (-1.0, INFINITY)", pow (-1.0, INFINITY), 1.00000000000000000000E+00);
check_double ("pow (-1.0, -INFINITY)", pow (-1.0, -INFINITY), 1.00000000000000000000E+00);
check_double ("pow (1.0, NAN)", pow (1.0, NAN), 1.00000000000000000000E+00);
check_double ("pow (-1.0, NAN)", pow (-1.0, NAN), NAN);
check_double ("pow (INFINITY, 0.0)", pow (INFINITY, 0.0), 1.00000000000000000000E+00);
check_double ("pow (INFINITY, -0.0)", pow (INFINITY, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-INFINITY, 0.0)", pow (-INFINITY, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-INFINITY, -0.0)", pow (-INFINITY, -0.0), 1.00000000000000000000E+00);
check_double ("pow (INFINITY, 1.0)", pow (INFINITY, 1.0), INF);
check_double ("pow (INFINITY, -1.0)", pow (INFINITY, -1.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 1.0)", pow (-INFINITY, 1.0), -INF);
check_double ("pow (-INFINITY, -1.0)", pow (-INFINITY, -1.0), -0.00000000000000000000E+00);
check_double ("pow (INFINITY, INFINITY)", pow (INFINITY, INFINITY), INF);
check_double ("pow (INFINITY, -INFINITY)", pow (INFINITY, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, INFINITY)", pow (-INFINITY, INFINITY), INF);
check_double ("pow (-INFINITY, -INFINITY)", pow (-INFINITY, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (INFINITY, NAN)", pow (INFINITY, NAN), NAN);
check_double ("pow (-INFINITY, NAN)", pow (-INFINITY, NAN), NAN);
check_double ("pow (NAN, 0.0)", pow (NAN, 0.0), 1.00000000000000000000E+00);
check_double ("pow (NAN, -0.0)", pow (NAN, -0.0), 1.00000000000000000000E+00);
check_double ("pow (NAN, 1.0)", pow (NAN, 1.0), NAN);
check_double ("pow (NAN, -1.0)", pow (NAN, -1.0), NAN);
check_double ("pow (NAN, INFINITY)", pow (NAN, INFINITY), NAN);
check_double ("pow (NAN, -INFINITY)", pow (NAN, -INFINITY), NAN);
check_double ("pow (NAN, NAN)", pow (NAN, NAN), NAN);
check_double ("pow (0.9, INFINITY)", pow (0.9, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.9, -INFINITY)", pow (0.9, -INFINITY), INF);
check_double ("pow (-0.9, INFINITY)", pow (-0.9, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-0.9, -INFINITY)", pow (-0.9, -INFINITY), INF);
check_double ("pow (1.1, INFINITY)", pow (1.1, INFINITY), INF);
check_double ("pow (1.1, -INFINITY)", pow (1.1, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-1.1, INFINITY)", pow (-1.1, INFINITY), INF);
check_double ("pow (-1.1, -INFINITY)", pow (-1.1, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.0, 2.0)", pow (0.0, 2.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -2.0)", pow (0.0, -2.0), INF);
check_double ("pow (-0.0, 2.0)", pow (-0.0, 2.0), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -2.0)", pow (-0.0, -2.0), INF);
check_double ("pow (0.0, 3.0)", pow (0.0, 3.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -3.0)", pow (0.0, -3.0), INF);
check_double ("pow (-0.0, 3.0)", pow (-0.0, 3.0), -0.00000000000000000000E+00);
check_double ("pow (-0.0, -3.0)", pow (-0.0, -3.0), -INF);
check_double ("pow (0.0, 3.14)", pow (0.0, 3.14), 0.00000000000000000000E+00);
check_double ("pow (0.0, -3.14)", pow (0.0, -3.14), INF);
check_double ("pow (-0.0, 3.14)", pow (-0.0, 3.14), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -3.14)", pow (-0.0, -3.14), INF);
check_double ("pow (1.0, 3.14)", pow (1.0, 3.14), 1.00000000000000000000E+00);
check_double ("pow (1.0, -3.14)", pow (1.0, -3.14), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 3.14)", pow (-1.0, 3.14), -NAN);
check_double ("pow (-1.0, -3.14)", pow (-1.0, -3.14), -NAN);
check_double ("pow (3.14, 0.0)", pow (3.14, 0.0), 1.00000000000000000000E+00);
check_double ("pow (3.14, -0.0)", pow (3.14, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-3.14, 0.0)", pow (-3.14, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-3.14, -0.0)", pow (-3.14, -0.0), 1.00000000000000000000E+00);
check_double ("pow (3.14, 1.0)", pow (3.14, 1.0), 3.14000000000000012434E+00);
check_double ("pow (3.14, -1.0)", pow (3.14, -1.0), 3.18471337579617819191E-01);
check_double ("pow (-3.14, 1.0)", pow (-3.14, 1.0), -3.14000000000000012434E+00);
check_double ("pow (-3.14, -1.0)", pow (-3.14, -1.0), -3.18471337579617819191E-01);
check_double ("pow (3.14, 2.0)", pow (3.14, 2.0), 9.85960000000000036380E+00);
check_double ("pow (3.14, -2.0)", pow (3.14, -2.0), 1.01423992859750899953E-01);
check_double ("pow (-3.14, 2.0)", pow (-3.14, 2.0), 9.85960000000000036380E+00);
check_double ("pow (-3.14, -2.0)", pow (-3.14, -2.0), 1.01423992859750899953E-01);
check_double ("pow (3.14, 3.0)", pow (3.14, 3.0), 3.09591440000000019950E+01);
check_double ("pow (3.14, -3.0)", pow (3.14, -3.0), 3.23006346687104775595E-02);
check_double ("pow (-3.14, 3.0)", pow (-3.14, 3.0), -3.09591440000000019950E+01);
check_double ("pow (-3.14, -3.0)", pow (-3.14, -3.0), -3.23006346687104775595E-02);
check_double ("pow (3.14, 3.14)", pow (3.14, 3.14), 3.63378388801747078674E+01);
check_double ("pow (3.14, -3.14)", pow (3.14, -3.14), 2.75195231972252124519E-02);
check_double ("pow (-3.14, 3.14)", pow (-3.14, 3.14), -NAN);
check_double ("pow (-3.14, -3.14)", pow (-3.14, -3.14), -NAN);
check_double ("pow (INFINITY, 2.0)", pow (INFINITY, 2.0), INF);
check_double ("pow (INFINITY, -2.0)", pow (INFINITY, -2.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 2.0)", pow (-INFINITY, 2.0), INF);
check_double ("pow (-INFINITY, -2.0)", pow (-INFINITY, -2.0), 0.00000000000000000000E+00);
check_double ("pow (INFINITY, 3.0)", pow (INFINITY, 3.0), INF);
check_double ("pow (INFINITY, -3.0)", pow (INFINITY, -3.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 3.0)", pow (-INFINITY, 3.0), -INF);
check_double ("pow (-INFINITY, -3.0)", pow (-INFINITY, -3.0), -0.00000000000000000000E+00);
check_double ("pow (INFINITY, 3.14)", pow (INFINITY, 3.14), INF);
check_double ("pow (INFINITY, -3.14)", pow (INFINITY, -3.14), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 3.14)", pow (-INFINITY, 3.14), INF);
check_double ("pow (-INFINITY, -3.14)", pow (-INFINITY, -3.14), 0.00000000000000000000E+00);
check_double ("pow (0.7, 1.2)", pow (0.7, 1.2), 6.51804940566386381562E-01);
check_double ("sqrt (0.0)", sqrt (0.0), 0.00000000000000000000E+00);
check_double ("sqrt (-0.0)", sqrt (-0.0), -0.00000000000000000000E+00);
check_double ("sqrt (1.0)", sqrt (1.0), 1.00000000000000000000E+00);
check_double ("sqrt (-1.0)", sqrt (-1.0), -NAN);
check_double ("sqrt (INFINITY)", sqrt (INFINITY), INF);
check_double ("sqrt (-INFINITY)", sqrt (-INFINITY), -NAN);
check_double ("sqrt (NAN)", sqrt (NAN), NAN);
check_double ("sqrt (0.7)", sqrt (0.7), 8.36660026534075562665E-01);
check_double ("sqrt (2)", sqrt (2), 1.41421356237309514547E+00);
check_double ("sqrt (10)", sqrt (10), 3.16227766016837952279E+00);
check_double ("sqrt (2.22e-308)", sqrt (2.22e-308), 1.48996644257513405066E-154);
check_double ("sqrt (2.23e-308)", sqrt (2.23e-308), 1.49331845230680803391E-154);
check_double ("sqrt (3.72e-09)", sqrt (3.72e-09), 6.09918027279076225416E-05);
check_double ("sqrt (7.37e+19)", sqrt (7.37e+19), 8.58487041253390121460E+09);
check_double ("sqrt (2209)", sqrt (2209), 4.70000000000000000000E+01);
check_double ("sqrt (4)", sqrt (4), 2.00000000000000000000E+00);
check_double ("sqrt (0.25)", sqrt (0.25), 5.00000000000000000000E-01);
check_double ("sqrt (6642.25)", sqrt (6642.25), 8.15000000000000000000E+01);
check_double ("sqrt (15239.9025)", sqrt (15239.9025), 1.23450000000000002842E+02);
check_double ("cbrt (0.0)", cbrt (0.0), 0.00000000000000000000E+00);
check_double ("cbrt (-0.0)", cbrt (-0.0), -0.00000000000000000000E+00);
check_double ("cbrt (1.0)", cbrt (1.0), 1.00000000000000000000E+00);
check_double ("cbrt (-1.0)", cbrt (-1.0), -1.00000000000000000000E+00);
check_double ("cbrt (INFINITY)", cbrt (INFINITY), INF);
check_double ("cbrt (-INFINITY)", cbrt (-INFINITY), -INF);
check_double ("cbrt (NAN)", cbrt (NAN), NAN);
check_double ("cbrt (0.7)", cbrt (0.7), 8.87904001742600645919E-01);
check_double ("cbrt (2)", cbrt (2), 1.25992104989487319067E+00);
check_double ("cbrt (10)", cbrt (10), 2.15443469003188381450E+00);
check_double ("cbrt (2.22e-308)", cbrt (2.22e-308), 2.81050475771047639693E-103);
check_double ("cbrt (2.23e-308)", cbrt (2.23e-308), 2.81471841433133404618E-103);
check_double ("cbrt (3.72e-09)", cbrt (3.72e-09), 1.54946217899915657419E-03);
check_double ("cbrt (7.37e+19)", cbrt (7.37e+19), 4.19265534205965511501E+06);
check_double ("cbrt (2209)", cbrt (2209), 1.30236256766892157799E+01);
check_double ("cbrt (4)", cbrt (4), 1.58740105196819958344E+00);
check_double ("cbrt (0.25)", cbrt (0.25), 6.29960524947436595333E-01);
check_double ("cbrt (6642.25)", cbrt (6642.25), 1.87977155063238647870E+01);
check_double ("cbrt (15239.9025)", cbrt (15239.9025), 2.47929038511971775449E+01);
check_double ("cbrt (3)", cbrt (3), 1.44224957030740830177E+00);
check_double ("cbrt (9)", cbrt (9), 2.08008382305190409056E+00);
check_double ("cbrt (-17.87)", cbrt (-17.87), -2.61441695192974155049E+00);
check_double ("cbrt (-8941)", cbrt (-8941), -2.07552848589356599973E+01);
check_double ("sin (0.0)", sin (0.0), 0.00000000000000000000E+00);
check_double ("sin (-0.0)", sin (-0.0), -0.00000000000000000000E+00);
check_double ("sin (1.0)", sin (1.0), 8.41470984807896504876E-01);
check_double ("sin (-1.0)", sin (-1.0), -8.41470984807896504876E-01);
check_double ("sin (INFINITY)", sin (INFINITY), -NAN);
check_double ("sin (-INFINITY)", sin (-INFINITY), -NAN);
check_double ("sin (NAN)", sin (NAN), NAN);
check_double ("sin (M_PI)", sin (M_PI), 1.22464679914735320717E-16);
check_double ("sin (-M_PI)", sin (-M_PI), -1.22464679914735320717E-16);
check_double ("sin (2.0 * M_PI)", sin (2.0 * M_PI), -2.44929359829470641435E-16);
check_double ("sin (-2.0 * M_PI)", sin (-2.0 * M_PI), 2.44929359829470641435E-16);
check_double ("sin (M_PI / 2.0)", sin (M_PI / 2.0), 1.00000000000000000000E+00);
check_double ("sin (-M_PI / 2.0)", sin (-M_PI / 2.0), -1.00000000000000000000E+00);
check_double ("sin (M_PI / 3.0)", sin (M_PI / 3.0), 8.66025403784438596588E-01);
check_double ("sin (-M_PI / 3.0)", sin (-M_PI / 3.0), -8.66025403784438596588E-01);
check_double ("sin (M_PI / 4.0)", sin (M_PI / 4.0), 7.07106781186547461715E-01);
check_double ("sin (-M_PI / 4.0)", sin (-M_PI / 4.0), -7.07106781186547461715E-01);
check_double ("sin (M_PI / 6.0)", sin (M_PI / 6.0), 4.99999999999999944489E-01);
check_double ("sin (-M_PI / 6.0)", sin (-M_PI / 6.0), -4.99999999999999944489E-01);
check_double ("sin (M_PI * 2.0 / 3.0)", sin (M_PI * 2.0 / 3.0), 8.66025403784438707611E-01);
check_double ("sin (-M_PI * 2.0 / 3.0)", sin (-M_PI * 2.0 / 3.0), -8.66025403784438707611E-01);
check_double ("sin (M_PI * 5.0 / 6.0)", sin (M_PI * 5.0 / 6.0), 4.99999999999999944489E-01);
check_double ("sin (-M_PI * 5.0 / 6.0)", sin (-M_PI * 5.0 / 6.0), -4.99999999999999944489E-01);
check_double ("sin (6.9e-18)", sin (6.9e-18), 6.90000000000000026253E-18);
check_double ("sin (-6.9e-18)", sin (-6.9e-18), -6.90000000000000026253E-18);
check_double ("sin (7.0e-18)", sin (7.0e-18), 6.99999999999999973042E-18);
check_double ("sin (-7.0e-18)", sin (-7.0e-18), -6.99999999999999973042E-18);
check_double ("sin (7.4e-9)", sin (7.4e-9), 7.40000000000000008865E-09);
check_double ("sin (-7.4e-9)", sin (-7.4e-9), -7.40000000000000008865E-09);
check_double ("sin (7.5e-9)", sin (7.5e-9), 7.49999999999999932974E-09);
check_double ("sin (-7.5e-9)", sin (-7.5e-9), -7.49999999999999932974E-09);
check_double ("sin (0.2)", sin (0.2), 1.98669330795061216399E-01);
check_double ("sin (-0.2)", sin (-0.2), -1.98669330795061216399E-01);
check_double ("sin (0.4)", sin (0.4), 3.89418342308650522465E-01);
check_double ("sin (-0.4)", sin (-0.4), -3.89418342308650522465E-01);
check_double ("sin (0.7)", sin (0.7), 6.44217687237691016833E-01);
check_double ("sin (-0.7)", sin (-0.7), -6.44217687237691016833E-01);
check_double ("sin (0.8)", sin (0.8), 7.17356090899522791382E-01);
check_double ("sin (-0.8)", sin (-0.8), -7.17356090899522791382E-01);
check_double ("sin (3.0)", sin (3.0), 1.41120008059867213523E-01);
check_double ("sin (-3.0)", sin (-3.0), -1.41120008059867213523E-01);
check_double ("sin (4.0)", sin (4.0), -7.56802495307928202450E-01);
check_double ("sin (-4.0)", sin (-4.0), 7.56802495307928202450E-01);
check_double ("sin (6.0)", sin (6.0), -2.79415498198925860152E-01);
check_double ("sin (-6.0)", sin (-6.0), 2.79415498198925860152E-01);
check_double ("sin (7.0)", sin (7.0), 6.56986598718789061024E-01);
check_double ("sin (-7.0)", sin (-7.0), -6.56986598718789061024E-01);
check_double ("cos (0.0)", cos (0.0), 1.00000000000000000000E+00);
check_double ("cos (-0.0)", cos (-0.0), 1.00000000000000000000E+00);
check_double ("cos (1.0)", cos (1.0), 5.40302305868139765010E-01);
check_double ("cos (-1.0)", cos (-1.0), 5.40302305868139765010E-01);
check_double ("cos (INFINITY)", cos (INFINITY), -NAN);
check_double ("cos (-INFINITY)", cos (-INFINITY), -NAN);
check_double ("cos (NAN)", cos (NAN), NAN);
check_double ("cos (M_PI)", cos (M_PI), -1.00000000000000000000E+00);
check_double ("cos (-M_PI)", cos (-M_PI), -1.00000000000000000000E+00);
check_double ("cos (2.0 * M_PI)", cos (2.0 * M_PI), 1.00000000000000000000E+00);
check_double ("cos (-2.0 * M_PI)", cos (-2.0 * M_PI), 1.00000000000000000000E+00);
check_double ("cos (M_PI / 2.0)", cos (M_PI / 2.0), 6.12323399573676603587E-17);
check_double ("cos (-M_PI / 2.0)", cos (-M_PI / 2.0), 6.12323399573676603587E-17);
check_double ("cos (M_PI / 3.0)", cos (M_PI / 3.0), 5.00000000000000111022E-01);
check_double ("cos (-M_PI / 3.0)", cos (-M_PI / 3.0), 5.00000000000000111022E-01);
check_double ("cos (M_PI / 4.0)", cos (M_PI / 4.0), 7.07106781186547572737E-01);
check_double ("cos (-M_PI / 4.0)", cos (-M_PI / 4.0), 7.07106781186547572737E-01);
check_double ("cos (M_PI / 6.0)", cos (M_PI / 6.0), 8.66025403784438707611E-01);
check_double ("cos (-M_PI / 6.0)", cos (-M_PI / 6.0), 8.66025403784438707611E-01);
check_double ("cos (M_PI * 2.0 / 3.0)", cos (M_PI * 2.0 / 3.0), -4.99999999999999777955E-01);
check_double ("cos (-M_PI * 2.0 / 3.0)", cos (-M_PI * 2.0 / 3.0), -4.99999999999999777955E-01);
check_double ("cos (M_PI * 5.0 / 6.0)", cos (M_PI * 5.0 / 6.0), -8.66025403784438707611E-01);
check_double ("cos (-M_PI * 5.0 / 6.0)", cos (-M_PI * 5.0 / 6.0), -8.66025403784438707611E-01);
check_double ("cos (6.9e-18)", cos (6.9e-18), 1.00000000000000000000E+00);
check_double ("cos (-6.9e-18)", cos (-6.9e-18), 1.00000000000000000000E+00);
check_double ("cos (7.0e-18)", cos (7.0e-18), 1.00000000000000000000E+00);
check_double ("cos (-7.0e-18)", cos (-7.0e-18), 1.00000000000000000000E+00);
check_double ("cos (7.4e-9)", cos (7.4e-9), 1.00000000000000000000E+00);
check_double ("cos (-7.4e-9)", cos (-7.4e-9), 1.00000000000000000000E+00);
check_double ("cos (7.5e-9)", cos (7.5e-9), 1.00000000000000000000E+00);
check_double ("cos (-7.5e-9)", cos (-7.5e-9), 1.00000000000000000000E+00);
check_double ("cos (0.2)", cos (0.2), 9.80066577841241626246E-01);
check_double ("cos (-0.2)", cos (-0.2), 9.80066577841241626246E-01);
check_double ("cos (0.4)", cos (0.4), 9.21060994002885102816E-01);
check_double ("cos (-0.4)", cos (-0.4), 9.21060994002885102816E-01);
check_double ("cos (0.7)", cos (0.7), 7.64842187284488495003E-01);
check_double ("cos (-0.7)", cos (-0.7), 7.64842187284488495003E-01);
check_double ("cos (0.8)", cos (0.8), 6.96706709347165387136E-01);
check_double ("cos (-0.8)", cos (-0.8), 6.96706709347165387136E-01);
check_double ("cos (3.0)", cos (3.0), -9.89992496600445415211E-01);
check_double ("cos (-3.0)", cos (-3.0), -9.89992496600445415211E-01);
check_double ("cos (4.0)", cos (4.0), -6.53643620863611940486E-01);
check_double ("cos (-4.0)", cos (-4.0), -6.53643620863611940486E-01);
check_double ("cos (6.0)", cos (6.0), 9.60170286650365967240E-01);
check_double ("cos (-6.0)", cos (-6.0), 9.60170286650365967240E-01);
check_double ("cos (7.0)", cos (7.0), 7.53902254343304600859E-01);
check_double ("cos (-7.0)", cos (-7.0), 7.53902254343304600859E-01);
check_double ("tan (0.0)", tan (0.0), 0.00000000000000000000E+00);
check_double ("tan (-0.0)", tan (-0.0), -0.00000000000000000000E+00);
check_double ("tan (1.0)", tan (1.0), 1.55740772465490229237E+00);
check_double ("tan (-1.0)", tan (-1.0), -1.55740772465490229237E+00);
check_double ("tan (INFINITY)", tan (INFINITY), -NAN);
check_double ("tan (-INFINITY)", tan (-INFINITY), -NAN);
check_double ("tan (NAN)", tan (NAN), NAN);
check_double ("tan (M_PI)", tan (M_PI), -1.22464679914735320717E-16);
check_double ("tan (-M_PI)", tan (-M_PI), 1.22464679914735320717E-16);
check_double ("tan (2.0 * M_PI)", tan (2.0 * M_PI), -2.44929359829470641435E-16);
check_double ("tan (-2.0 * M_PI)", tan (-2.0 * M_PI), 2.44929359829470641435E-16);
check_double ("tan (M_PI / 2.0)", tan (M_PI / 2.0), 1.63312393531953700000E+16);
check_double ("tan (-M_PI / 2.0)", tan (-M_PI / 2.0), -1.63312393531953700000E+16);
check_double ("tan (M_PI / 3.0)", tan (M_PI / 3.0), 1.73205080756887674909E+00);
check_double ("tan (-M_PI / 3.0)", tan (-M_PI / 3.0), -1.73205080756887674909E+00);
check_double ("tan (M_PI / 4.0)", tan (M_PI / 4.0), 9.99999999999999888978E-01);
check_double ("tan (-M_PI / 4.0)", tan (-M_PI / 4.0), -9.99999999999999888978E-01);
check_double ("tan (M_PI / 6.0)", tan (M_PI / 6.0), 5.77350269189625731059E-01);
check_double ("tan (-M_PI / 6.0)", tan (-M_PI / 6.0), -5.77350269189625731059E-01);
check_double ("tan (M_PI * 2.0 / 3.0)", tan (M_PI * 2.0 / 3.0), -1.73205080756887830340E+00);
check_double ("tan (-M_PI * 2.0 / 3.0)", tan (-M_PI * 2.0 / 3.0), 1.73205080756887830340E+00);
check_double ("tan (M_PI * 5.0 / 6.0)", tan (M_PI * 5.0 / 6.0), -5.77350269189625731059E-01);
check_double ("tan (-M_PI * 5.0 / 6.0)", tan (-M_PI * 5.0 / 6.0), 5.77350269189625731059E-01);
check_double ("tan (3.7e-9)", tan (3.7e-9), 3.70000000000000004433E-09);
check_double ("tan (-3.7e-9)", tan (-3.7e-9), -3.70000000000000004433E-09);
check_double ("tan (3.8e-9)", tan (3.8e-9), 3.80000000000000011259E-09);
check_double ("tan (-3.8e-9)", tan (-3.8e-9), -3.80000000000000011259E-09);
check_double ("tan (0.6)", tan (0.6), 6.84136808341692326252E-01);
check_double ("tan (-0.6)", tan (-0.6), -6.84136808341692326252E-01);
check_double ("tan (0.7)", tan (0.7), 8.42288380463079411342E-01);
check_double ("tan (-0.7)", tan (-0.7), -8.42288380463079411342E-01);
check_double ("tan (3.0)", tan (3.0), -1.42546543074277803909E-01);
check_double ("tan (-3.0)", tan (-3.0), 1.42546543074277803909E-01);
check_double ("tan (4.0)", tan (4.0), 1.15782128234957748525E+00);
check_double ("tan (-4.0)", tan (-4.0), -1.15782128234957748525E+00);
check_double ("tan (6.0)", tan (6.0), -2.91006191384749146600E-01);
check_double ("tan (-6.0)", tan (-6.0), 2.91006191384749146600E-01);
check_double ("tan (7.0)", tan (7.0), 8.71447982724318781500E-01);
check_double ("tan (-7.0)", tan (-7.0), -8.71447982724318781500E-01);
check_double ("cosh (0.0)", cosh (0.0), 1.00000000000000000000E+00);
check_double ("cosh (-0.0)", cosh (-0.0), 1.00000000000000000000E+00);
check_double ("cosh (1.0)", cosh (1.0), 1.54308063481524371241E+00);
check_double ("cosh (-1.0)", cosh (-1.0), 1.54308063481524371241E+00);
check_double ("cosh (INFINITY)", cosh (INFINITY), INF);
check_double ("cosh (-INFINITY)", cosh (-INFINITY), INF);
check_double ("cosh (NAN)", cosh (NAN), NAN);
check_double ("cosh (M_PI)", cosh (M_PI), 1.15919532755215186626E+01);
check_double ("cosh (-M_PI)", cosh (-M_PI), 1.15919532755215186626E+01);
check_double ("cosh (2.0 * M_PI)", cosh (2.0 * M_PI), 2.67746761483748173305E+02);
check_double ("cosh (-2.0 * M_PI)", cosh (-2.0 * M_PI), 2.67746761483748173305E+02);
check_double ("cosh (M_PI / 2.0)", cosh (M_PI / 2.0), 2.50917847865805665464E+00);
check_double ("cosh (-M_PI / 2.0)", cosh (-M_PI / 2.0), 2.50917847865805665464E+00);
check_double ("cosh (M_PI / 3.0)", cosh (M_PI / 3.0), 1.60028685770238610075E+00);
check_double ("cosh (-M_PI / 3.0)", cosh (-M_PI / 3.0), 1.60028685770238610075E+00);
check_double ("cosh (M_PI / 4.0)", cosh (M_PI / 4.0), 1.32460908925200571140E+00);
check_double ("cosh (-M_PI / 4.0)", cosh (-M_PI / 4.0), 1.32460908925200571140E+00);
check_double ("cosh (M_PI / 6.0)", cosh (M_PI / 6.0), 1.14023832107642886236E+00);
check_double ("cosh (-M_PI / 6.0)", cosh (-M_PI / 6.0), 1.14023832107642886236E+00);
check_double ("cosh (M_PI * 2.0 / 3.0)", cosh (M_PI * 2.0 / 3.0), 4.12183605386995388642E+00);
check_double ("cosh (-M_PI * 2.0 / 3.0)", cosh (-M_PI * 2.0 / 3.0), 4.12183605386995388642E+00);
check_double ("cosh (M_PI * 5.0 / 6.0)", cosh (M_PI * 5.0 / 6.0), 6.89057236497588299073E+00);
check_double ("cosh (-M_PI * 5.0 / 6.0)", cosh (-M_PI * 5.0 / 6.0), 6.89057236497588299073E+00);
check_double ("cosh (6.9e-18)", cosh (6.9e-18), 1.00000000000000000000E+00);
check_double ("cosh (-6.9e-18)", cosh (-6.9e-18), 1.00000000000000000000E+00);
check_double ("cosh (7.0e-18)", cosh (7.0e-18), 1.00000000000000000000E+00);
check_double ("cosh (-7.0e-18)", cosh (-7.0e-18), 1.00000000000000000000E+00);
check_double ("cosh (7.4e-9)", cosh (7.4e-9), 1.00000000000000000000E+00);
check_double ("cosh (-7.4e-9)", cosh (-7.4e-9), 1.00000000000000000000E+00);
check_double ("cosh (7.5e-9)", cosh (7.5e-9), 1.00000000000000000000E+00);
check_double ("cosh (-7.5e-9)", cosh (-7.5e-9), 1.00000000000000000000E+00);
check_double ("cosh (0.2)", cosh (0.2), 1.02006675561907589334E+00);
check_double ("cosh (-0.2)", cosh (-0.2), 1.02006675561907589334E+00);
check_double ("cosh (0.4)", cosh (0.4), 1.08107237183845472650E+00);
check_double ("cosh (-0.4)", cosh (-0.4), 1.08107237183845472650E+00);
check_double ("cosh (0.7)", cosh (0.7), 1.25516900563094302434E+00);
check_double ("cosh (-0.7)", cosh (-0.7), 1.25516900563094302434E+00);
check_double ("cosh (0.8)", cosh (0.8), 1.33743494630484471841E+00);
check_double ("cosh (-0.8)", cosh (-0.8), 1.33743494630484471841E+00);
check_double ("cosh (3.0)", cosh (3.0), 1.00676619957777653269E+01);
check_double ("cosh (-3.0)", cosh (-3.0), 1.00676619957777653269E+01);
check_double ("cosh (4.0)", cosh (4.0), 2.73082328360164865444E+01);
check_double ("cosh (-4.0)", cosh (-4.0), 2.73082328360164865444E+01);
check_double ("cosh (6.0)", cosh (6.0), 2.01715636122455890700E+02);
check_double ("cosh (-6.0)", cosh (-6.0), 2.01715636122455890700E+02);
check_double ("cosh (7.0)", cosh (7.0), 5.48317035155212124664E+02);
check_double ("cosh (-7.0)", cosh (-7.0), 5.48317035155212124664E+02);
check_double ("sinh (0.0)", sinh (0.0), 0.00000000000000000000E+00);
check_double ("sinh (-0.0)", sinh (-0.0), -0.00000000000000000000E+00);
check_double ("sinh (1.0)", sinh (1.0), 1.17520119364380137839E+00);
check_double ("sinh (-1.0)", sinh (-1.0), -1.17520119364380137839E+00);
check_double ("sinh (INFINITY)", sinh (INFINITY), INF);
check_double ("sinh (-INFINITY)", sinh (-INFINITY), -INF);
check_double ("sinh (NAN)", sinh (NAN), NAN);
check_double ("sinh (M_PI)", sinh (M_PI), 1.15487393572577463630E+01);
check_double ("sinh (-M_PI)", sinh (-M_PI), -1.15487393572577463630E+01);
check_double ("sinh (2.0 * M_PI)", sinh (2.0 * M_PI), 2.67744894041016436859E+02);
check_double ("sinh (-2.0 * M_PI)", sinh (-2.0 * M_PI), -2.67744894041016436859E+02);
check_double ("sinh (M_PI / 2.0)", sinh (M_PI / 2.0), 2.30129890230729472478E+00);
check_double ("sinh (-M_PI / 2.0)", sinh (-M_PI / 2.0), -2.30129890230729472478E+00);
check_double ("sinh (M_PI / 3.0)", sinh (M_PI / 3.0), 1.24936705052397512006E+00);
check_double ("sinh (-M_PI / 3.0)", sinh (-M_PI / 3.0), -1.24936705052397512006E+00);
check_double ("sinh (M_PI / 4.0)", sinh (M_PI / 4.0), 8.68670961486009529651E-01);
check_double ("sinh (-M_PI / 4.0)", sinh (-M_PI / 4.0), -8.68670961486009529651E-01);
check_double ("sinh (M_PI / 6.0)", sinh (M_PI / 6.0), 5.47853473888039732564E-01);
check_double ("sinh (-M_PI / 6.0)", sinh (-M_PI / 6.0), -5.47853473888039732564E-01);
check_double ("sinh (M_PI * 2.0 / 3.0)", sinh (M_PI * 2.0 / 3.0), 3.99869134279982052504E+00);
check_double ("sinh (-M_PI * 2.0 / 3.0)", sinh (-M_PI * 2.0 / 3.0), -3.99869134279982052504E+00);
check_double ("sinh (M_PI * 5.0 / 6.0)", sinh (M_PI * 5.0 / 6.0), 6.81762330412654371514E+00);
check_double ("sinh (-M_PI * 5.0 / 6.0)", sinh (-M_PI * 5.0 / 6.0), -6.81762330412654371514E+00);
check_double ("sinh (6.9e-18)", sinh (6.9e-18), 6.90000000000000026253E-18);
check_double ("sinh (-6.9e-18)", sinh (-6.9e-18), -6.90000000000000026253E-18);
check_double ("sinh (7.0e-18)", sinh (7.0e-18), 6.99999999999999973042E-18);
check_double ("sinh (-7.0e-18)", sinh (-7.0e-18), -6.99999999999999973042E-18);
check_double ("sinh (7.4e-9)", sinh (7.4e-9), 7.40000000000000008865E-09);
check_double ("sinh (-7.4e-9)", sinh (-7.4e-9), -7.40000000000000008865E-09);
check_double ("sinh (7.5e-9)", sinh (7.5e-9), 7.49999999999999932974E-09);
check_double ("sinh (-7.5e-9)", sinh (-7.5e-9), -7.49999999999999932974E-09);
check_double ("sinh (0.2)", sinh (0.2), 2.01336002541093989082E-01);
check_double ("sinh (-0.2)", sinh (-0.2), -2.01336002541093989082E-01);
check_double ("sinh (0.4)", sinh (0.4), 4.10752325802815509981E-01);
check_double ("sinh (-0.4)", sinh (-0.4), -4.10752325802815509981E-01);
check_double ("sinh (0.7)", sinh (0.7), 7.58583701839533497413E-01);
check_double ("sinh (-0.7)", sinh (-0.7), -7.58583701839533497413E-01);
check_double ("sinh (0.8)", sinh (0.8), 8.88105982187623044233E-01);
check_double ("sinh (-0.8)", sinh (-0.8), -8.88105982187623044233E-01);
check_double ("sinh (3.0)", sinh (3.0), 1.00178749274099025968E+01);
check_double ("sinh (-3.0)", sinh (-3.0), -1.00178749274099025968E+01);
check_double ("sinh (4.0)", sinh (4.0), 2.72899171971277532123E+01);
check_double ("sinh (-4.0)", sinh (-4.0), -2.72899171971277532123E+01);
check_double ("sinh (6.0)", sinh (6.0), 2.01713157370279219549E+02);
check_double ("sinh (-6.0)", sinh (-6.0), -2.01713157370279219549E+02);
check_double ("sinh (7.0)", sinh (7.0), 5.48316123273246489589E+02);
check_double ("sinh (-7.0)", sinh (-7.0), -5.48316123273246489589E+02);
check_double ("tanh (0.0)", tanh (0.0), 0.00000000000000000000E+00);
check_double ("tanh (-0.0)", tanh (-0.0), -0.00000000000000000000E+00);
check_double ("tanh (1.0)", tanh (1.0), 7.61594155955764851029E-01);
check_double ("tanh (-1.0)", tanh (-1.0), -7.61594155955764851029E-01);
check_double ("tanh (INFINITY)", tanh (INFINITY), 1.00000000000000000000E+00);
check_double ("tanh (-INFINITY)", tanh (-INFINITY), -1.00000000000000000000E+00);
check_double ("tanh (NAN)", tanh (NAN), NAN);
check_double ("tanh (M_PI)", tanh (M_PI), 9.96272076220749980280E-01);
check_double ("tanh (-M_PI)", tanh (-M_PI), -9.96272076220749980280E-01);
check_double ("tanh (2.0 * M_PI)", tanh (2.0 * M_PI), 9.99993025339610652757E-01);
check_double ("tanh (-2.0 * M_PI)", tanh (-2.0 * M_PI), -9.99993025339610652757E-01);
check_double ("tanh (M_PI / 2.0)", tanh (M_PI / 2.0), 9.17152335667274387632E-01);
check_double ("tanh (-M_PI / 2.0)", tanh (-M_PI / 2.0), -9.17152335667274387632E-01);
check_double ("tanh (M_PI / 3.0)", tanh (M_PI / 3.0), 7.80714435359267655556E-01);
check_double ("tanh (-M_PI / 3.0)", tanh (-M_PI / 3.0), -7.80714435359267655556E-01);
check_double ("tanh (M_PI / 4.0)", tanh (M_PI / 4.0), 6.55794202632672407205E-01);
check_double ("tanh (-M_PI / 4.0)", tanh (-M_PI / 4.0), -6.55794202632672407205E-01);
check_double ("tanh (M_PI / 6.0)", tanh (M_PI / 6.0), 4.80472778156451563181E-01);
check_double ("tanh (-M_PI / 6.0)", tanh (-M_PI / 6.0), -4.80472778156451563181E-01);
check_double ("tanh (M_PI * 2.0 / 3.0)", tanh (M_PI * 2.0 / 3.0), 9.70123821165930766419E-01);
check_double ("tanh (-M_PI * 2.0 / 3.0)", tanh (-M_PI * 2.0 / 3.0), -9.70123821165930766419E-01);
check_double ("tanh (M_PI * 5.0 / 6.0)", tanh (M_PI * 5.0 / 6.0), 9.89413207352682011475E-01);
check_double ("tanh (-M_PI * 5.0 / 6.0)", tanh (-M_PI * 5.0 / 6.0), -9.89413207352682011475E-01);
check_double ("tanh (6.9e-18)", tanh (6.9e-18), 6.90000000000000026253E-18);
check_double ("tanh (-6.9e-18)", tanh (-6.9e-18), -6.90000000000000026253E-18);
check_double ("tanh (7.0e-18)", tanh (7.0e-18), 6.99999999999999973042E-18);
check_double ("tanh (-7.0e-18)", tanh (-7.0e-18), -6.99999999999999973042E-18);
check_double ("tanh (7.4e-9)", tanh (7.4e-9), 7.40000000000000008865E-09);
check_double ("tanh (-7.4e-9)", tanh (-7.4e-9), -7.40000000000000008865E-09);
check_double ("tanh (7.5e-9)", tanh (7.5e-9), 7.49999999999999932974E-09);
check_double ("tanh (-7.5e-9)", tanh (-7.5e-9), -7.49999999999999932974E-09);
check_double ("tanh (0.2)", tanh (0.2), 1.97375320224904005073E-01);
check_double ("tanh (-0.2)", tanh (-0.2), -1.97375320224904005073E-01);
check_double ("tanh (0.4)", tanh (0.4), 3.79948962255224897966E-01);
check_double ("tanh (-0.4)", tanh (-0.4), -3.79948962255224897966E-01);
check_double ("tanh (0.7)", tanh (0.7), 6.04367777117163496037E-01);
check_double ("tanh (-0.7)", tanh (-0.7), -6.04367777117163496037E-01);
check_double ("tanh (0.8)", tanh (0.8), 6.64036770267849019156E-01);
check_double ("tanh (-0.8)", tanh (-0.8), -6.64036770267849019156E-01);
check_double ("tanh (3.0)", tanh (3.0), 9.95054753686730464324E-01);
check_double ("tanh (-3.0)", tanh (-3.0), -9.95054753686730464324E-01);
check_double ("tanh (4.0)", tanh (4.0), 9.99329299739067034025E-01);
check_double ("tanh (-4.0)", tanh (-4.0), -9.99329299739067034025E-01);
check_double ("tanh (6.0)", tanh (6.0), 9.99987711650795585427E-01);
check_double ("tanh (-6.0)", tanh (-6.0), -9.99987711650795585427E-01);
check_double ("tanh (7.0)", tanh (7.0), 9.99998336943944687860E-01);
check_double ("tanh (-7.0)", tanh (-7.0), -9.99998336943944687860E-01);
