<?hh
// Copyright 2004-present Facebook. All Rights Reserved.

class A {
  public function __call($name, $arguments) {
    echo "================== A::__call =====================\n";
    var_dump($arguments);
    var_dump(is_varray($arguments));
  }

  public static function __callStatic($name, $arguments) {
    echo "================== A::__callStatic ===============\n";
    var_dump($arguments);
    var_dump(is_varray($arguments));
  }
}

function variadic($a, ...$b) {
  echo "================== variadic ======================\n";
  var_dump($b);
  var_dump(is_varray($b));
}

function test($x) {
  variadic(1, 2, 3, 4);
  variadic(1, 2, ...$x);
  if (count($x) > 0) variadic(...$x);
  if (count($x) > 0) call_user_func_array('variadic', $x);

  $a = new A();
  if (count($x) > 0) $a->foobaz(...$x);
  $a->foobaz(1, 2, ...$x);
  if (count($x) > 0) call_user_func_array([$a, 'foobaz'], $x);

  if (count($x) > 0) A::foobaz(...$x);
  A::foobaz(1, 2, ...$x);
  if (count($x) > 0) call_user_func_array('A::foobaz', $x);
}
test([]);
test([3, 4, 5]);
test(vec[]);
test(vec[3, 4, 5]);
test(dict['a' => 3, 'b' => 4, 'c' => 5]);
test(varray[3, 4, 5]);
test(Vector{3, 4, 5});
