/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// SourceInfo struct for SourceInfo
type SourceInfo struct {
	File *string `json:"file,omitempty" yaml:"file,omitempty"`
}

// NewSourceInfo instantiates a new SourceInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSourceInfo() *SourceInfo {
	this := SourceInfo{}
	return &this
}

// NewSourceInfoWithDefaults instantiates a new SourceInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSourceInfoWithDefaults() *SourceInfo {
	this := SourceInfo{}
	return &this
}

// GetFile returns the File field value if set, zero value otherwise.
func (o *SourceInfo) GetFile() string {
	if o == nil || o.File == nil {
		var ret string
		return ret
	}
	return *o.File
}

// GetFileOk returns a tuple with the File field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SourceInfo) GetFileOk() (*string, bool) {
	if o == nil || o.File == nil {
		return nil, false
	}
	return o.File, true
}

// HasFile returns a boolean if a field has been set.
func (o *SourceInfo) HasFile() bool {
	if o != nil && o.File != nil {
		return true
	}

	return false
}

// SetFile gets a reference to the given string and assigns it to the File field.
func (o *SourceInfo) SetFile(v string) {
	o.File = &v
}

func (o SourceInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.File != nil {
		toSerialize["file"] = o.File
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableSourceInfo struct {
	value *SourceInfo
	isSet bool
}

func (v NullableSourceInfo) Get() *SourceInfo {
	return v.value
}

func (v *NullableSourceInfo) Set(val *SourceInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableSourceInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableSourceInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSourceInfo(val *SourceInfo) *NullableSourceInfo {
	return &NullableSourceInfo{value: val, isSet: true}
}

func (v NullableSourceInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSourceInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
