/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace Cowbell.Base
{
	public class FilenamePattern
	{
		/* public methods */
		public static string Parse (Song s, string pattern)
		{
			return Parse (pattern, s.Title, s.Artist, s.Album,
			              s.TrackNumber, s.Year, s.Genre);
		}

		public static string Parse (string pattern, string title,
		                            string artist, string album,
		                            uint tracknumber, uint year,
		                            string genre)
		{
			int num_digits = (Convert.ToString (Runtime.Database.Count)).Length;
			string pad = String.Empty;
			while (num_digits > 0)
			{
				pad += "0";
				num_digits--;
			}

			pattern = pattern.Replace (Catalog.GetString ("Artist"), "{0}");
			pattern = pattern.Replace (Catalog.GetString ("Album"), "{1}");
			pattern = pattern.Replace (Catalog.GetString ("Title"), "{2}");
			pattern = pattern.Replace (Catalog.GetString ("Track"), "{3:" + pad + "}");
			pattern = pattern.Replace (Catalog.GetString ("Genre"), "{4}");
			pattern = pattern.Replace (Catalog.GetString ("Year"), "{5}");

			return String.Format (pattern, artist, album, title, tracknumber, genre, year);
		}
	}
}
