cookieMonsterBys1tony.showCookieExceptions =
{
    _siteCookiesWindow: "chrome://cookiemonster/content/siteCookies_ff36.xul",
	    
    init: function()
    {
        // Check if this version of FF contains add-on bar
		if (document.getElementById("addon-bar"))
		{
			this._siteCookiesWindow = "chrome://cookiemonster/content/siteCookies.xul";
		}  
    },
    
    onMenuItemCommand: function(evt)
    {
        var bundlePreferences = document.getElementById("cookiemonster-s1tony-preferences");
        var windowAddress = "chrome://browser/content/preferences/permissions.xul";
        var windowName = "cookieMonster_ShowExceptions";
        var params =
        {
            blockVisible   : true,
            sessionVisible : true,
            allowVisible   : true,
            prefilledHost  : "",
            permissionType : "cookie",
            windowTitle    : bundlePreferences.getString("cookiepermissionstitle"),
            introText      : bundlePreferences.getString("cookiepermissionstext")
        };

        if (evt.target.id == 'cookiemonster-s1tony-show-cookies' || evt.target.id == 'cookiemonster-s1tony-show-cookies-site')
        {
        	//windowAddress = "chrome://browser/content/preferences/cookies.xul";
        	windowAddress = this._siteCookiesWindow;
        	windowName = "cookieMonster_ShowCookies";
        	params = {filterString : "", showSearch: true};
        	
        	if (evt.target.id == 'cookiemonster-s1tony-show-cookies-site')
        	{
        		//windowAddress = "chrome://cookiemonster/content/siteCookies.xul";
        		var currentDomain = document.getElementById(evt.target.id);
        		params = {filterString : currentDomain.getAttribute("name"), showSearch: false};
        	}
        }

        var cookieWindow = window.openDialog(windowAddress, windowName, "chrome=yes,close=yes", params);
    }
};

cookieMonsterBys1tony.showOverrideGlobal =
{
	// Callback method for overrideGlobal window
	// to add, delete or delete all URI hosts
	// from preference list
	overrideListChange: function(aHost, aListType)
	{
		var domainType = cookieMonsterBys1tony.cookieMonster.extGetCurrentDomainType();

        switch (aListType)
        {
            case 0: // Add
                cookieMonsterBys1tony.cookieInfo.addOverrideGlobal(aHost, domainType);
                break;
            case 1: // Delete
                cookieMonsterBys1tony.cookieInfo.removeOverrideGlobal(aHost, domainType);
                break;
            case 2: // Delete All and reload page
                cookieMonsterBys1tony.cookieInfo.removeAllOverrideGlobal();
                break;
            default:
                break;
        }
        
        // If aHost is the current host or if remove all, reload page
        if ((aHost != null) && (cookieMonsterBys1tony.cookieMonster.extGetCurrentHost() == aHost))
        {
        	cookieMonsterBys1tony.cookieMonster.extReloadCurrentPage();
        }
	},
	
    onMenuItemCommand: function(evt)
    {
        var bundlePreferences = document.getElementById("cookiemonster-s1tony-preferences");
        var windowAddress = "chrome://cookiemonster/content/overrideGlobal.xul";
        var windowName = "cookieMonster_ShowOverride";
        var params =
        {
            prefilledHost  : cookieMonsterBys1tony.cookieMonster.extGetCurrentHost(),
            //aURI		   : cookieMonster.extGetCurrentURI(),
            //windowTitle    : bundlePreferences.getString("cookiepermissionstitle"),
            //introText      : bundlePreferences.getString("cookiepermissionstext"),
            globalOverrideList: cookieMonsterBys1tony.cookieInfo.getGlobalOverrideList()
        };

        var cookieWindow = window.openDialog(windowAddress, windowName, "modal=yes,chrome=yes,close=yes", params, this.overrideListChange);
    }
};

cookieMonsterBys1tony.deleteCookies =
{
    onMenuItemCommand: function(evt)
    {
        var menuBundle = document.getElementById("cookiemonster-s1tony-menu-labels");
    	var currentHost = null;
    	var result = true;
    	
    	if (evt.target.id == 'cookiemonster-s1tony-delete-cookies-site')
    	{
    		currentHost = cookieMonsterBys1tony.cookieMonster.extGetCurrentHost();
  			
  			// Display confirmation dialog, unless turned off in Options
  			if (!cookieMonsterBys1tony.nsPreferences.getBoolPref("disabledeletecookieconfirm", false))
  			{
				var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
				                        .getService(Components.interfaces.nsIPromptService);
				result = prompts.confirm(null, menuBundle.getString("confirmtitle"),
											menuBundle.getFormattedString("confirmtext", [currentHost]));  				
  			}
  			
  			if (result)
  			{
  				cookieMonsterBys1tony.cookieInfo.deleteHostCookies(currentHost, true);  				
  			}
    	}
    }
};

cookieMonsterBys1tony.showCookiesMenu = 
{
    _popupset: null,
	    
    init: function()
    {
    	// Retrieve original parent node for cookie monster menu
        this._popupset = document.getElementById("cookiemonster-s1tony-menu").parentNode;
    	
        // Set whether or not keyboard shortcut is enabled based on user's preference
        if (!cookieMonsterBys1tony.nsPreferences.getBoolPref("enablekeyboardshortcut", true))
        {
            document.getElementById("cookiemonster-s1tony-key").setAttribute("disabled", true);
        }
    },

    onMenuItemCommand: function(evt)
    {   
    	if (evt.target.id == 'contentAreaContextMenu')
    	{			
    		// Make cookie monster menu item visible in context menu and add
    		// the cookie-access menu popup
    	    var menuItem = document.getElementById("cookiemonster-s1tony-context");
    		var cookieMenu = document.getElementById("cookiemonster-s1tony-menu");
	        
	        // Only show the context menu if enablecontextmenu is set to true
	        if (cookieMonsterBys1tony.nsPreferences.getBoolPref("enablecontextmenu", false))
	        {
	    		if (evt.type == 'popupshown')
	    		{
	  				menuItem.hidden = false;
	  				menuItem.setAttribute("image", cookieMonsterBys1tony.cookieMonsterButton.getIcon());
	  				cookieMenu.setAttribute("position", "end_before");
	  				menuItem.appendChild(cookieMenu);
	    		}
	    		else if (evt.type == 'popuphidden')
	    		{
	   				menuItem.hidden = true;
	  				cookieMenu.setAttribute("position", "before_end");
  					this._popupset.appendChild(cookieMenu);
				}        	
	        }
    	}
    },
    
    onKeyboardShortcut: function(evt)
    {
        if (evt.target.id == 'cookiemonster-s1tony-key')
    	{			    		
    	    // Check if cookiemonster-s1tony-menu popup is showing and hide
    	    var cookieMenu = document.getElementById("cookiemonster-s1tony-menu");

    		if (cookieMenu.state == 'open')
    		{
    			cookieMenu.hidePopup();
    		}
    		
    		cookieMenu.openPopup(null, "", 0, 0, false, false);
    	}    	
    }
}

//window.addEventListener("load", function(e) { cookieMonsterBys1tony.showCookieExceptions.onLoad(e); },
//false);
