/**
 * Handle Temporary Allow List by maintaining the config preference
 * CM_PREFERENCE_TYPE_COOKIE_TEMP
 * @type cookieMonsterBys1tony.tempAllow
 */
cookieMonsterBys1tony.tempAllow = 
{
    _cm: cookieMonsterBys1tony,

    init: function()
    {
		// Do nothing for now    	
	},
	
	/**
	 * Check if the host is already contained in this list
	 * @param {} aList
	 * @param {} elt
	 * @return Integer
	 */
    _requestHostIndexOf: function(aList, elt /*, checkDomain, from*/)
	{
		var len = aList.length >>> 0;
		var checkDomain = false || Boolean(arguments[2]);
	
		var from = Number(arguments[3]) || 0;
		from = (from < 0)
			? Math.ceil(from)
			: Math.floor(from);
		if (from < 0)
			from += len;

		if (!checkDomain)
		{
			for (; from < len; from++)
			{
	  			if (from in aList &&
	      			aList[from].split(';')[0] === elt)
	    		return from;    		
			}
		}
		else
		{
			for (; from < len; from++)
			{		
			    if (from in aList &&
	      			this._cm.cookieInfo.getSecondLevelHost(aList[from].split(';')[0]) === elt)
	    		return from;
			}
		}
		
		return -1;		
	},
	
	add: function(aURI)
	{
        // Only add if not already added
	    if (!this.isTempPermission(aURI))
	    {
	        // Check if URI already has a non-default cookie access
	        // Use CM_TOP_LEVEL because the level is already inherently defined
	        // by aURI in this case 
	        var accessLevel = this._cm.cookieInfo.checkPermissionArray(aURI, CM_PERMISSION_TYPE_COOKIE);
	        var accessValue = this._cm.cookieInfo.getPermissionValue(accessLevel[CM_TOP_LEVEL]);

	        this._cm.nsPreferences.setAppendToStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aURI.prePath + ';' + accessValue);
	    }
	},
	
	remove: function(aURI)
	{
	    this._cm.nsPreferences.setRemoveFromStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aURI.prePath);
	},

	// Check to see if aURI is a temporary permission
	isTempPermission: function(aURI)
	{
	    var retValue = false;
	    var tempList = this._cm.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);

	    // Each array item should contain a URI and a cookie preference,
	    // separated by a semicolon
	    for (var i = 0; i < tempList.length; i++)
	    {
	        var tempItem = tempList[i].split(';');

	        if (tempItem[0] === aURI.prePath)
	        {
	            retValue = true;
	            break;
	        }
	    }

	    return retValue;
	},

	/**
	 * Reset permission for aHost from temp allow
	 * back to original permission
	 * @param {string} aHost
	 * @return {Integer} Original Permission Setting
	 */
	resetTempCookie: function(aHost)
	{
	    var retValue = null;
	    var tempList = this._cm.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);

	    // Retrieve index position for aURI
	    var hostIndex = this._requestHostIndexOf(tempList, aHost);
	    //alert("Got to resetTempCookie:  hostIndex:  " + hostIndex + " " + tempList[hostIndex]);

	    // Reset cookie permissions back to previous setting and
	    // remove from preference string
	    if (hostIndex > -1)
	    {
	        this._resetTempCookieValues(tempList[hostIndex], hostIndex);
	        this._cm.nsPreferences.setRemoveFromStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aHost);
	        retValue = tempList[hostIndex].split(';')[1];
	    }

	    return retValue;
	},
	
	/**
	 * Reset temp cookie list
	 */
	resetTempCookies: function()
	{
	    var tempList = this._cm.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);
	    tempList.forEach(this._resetTempCookieValues, this);

	    this._cm.nsPreferences.clearUserPref(CM_PREFERENCE_TYPE_COOKIE_TEMP);
	},

    // Delete temp cookies from host and reset temp cookie permissions
	_resetTempCookieValues: function(aItem, aIndex)
	{
	    var hostURI = null;
	    var item = aItem.split(';');
	    var host = item[0];
	    var prefSetting = item[1];

	    // Set aUseBaseDomain to true
	    hostURI = this._cm.utils.createURIFromHostName(host, true);
	    this._cm.cookieInfo.deleteHostCookies(hostURI.asciiHost, true);

	    // Reset cookie permissions back to previous setting 
	    this._cm.cookieInfo.choice.setAccess(hostURI, prefSetting);
	}
}
