#include "TicTacToeApp.h"

// Implementation (for the .cpp file)

// This application instance is required or the app will not run
TicTacToeApp applicationInstance; 

// Constructor
TicTacToeApp::TicTacToeApp() {}

// Destructor
TicTacToeApp::~TicTacToeApp() {}

int TicTacToeApp::main(int, char **) {

	// Create a console window for text-output if not available
	CL_ConsoleWindow console("TicTacToeApp Console");
	console.redirect_stdio();

	try	{
		// CL initialization functions
		// These must be called or CL functions will not work
		// Also, SetupCore must be init()'ed first and denit()'ed last
		CL_SetupCore::init();
		CL_SetupDisplay::init();
		CL_SetupGL::init();

		// Set display mode
		CL_DisplayWindow window("TicTacToeApp", 500, 450);
		
		TicTacToeGame myGame;
		myGame.run();

		// CL deinitialization functions
		CL_SetupGL::deinit();
		CL_SetupDisplay::deinit();
		CL_SetupCore::deinit();

	} catch (CL_Error err) {
		std::cout << "Exception caught: " << err.message.c_str() << std::endl;

		// Display console close message and wait for a key
		console.display_close_message();
	}

	return 0;
}