# CiviCRM 5.58.0

Released February 1, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Support DedupeRules as Managed entities
  ([25227](https://github.com/civicrm/civicrm-core/pull/25227))**

  Adds support for Dedupe Rules as managed entities.

- **Add search/display details to searchKitTasks hook - allows for eg. filtering
  actions by search display
  ([25123](https://github.com/civicrm/civicrm-core/pull/25123) and
  [25482](https://github.com/civicrm/civicrm-core/pull/25482))**

  Improves the searchKitTasks hook by making details regarding the search
  display available.

- **Add Option Group descriptions from templates/CRM/Admin/Page/Options.tpl
  ([25143](https://github.com/civicrm/civicrm-core/pull/25143))**

  Makes the Option Group -> description field accessible to APIv4/SearchKit etc.

- **List of languages: Enable Croatian language by default
  ([25192](https://github.com/civicrm/civicrm-core/pull/25192))**

  Improves the list of languages by enabling Croatian by default.

- **Status Check - Raise severity of the check for signing keys
  ([25285](https://github.com/civicrm/civicrm-core/pull/25285))**

  Changes the Status Check for missing CIVICRM_SIGN_KEYS to throw an error
  instead of a notice.

- **Drop php 7.2 support from CiviCRM 5.58 (after 5.57 ESR)
  ([dev/core#3991](https://lab.civicrm.org/dev/core/-/issues/3991):
  [25147](https://github.com/civicrm/civicrm-core/pull/25147),
  [662](https://github.com/civicrm/civicrm-drupal/pull/662),
  [68](https://github.com/civicrm/civicrm-joomla/pull/68),
  [166](https://github.com/civicrm/civicrm-backdrop/pull/166) and
  [286](https://github.com/civicrm/civicrm-wordpress/pull/286))**

  Bumps the minimum PHP version to 7.3.0 (from 7.2).

### CiviContribute

- **Add datasource selector to generic import (so it can be used eg. with
  contribution import)
  ([25161](https://github.com/civicrm/civicrm-core/pull/25161) and
  [25427](https://github.com/civicrm/civicrm-core/pull/25427))**

  Makes CSV and SQL available as datasources for Contribution Imports.

### CiviMember

- **Add Membership entity to formbuilder
  ([25144](https://github.com/civicrm/civicrm-core/pull/25144))**

  Adds the Membership entity to Form Builder.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **htmlspecialchars() issue on PHP8 and CiviReport (Work Towards
  [dev/core#4047](https://lab.civicrm.org/dev/core/-/issues/4047):
  [356](https://github.com/civicrm/civicrm-packages/pull/356))**

  Fixes fatal error when running a CiviReport on PHP8 when htmlspecialchars()
  is called on an empty array.

- **Avoid 5.57 upgrade taking hours on large activity tables
  ([25380](https://github.com/civicrm/civicrm-core/pull/25380),
  [25437](https://github.com/civicrm/civicrm-core/pull/25437), and
  [25435](https://github.com/civicrm/civicrm-core/pull/25435))**

  The queries on `is_current_revision` and `original_id` perform badly on large
  activity tables. This change only runs them if you don't have a lot of
  activities. If it can't run the queries then it points you to a snippet which
  contains the queries you can run manually.

- **Configure Event Fees tab
  ([25120](https://github.com/civicrm/civicrm-core/pull/25120))**

  Makes the Fees tab on the Configure Event page, as well as the link to the
  Fees page from the Configure button on an event, conditionally dependent on
  whether CiviContribute is enabled.

- **Search Kit: Mailing labels don't work
  ([dev/core#3470](https://lab.civicrm.org/dev/core/-/issues/3470):
  [25164](https://github.com/civicrm/civicrm-core/pull/25164))**

  Fixes the Mailing Labels action for SearchKit displays.

- **Some renames missing from #24982
  ([25467](https://github.com/civicrm/civicrm-core/pull/25467))**

  This restores some class declarations that were changed in 5.57.0 without
  changing the corresponding DAO file names.

- **Cannot fill in FormBuilder fields when using Existing Contact autocomplete
  ([dev/core#4083](https://lab.civicrm.org/dev/core/-/issues/4083):
  [25374](https://github.com/civicrm/civicrm-core/pull/25374))**

- **correct logic for handling empty-array values for checkboxes
  ([23305](https://github.com/civicrm/civicrm-core/pull/23305))**

- **Only allow valid image types to be uploaded to image_URL field on profiles
  ([25217](https://github.com/civicrm/civicrm-core/pull/25217))**

- **Remove conditionals that rely on NULL not being NULL
  ([25183](https://github.com/civicrm/civicrm-core/pull/25183))**

- **Remove incorrect usages of {localize} in civicrm_data.tpl
  ([25172](https://github.com/civicrm/civicrm-core/pull/25172))**

- **SearchKit - Ensure id & name are defined when loading saved searches
  ([25146](https://github.com/civicrm/civicrm-core/pull/25146))**

- **searchkit - fix broken update task in dropdown
  ([25289](https://github.com/civicrm/civicrm-core/pull/25289))**

- **PHP8: callback function on GOTV must be static
  ([25200](https://github.com/civicrm/civicrm-core/pull/25200))**

- **Smarty notice fix on contact search results
  ([25261](https://github.com/civicrm/civicrm-core/pull/25261) and
  [25269](https://github.com/civicrm/civicrm-core/pull/25269))**

- **E_NOTICES on activity view
  ([25169](https://github.com/civicrm/civicrm-core/pull/25169))**

- **Enotice fixes, consolidation on Import datasource forms
  ([25141](https://github.com/civicrm/civicrm-core/pull/25141))**

- **Fix broken call to registerElementType in advmultiselect.php
  ([357](https://github.com/civicrm/civicrm-packages/pull/357))**

- **Fix `cv` failure on J3.
  ([25320](https://github.com/civicrm/civicrm-core/pull/25320))**

- **5.57.0 quotes typo: security 2x double quotes to 1x double quotes
  ([25316](https://github.com/civicrm/civicrm-core/pull/25316))**

- **Fix Civix not correctly loading Mixins
  ([totten/civix#257](https://github.com/totten/civix/issues/257):
  [25179](https://github.com/civicrm/civicrm-core/pull/25179))**

- **5.58 rc upgrade error
  ([dev/core#40095](https://lab.civicrm.org/dev/core/-/issues/4095):
  [25421](https://github.com/civicrm/civicrm-core/pull/25421))**

  If logging is enabled, this updates the schema of the logging table for
  `civicrm_option_group` before adding description values to it.

- **Fix APIv4 autocomplete for dynamic entities ([#25490](https://github.com/civicrm/civicrm-core/pull/25490))**

### CiviCase

- **Fix smarty notices on Open Case
  ([25165](https://github.com/civicrm/civicrm-core/pull/25165))**

### CiviContribute

- **Pagination and counts for soft credits on contact contribution tab are
  broken ([dev/core#4063](https://lab.civicrm.org/dev/core/-/issues/4063):
  [25460](https://github.com/civicrm/civicrm-core/pull/25460))**

- **Fix Contributions listing crash due to getLineItemTitle returning null
  ([25300](https://github.com/civicrm/civicrm-core/pull/25300))**

- **Fix APIv4 autocomplete for contributions ([dev/core#4104](https://lab.civicrm.org/dev/core/-/issues/4104): [#25485](https://github.com/civicrm/civicrm-core/pull/25485))**

### CiviEvent

- **Offline Event confirmation receipt prints waitlist message
  ([dev/core#4087](https://lab.civicrm.org/dev/core/-/issues/4087):
  [25370](https://github.com/civicrm/civicrm-core/pull/25370))**

  The email sent from an offline event registration incorrectly included the
  waitlist message.

- **Fix missing default values for required fields in event registration setup
  ([25410](https://github.com/civicrm/civicrm-core/pull/25410))**

### CiviMail

- **E_WARNING on bulk email activity view
  ([25193](https://github.com/civicrm/civicrm-core/pull/25193))**

### CiviPetition

- **Petition ThankYou.tpl: fix strong typo
  ([25275](https://github.com/civicrm/civicrm-core/pull/25275))**

## <a name="misc"></a>Miscellany

- **Status Check - Add check to ensure that MySQL timezones are
  operational ([#25367](https://github.com/civicrm/civicrm-core/pull/25367))**

- **Standardise method of getting entity in imports
  ([25173](https://github.com/civicrm/civicrm-core/pull/25173))**

- **Divide & conquer, `initSet` no longer shared as much code is not
  ([25184](https://github.com/civicrm/civicrm-core/pull/25184))**

- **Post code-divide tidy-up
  ([25194](https://github.com/civicrm/civicrm-core/pull/25194))**

- **Simplify params on now-private function
  ([25182](https://github.com/civicrm/civicrm-core/pull/25182))**

- **Remove legacy code payment processor handling
  ([25240](https://github.com/civicrm/civicrm-core/pull/25240))**

- **Remove broken method CRM_Utils_File::isHtml()
  ([25233](https://github.com/civicrm/civicrm-core/pull/25233))**

- **Remove deprecated ids from OptionValue::add
  ([25223](https://github.com/civicrm/civicrm-core/pull/25223))**

- **Remove unreachable code (since 2020)
  ([25268](https://github.com/civicrm/civicrm-core/pull/25268))**

- **Move legacy search selector file to legacy search extension
  ([25264](https://github.com/civicrm/civicrm-core/pull/25264))**

- **Remove Mar 2020 deprecated functions
  ([25260](https://github.com/civicrm/civicrm-core/pull/25260))**

- **AssetBuilder - Fix `testInvalid()` failure. Switch to JWT.
  ([25305](https://github.com/civicrm/civicrm-core/pull/25305))**

- **Move newly added Help Test to Inline folder to match Core Folder structure
  ([25281](https://github.com/civicrm/civicrm-core/pull/25281))**

- **Extract `getMembershipBlock`
  ([25238](https://github.com/civicrm/civicrm-core/pull/25238))**

- **Remove unnecessary pass-by-ref
  ([25263](https://github.com/civicrm/civicrm-core/pull/25263))**

- **Remove unused variable
  ([25257](https://github.com/civicrm/civicrm-core/pull/25257))**

- **Simplify dataProvider in queryTest
  ([25255](https://github.com/civicrm/civicrm-core/pull/25255))**

- **Php layer consolidation on Import DataSource form
  ([25142](https://github.com/civicrm/civicrm-core/pull/25142))**

- **Remove reference to 'dataArray' from text version of
  contribution_online_receipt
  ([25186](https://github.com/civicrm/civicrm-core/pull/25186))**

- **Remove no-longer-used noisily deprecated function
  `CRM_Contact_Form_Task_PDFLetterCommon::createActivities`
  ([25152](https://github.com/civicrm/civicrm-core/pull/25152))**

- **Move part of deprecated function `loadRelatedObjects` to calling functions
  ([25267](https://github.com/civicrm/civicrm-core/pull/25267))**

- **Remove empty param declarations in docblocks
  ([25252](https://github.com/civicrm/civicrm-core/pull/25252))**

- **PHPDoc corrections
  ([25266](https://github.com/civicrm/civicrm-core/pull/25266))**

- **[REF][PHP8.2] Avoid dynamic properties in civicrm_api3 class
  ([25253](https://github.com/civicrm/civicrm-core/pull/25253))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Activity_BAO_ICalendar
  ([25245](https://github.com/civicrm/civicrm-core/pull/25245))**

- **[REF][PHP8.2] Avoid dynamic properties in mailstores
  ([25243](https://github.com/civicrm/civicrm-core/pull/25243))**

- **[REF][PHP8.2] Update Composer Patches to latest version to fix notice issue
  in php8.2 ([25212](https://github.com/civicrm/civicrm-core/pull/25212))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Utils_Signer
  ([25244](https://github.com/civicrm/civicrm-core/pull/25244))**

- **[REF][PHP8.2] Further resolve some deprecation issues around dynamic class
  properties ([25202](https://github.com/civicrm/civicrm-core/pull/25202))**

- **[REF] Fix a couple of errors in PHP8.2
  ([25196](https://github.com/civicrm/civicrm-core/pull/25196))**

- **[REF] Update Composer Compile Lib with latest version
  ([25203](https://github.com/civicrm/civicrm-core/pull/25203))**

- **(REF) CiviUnitTestCase - Cleanup and simplify the DB-reset mechanism
  ([25178](https://github.com/civicrm/civicrm-core/pull/25178))**

- **[REF] Create Alter Column function in upgrade base class
  ([25174](https://github.com/civicrm/civicrm-core/pull/25174))**

- **[REF] [merge custom fields function] Stop returning unaltered cFields
  parameter (good unit test cover)
  ([25221](https://github.com/civicrm/civicrm-core/pull/25221))**

- **[REF] Fix strstr deprecation in CustomDataByType class
  ([25230](https://github.com/civicrm/civicrm-core/pull/25230))**

- **(REF) Remove _tagElement dynamic property
  ([25265](https://github.com/civicrm/civicrm-core/pull/25265))**

- **[REF] [merge custom fields] Only call function when applicable  
  (well tested code)
  ([25222](https://github.com/civicrm/civicrm-core/pull/25222))**

- **[NFC] Restore locale properly after test
  ([25276](https://github.com/civicrm/civicrm-core/pull/25276))**

- **NFC cleanup in test class
  ([25258](https://github.com/civicrm/civicrm-core/pull/25258))**

- **(NFC) Fix documented return type on getByClass method
  ([25246](https://github.com/civicrm/civicrm-core/pull/25246))**

- **(NFC) When using @var annotations, ensure type comes first
  ([25242](https://github.com/civicrm/civicrm-core/pull/25242))**

- **[NFC] Remove line that does nothing
  ([25234](https://github.com/civicrm/civicrm-core/pull/25234))**

- **[NFC] Fix @method documentation for shouldExitAfterFatal
  ([25236](https://github.com/civicrm/civicrm-core/pull/25236))**

- **[NFC] php8 - Unit test for empty checkbox array #23305
  ([25201](https://github.com/civicrm/civicrm-core/pull/25201))**

- **NFC: Fix variable name in activity import
  ([25205](https://github.com/civicrm/civicrm-core/pull/25205))**

- **(NFC) PrevNextTest - Fix warning about "@group"
  ([25168](https://github.com/civicrm/civicrm-core/pull/25168))**

- **[REF] Bump UA Parser to 0.7.33
  ([25423](https://github.com/civicrm/civicrm-core/pull/25423))**

- **distmaker - Fix 'WordPress' entry in JSON report
  ([25424](https://github.com/civicrm/civicrm-core/pull/25424))**

- **Update dompdf to 2.0.2 ([#25492](https://github.com/civicrm/civicrm-core/pull/25492))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; BrightMinded Ltd - Bradley Taylor;
CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; Coop SymbioTIC - Mathieu Lutfy; craft-coders.de - Sebastian Gellweiler;
Dave D; Ginkgo Street Labs - Michael Z Daryabeygi; JMA Consulting - Monish Deb,
Seamus Lee; Systopia - Johannes; Megaphone Technology Consulting - Jon Goldberg;
MJW Consulting - Matthew Wire; Squiffle Consulting - Aidan Saunders; Third
Sector Design - Kurund Jalmi; Wikimedia Foundation - Eileen McNaughton;
Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
