# CiviCRM 5.39.0

Released July 7, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Separate the default language for contacts from the site language (Work Towards
  [dev/core#2584](https://lab.civicrm.org/dev/core/-/issues/2584):
  [20214](https://github.com/civicrm/civicrm-core/pull/20214))**

  Improves user experience for multilingual sites by separating the
  CiviCRM contacts default language setting from the site default language.

- **Canonize API for storing translated data (Work Towards
  [dev/translation#67](https://lab.civicrm.org/dev/translation/-/issues/67):
  [20478](https://github.com/civicrm/civicrm-core/pull/20478))**

  Defines a "Translation" table (`civicrm_translation`), to represent a single
  translated string (e.g. a translated message-title or a translated
  event-description).

- **Allow for the default number of search results to be configurable
  ([dev/core#2187](https://lab.civicrm.org/dev/core/-/issues/2187):
  [20336](https://github.com/civicrm/civicrm-core/pull/20336 and
  [18969](https://github.com/civicrm/civicrm-core/pull/18969))**

  Creates a setting to define the number of search results to be returned.

- **Give the custom CSS file a 'name' to make it easier to manipulate in
  hook_civicrm_alterBundle()
  ([20278](https://github.com/civicrm/civicrm-core/pull/20278))**

  Gives the resource bundles custom CSS file a useful 'name' to make it easier
  to manipulate in the alterBundle hook.

- **OAuth: initial support for per-contact OAuth tokens
  ([20189](https://github.com/civicrm/civicrm-core/pull/20189))**

  Adds a system for managing OAuthContactTokens -- tokens linked to a
  contact_id.

- **BAOs, Tests, etal - Support `HookInterface` and `EventSubscriberInterface`
  for auto-registration
  ([20427](https://github.com/civicrm/civicrm-core/pull/20427))**

  Expands the functionality for declaring event-listeners in different classes,
  making it easier to participate in Symfony events.

- **The version numbers for core-extensions should match core-proper.
  ([dev/release#17](https://lab.civicrm.org/dev/release/-/issues/17):
  [20303](https://github.com/civicrm/civicrm-core/pull/20303) and
  [20302](https://github.com/civicrm/civicrm-core/pull/20302))**

  Ensures that CiviCRM core extension version numbers are updated to match the
  core release they are included in and denotes development stage of extensions
  using icons.

- **Enable/Disable Extension Receives API Error (Work Towards
  [dev/core#2646](https://lab.civicrm.org/dev/core/-/issues/2646):
  [20564](https://github.com/civicrm/civicrm-core/pull/20564))**

  Improves the error messages when disabling or enabling an extension causes an
  API Error.

- **Regen.sh/setup.sh would be nice if the output for civicrm_generated.mysql
  had long lines broken up
  ([dev/core#1549](https://lab.civicrm.org/dev/core/-/issues/1549):
  [20513](https://github.com/civicrm/civicrm-core/pull/20513))**

  Improves display of civicrm_generated.mysql output so its easier to read.

- **Use new crm-angular-js instead of ng-app to bootstrap AngularJS
  ([20419](https://github.com/civicrm/civicrm-core/pull/20419))**

  Updates the method used to bootstrap Angular for internal consistency and so
  that multiple angular apps can be used on the same page.

- **APIv4 - Save custom fields in bulk
  ([20269](https://github.com/civicrm/civicrm-core/pull/20269))**

  Makes it so custom fields can be saved in bulk thru APIv4.

- **Add APIv4 Batch.create spec
  ([20501](https://github.com/civicrm/civicrm-core/pull/20501))**

  Adds a spec for APIv4 Batch.create.

- **APIv4 - Make the @searchable flag explicit for OptionList type entities.
  ([20560](https://github.com/civicrm/civicrm-core/pull/20560))**

  Improves code for categorizing entities for SearchKit, making searchability
  easier to grok and less magical/mysterious.

- **Apiv4 entity parity (Work Towards
  [dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [20559](https://github.com/civicrm/civicrm-core/pull/20559),
  [20499](https://github.com/civicrm/civicrm-core/pull/20499),
  [20464](https://github.com/civicrm/civicrm-core/pull/20464),
  [20609](https://github.com/civicrm/civicrm-core/pull/20609),
  [20433](https://github.com/civicrm/civicrm-core/pull/20433) and
  [20474](https://github.com/civicrm/civicrm-core/pull/20474))**

  Works towards APIv4 parity with APIv3 by adding the following entities to
  APIv4: WordReplacement, FinancialItem and ACLEntityRole.

- **Introduce civi.api4.authorizeRecord and civi.api4.validate
  ([20533](https://github.com/civicrm/civicrm-core/pull/20533))**

  Refactors APIv4 code so that events use more consistent style (ie
  civi.api4.{$TASK} with alias civi.api4.{$TASK}::{$ENTITY}).

- **APIv4 Entity.get refactor to be more efficient
  ([20470](https://github.com/civicrm/civicrm-core/pull/20470))**

  Makes APIv4 Entity.get more efficient.

- **APIv4 - Return id_field as part of Entity.get
  ([20457](https://github.com/civicrm/civicrm-core/pull/20457))**

  Improves APIv4 metadata so it returns the name of the unique identifier field
  for each entity (usually but not always named "id").

- **Add DedupeRule, DedupeRuleGroup and DedupeException API4 entity
  ([20466](https://github.com/civicrm/civicrm-core/pull/20466))**

  Adds the following entities to APIv4: DedupeRule, DedupeRuleGroup and
  DedupeException.

- **Use PHPUnit8 in main test suites
  ([20370](https://github.com/civicrm/civicrm-core/pull/20370))**

  Makes phpunit8 the default test runner for PHP versions greater than 7.2 for
  the core test suites.

- **Link styling with default greenwich theme is not linklike on search kit
 screen ([dev/core#2403](https://lab.civicrm.org/dev/core/-/issues/2403):
 [20341](https://github.com/civicrm/civicrm-core/pull/20341))**

  Improves the SearchKit user interface by making links blue so that they are
  easier to find.

- **Afform - Improve Gui, prefill & submit APIs
 ([20383](https://github.com/civicrm/civicrm-core/pull/20383))**

  Standardizes prefill & submit APIs to use the same logic for validating
  contacts. Displays correct form URL in the Afform GUI depending on is_frontend
  setting. Shows warning about url arguments to prevent unintentional
  permissions escalation.

- **Afform Gui - Add support for entityRef fields
 ([20216](https://github.com/civicrm/civicrm-core/pull/20216))**

  Adds a widget to Afform for EntityRef to autocomplete contacts & other
  entities, allows the autocomplete field to be changed to Number (for entering
  ID) or Select (for choosing another entity on a form).

- **Afform Entity Reference Submit
 ([20305](https://github.com/civicrm/civicrm-core/pull/20305))**

  Improves Afform Submit handling to handle entity reference fields that
  reference other form elements.

- **SearchKit - allow searches based on relationships
  ([20558](https://github.com/civicrm/civicrm-core/pull/20558))**

  Allows SearchKit searches based on relationships.

- **SearchKit - Add API filter for contacts in groups and smart groups
  ([20507](https://github.com/civicrm/civicrm-core/pull/20507))**

  Adds a filter-style field to search for contacts in (or not in) one or more
  groups.

- **SearchKit - Update `hook_civicrm_searchKitTasks` signature
  ([20467](https://github.com/civicrm/civicrm-core/pull/20467))**

  Updates the hook_civicrm_searchKitTasks signature to include checkPermissions
  and userId.

- **SearchKit - Add static groups and organize main entity selector
  ([20434](https://github.com/civicrm/civicrm-core/pull/20434))**

  Adds static (non-smart) groups to SearchKit, and organizes main entity
  selector to be less cluttered, with primary entities up top and the rest
  within a collapsible optgroup.

- **SearchKit and Afform UI improvements
  ([20348](https://github.com/civicrm/civicrm-core/pull/20348))**

  Cleans up the admin UI for SearchKit and Afform, adds click-to-sort table
  headers and fixes a bug where SavedSearch modified_date were not being saved.

- **SearchKit - Rename crmSearchActions module to crmSearchTasks & add hook
  ([20307](https://github.com/civicrm/civicrm-core/pull/20307))**

  Adds hook_civicrm_searchKitTasks() to make it easy for other extensions to add
  tasks specific to SearchKit. Also renames the module for consistency.

- **[php8-compat] Upgrade PHPWord Package to support php8
  ([20449](https://github.com/civicrm/civicrm-core/pull/20449))**

  Work towards making CiviCRM php8 compatible, specifically by upgrading PHPWord
  Package.

- **[php8-compat] Upgrade TCPDF version to support php8
  ([20540](https://github.com/civicrm/civicrm-core/pull/20540))**

  Work Towards making CiviCRM php8 compatible specifically by upgrading TCPDF.

- **Consider joining the GitHub Sponsors program
  ([community/sustainability#20](https://lab.civicrm.org/community/sustainability/-/issues/20):
  [248](https://github.com/civicrm/civicrm-wordpress/pull/248) and
  [62](https://github.com/civicrm/civicrm-joomla/pull/62))**

  Adds a sponsor link as apart of the GitHub Sponsors program.

- **Change the help text for Message Templates and Scheduled Reminders to
  include link to CiviCRM Token Documentation page
  ([20259](https://github.com/civicrm/civicrm-core/pull/20259))**

  Improves user experience by linking to CiviCRM Token documentation from the
  Message Templates and Scheduled Reminders forms.

- **authx - Accept API keys by default
  ([20081](https://github.com/civicrm/civicrm-core/pull/20081))**

  Relaxes the default settings so that it is easier to use authx
  as a replacement for extern/rest.php (which uses the api_key for
  authentication).

### CiviCase

- **Add defaults for APIv4 Case create
  ([20306](https://github.com/civicrm/civicrm-core/pull/20306))**

  Adds the following defaults for APIv4 Case.create:
  - default Case Creator = current user
  - default Case Start Date = now

### CiviContribute

- **Improve Sample data by ensuring all Credit Card Contributions have a
  transaction id and that they are shown to be linked to the test payment
  processor ([20312](https://github.com/civicrm/civicrm-core/pull/20312))**

  Improves CiviContribute sample date.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **"You do not have permission to access this page" when exporting participants
  in Search Kit
  ([dev/report#67](https://lab.civicrm.org/dev/report/-/issues/67):
  [20528](https://github.com/civicrm/civicrm-core/pull/20528))**

  Fixes an 'access denied' error on standalone SearchKit export forms, caused by
  renaming the PHP classes.

- **500 error saving Search Kit Smart Group sorted on aggregated field
  ([dev/report#68](https://lab.civicrm.org/dev/report/-/issues/68):
  [20610](https://github.com/civicrm/civicrm-core/pull/20610))**

- **Fatal error reported when photo cannot be found
  ([dev/core#2369](https://lab.civicrm.org/dev/core/-/issues/2369):
  [20447](https://github.com/civicrm/civicrm-core/pull/20447))**

- **Loss of translation when copying (cloning) entities (multilingual)
  ([dev/core#2479](https://lab.civicrm.org/dev/core/-/issues/2479):
  [20059](https://github.com/civicrm/civicrm-core/pull/20059))**

- **Fatal error while upgrading smart-group data
  ([dev/core#2659](https://lab.civicrm.org/dev/core/-/issues/2659):
  [20756](https://github.com/civicrm/civicrm-core/pull/20756/))**

- **CRM_Utils_File::isAbsolute does not respect PHP stream wrappers (Work
  Towards [dev/core#2590](https://lab.civicrm.org/dev/core/-/issues/2590):
  [20270](https://github.com/civicrm/civicrm-core/pull/20270))**

  Removes unused function.

- **Installer doesn't check MySQL version properly
  ([dev/core#2602](https://lab.civicrm.org/dev/core/-/issues/2602):
  [20255](https://github.com/civicrm/civicrm-core/pull/20255))**

- **Useradd task gives a deprecation notice for the password confirmation field
  ([dev/core#2613](https://lab.civicrm.org/dev/core/-/issues/2613):
  [20347](https://github.com/civicrm/civicrm-core/pull/20347))**

- **APIv4 - Delete undocumented deprecated activityType lookup
  ([20506](https://github.com/civicrm/civicrm-core/pull/20506))**

  Deletes an undocumented APIv4 quirk that's been giving deprecated warnings for
  over a year.

- **APIv4 - Fix getFields to respect default_value from getFields
  ([20481](https://github.com/civicrm/civicrm-core/pull/20481))**

- **AfformGui - Fix tabs when cms theme adds extra margin
  ([20431](https://github.com/civicrm/civicrm-core/pull/20431))**

- **Afform GUI - Fix tab breakage in Shoreditch theme
  ([20416](https://github.com/civicrm/civicrm-core/pull/20416))**

- **Afform drag n drop fixes
  ([20281](https://github.com/civicrm/civicrm-core/pull/20281) and
  [20263](https://github.com/civicrm/civicrm-core/pull/20263))**

- **Afform - Fix custom field handling and add tests
  ([20480](https://github.com/civicrm/civicrm-core/pull/20480))**

- **Afform - hide disabled contact types & entities from disabled
  components/extensions
  ([20283](https://github.com/civicrm/civicrm-core/pull/20283))**

  Cleans up and improves Afform's internal entity lookup so it won't show
  disabled entities.

- **SearchKit - Fix link target selection
  ([20537](https://github.com/civicrm/civicrm-core/pull/20537))**

- **SearchKit - Fix menu permission
  ([20349](https://github.com/civicrm/civicrm-core/pull/20349))**

- **SearchKit - Organize ON clause field selectors with joined entity first
  ([20454](https://github.com/civicrm/civicrm-core/pull/20454))**

- **[php8-compat] Fix some more examples of where required parameters are after
  optional parameters in function declaration
  ([20515](https://github.com/civicrm/civicrm-core/pull/20515))**

- **[php8-compat] Fix PHP Beautifier notice by conditionally assigning dynamic
  foreign key to the template
  ([20509](https://github.com/civicrm/civicrm-core/pull/20509))**

- **[php8-compat] Fix issue in APIv3 Where by because product has a column
  called options the testCreateSingleValueAlter triggers a cannot access offset
  of type string on string in php8
  ([20508](https://github.com/civicrm/civicrm-core/pull/20508))**

- **[php8-compat] Fix issue with returning bool from uasort by using the
  spaceship operator
  ([20502](https://github.com/civicrm/civicrm-core/pull/20502))**

- **[php8-compat] Fix Upgrade call back issues by making functions static and
  also fixing an issue with an array key not existing when checking obsolete
  extensions ([20503](https://github.com/civicrm/civicrm-core/pull/20503))**

- **Update PHPUnit for PHPUnit8 config to ensure we don't cache test results
  ([645](https://github.com/civicrm/civicrm-drupal/pull/645),
  [140](https://github.com/civicrm/civicrm-backdrop/pull/140) and
  [249](https://github.com/civicrm/civicrm-wordpress/pull/249))**

- **[php8-compat] Fix calling method_exist with paremeter that is bool not an
  object in php8 ([323](https:

- **[php8-compat] Fix calling method_exist with paremeter that is bool not an
  object in php8 ([20443](https://github.com/civicrm/civicrm-core/pull/20443))**

- **[php8-compat] Fix deprecation error where by required function parameter
  follows an optional function parameter
  ([20473](https://github.com/civicrm/civicrm-core/pull/20473))**

- **[php8-compat] Fix Warning Notices when running schema generation
  ([20445](https://github.com/civicrm/civicrm-core/pull/20445))**

- **[php8-compat] Update Various Symfony components to latest version in the
  3.4.x series to fix deprecation notice around libxml entity disable
  ([20444](https://github.com/civicrm/civicrm-core/pull/20444))**

- **Fix the populateTempTable to be more direct
  ([20548](https://github.com/civicrm/civicrm-core/pull/20548))**

- **Sort trigger data before processing
  ([20541](https://github.com/civicrm/civicrm-core/pull/20541))**

- **Allow legacy warnings to be fully suppressed in PropertyBag
  ([20331](https://github.com/civicrm/civicrm-core/pull/20331))**

- **Prevent adding duplicate dashlet if present with same name and label
  ([20375](https://github.com/civicrm/civicrm-core/pull/20375))**

- **Ensure contacts without a name are updated when primary email changes
  ([20403](https://github.com/civicrm/civicrm-core/pull/20403))**

- **fix arguments sent to hook_civicrm_check
  ([20400](https://github.com/civicrm/civicrm-core/pull/20400))**

- **Fix Distmaker building by ensuring we are rsyncing from the right folder
  ([20353](https://github.com/civicrm/civicrm-core/pull/20353))**

- **Fix mandatory keys check fail for value of float 0.0 in a required key in an
  entity ([20342](https://github.com/civicrm/civicrm-core/pull/20342))**

- **Fix extraneous white space in generated SQL
  ([20340](https://github.com/civicrm/civicrm-core/pull/20340))**

- **Fix case sensitive parameter for call to getCustomFieldTokens
  ([20333](https://github.com/civicrm/civicrm-core/pull/20333))**

- **Fix CKEditor5 link editing in modal dialog
  ([20285](https://github.com/civicrm/civicrm-core/pull/20285))**

- **Correct copy-paste error in CustomField schema
  ([20329](https://github.com/civicrm/civicrm-core/pull/20329))**

- **Explicitly throw an error/status bounce on Edit/New if no types.
  ([19840](https://github.com/civicrm/civicrm-core/pull/19840))**

- **Core_DAO - Fire links_callback for all entities
  ([20332](https://github.com/civicrm/civicrm-core/pull/20332))**

- **Get county fields populated via api call
  ([20309](https://github.com/civicrm/civicrm-core/pull/20309))**

  Ensure that county fields are properly populated when calling the
  Profile.getfields api.

- **Activate user when no activation is required
  ([20229](https://github.com/civicrm/civicrm-core/pull/20229))**

  Ensures that any user created on a site that does not require admin approval
  is considered active.

- **Switch to non deprecated buildPermissionClause() for contact detail report
  ([20314](https://github.com/civicrm/civicrm-core/pull/20314))**

- **Switch to non deprecated buildPermissionClause() for contact summary report
  ([20287](https://github.com/civicrm/civicrm-core/pull/20287))**

- **Freeze readonly fields
  ([20204](https://github.com/civicrm/civicrm-core/pull/20204))**

- **CiviCRM Scheduled Reminders, Subject field missing Token selector - users
  must copy Token from Body field to Subject
  ([20260](https://github.com/civicrm/civicrm-core/pull/20260))**

- **Fix delete customgroup using API4 so it removes data table
  ([20265](https://github.com/civicrm/civicrm-core/pull/20265))**

- **hook_managed - Do not try to disable managed entities if is_active is not
  available to api3.create
  ([20144](https://github.com/civicrm/civicrm-core/pull/20144))**

- **DB/DataObject: use mb_strtolower because in turkish, INSERT becomes Insert
  ([324](https://github.com/civicrm/civicrm-packages/pull/324))**

### CiviCase

- **APIv4 - CiviCase API: Fix opening a case with current user as creator
  ([20238](https://github.com/civicrm/civicrm-core/pull/20238))**

- **My Cases dashlet no longer working (javascript network error - blank
  dashlet) ([dev/core#2606](https://lab.civicrm.org/dev/core/-/issues/2606):
  [20275](https://github.com/civicrm/civicrm-core/pull/20275))**

## CiviContribute

- **PayPal fails to create contribution following duplicate merge when
  membership record has been deleted
  ([dev/core#2593](https://lab.civicrm.org/dev/core/-/issues/2593):
  [20422](https://github.com/civicrm/civicrm-core/pull/20422),
  [20424](https://github.com/civicrm/civicrm-core/pull/20424),
  [20246](https://github.com/civicrm/civicrm-core/pull/20246) and
  [20300](https://github.com/civicrm/civicrm-core/pull/20300))**

- **"Pay Now" button on user dashboard is only for Pending, not Partially Paid
  contributions
  ([dev/financial#173](https://lab.civicrm.org/dev/financial/-/issues/173):
  [20376](https://github.com/civicrm/civicrm-core/pull/20376))**

  Ensures the 'Pay Now' buttons on the user dashboard are displayed for
  partially paid contributions.

- **Do not error on view contribution recur if not displaying contributions
  ([20209](https://github.com/civicrm/civicrm-core/pull/20209))**

- **Fix for tax rates being mangled on contribution update
  ([20357](https://github.com/civicrm/civicrm-core/pull/20357))**

- **Add call to validateAllContributions & fix getTotalAmount
  ([20391](https://github.com/civicrm/civicrm-core/pull/20391))**

- **Add warning when url_site is not specified for paypal (it won't work if not
  set) ([20082](https://github.com/civicrm/civicrm-core/pull/20082))**

- **Typo when retrieving help_pre textarea attributes for price field
  ([20276](https://github.com/civicrm/civicrm-core/pull/20276))**

- **Fix old-ish regression on paypal standard self-service cancel links
  ([20210](https://github.com/civicrm/civicrm-core/pull/20210))**

- **Don't pass doPayment by reference in Contribution.transact API
  ([20463](https://github.com/civicrm/civicrm-core/pull/20463))**

- **If paymentprocessor still uses doTransferCheckout/doDirectPayment trigger
  deprecated function warning
  ([20384](https://github.com/civicrm/civicrm-core/pull/20384))**

- **Convert payJunction to doPayment
  ([20326](https://github.com/civicrm/civicrm-core/pull/20326))**

- **Convert FirstData to doPayment
  ([20325](https://github.com/civicrm/civicrm-core/pull/20325))**

- **Convert elavon to doPayment
  ([20324](https://github.com/civicrm/civicrm-core/pull/20324))**

- **Convert Realex to doPayment
  ([20327](https://github.com/civicrm/civicrm-core/pull/20327))**

- **Convert payflowpro to doPayment
  ([20328](https://github.com/civicrm/civicrm-core/pull/20328))**

- **Convert eway to doPayment
  ([20323](https://github.com/civicrm/civicrm-core/pull/20323))**

- **Convert AuthorizeNet to doPayment()
  ([20322](https://github.com/civicrm/civicrm-core/pull/20322))**

- **Sample payment processor types are misaligned in the sample data
  ([dev/core#2614](https://lab.civicrm.org/dev/core/-/issues/2614):
  [20311](https://github.com/civicrm/civicrm-core/pull/20311))**

### CiviMail

- **<link> URLs are tracked and shouldn't be
  ([dev/mail#95](https://lab.civicrm.org/dev/mail/-/issues/95):
  [20129](https://github.com/civicrm/civicrm-core/pull/20129))**

  Ensures link tracking is applied only to URLs inside <a> tags.

### CiviMember

- **Creating a relationship fails when a related membership has a contact
  reference custom field.
  ([dev/membership#37](https://lab.civicrm.org/dev/membership/-/issues/37):
  [20493](https://github.com/civicrm/civicrm-core/pull/20493))**

- **Use line items to look up memberships
  ([20495](https://github.com/civicrm/civicrm-core/pull/20495))**

- **Use order api when creating a recurring membership from the Membership
  ([20077](https://github.com/civicrm/civicrm-core/pull/20077))**

### Drupal Integration

- **AuthX extension: user_load() deprecated in Drupal 8.x.
  ([dev/core#2636](https://lab.civicrm.org/dev/core/-/issues/2636):
  [20479](https://github.com/civicrm/civicrm-core/pull/20479))**

- **drush install - Bump up entropy for autogenerated creds. Add signing key.
  ([128](https://github.com/civicrm/civicrm-backdrop/pull/128))**

### WordPress Integration

- **[php8-compat] Fix undefined property on Array Cache class in wordpress on
  PHP8 ([20491](https://github.com/civicrm/civicrm-core/pull/20491))**

- **Remove Base Page content filter once it has been used
  ([dev/wordpress#91](https://lab.civicrm.org/dev/wordpress/-/issues/91):
  [240](https://github.com/civicrm/civicrm-wordpress/pull/240))**

  Fixes a bug where CiviCRM content would repeat itself in certain page
  configurations.

## <a name="misc"></a>Miscellany

- **Add file_exists check on loading services xml
  ([20620](https://github.com/civicrm/civicrm-core/pull/20620))**

- **APIv4 - Cleanup getFields, add @internal flag for non-public field
  attributes ([20489](https://github.com/civicrm/civicrm-core/pull/20489))**

- **Extract code that populates temp table for an individual group
  ([20458](https://github.com/civicrm/civicrm-core/pull/20458))**

- **Cleanup - declare return types, remove unused var
  ([20363](https://github.com/civicrm/civicrm-core/pull/20363))**

- **Bump lodash from 4.17.19 to 4.17.21
  ([20247](https://github.com/civicrm/civicrm-core/pull/20247))**

- **Bump DOMPDF to `~1.0.0`
  ([20465](https://github.com/civicrm/civicrm-core/pull/20465))**

- **Make functions protected
  ([20455](https://github.com/civicrm/civicrm-core/pull/20455))**

- **Deprecate function CRM_Core_BAO_CustomField::bulkSave
  ([20367](https://github.com/civicrm/civicrm-core/pull/20367))**

- **Cleanup tracking on group.load
  ([20310](https://github.com/civicrm/civicrm-core/pull/20310))**

- **Describe logic behind placement of `invalidateRouteCache`
  ([20414](https://github.com/civicrm/civicrm-core/pull/20414))**

- **Fix internal group contact cache functions to be protected
  ([20385](https://github.com/civicrm/civicrm-core/pull/20385))**

- **Clarify types on `hook_custom` and `hook_customPre`
  ([20488](https://github.com/civicrm/civicrm-core/pull/20488))**

- **Cleanup references to old dedupe class names
  ([20492](https://github.com/civicrm/civicrm-core/pull/20492))**

- **Switch l10n.js from ajax callback to assetBuilder
  ([20121](https://github.com/civicrm/civicrm-core/pull/20121))**

- **ACLEntityRole BAO tidy fixes
  ([20504](https://github.com/civicrm/civicrm-core/pull/20504))**

- **Dedupe DAO is out of date
  ([20534](https://github.com/civicrm/civicrm-core/pull/20534))**

- **Switch table mapping to square bracket array syntax.
  ([20535](https://github.com/civicrm/civicrm-core/pull/20535))**

- **Update civicrm_generated (5.39 version)
  ([20571](https://github.com/civicrm/civicrm-core/pull/20571))**

- **[REF] Cannot edit CiviCRM Joomla permissions (access control) in 5.37.0
  (Clean up for [dev/core#2601](https://lab.civicrm.org/dev/core/-/issues/2601):
  [20271](https://github.com/civicrm/civicrm-core/pull/20271))**

- **Revised fix for menu/UI issues for Joomla 4.0
  ([20401](https://github.com/civicrm/civicrm-core/pull/20401))**

- **[php8-compat] Fix Include/Exclude Group Custom Search Tests by better
  handling empty arrays on exclusions in the custom search
  ([20539](https://github.com/civicrm/civicrm-core/pull/20539))**

- **[php8-compat] Fix Resources Test issue due to undefined array key add
  CacheCode ([20538](https://github.com/civicrm/civicrm-core/pull/20538))**

- **[php8-compat] Fix api_v3_PaymentTest failures by putting in more guards into
  message templates
  ([20520](https://github.com/civicrm/civicrm-core/pull/20520))**

- **[php8-compat] Update smarty templates and some PHP files to get the
  api_v3_contribution testclass to pass on php8
  ([20512](https://github.com/civicrm/civicrm-core/pull/20512))**

- **[php8-compact] Add in guards into various templates to fix hook tests in
  php8 ([20542](https://github.com/civicrm/civicrm-core/pull/20542))**

- **[php8-compact] Fix Report tests failing on php8
  ([20549](https://github.com/civicrm/civicrm-core/pull/20549))**

- **[php8-compat] Partial Fix of hook tests for php8
  ([20545](https://github.com/civicrm/civicrm-core/pull/20545))**

- **[php8-compat] [REF] Fix a couple of functions triggering deprecation notices
  in php 8.0 where by an optional parameter is before required parameters in the
  function signature
  ([20442](https://github.com/civicrm/civicrm-core/pull/20442))**

- **[php8-compat] [REF] Fix call to function CRM_Utils_String::createRandom by
  ensuring that the length is the first parameter not 2nd
  ([20441](https://github.com/civicrm/civicrm-core/pull/20441))**

- **[php8-compat][NFC] Ensure that the 2nd parameter of hash_equals is a string
  in authx ([20483](https://github.com/civicrm/civicrm-core/pull/20483))**

- **[php8-compat][NFC] Fix using ZipArchive::open on an empty file
  ([20500](https://github.com/civicrm/civicrm-core/pull/20500))**

- **[php8-compat][NFC] Fix issue where by we are tryiing to access array keys
  that haven't been created yet
  ([20496](https://github.com/civicrm/civicrm-core/pull/20496))**

- **[REF][php8-compat] Fix more instances of where there is a required parameter
  for a function after an optional one and fix an issue where by a NULL function
  property is treated as not exisiting in php8
  ([20497](https://github.com/civicrm/civicrm-core/pull/20497))**

- **[REF][php8-compat] Further fixes where there is a required paramater after
  an optional paramater
  ([20490](https://github.com/civicrm/civicrm-core/pull/20490))**

- **[php8-compat][REF] Fix some more test failures in php8
  ([20516](https://github.com/civicrm/civicrm-core/pull/20516))**

- **[php8-compat][REF] Fix api_v3_contributionpagetest on php8
  ([20518](https://github.com/civicrm/civicrm-core/pull/20518))**

- **[php8-compat][REF] Fix more php8 test failures caused by template issues
  ([20517](https://github.com/civicrm/civicrm-core/pull/20517))**

- **[php8-compat][REF] Fix php8 error on undefined constant
  CIVICRM_DISABLE_DEFAULT_MENU
  ([20485](https://github.com/civicrm/civicrm-core/pull/20485))**

- **[php8-compat][REF] Fix Date unit tests in php8 by passing in 00 instead of
  null for hours,minutes and seconds
  ([20525](https://github.com/civicrm/civicrm-core/pull/20525))**

- **[php8-compact][REF] Fix another couple of places where by there are required
  variables in php function declaration after optional ones
  ([20526](https://github.com/civicrm/civicrm-core/pull/20526))**

- **[php8-compact][REF] Fix api_v3_PaymentTokenTest to work on php8
  ([20527](https://github.com/civicrm/civicrm-core/pull/20527))**

- **[php8-compat][REF] Fix Case and Custom data tests by adding guards in to
  templates ([20524](https://github.com/civicrm/civicrm-core/pull/20524))**

- **[php8-compat][phpunit8][NFC] Fix PHPUnit Warnings and fix a php error on
  function declaration syntax in core extension tests
  ([20477](https://github.com/civicrm/civicrm-core/pull/20477))**

- **Remove extraneous debug
  ([20319](https://github.com/civicrm/civicrm-core/pull/20319))**

- **Remove legacy references to partial_amount_to_pay
  ([20358](https://github.com/civicrm/civicrm-core/pull/20358))**

- **Remove remains of md5 check from authorizenet
  ([20406](https://github.com/civicrm/civicrm-core/pull/20406))**

- **Remove deprecation of order-must-be-pending
  ([20205](https://github.com/civicrm/civicrm-core/pull/20205))**

- **Remove some unused variables
  ([20487](https://github.com/civicrm/civicrm-core/pull/20487))**

- **Remove never-passed parameter from now unshared function
  ([20304](https://github.com/civicrm/civicrm-core/pull/20304))**

- **Remove defunct default return property
  ([20139](https://github.com/civicrm/civicrm-core/pull/20139))**

- **Remove now-unused ids parameter from signature
  ([20299](https://github.com/civicrm/civicrm-core/pull/20299))**

- **Remove unused functions from payJunction
  ([20417](https://github.com/civicrm/civicrm-core/pull/20417))**

- **Remove unused variable on dummy processor
  ([20418](https://github.com/civicrm/civicrm-core/pull/20418))**

- **Remove pass-by-ref as param not altered
  ([20475](https://github.com/civicrm/civicrm-core/pull/20475))**

- **[REF] (Code style) To const, or not const - that is the event
  ([dev/core#1744](https://lab.civicrm.org/dev/core/-/issues/1744):
  [20555](https://github.com/civicrm/civicrm-core/pull/20555))**

- **[REF] Extract function to get locks
  ([20373](https://github.com/civicrm/civicrm-core/pull/20373))**

- **[REF] Remove unused variable
  ([20378](https://github.com/civicrm/civicrm-core/pull/20378))**

- **[REF] Slightly more logical order of code
  ([20368](https://github.com/civicrm/civicrm-core/pull/20368))**

- **[REF] Extract code to transfer groups from temp table to cache
  ([20435](https://github.com/civicrm/civicrm-core/pull/20435))**

- **[REF] Remove never-passed param
  ([20456](https://github.com/civicrm/civicrm-core/pull/20456))**

- **[REF] APIv4 refactoring to support calculated fields
  ([20440](https://github.com/civicrm/civicrm-core/pull/20440))**

- **[REF] Set receipt_date after sending, (from batch) not in anticipation
  ([20395](https://github.com/civicrm/civicrm-core/pull/20395))**

- **[REF] Minor extraction - getInfoUrl
  ([20421](https://github.com/civicrm/civicrm-core/pull/20421))**

- **[REF] Fix issue where by mailing urls were always stuck in the original
  language not the overriden language in a multilingual site
  ([20102](https://github.com/civicrm/civicrm-core/pull/20102))**

- **[REF] Paypal pro - remove call to load contact record
  ([20423](https://github.com/civicrm/civicrm-core/pull/20423))**

- **[REF] Stop passing unneed params to the recur function
  ([20412](https://github.com/civicrm/civicrm-core/pull/20412))**

- **[REF] Replace isFirst parameter
  ([20411](https://github.com/civicrm/civicrm-core/pull/20411))**

- **[REF] Remove now-unused params
  ([20410](https://github.com/civicrm/civicrm-core/pull/20410))**

- **[REF] Paypal IPN - Cleanup references to completion
  ([20407](https://github.com/civicrm/civicrm-core/pull/20407))**

- **[REF] Replace deprecated code call
  ([20409](https://github.com/civicrm/civicrm-core/pull/20409))**

- **[REF] Cleanup validation in PaypalProIPN single function
  ([20360](https://github.com/civicrm/civicrm-core/pull/20360))**

- **[REF] Minor simplification
  ([20393](https://github.com/civicrm/civicrm-core/pull/20393))**

- **[REF] Useradd contact task - Use OO instead of hardcoding "if Wordpress"
  ([20366](https://github.com/civicrm/civicrm-core/pull/20366))**

- **[REF] Cleanup on import rows error
  ([20196](https://github.com/civicrm/civicrm-core/pull/20196))**

- **[REF] Extract function to build temporary table of members of group from
  Report_Form ([20297](https://github.com/civicrm/civicrm-core/pull/20297))**

- **[REF] Remove now-unused parameter
  ([20354](https://github.com/civicrm/civicrm-core/pull/20354))**

- **[REF] Extract getContributionObject
  ([20355](https://github.com/civicrm/civicrm-core/pull/20355))**

- **[REF] Add getter for contributionID
  ([20318](https://github.com/civicrm/civicrm-core/pull/20318))**

- **[REF] Make previous unshared function protected & Remove hard-coded params
  ([20345](https://github.com/civicrm/civicrm-core/pull/20345))**

- **[REF] Update Pear Validate Finance CreditCard to use latest tagged release
  that now includes the improved mastercard 2bin regex
  ([20351](https://github.com/civicrm/civicrm-core/pull/20351))**

- **[REF] Make previously unshared function protected
  ([20346](https://github.com/civicrm/civicrm-core/pull/20346))**

- **[REF] Remove unused parameters
  ([20301](https://github.com/civicrm/civicrm-core/pull/20301))**

- **[REF] Cleanup BAO_ActionSchedule::getlist() signature
  ([20239](https://github.com/civicrm/civicrm-core/pull/20239))**

- **(REF) Regen CRM/Core/DAO/CustomField.php
  ([20337](https://github.com/civicrm/civicrm-core/pull/20337))**

- **[REF] Remove redundant call to clearGroupContactCache
  ([20243](https://github.com/civicrm/civicrm-core/pull/20243))**

- **[REF] [tests only] Replace direct calls to enable logging with calls to the
  setting ([20460](https://github.com/civicrm/civicrm-core/pull/20460))**

- **[REF] Remove function parameter only used from test
  ([20459](https://github.com/civicrm/civicrm-core/pull/20459))**

- **[REF] Extract code determining list of groups requiring a refresh
  ([20242](https://github.com/civicrm/civicrm-core/pull/20242))**

- **REF - Cleanup array key checking to use array_key_exists
  ([20563](https://github.com/civicrm/civicrm-core/pull/20563))**

- **[REF] CRM_Contact_Task - Use short array syntax
  ([20562](https://github.com/civicrm/civicrm-core/pull/20562))**

- **[REF] Fix Authx tests on Druapl 8/9 by ensuring that we only return an id
  for the user id if it is greater than 0
  ([20498](https://github.com/civicrm/civicrm-core/pull/20498))**

- **[REF] Move ACLPermission Trait into Civi Folder so that it can be accessed
  by Extensions ([20208](https://github.com/civicrm/civicrm-core/pull/20208))**

- **[REF] Use function to getContributionRecurID
  ([20293](https://github.com/civicrm/civicrm-core/pull/20293))**

- **[REF] Duplicate processMembership preliminary to cleanup
  ([20295](https://github.com/civicrm/civicrm-core/pull/20295))**

- **[REF] Switch to using getContributionRecurID function, remove now unused
  param ([20316](https://github.com/civicrm/civicrm-core/pull/20316))**

- **[REF] Fully remove ids variable from paypal std
  ([20317](https://github.com/civicrm/civicrm-core/pull/20317))**

- **[REF] Make use of recently added default pager size setting in Reports
  ([20273](https://github.com/civicrm/civicrm-core/pull/20273))**

- **[REF] Duplicate & deprecate processMembership
  ([20313](https://github.com/civicrm/civicrm-core/pull/20313))**

- **[REF] Provide standardised methods to get recurring contribution id & object
  ([20294](https://github.com/civicrm/civicrm-core/pull/20294))**

- **[REF] Reverse if statement
  ([20211](https://github.com/civicrm/civicrm-core/pull/20211))**

- **Mark test class as having invalid financials
  ([20448](https://github.com/civicrm/civicrm-core/pull/20448))**

- **Update eventcart test to only test payment form
  ([20405](https://github.com/civicrm/civicrm-core/pull/20405))**

- **Fix profile test teardown
  ([20439](https://github.com/civicrm/civicrm-core/pull/20439))**

- **Fix separate payment membership test to create valid financial transactions
  ([20436](https://github.com/civicrm/civicrm-core/pull/20436))**

- **fix missing parent tearDown
  ([20261](https://github.com/civicrm/civicrm-core/pull/20261) and
  [20262](https://github.com/civicrm/civicrm-core/pull/20262))**

- **Fix v3 api payment test to validate on postAssert
  ([20530](https://github.com/civicrm/civicrm-core/pull/20530))**

- **Fix Financial item test to validate Financials
  ([20532](https://github.com/civicrm/civicrm-core/pull/20532))**

- **Mark DetailTest as having invalid financials
  ([20552](https://github.com/civicrm/civicrm-core/pull/20552))**

- **Fix form params for testEventPaymentForms
  ([20330](https://github.com/civicrm/civicrm-core/pull/20330))**

- **Update bulkSave test to use the api
  ([20362](https://github.com/civicrm/civicrm-core/pull/20362))**

- **Fix contribution page pledge tests to create valid contributions
  ([20404](https://github.com/civicrm/civicrm-core/pull/20404))**

- **Improve cleanup on contact test
  ([20248](https://github.com/civicrm/civicrm-core/pull/20248))**

- **Test fix up for AdditionalPaymentTest
  ([20521](https://github.com/civicrm/civicrm-core/pull/20521))**

- **Test fix - assertion fails when run with other tests (sometimes)
  ([20250](https://github.com/civicrm/civicrm-core/pull/20250))**

- **[Test] Improve cleanup of domain contacts
  ([20253](https://github.com/civicrm/civicrm-core/pull/20253))**

- **Test - fix contributionTest to validate contributions
  ([20415](https://github.com/civicrm/civicrm-core/pull/20415))**

- **Test fixes ([20426](https://github.com/civicrm/civicrm-core/pull/20426))**

- **Tax fixes in unit test
  ([20390](https://github.com/civicrm/civicrm-core/pull/20390))**

- **[Test] Add test cover for contribution tokens in pdf letter
  ([20217](https://github.com/civicrm/civicrm-core/pull/20217))**

- **Unit test for #20342
  ([20361](https://github.com/civicrm/civicrm-core/pull/20361))**

- **Add test for mixed Order data
  ([20241](https://github.com/civicrm/civicrm-core/pull/20241))**

- **Add unit test for #20144
  ([20320](https://github.com/civicrm/civicrm-core/pull/20320))**

- **Superficial tidy up in test class
  ([20359](https://github.com/civicrm/civicrm-core/pull/20359))**

- **[NFC] Remove timecop function references from Cache Tiered Test
  ([20343](https://github.com/civicrm/civicrm-core/pull/20343))**

- **[NFC] Superficial code cleanup
  ([20446](https://github.com/civicrm/civicrm-core/pull/20446))**

- **[NFC] Cleanup in test class
  ([20402](https://github.com/civicrm/civicrm-core/pull/20402))**

- **[NFC] {test} code cleanup in test class
  ([20389](https://github.com/civicrm/civicrm-core/pull/20389))**

- **[NFC] Minor cleanup
  ([20387](https://github.com/civicrm/civicrm-core/pull/20387))**

- **[NFC] Minor code cleanup
  ([20386](https://github.com/civicrm/civicrm-core/pull/20386))**

- **[NFC] Fix PHPUnit8 Deprecation Warnings in api_v3 and Civi Test Suites
  ([20380](https://github.com/civicrm/civicrm-core/pull/20380))**

- **[NFC] [Test] Big cleanup in test class
  ([20374](https://github.com/civicrm/civicrm-core/pull/20374))**

- **[NFC] Fix PHPUnit8 Deprecation warnings in the api_v4 Test Suite
  ([20381](https://github.com/civicrm/civicrm-core/pull/20381))**

- **[NFC] Fix PHPUnit8 Warning notices in E2E And in some API unit tests
  ([20379](https://github.com/civicrm/civicrm-core/pull/20379))**

- **[NFC] Fix PHPUnit8 deprecation warnings in the CRM_AllTests suite
  ([20377](https://github.com/civicrm/civicrm-core/pull/20377))**

- **[NFC] Further cleanup in test class
  ([20372](https://github.com/civicrm/civicrm-core/pull/20372))**

- **[NFC] Add in more voids to unit tests to support PHPUnit8
  ([20369](https://github.com/civicrm/civicrm-core/pull/20369))**

- **[NFC] [Test] Preliminary cleanup in test class
  ([20371](https://github.com/civicrm/civicrm-core/pull/20371))**

- **[NFC] Add in voids to various setUpBeforeClass and tearDownAfterClass
  functions ([20365](https://github.com/civicrm/civicrm-core/pull/20365))**

- **[NFC] Update PHPUnit config to not cache results in phpunit8 and add more
  voids into PayflowProTest
  ([20356](https://github.com/civicrm/civicrm-core/pull/20356))**

- **[NFC] Add in unit tests of credit card validation rules
  ([20352](https://github.com/civicrm/civicrm-core/pull/20352))**

- **[NFC/TEST] - Add unit test enforcing automatic chaining for financial
  type/account creation via api
  ([20288](https://github.com/civicrm/civicrm-core/pull/20288))**

- **[NFC] Test - Improve tearDown cleanup of domain contacts
  ([20258](https://github.com/civicrm/civicrm-core/pull/20258))**

- **[NFC] Test - fix to use v3 api on postAsserts
  ([20257](https://github.com/civicrm/civicrm-core/pull/20257))**

- **[NFC] Fix phpunit9 deprecation issues on using assertType instead of more
  explicit assertIsArray or AssertIsInt
  ([20567](https://github.com/civicrm/civicrm-core/pull/20567))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma;
CiviCRM - Coleman Watts, Tim Otten; CompuCorp - Ahed Eid; Coop SymbioTIC -
Mathieu Lutfy, Samuel Vanhove; Dave D; iXiam - Vangelis Pantazis; JMA
Consulting - Monish Deb, Seamus Lee; Lemniscus - Noah Miller; Megaphone
Technology Consulting - Jon Goldberg; MJCO - Mikey O'Toole; MJW Consulting -
Matthew Wire; Nicol Wistreich; Progressive Technology Project - Jamie
McClelland; Richard van Oosterhout; Robert J. Lang; Squiffle Consulting - Aidan
Saunders; Wikimedia Foundation - Eileen McNaughton; Wildsight - Lars
Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman;  Business & Code - Alain Benbassat;  CiviDesk -
Nicolas Ganivet, Yashodha Chaku;  CompuCorp - Jamie Novick;  Coop SymbioTIC -
Mathieu Lutfy, Samuel Vanhove;  Dave D;  Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit;  Semper IT - Karin Gerritsen;  SYSTOPIA
Organisationsberatung - Björn Endres; Tadpole Collective - Kevin Cristiano


## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
