# CiviCRM 4.7.30

Released February 7, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21380](https://issues.civicrm.org/jira/browse/CRM-21380) Add setting to
  block activity type from sending assignee notification
  ([11222](https://github.com/civicrm/civicrm-core/pull/11222))**

  Site administrators can now choose to suppress activity assignee notifications
  for certain activity types even while assignee notifications are enabled for
  other activity types.

- **Increase minimum php version requirements
  ([11416](https://github.com/civicrm/civicrm-core/pull/11416))**

  CiviCRM now requires a minimum of PHP 5.4 to run or install, though versions
  below 5.6 are not advised and will display a notice.  PHP 7.0 is the
  recommended version.

- **[CRM-21406](https://issues.civicrm.org/jira/browse/CRM-21406) Create
  Standalone Export Form
  ([11254](https://github.com/civicrm/civicrm-core/pull/11254))**

  Entities such as contacts, cases, and others can now be exported from a form
  at a URL specifying the IDs of each entity to export.

- **[CRM-21584](https://issues.civicrm.org/jira/browse/CRM-21584) Add `CrmRegion`
  Tag to Contact Actions menu template
  ([11439](https://github.com/civicrm/civicrm-core/pull/11439))**

  The "Actions" menu item at the top of a contact record now is now specified as
  a region where extensions can easily insert markup.

- **[CRM-21389](https://issues.civicrm.org/jira/browse/CRM-21389) Add Regions to
  Contact UserDashBoard
  ([11235](https://github.com/civicrm/civicrm-core/pull/11235))**

  The frontend user dashboard now has regions specified before and after each
  section.  Extensions can now easily instert markup in these regions.

- **[CRM-13123](https://issues.civicrm.org/jira/browse/CRM-13123) Handle
  value-separated fields at the dao level
  ([11394](https://github.com/civicrm/civicrm-core/pull/11394))**

  There are various ways serialized data is stored as strings in the database,
  but handling of this was generally ad-hoc.  This change documents each field's
  serialization type (e.g. delimited values, PHP serialization, or JSON) and
  implements a common utility for serializing and unserializing values.

- **[CRM-21530](https://issues.civicrm.org/jira/browse/CRM-21530) Call post hook
  after activity is filed on case
  ([11385](https://github.com/civicrm/civicrm-core/pull/11385))**

  `hook_civicrm_post` is now invoked for a `CaseActivity` entity when an
  activity is filed to a case.  This allows extension developers to have certain
  actions be triggered by the event.

- **[CRM-21499](https://issues.civicrm.org/jira/browse/CRM-21499) Add filter to
  manage tags page ([11368](https://github.com/civicrm/civicrm-core/pull/11368)
  and [11352](https://github.com/civicrm/civicrm-core/pull/11352))**

  An administrator may now filter the list of tags by partial name on the Manage
  Tags page.

- **[CRM-21443](https://issues.civicrm.org/jira/browse/CRM-21443) Add support
  for auto-complete fields in the batch update forms
  ([11290](https://github.com/civicrm/civicrm-core/pull/11290))**

  Previously, the batch update form would exclude autocomplete-select custom
  fields.  This adds support for them.

- **[CRM-21286](https://issues.civicrm.org/jira/browse/CRM-21286) expose active
  flag in UI for group
  ([11103](https://github.com/civicrm/civicrm-core/pull/11103))**

  A checkbox when editing a group now allows changing whether the group is
  active.

- **[CRM-21483](https://issues.civicrm.org/jira/browse/CRM-21483) Move anguar
  module crmRouteBinder to core
  ([11328](https://github.com/civicrm/civicrm-core/pull/11328))**

  A new data sync method for AngularJS, `crmRouteBinder`, is now available in
  core.  It had previously been part of the new CiviCase extension.

- **[CRM-21497](https://issues.civicrm.org/jira/browse/CRM-21497)
  crmRouteBinder: add deep comparison option
  ([11345](https://github.com/civicrm/civicrm-core/pull/11345))**

  There is now the option for the `crmRouteBinder` AngularJS data sync method to
  notice changes that may be deep within a nested object or array.

- **[CRM-20681](https://issues.civicrm.org/jira/browse/CRM-20681) Automatically
  search when switching options in Quicksearch
  ([10466](https://github.com/civicrm/civicrm-core/pull/10466))**

  The quick search box in the menu bar supports a variety of options.  When the
  box has search text and a user clicks another option, the box immediately runs
  a search based upon that new option.

- **[CRM-21204](https://issues.civicrm.org/jira/browse/CRM-21204) Show Import
  Progress Bar for Activity, Contribution and Membership imports
  ([11007](https://github.com/civicrm/civicrm-core/pull/11007))**

  This fixes the progress bar interface for activity, contribution, and
  membership imports to match that for contact imports.

- **[CRM-21449](https://issues.civicrm.org/jira/browse/CRM-21449) Add location
  field to Activity Report
  ([11296](https://github.com/civicrm/civicrm-core/pull/11296))**

  The activity report can now display and filter by the activity location.

- **[CRM-21419](https://issues.civicrm.org/jira/browse/CRM-21419) Prevent users
  from accidentally creating a single activity when they want multiple
  activities ([11264](https://github.com/civicrm/civicrm-core/pull/11264))**

  When creating an activity with multiple target contacts, you are now required
  to choose whether to create a single activity with all of the targets together
  or one activity with each of the targets by itself.  Previously, the single
  activity was default, and a checkbox allowed creating separate activities.

- **[CRM-21349](https://issues.civicrm.org/jira/browse/CRM-21349) Increase
  timeout of status message after batch merge.
  ([11195](https://github.com/civicrm/civicrm-core/pull/11195))**

  The status message after a batch merge now must be manually dismissed.

- **[CRM-21416](https://issues.civicrm.org/jira/browse/CRM-21416) Add reset link
  beside 'Search' button below Advance Search form
  ([11260](https://github.com/civicrm/civicrm-core/pull/11260))**

  The Reset Form link is now available at both the bottom and the top of the
  Advanced Search form.

- **[CRM-21408](https://issues.civicrm.org/jira/browse/CRM-21408) Api explorer -
  better defaults for sequential checkbox
  ([11256](https://github.com/civicrm/civicrm-core/pull/11256))**

  When using the API Explorer, the "Sequential" checkbox is now unchecked for
  actions other than `Get` and entirely hidden for `Getsingle`.

- **[CRM-21551](https://issues.civicrm.org/jira/browse/CRM-21551) Add parameter
  to support skipping processing greetings when calling api contact.create
  ([11405](https://github.com/civicrm/civicrm-core/pull/11405))**

  When creating or updating a contact via the API, you may now bypass the
  process that updates the contact's greeting values.

- **[CRM-21547](https://issues.civicrm.org/jira/browse/CRM-21547) Add UI order
  by options to Contact logging summary report
  ([11402](https://github.com/civicrm/civicrm-core/pull/11402))**

  The Contact Logging Summary report can now be sorted by log date, the contact
  that was altered, or the contact making the change.

### CiviCase

- **[CRM-21446](https://issues.civicrm.org/jira/browse/CRM-21446) Allow case id
  as well as hash in inbound email processing to autofile emails on cases
  ([11320](https://github.com/civicrm/civicrm-core/pull/11320))**

  Inbound emails can now specify a case ID and be accurately filed to the
  corresponding case.

- **[CRM-21360](https://issues.civicrm.org/jira/browse/CRM-21360) Make 'Open
  Case' Activity Optional When Defining Case Types
  ([11204](https://github.com/civicrm/civicrm-core/pull/11204))**

  A case type can now be defined without an "Open Case" activity type.

### CiviContribute

- **[CRM-21448](https://issues.civicrm.org/jira/browse/CRM-21448) Need a link
  from contribution record when there is no cid in the url
  ([11295](https://github.com/civicrm/civicrm-core/pull/11295))**

  The contact display name on a contribution is now displayed as a link to the
  contact record.

- **[CRM-21106](https://issues.civicrm.org/jira/browse/CRM-21106) Move financial
  type ACL clause for reports into extension
  ([10901](https://github.com/civicrm/civicrm-core/pull/10901))**

  In order to use financial type ACLs in a report, you must install the [Access
  Control by Financial Type
  Reports](https://civicrm.org/extensions/access-control-by-financial-type-for-reports)
  extension.

- **[CRM-21577](https://issues.civicrm.org/jira/browse/CRM-21577) Add links to
  payment blocks to allow payments
  ([11432](https://github.com/civicrm/civicrm-core/pull/11432))**

  When a contribution listing displays payments beneath each contribution,
  Record Payment links now appear beneath partially paid contributions.

- **[CRM-21454](https://issues.civicrm.org/jira/browse/CRM-21454) Add money
  raised on page contribution widget ajax response
  ([11299](https://github.com/civicrm/civicrm-core/pull/11299))**

  The AJAX data used to populate contribution page widgets now return the amount
  raised as its own value.

- **[CRM-21400](https://issues.civicrm.org/jira/browse/CRM-21400) Add in static
  var on contribution thank you page to hold trxn id
  ([11247](https://github.com/civicrm/civicrm-core/pull/11247))**

  Extension developers can now access the transaction ID when customizing the
  thank you page.

### CiviMail

- **[CRM-21378](https://issues.civicrm.org/jira/browse/CRM-21378) Incorporate
  email abuse report as a spam type of bounce
  ([11226](https://github.com/civicrm/civicrm-core/pull/11226))**

  Email abuse reports from email providers are now recorded similarly to spam
  report bounce messages, causing them to be handled as more severe bounces.

- **[CRM-21476](https://issues.civicrm.org/jira/browse/CRM-21476) Rename
  'Clicks' to 'Unique Clicks' in mailing summary report
  ([11319](https://github.com/civicrm/civicrm-core/pull/11319))**

  The "Clicks" item in the mailing summary report is now specified as "Unique
  Clicks" to highlight the fact that it displays the number of *recipients* who
  clicked items rather than the number of actual clicks.

- **[CRM-21567](https://issues.civicrm.org/jira/browse/CRM-21567) Add email
  filter for Mail Bounce Report
  ([11415](https://github.com/civicrm/civicrm-core/pull/11415))**

  The Mail Bounce Report can now be filtered by email address.

- **[CRM-21486](https://issues.civicrm.org/jira/browse/CRM-21486) Support
  multiple test mail
  ([11332](https://github.com/civicrm/civicrm-core/pull/11332))**

  Multiple addresses can be set as recipients for test messages from the
  CiviMail composition form.

- **[CRM-21279](https://issues.civicrm.org/jira/browse/CRM-21279) Rebuild
  recipient list and calculate count on demand, store result in $cacheFactory
  ([11091](https://github.com/civicrm/civicrm-core/pull/11091))**

  Automatic calculation of the number of recipients on a CiviMail mailing is now
  optional; otherwise, there is a new "Estimate recipient count" button that
  manually calculates the number of recipients.

- **[CRM-21472](https://issues.civicrm.org/jira/browse/CRM-21472) Make CiviMail
  token validation extensible
  ([11316](https://github.com/civicrm/civicrm-core/pull/11316))**

  Extensions using FlexMailer can now alter the list of required tokens (such as
  an unsubscribe URL and the domain address) for CiviMail messages.

- **[CRM-21383](https://issues.civicrm.org/jira/browse/CRM-21383) Load message
  templates on demand in CiviMail compose UI
  ([11267](https://github.com/civicrm/civicrm-core/pull/11267))**

  Message templates are now loaded only when needed rather than upon opening the
  CiviMail composition form.

### CiviMember

- **[CRM-21504](https://issues.civicrm.org/jira/browse/CRM-21504) Add membership
  to recurring contribution detail
  ([11358](https://github.com/civicrm/civicrm-core/pull/11358))**

  If a recurring contribution auto-renews a membership, a link to the membership
  now appears when viewing the recurring contribution.

### Drupal Integration

- **[CRM-21341](https://issues.civicrm.org/jira/browse/CRM-21341) Drupal 8 Hook
  Support ([11171](https://github.com/civicrm/civicrm-core/pull/11171))**

  CiviCRM now invokes CiviCRM hook implementations in Drupal 8 modules.

- **[CRM-21093](https://issues.civicrm.org/jira/browse/CRM-21093) Move CiviCRM
  initialization out of service constructor (in Drupal 8) and into method
  ([11379](https://github.com/civicrm/civicrm-core/pull/11379)) (completes prior
  work)**

  CiviCRM core now initializes using a new method that was modified in the past.

### WordPress Integration

- **[CRM-21470](https://issues.civicrm.org/jira/browse/CRM-21470) Add support
  for WordPress Polylang plugin
  ([11333](https://github.com/civicrm/civicrm-core/pull/11333) and
  [11312](https://github.com/civicrm/civicrm-core/pull/11312))**

  CiviCRM can now inherit the CMS language from WordPress sites with the
  Polylang plugin, working similarly to WPML and other CMSes.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21473](https://issues.civicrm.org/jira/browse/CRM-21473) Adding new
  permission for adding notes and fixing existing issues with notes permissions
  ([11314](https://github.com/civicrm/civicrm-core/pull/11314))**

  Users with the ability to view contacts were previously able to add notes by
  using a specially-crafted URL to reach the New Note form even if they lacked
  the ability to edit the contact.  This change requires a new permission to add
  notes, and it requires the permission to edit the contact in order to edit or
  delete notes.

- **[CRM-14343](https://issues.civicrm.org/jira/browse/CRM-14343) Import Error
  File Maxes out at 250
  ([11233](https://github.com/civicrm/civicrm-core/pull/11233))**

  This removes a limit that would only display the first 250 rows of errors from
  an import.

- **[CRM-21229](https://issues.civicrm.org/jira/browse/CRM-21229) Manage Group
  page is slow if you have smart groups
  ([11050](https://github.com/civicrm/civicrm-core/pull/11050)) (completes
  previous work)**

  Some adjustments were made to improve related tests and to prevent problems
  over repeated test runs.

- **[CRM-21518](https://issues.civicrm.org/jira/browse/CRM-21518) and
  [CRM-21539](https://issues.civicrm.org/jira/browse/CRM-21539) Add missing
  structure divs in templates
  ([11369](https://github.com/civicrm/civicrm-core/pull/11369) and
  [11396](https://github.com/civicrm/civicrm-core/pull/11396))**

  Many administrative forms had minor inconsistencies in their markup,
  complicating the task of retheming.  This adds missing `div` elements and
  classes.

- **[CRM-21180](https://issues.civicrm.org/jira/browse/CRM-21180) Inline changes
  to custom fields aren't reflected in custom greetings
  ([11364](https://github.com/civicrm/civicrm-core/pull/11364))**

  This resolves a bug where greetings that use custom fields would not update to
  reflect changes that are made through inline edits to those fields.

- **[CRM-21298](https://issues.civicrm.org/jira/browse/CRM-21298) Don't offer to
  fix indices until we can do it right
  ([11250](https://github.com/civicrm/civicrm-core/pull/11250))**

  A change in 2017 introduced a warning on the system status page if a site
  lacks a database index that CiviCRM expects.  The warning message would offer
  to "update indices" in the database, resolving the problem.  However, the
  update would fail on some sites due to a database error.

  This change merely suppresses the warning message while work is done to
  improve the update process.

- **[CRM-21433](https://issues.civicrm.org/jira/browse/CRM-21433) Optimize dupe
  checking in Recent Items stack
  ([11281](https://github.com/civicrm/civicrm-core/pull/11281))**

  The Recent Items list now suppresses duplicate items according to their entity
  type and ID.  Previously, duplicates were checked using the URL, which may
  place parameters in a different order each time.

- **[CRM-21409](https://issues.civicrm.org/jira/browse/CRM-21409) Don't bypass
  hooks when updating thankyou_sent/receipt_sent fields via PDF letter action
  ([11257](https://github.com/civicrm/civicrm-core/pull/11257))**

- **[CRM-21398](https://issues.civicrm.org/jira/browse/CRM-21398) Error when
  exporting cases
  ([11245](https://github.com/civicrm/civicrm-core/pull/11245))**

  This sets all ID fields on the temporary table for exports to have a length of
  255, reducing the likelihood of values being to long when exported.

- **[CRM-21001](https://issues.civicrm.org/jira/browse/CRM-21001) E-notice in
  com_civicrm/civicrm/CRM/Core/BAO/SchemaHandler.php on line 730
  ([11307](https://github.com/civicrm/civicrm-core/pull/11307))**

- **[CRM-21412](https://issues.civicrm.org/jira/browse/CRM-21412) Do not give
  fatal error on report when no fields selected
  ([11259](https://github.com/civicrm/civicrm-core/pull/11259))**

  A report with no columns selected now gracefully shows no results.

- **[CRM-21552](https://issues.civicrm.org/jira/browse/CRM-21552) Dedupe Rule :
  get contact type name instead of label
  ([11406](https://github.com/civicrm/civicrm-core/pull/11406))**

  The form for editing dedupe rules would validate by contact type label
  (potentially translated) rather than name.

- **[CRM-21534](https://issues.civicrm.org/jira/browse/CRM-21534) Key UI
  elements fail when fetching activity records from MariaDB
  ([11395](https://github.com/civicrm/civicrm-core/pull/11395))**

- **[CRM-21535](https://issues.civicrm.org/jira/browse/CRM-21535) Custom file
  upload field not showing up when Viewing Activity from Case Report
  ([11386](https://github.com/civicrm/civicrm-core/pull/11386))**

- **[CRM-21531](https://issues.civicrm.org/jira/browse/CRM-21531) Multi-select
  custom field searches can crash on MariaDB
  ([11388](https://github.com/civicrm/civicrm-core/pull/11388))**

  This resolves an inconsistency in how MySQL and MariaDB would apply RegEx for
  searching multiple-value delimited custom fields.

- **[CRM-21466](https://issues.civicrm.org/jira/browse/CRM-21466) Fix (obscure)
  enotice when updating greeting for contact, add test
  ([11310](https://github.com/civicrm/civicrm-core/pull/11310))**

- **[CRM-21469](https://issues.civicrm.org/jira/browse/CRM-21469) Cannot remove
  all groups when editing a contact
  ([11311](https://github.com/civicrm/civicrm-core/pull/11311))**

- **[CRM-21363](https://issues.civicrm.org/jira/browse/CRM-21363) Ensure that
  tests run using ONLY_FULL_GROUP_BY sql_mode for mysql 5.7
  ([11208](https://github.com/civicrm/civicrm-core/pull/11208))**

- **[CRM-21344](https://issues.civicrm.org/jira/browse/CRM-21344) Links to
  documentation from installer error messages are broken
  ([11190](https://github.com/civicrm/civicrm-core/pull/11190))**

- **[CRM-21214](https://issues.civicrm.org/jira/browse/CRM-21214) Chaining
  shared addresses doesn't work correctly
  ([11324](https://github.com/civicrm/civicrm-core/pull/11324)) (follow-up on
  previous work)**

  This resolves a bug causing a crash when passing "null" as a string for an
  address master ID.

- **[CRM-20861](https://issues.civicrm.org/jira/browse/CRM-20861) Location type
  does not show for custom address fields
  ([10650](https://github.com/civicrm/civicrm-core/pull/10650))**

- **[CRM-21324](https://issues.civicrm.org/jira/browse/CRM-21324) Support 'null'
  on date fields in the api
  ([11152](https://github.com/civicrm/civicrm-core/pull/11152))**

  Date fields are now consistent with other fields in accepting the word `null`
  to save a null value.

- **[CRM-21422](https://issues.civicrm.org/jira/browse/CRM-21422) TimeZone
  handling for Europe/London fails
  ([11273](https://github.com/civicrm/civicrm-core/pull/11273))**

  A "Timestamp Mismatch" system message would appear when the system's time zone
  has an offset from UTC of zero.  This is the case for a number of European and
  African time zones at least part of the year.

- **[CRM-21395](https://issues.civicrm.org/jira/browse/CRM-21395) DOMPDF
  produces either white screen or No-Block-Level parent found error in some
  circumstances blocking invoice production
  ([11246](https://github.com/civicrm/civicrm-core/pull/11246) and
  [11243](https://github.com/civicrm/civicrm-core/pull/11243))**

- **[CRM-21458](https://issues.civicrm.org/jira/browse/CRM-21458)
  HTML_QuickForm_hierselect doesn't handle JS escaping properly
  ([196](https://github.com/civicrm/civicrm-packages/pull/196))**

- **[CRM-20545](https://issues.civicrm.org/jira/browse/CRM-20545) contact report
  lists contacts that have been 'soft' deleted (placed in Trash)
  ([11276](https://github.com/civicrm/civicrm-core/pull/11276)) (completes past
  work)**

- **[CRM-21447](https://issues.civicrm.org/jira/browse/CRM-21447) Contact
  Relationship Report fatal error if used from the API with a
  relationship_type_id filter (also affects excel export)
  ([11293](https://github.com/civicrm/civicrm-core/pull/11293))**

- **[CRM-21563](https://issues.civicrm.org/jira/browse/CRM-21563) Cannot search
  child tags on 'Manage Tag' page
  ([11414](https://github.com/civicrm/civicrm-core/pull/11414))**

- **[CRM-19888](https://issues.civicrm.org/jira/browse/CRM-19888) On contact
  import, State field does not respect default country
  ([10740](https://github.com/civicrm/civicrm-core/pull/10740))**

- **[CRM-19915](https://issues.civicrm.org/jira/browse/CRM-19915) Multi-lingual
  Upgrade from 4.6 fails on missing DB table or field
  ([9739](https://github.com/civicrm/civicrm-core/pull/9739))**

- **[CRM-21407](https://issues.civicrm.org/jira/browse/CRM-21407) ISO compliance
  for German counties
  ([11255](https://github.com/civicrm/civicrm-core/pull/11255))**

  The state/province list now has correct spellings for Thüringen and
  Baden-Württemberg, and the abbreviation for Berlin has been corrected to "BE".

- **[CRM-21041](https://issues.civicrm.org/jira/browse/CRM-21041) API Bug when
  Creating Contact with Webform-Civicrm
  ([11269](https://github.com/civicrm/civicrm-core/pull/11269))**

  The Communication Style field would be left blank when a contact was created
  through the API (and through modules like Webform that use the API).

### CiviCase

- **[CRM-21559](https://issues.civicrm.org/jira/browse/CRM-21559) Save button in
  Case Type not clickable
  ([11473](https://github.com/civicrm/civicrm-core/pull/11473))**

- **[CRM-21384](https://issues.civicrm.org/jira/browse/CRM-21384) Ensure deleted
  contacts are filtered out of CiviCase
  ([11224](https://github.com/civicrm/civicrm-core/pull/11224))**

- **[CRM-21382](https://issues.civicrm.org/jira/browse/CRM-21382) Print/Merge
  document not filed on cases
  ([11223](https://github.com/civicrm/civicrm-core/pull/11223))**

- **[CRM-21456](https://issues.civicrm.org/jira/browse/CRM-21456) Relationship
  end date not set when creating resolved cases.
  ([11301](https://github.com/civicrm/civicrm-core/pull/11301))**

- **[CRM-21538](https://issues.civicrm.org/jira/browse/CRM-21538) CiviReport:
  Field not found when sorting by Case Type as a section header
  ([11419](https://github.com/civicrm/civicrm-core/pull/11419))**

- **[CRM-21507](https://issues.civicrm.org/jira/browse/CRM-21507) Unable to add
  multiple target contacts to a new case activity
  ([11360](https://github.com/civicrm/civicrm-core/pull/11360))**

  This resolves a problem where users trying to add multiple targets to a new
  case activity would be presented an error saying, "Activity Separation is a
  required field".

- **[CRM-21421](https://issues.civicrm.org/jira/browse/CRM-21421) Cannot update
  existing CaseContact
  ([11268](https://github.com/civicrm/civicrm-core/pull/11268) and
  [11270](https://github.com/civicrm/civicrm-core/pull/11270))**

  A bug prevented updating cases through the API due to constraints on updating
  case contact records.

### CiviContribute

- **[CRM-21595](https://issues.civicrm.org/jira/browse/CRM-21595) Regression:
  Contribution page no longer works when configured with PayPal Pro and pay
  later ([11483](https://github.com/civicrm/civicrm-core/pull/11483))**

  This resolves a PHP error when using a contribution page with pay later
  enabled.

- **[CRM-21465](https://issues.civicrm.org/jira/browse/CRM-21465) clicking on
  pledge link in email returns fatal error
  ([11305](https://github.com/civicrm/civicrm-core/pull/11305))**

- **[CRM-17647](https://issues.civicrm.org/jira/browse/CRM-17647) Recording
  payment truncates the amount after the comma (whether thousands or decimal
  separator) ([11548](https://github.com/civicrm/civicrm-core/pull/11548) and
  [11549](https://github.com/civicrm/civicrm-core/pull/11549))**

- **[CRM-21482](https://issues.civicrm.org/jira/browse/CRM-21482) Allow
  retrieval of currency from $_REQUEST (as supplied by webform_civicrm)
  ([11329](https://github.com/civicrm/civicrm-core/pull/11329),
  [11348](https://github.com/civicrm/civicrm-core/pull/11348), and
  [11344](https://github.com/civicrm/civicrm-core/pull/11344))**

  A new standardized method is introduced for retrieving the currency from the
  form values or page request.

- **[CRM-21200](https://issues.civicrm.org/jira/browse/CRM-21200) Pay Now
  payment overwrites the contribution
  ([11059](https://github.com/civicrm/civicrm-core/pull/11059))**

  When a donor completes a pay-later donation using the Pay Now link, the
  source, campaign, and contribution page values should be retained on the
  contribution as they were initially set.

- **[CRM-21492](https://issues.civicrm.org/jira/browse/CRM-21492) Authorize.Net
  fails on updated recurring contributions
  ([11338](https://github.com/civicrm/civicrm-core/pull/11338))**

  IPN transmissions from Authorize.net would fail because the payment amount
  would not match the original.

- **[CRM-21328](https://issues.civicrm.org/jira/browse/CRM-21328) Remove
  'Select' option from price option visibility drop-down (undefined index
  visibility_id error)
  ([11193](https://github.com/civicrm/civicrm-core/pull/11193))**

  Price options could be created without visibility being set.  This caused PHP
  notices.

- **[CRM-21436](https://issues.civicrm.org/jira/browse/CRM-21436) Fatal error on
  contribution page with only pay later enabled.
  ([11334](https://github.com/civicrm/civicrm-core/pull/11334)) (follow-up on
  past work)**

  Test coverage is added for this bug.

- **[CRM-21457](https://issues.civicrm.org/jira/browse/CRM-21457) Receipt date
  not updated when submitting a credit card payment from the back-end
  (Contribution) ([11343](https://github.com/civicrm/civicrm-core/pull/11343))**

- **[CRM-21477](https://issues.civicrm.org/jira/browse/CRM-21477) Buttons
  missing on Delete Premium product form
  ([11318](https://github.com/civicrm/civicrm-core/pull/11318))**

- **[CRM-20899](https://issues.civicrm.org/jira/browse/CRM-20899) Format refund
  amount ([10687](https://github.com/civicrm/civicrm-core/pull/10687))**

- **[CRM-20800](https://issues.civicrm.org/jira/browse/CRM-20800) User Cannot
  Cancel Recurring Payment With Paypal
  ([11359](https://github.com/civicrm/civicrm-core/pull/11359) and
  [10986](https://github.com/civicrm/civicrm-core/pull/10986))**

- **[CRM-21342](https://issues.civicrm.org/jira/browse/CRM-21342) Contribution
  note is not wiped if the value is removed
  ([11187](https://github.com/civicrm/civicrm-core/pull/11187))**

  When the contents of the contribution notes field are emptied, the entry in
  the note table is deleted.

- **[CRM-21478](https://issues.civicrm.org/jira/browse/CRM-21478) Pay Now on
  user dashboard only works in english
  ([11323](https://github.com/civicrm/civicrm-core/pull/11323))**

  The condition displaying the Pay Now link now compares the contribution status
  name rather than the status label.

- **[CRM-21424](https://issues.civicrm.org/jira/browse/CRM-21424) Print
  Contribution Receipt does not set receipt_date when downloading pdf receipts
  ([11289](https://github.com/civicrm/civicrm-core/pull/11289))**

- **[CRM-21432](https://issues.civicrm.org/jira/browse/CRM-21432) Fix display of
  end date for recurring contributions
  ([11283](https://github.com/civicrm/civicrm-core/pull/11283))**

- **[CRM-20166](https://issues.civicrm.org/jira/browse/CRM-20166) Setting CVV is
  'not required for backend' affects all front facing forms
  ([11205](https://github.com/civicrm/civicrm-core/pull/11205))**

  CVV is now always required for front-facing forms.

### CiviEvent

- **[CRM-21513](https://issues.civicrm.org/jira/browse/CRM-21513) Change fee
  selection for text price field on backoffice Event registration Not Creating
  Correct Financial Items
  ([11380](https://github.com/civicrm/civicrm-core/pull/11380))**

- **[CRM-19273](https://issues.civicrm.org/jira/browse/CRM-19273) Changes to
  Event Option Value Selections on Pending (Pay Later) Contribution Not Creating
  Correct Financial Items Causing Imbalance in Accounting Batch Export
  ([10962](https://github.com/civicrm/civicrm-core/pull/10962),
  [11300](https://github.com/civicrm/civicrm-core/pull/11300), and
  [11272](https://github.com/civicrm/civicrm-core/pull/11272))**

- **[CRM-20676](https://issues.civicrm.org/jira/browse/CRM-20676) Tax applied
  repeatedly on edits of price set events
  ([11455](https://github.com/civicrm/civicrm-core/pull/11455))**

- **[CRM-20787](https://issues.civicrm.org/jira/browse/CRM-20787) For a
  repeating Event series. If change the Price Set for a paid Event then this
  Price Set selection is not applied to all Events in the series even when apply
  to Every Event is selected
  ([11161](https://github.com/civicrm/civicrm-core/pull/11161))**

  This resoves a bug on changing the price set on an event that is part of a
  repeating event series.  An option allows selection of whether to apply
  changes to every event in the series, but the price set would not update on
  the other events.

- **[CRM-21245](https://issues.civicrm.org/jira/browse/CRM-21245) Incorrect
  Contribution status "Pending Refund"
  ([11077](https://github.com/civicrm/civicrm-core/pull/11077))**

  This resolves a problem on reducing the total fee on events that are partially
  paid.  Even if the partial payment is lower than the new total, the
  participant payment contribution would display "pending refund" instead of
  "partially paid".

- **[CRM-21560](https://issues.civicrm.org/jira/browse/CRM-21560)
  CRM_Event_Form_Task fatal error
  ([11410](https://github.com/civicrm/civicrm-core/pull/11410))**

- **[CRM-21426](https://issues.civicrm.org/jira/browse/CRM-21426) Cancel/Delete
  Event Participants - Duplicate Submit Buttons
  ([11277](https://github.com/civicrm/civicrm-core/pull/11277))**

  The confirmation screen for canceling event registrations is now consistent
  with other forms in only having buttons at the bottom.  In addition, the
  buttons are made less ambiguous by renaming the "Continue" button to "Cancel
  Registration".

- **[CRM-21393](https://issues.civicrm.org/jira/browse/CRM-21393) Event Location
  page is slow (because of checkPermission)
  ([11242](https://github.com/civicrm/civicrm-core/pull/11242))**

  When checking permissions for viewing an event, details are now loaded for
  only the one event.

### CiviMail

- **[CRM-21468](https://issues.civicrm.org/jira/browse/CRM-21468) mailing
  recipients field limits how many groups can be selected
  ([11349](https://github.com/civicrm/civicrm-core/pull/11349))**

  The number of groups that could be selected in the mailing recipients field
  was limited to the number of autocomplete results as defined in the search
  settings.  There is now no limit.

- **[CRM-21501](https://issues.civicrm.org/jira/browse/CRM-21501) bounce report:
  bounce date filter doesn't include timestamp
  ([11354](https://github.com/civicrm/civicrm-core/pull/11354))**

  On the Bounce Report, the filter for bounce date was missing the time, causing
  date filters to be evaluated as midnight.

- **[CRM-19704](https://issues.civicrm.org/jira/browse/CRM-19704) Image-only
  emails fail to send
  ([11399](https://github.com/civicrm/civicrm-core/pull/11399))**

- **[CRM-21206](https://issues.civicrm.org/jira/browse/CRM-21206) Recipients
  missing from AB Test Report
  ([11010](https://github.com/civicrm/civicrm-core/pull/11010))**

- **[CRM-21362](https://issues.civicrm.org/jira/browse/CRM-21362) Mailing
  summary report group by MySQL 5.7 error
  ([11261](https://github.com/civicrm/civicrm-core/pull/11261)) (completes
  previous work)**

  Users of MySQL 5.7 with `only_full_group_by` SQL mode would have errors
  viewing the mailing summary report when the start or end dates were included
  among the columns.

### CiviMember

- **[CRM-20343](https://issues.civicrm.org/jira/browse/CRM-20343) Wrong Activity
  creation when Membership status is changed from membership form.
  ([11198](https://github.com/civicrm/civicrm-core/pull/11198)) (follow-of of
  previous work)**

  The "is override" field is now automatically selected when a membership is set
  to "canceled" status because of a canceled contribution.

- **[CRM-21190](https://issues.civicrm.org/jira/browse/CRM-21190) Warning error
  on Thankyou page on pay later membership priceset.
  ([11303](https://github.com/civicrm/civicrm-core/pull/11303))**

- **[CRM-20569](https://issues.civicrm.org/jira/browse/CRM-20569) Record Payment
  for partially paid membership: update amt, fix deferred
  ([11000](https://github.com/civicrm/civicrm-core/pull/11000)) (partial work)**

- **[CRM-19060](https://issues.civicrm.org/jira/browse/CRM-19060) Membership
  Detailed Report Payment Amount (most recent) not reporting correct
  contribution ([11389](https://github.com/civicrm/civicrm-core/pull/11389))
  (preliminary work)**

- **[CRM-19608](https://issues.civicrm.org/jira/browse/CRM-19608) "Auto Renew
  Required" is not enforced during membership registration using priceset.
  ([9648](https://github.com/civicrm/civicrm-core/pull/9648))**

- **[CRM-21265](https://issues.civicrm.org/jira/browse/CRM-21265) For failed
  membership transaction, update payment status to failed
  ([11072](https://github.com/civicrm/civicrm-core/pull/11072))**

  Previously, the payment status would remain as "Incomplete".

- **[CRM-21357](https://issues.civicrm.org/jira/browse/CRM-21357) Batch Data
  Entry: Start date is NULL when membership batch entry is processed
  ([11202](https://github.com/civicrm/civicrm-core/pull/11202))**

### Backdrop Integration

- **[CRM-20764](https://issues.civicrm.org/jira/browse/CRM-20764) Need to update
   civicrm.settings.php to account for clean urls in Backdrop
  ([10674](https://github.com/civicrm/civicrm-core/pull/10674))**

### Drupal Integration

- **[CRM-21526](https://issues.civicrm.org/jira/browse/CRM-21526)
  CRM_Utils_System_Drupal8::authenticate() is incomplete
  ([11381](https://github.com/civicrm/civicrm-core/pull/11381)) (partial work)**

  The method for scripts to authenticate a Drupal 8 user would simply return the
  user ID rather than switching to that user.

- **[CRM-21372](https://issues.civicrm.org/jira/browse/CRM-21372) Fatal error
  adding profile on Drupal 8
  ([11216](https://github.com/civicrm/civicrm-core/pull/11216))**

- **[CRM-21312](https://issues.civicrm.org/jira/browse/CRM-21312) Fix display of
  Recent Items when using a bootstrap theme
  ([11138](https://github.com/civicrm/civicrm-core/pull/11138))**

  Some Drupal themes that implement the Bootstrap framework had been shifting
  items to the right within the recent items block and allowing their text to
  overflow their containers.

- **[CRM-20728](https://issues.civicrm.org/jira/browse/CRM-20728) Store session
  in drupal session table before exiting
  ([10501](https://github.com/civicrm/civicrm-core/pull/10501))**

  Anonymous webform session variables had not been saved before going to the
  payment form, which caused problems retrieving return URLs and other details.

- **[CRM-20153](https://issues.civicrm.org/jira/browse/CRM-20153) Drupal Views:
  PCP Pages for Events not showing up in list of pages
  ([463](https://github.com/civicrm/civicrm-drupal/pull/463))**

- **[CRM-20734](https://issues.civicrm.org/jira/browse/CRM-20734) State doesn't
  populate on first load of view even if country is selected.
  ([506](https://github.com/civicrm/civicrm-drupal/pull/506))**

- **[CRM-20783](https://issues.civicrm.org/jira/browse/CRM-20783) undefined
  currency error when pricefield value is included in view
  ([458](https://github.com/civicrm/civicrm-drupal/pull/458))**

- **[CRM-20592](https://issues.civicrm.org/jira/browse/CRM-20592) Drupal Views
  integration : bug when selecting website
  ([446](https://github.com/civicrm/civicrm-drupal/pull/446))**

  Location type options were displayed for website field in Views even though
  websites don't use location types.

- **[CRM-20292](https://issues.civicrm.org/jira/browse/CRM-20292) Drush cc all
  clears custom fields from Drupal Views
  ([472](https://github.com/civicrm/civicrm-drupal/pull/472))**

  Clearing the Drupal Views cache as a user without the permission to view
  custom fields would cause those fields to be removed from views using them.

### Joomla Integration

- **[CRM-20164](https://issues.civicrm.org/jira/browse/CRM-20164) PayPal
  Standard notify_url breaks with Joomla when derived from menu item
  ([11236](https://github.com/civicrm/civicrm-core/pull/11236))**

  The PayPal Standard IPN notification URL would be formed incorrectly when the
  contribution comes from a contribution form that is linked as a menu item.

### WordPress Integration

- **[CRM-21385](https://issues.civicrm.org/jira/browse/CRM-21385) WordPress top
  nav bar blocks top row of WYSIWYG editor when maximized
  ([11230](https://github.com/civicrm/civicrm-core/pull/11230))**

- **[CRM-16421](https://issues.civicrm.org/jira/browse/CRM-16421) Work to get
  CiviCRM for WordPress in WordPress' official Repository
  ([11397](https://github.com/civicrm/civicrm-core/pull/11397)) (continues
  ongoing work)**

  The version header in `civicrm.php` now has the complete version number of
  CiviCRM rather than just `4.7`.

- **[CRM-20358](https://issues.civicrm.org/jira/browse/CRM-20358) WordPress
  access control table is basically unusable
  ([11253](https://github.com/civicrm/civicrm-core/pull/11253))**

  The layout of the table on the WordPress access control form now works
  properly even when text wraps.

## <a name="misc"></a>Miscellany

- **[CRM-21555](https://issues.civicrm.org/jira/browse/CRM-21555) Replace
  `CRM_Core_OptionGroup::getValue` with `CRM_Core_PseudoConstant::getKey` for
  Case ([11409](https://github.com/civicrm/civicrm-core/pull/11409))**

- **[CRM-21548](https://issues.civicrm.org/jira/browse/CRM-21548) Remove unused
  variables from `CRM_Utils_Address::format`
  ([11403](https://github.com/civicrm/civicrm-core/pull/11403))**

- **[CRM-21544](https://issues.civicrm.org/jira/browse/CRM-21544) Remove unused
  `CRM_Contact_BAO_Contact_Optimizer` class
  ([11400](https://github.com/civicrm/civicrm-core/pull/11400))**

- **[CRM-21527](https://issues.civicrm.org/jira/browse/CRM-21527) Add default to
  extra address::create param
  ([11382](https://github.com/civicrm/civicrm-core/pull/11382))**

- **[CRM-21517](https://issues.civicrm.org/jira/browse/CRM-21517)
  UpdateSubscription OptionGroup->PseudoConstant
  ([11367](https://github.com/civicrm/civicrm-core/pull/11367))**

- **[CRM-21471](https://issues.civicrm.org/jira/browse/CRM-21471) Remove unused
  function CRM_Core_Pseudoconstant::greetingDefaults
  ([11313](https://github.com/civicrm/civicrm-core/pull/11313))**

- **Move test docs to civicrm-dev-docs
  ([11213](https://github.com/civicrm/civicrm-core/pull/11213))**

- **[CRM-17860](https://issues.civicrm.org/jira/browse/CRM-17860),
  [CRM-18231](https://issues.civicrm.org/jira/browse/CRM-18231) -
  JobProcessMailingTest - Re-remove require_once
  ([11251](https://github.com/civicrm/civicrm-core/pull/11251))**

- **Remove php 5.3 shim for json formatting
  ([11421](https://github.com/civicrm/civicrm-core/pull/11421))**

- **Add test for processing multipart-related emails in fetch_bounces
  ([11378](https://github.com/civicrm/civicrm-core/pull/11378))**

- **Fix ts() functions to have variable on the outside.
  ([11357](https://github.com/civicrm/civicrm-core/pull/11357))**

- **[CRM-21218](https://issues.civicrm.org/jira/browse/CRM-21218) Improve
  component statics flushing
  ([11022](https://github.com/civicrm/civicrm-core/pull/11022))**

- **NFC, comments only
  ([11330](https://github.com/civicrm/civicrm-core/pull/11330))**

- **NFC rerun setup.sh -dg and regen Participant DAO
  ([11315](https://github.com/civicrm/civicrm-core/pull/11315))**

- **[CRM-16819](https://issues.civicrm.org/jira/browse/CRM-16819) Improve on
  CRM_Utils_Request::retrieve()
  ([11285](https://github.com/civicrm/civicrm-core/pull/11285))**

- **(NFC) .toxic.json - Update list of functions which yield toxic warnings
  ([11302](https://github.com/civicrm/civicrm-core/pull/11302))**

- **[NFC] code cleanup: split out 2 functions that are mostly unrelated.
  ([11284](https://github.com/civicrm/civicrm-core/pull/11284))**

- **[NFC] Function extraction and renaming of variable for shorter refere…
  ([11278](https://github.com/civicrm/civicrm-core/pull/11278))**

- **[NFC] Fix a bunch of docstrings
  ([11034](https://github.com/civicrm/civicrm-core/pull/11034))**

- **[NFC] Additional test
  ([11266](https://github.com/civicrm/civicrm-core/pull/11266))**

- **[NFC] Minor refactor of test to allow re-use
  ([11265](https://github.com/civicrm/civicrm-core/pull/11265))**

- **Fix GenerateData for only_full_group_by sqlMode
  ([11225](https://github.com/civicrm/civicrm-core/pull/11225))**

  This resolves a problem with generating sample data using MySQL 5.7, which has
  the `only_full_group_by` SQL mode by default.

- **Lint civicrm.module and civicrm.install files
  ([467](https://github.com/civicrm/civicrm-drupal/pull/467))**

- **Fix Activity Unit Test failure
  ([11552](https://github.com/civicrm/civicrm-core/pull/11552))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Agileware Team, Alok Patel, Francis
Whittle; Australian Greens - Seamus Lee; British Humanist Association - Andrew
West; Christian Wach; CiviCoop - Klaas Eikelboom; CiviCRM - Coleman Watts, Tim
Otten; CiviDesk - Sunil Pawar, Yashodha Chaku; CiviFirst - John Kirk; Community
IT Academy - William Mortada; CompuCorp - Camilo Rodriguez, Mukesh Ram, Omar Abu
Hussein; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Deepak Srivastava;
Ergon Logic Enterprises - Christopher Gervais; Francesc Bassas i Bullich;
Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; JazzMan; JMA
Consulting - Edsel Lopez, Monish Deb, Pradeep Nayak; John Kingsnorth; Joinery -
Allen Shaw; Kompetenzzentrum Technik-Diversity-Chancengleichheit - Niels
Heinemann; Left Join Labs - Sean Madsen; Lighthouse Design and Consulting -
Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; Mihael
Mladenov; MJW Consulting - Matthew Wire; myDropWizard - David Snopek; Nathan
Brettell; Noah's Light Foundation - Carlos Loeza; Oxfam Germany - Thomas
Schüttler; Progressive Technology Project - Jamie McClelland; Rupal Javiya;
Squiffle Consulting - Aidan Saunders; Stephen Palmstrom; Third Sector Design -
Michael McAndrew; Timbsoft Technologies - Tunbola Ogunwande; Vinu Varshith
Sekar; Wikimedia Foundation - Eileen McNaughton, Elliott Eggleston, Maggie Epps;
Will Long

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin, Jane Hanley; Anne Smale; Australian Greens - John
Twyman; Avietech - Jonathan Boeke; BackOffice Thinking - Hassan Farooq; Campaign
Against Arms Trade - Kirk Jackson; CEDC - Laryn Kragt Bakker; Chris Burgess;
Christophe Golle; Circle Interactive - Dave Jenkins; CompuCorp - Guanhuan Chen,
Igor Pavlov, Madura Krishnamoorthy; Daniël van Vuuren; Dave D; Edinburgh College -
Graham Smith; Elennio Dec; Fatih Ateş; Forest CRM Consulting - Tamar Meir;
Fuzion - Peter Davis; Ginkgo Street Labs - Dan O'Brien, Evan Chute; Hartmann
Computer Consulting - Peter Hartmann; JMA Consulting - Joe Murray; Joanne
Chester; Joseph Lacey; Juan David Hurtado G.; Julian Libor; Just Hope - Phil
Morice Brubaker; Korlon - Stuart Gaston; Lemniscus - Noah Miller; Lullabot -
Nate Lampton; MC3 - Graham Mitchell; National Democratic Institute - Dean
Valentine; Neil Zampella; Octo Happiness; Robert Lang; Saurabh Batra; Semper IT -
Karin Gerritsen; Skvare - Mark Hanna; SLB Radio Productions - Larry Berger; Spry
Digital - Ellen Hendricks; Stan Dragnev;  Systopia - Björn Endres; Tadpole
Collective - Kevin Cristiano; Tommy Sheppard; Torrance Hodgson; Web Access -
Pratiksha Dubey; Website Express - James Forbes Keir

## <a name="feedback"></a>Feedback

These release notes are edited by Andie Hunt.  If you'd like to provide
feedback on them, please login to https://chat.civicrm.org/civicrm and contact
`@agh1`.
