# CiviCRM 4.7.20

Released June 7, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-20552](https://issues.civicrm.org/jira/browse/CRM-20552) Task for "Add
  Relationship - to individual" is missing
  ([10332](https://github.com/civicrm/civicrm-core/pull/10332))**

  You can now add a relationship to an individual for contacts in search results.

- **[CRM-19977](https://issues.civicrm.org/jira/browse/CRM-19977) Update all
  fields manipulated by hook_civicrm_geocoderFormat when geocoding
  ([9864](https://github.com/civicrm/civicrm-core/pull/9864))**

  Extensions implementing `hook_civicrm_geocoderFormat` will now modify all
  address fields instead of just the latitude, longitude, and postal code
  fields.

- **[CRM-20458](https://issues.civicrm.org/jira/browse/CRM-20458) Add
  `civi.dao.preDelete event`
  ([10197](https://github.com/civicrm/civicrm-core/pull/10197))**

  This triggers a Symfony event prior to deleting a record in the database.

- **[CRM-20425](https://issues.civicrm.org/jira/browse/CRM-20425) Activity
  status per mail account
  ([10159](https://github.com/civicrm/civicrm-core/pull/10159))**

  Administrators can now designate the status for activities created by inbound
  emails to accounts.  Each account may have a different activity status.

- **[CRM-20540](https://issues.civicrm.org/jira/browse/CRM-20540) entityRef
  field: create option to set wildcard preference
  ([10330](https://github.com/civicrm/civicrm-core/pull/10330))**

  Entity reference fields can now be configured to automatically include a
  wildcard.

- **APIExplorer - Add cv and hyperlinks
  ([10309](https://github.com/civicrm/civicrm-core/pull/10309))**

  Examples for an API call using the `cv` command-line tool are now provided
  alongside Drush or WP-CLI.

### CiviCampaign

- **[CRM-15984](https://issues.civicrm.org/jira/browse/CRM-15984) Add campaign
  field on Email activity form
  ([10317](https://github.com/civicrm/civicrm-core/pull/10317))**

  When sending an email to a contact, you can now set the campaign that the
  email belongs to.

- **[CRM-20510](https://issues.civicrm.org/jira/browse/CRM-20510) Petition
  signature doesn't show as an activity type for scheduled reminder
  ([10301](https://github.com/civicrm/civicrm-core/pull/10301))**

  Petition signature activities are now available as the basis for scheduled
  reminders.

### CiviContribute

- **[CRM-20591](https://issues.civicrm.org/jira/browse/CRM-20591) Disabling a
  payment processor via UI (other than Payment_PayPalImpl) will break live mode
  ([10402](https://github.com/civicrm/civicrm-core/pull/10402))**

- **[CRM-20037](https://issues.civicrm.org/jira/browse/CRM-20037) Change
  Contribution tab to show balance due
  ([10334]([10204](https://github.com/civicrm/civicrm-core/pull/10204),
  https://github.com/civicrm/civicrm-core/pull/10334) and
  [10295](https://github.com/civicrm/civicrm-core/pull/10295))**

  Partially paid and pending refund contributions now display the positive or
  negative amount due on a contact's contributions tab.

- **[CRM-15067](https://issues.civicrm.org/jira/browse/CRM-15067) Email should
  appear in the profile in which it is included, rather than always at the top
  of contribution page
  ([10349](https://github.com/civicrm/civicrm-core/pull/10349))**

  Contribution pages automatically contain the email address field.  In the
  past, the email address would appear ahead of any profiles, removing a site
  administrator's control over the field's placement.  Now, if the field is in
  one of the profiles included on the page, it appears there.  Otherwise, it
  appears before the profiles.

### CiviMail

- **[CRM-9683](https://issues.civicrm.org/jira/browse/CRM-9683) Implement
  timezone support for CiviMail
  ([10154](https://github.com/civicrm/civicrm-core/pull/10154))**

  The database schema *for new installations only* is altered to record the Unix
  timestamp for the times when CiviMail messages are created, scheduled, sent,
  and canceled.  This sidesteps problems that can arise from users with
  different local times creating mailings to send immediately.

### Drupal Integration

- **[CRM-20462](https://issues.civicrm.org/jira/browse/CRM-20462) Add filter for
  current employer in views
  ([440](https://github.com/civicrm/civicrm-drupal/pull/440))**

  Views can now filter contacts by the name of an individual's current employer.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-20498](https://issues.civicrm.org/jira/browse/CRM-20498) buildform hook
  invoked twice ([10278](https://github.com/civicrm/civicrm-core/pull/10278))**

  This fixes some of the cases where `hook_civicrm_buildForm` is invoked twice
  on CiviCRM forms.

- **[CRM-20539](https://issues.civicrm.org/jira/browse/CRM-20539) Do not heed
  dao default for field when setting defaults on reports
  ([10319](https://github.com/civicrm/civicrm-core/pull/10319))**

  The default value of a field as defined in the database schema should not
  automatically be the default for report settings.

- **[CRM-20541](https://issues.civicrm.org/jira/browse/CRM-20541) Edge case
  where DB connection is not available
  ([10320](https://github.com/civicrm/civicrm-core/pull/10320))**

  This resolves a bug in test cases where the database connection is not
  available from the cache.

- **[CRM-20418](https://issues.civicrm.org/jira/browse/CRM-20418) Not able to
  select Tokens from dropdown on Message Template
  ([10336](https://github.com/civicrm/civicrm-core/pull/10336))**

- **[CRM-20508](https://issues.civicrm.org/jira/browse/CRM-20508) Unable to use
  non-roman characters in Custom fields
  ([10335](https://github.com/civicrm/civicrm-core/pull/10335) and
  [10328](https://github.com/civicrm/civicrm-core/pull/10328))**

  This fixes a bug where a field named entirely with non-ASCII characters caused
  CiviCRM to assert that it already exists.

- **[CRM-20662](https://issues.civicrm.org/jira/browse/CRM-20662) SMS Domain ID
  upgrade step breaks on multisite
  ([10444](https://github.com/civicrm/civicrm-core/pull/10444))**

  This fixes an upgrade step to add `domain_id` on `civicrm_sms_provider` that
  breaks in 4.7.19 when running on multisite.  There was a problem with the
  check to ensure that it only runs a part of the script when a site has a
  single domain.

- **[CRM-20550](https://issues.civicrm.org/jira/browse/CRM-20550) navigation
  menu added by extension never appears
  ([10326](https://github.com/civicrm/civicrm-core/pull/10326))**

  When adding a navigation menu item via an extension that omits the navID and
  parentID, the menu item would never show up.

- **[CRM-20517](https://issues.civicrm.org/jira/browse/CRM-20517) Submitting a
  Profile results in a "Contact Sub Type does not match" error when the contact
  subtype of an existing contact does not match the Profile subtype
  ([10302](https://github.com/civicrm/civicrm-core/pull/10302))**

- **[CRM-20494](https://issues.civicrm.org/jira/browse/CRM-20494) Import contact
  with two similar external ids results into fatal error, should be skipped.
  ([10276](https://github.com/civicrm/civicrm-core/pull/10276))**

  If an import file has two rows with the same value for External Identifier,
  the affected rows are now skipped.  This fixes the previous behavior which
  would present a fatal error interrupting the whole import process.

- **NFC Add in function to check if Foreign key is there to make upgrade …
  ([10312](https://github.com/civicrm/civicrm-core/pull/10312))**

  Upgrades now have the ability to check if a foreign key exists before
  attempting to alter it.  Some upgrade steps now check this first.

- **[CRM-20452](https://issues.civicrm.org/jira/browse/CRM-20452) Fatal Error on
  saving Organisation Info when geocoding is enabled
  ([10192](https://github.com/civicrm/civicrm-core/pull/10192))**

  This resolves a bug where contacts without a State/Province have the value
  "null" passed to the geocoder, resulting in an error.

- **[CRM-20308](https://issues.civicrm.org/jira/browse/CRM-20308) Activity copy
  is always sent FROM logged in user's email ID
  ([10257](https://github.com/civicrm/civicrm-core/pull/10257) and
  [10213](https://github.com/civicrm/civicrm-core/pull/10213))**

  When sending an activity assignee notification, the From email address will be
  determined with the following priority order:

  1. the email address of the source contact of the activity
  2. the default from email address for the domain
  3. the email address of the logged-in user

  Previously, the email address of the logged-in user was always used.

- **[CRM-20441](https://issues.civicrm.org/jira/browse/CRM-20441) Fatal error on
  contact summary for ACL'd user (from activity tab count)
  ([10251](https://github.com/civicrm/civicrm-core/pull/10251))**

  This resolves a fatal error that would occur for users lacking the "View all
  contacts" permission when they would view the contact summary of a contact
  they had permission to view.

- **[CRM-19986](https://issues.civicrm.org/jira/browse/CRM-19986) Schema has
  differences when upgraded to when install in civicrm_action_schedule
  ([9809](https://github.com/civicrm/civicrm-core/pull/9809))**

- **[CRM-20450](https://issues.civicrm.org/jira/browse/CRM-20450) Fix invoice
  math for partial payments
  ([10224](https://github.com/civicrm/civicrm-core/pull/10224)) (adds test for
  previously completed work)**

- **Fixed minor template errors.
  ([10221](https://github.com/civicrm/civicrm-core/pull/10221))**

  Two templates had invalid HTML.

- **Address fatal errors on PHP7.1 - only vars can be passed by reference.
  ([10217](https://github.com/civicrm/civicrm-core/pull/10217))**

- **[CRM-20463](https://issues.civicrm.org/jira/browse/CRM-20463) Documentation
  links with "current" in them are broken
  ([10209](https://github.com/civicrm/civicrm-core/pull/10209))**

- **[CRM-20532](https://issues.civicrm.org/jira/browse/CRM-20532) Extension.Get
  API action filtering is broken
  ([10322](https://github.com/civicrm/civicrm-core/pull/10322))**

  The Extension.get API no longer ignores filters and result limits.

- **[CRM-19876](https://issues.civicrm.org/jira/browse/CRM-19876) Civi won't
  send simple mails to all email recpients if some hold multiple addresses
  ([10321](https://github.com/civicrm/civicrm-core/pull/10321)) (preliminary
  work)**

- **[CRM-19821](https://issues.civicrm.org/jira/browse/CRM-19821) Remove
  performance degrading joins from activity search (& api calls)
  ([10273](https://github.com/civicrm/civicrm-core/pull/10273)) (preliminary
  work)**

- **[CRM-20623](https://issues.civicrm.org/jira/browse/CRM-20623) Add Column
  function in Upgrade Base does not properly rebuild multilingual views
  ([10399](https://github.com/civicrm/civicrm-core/pull/10399))**

### CiviCase

- **[CRM-20478](Case Type "Reference" Field Not Working) Case Type "Reference"
  Field Not Working
  ([10281](https://github.com/civicrm/civicrm-core/pull/10281))**

  This resolves a bug where the reference activity drop-downs were empty when
  editing a timeline for a case type.  It also fixes the screen to use localized
  activity type labels rather than the fixed-value names.

- **[CRM-20171](https://issues.civicrm.org/jira/browse/CRM-20171) Problem with
  xml file not loaded
  ([10264](https://github.com/civicrm/civicrm-core/pull/10264))**

  This resolves PHP warnings that would display if CiviCase failed to load an
  XML file.

### CiviContribute

- **[CRM-20576](https://issues.civicrm.org/jira/browse/CRM-20576) Increase
  length of civicrm_batch.title
  ([10359](https://github.com/civicrm/civicrm-core/pull/10359))**

  The `title` field on the `civicrm_batch` table now supports 255 characters,
  resolving a bug where the system throws a fatal error when the batch name is
  more than 64 characters.

- **[CRM-20560](https://issues.civicrm.org/jira/browse/CRM-20560) Deferred
  Revenue report bug
  ([10338](https://github.com/civicrm/civicrm-core/pull/10338))**

  The deferred revenue report would behave inconsistently when line items'
  financial types differed from the contribution's financial type.

- **[CRM-20555](https://issues.civicrm.org/jira/browse/CRM-20555)  Incorrect
  balance amount is shown on participant view page if 'Deferred Revenue' is
  enabled ([10204](https://github.com/civicrm/civicrm-core/pull/10204))**

  Fixes this bug and implements CRM-20037 above.

- **[CRM-20260](https://issues.civicrm.org/jira/browse/CRM-20260) Incorrect
  information is stored in civicrm_financial_item table
  ([9984](https://github.com/civicrm/civicrm-core/pull/9984))**

  This fixes an error in line item data caused when sales tax is enabled.

- **[CRM-20276](https://issues.civicrm.org/jira/browse/CRM-20276) When editing a
  contribution the value in civicrm_financial_item_amount is not updated
  ([10235](https://github.com/civicrm/civicrm-core/pull/10235))**

- **[CRM-20564](https://issues.civicrm.org/jira/browse/CRM-20564) custom date
  fields in on-behalf-of forms broken
  ([10372](https://github.com/civicrm/civicrm-core/pull/10372))**

- **[CRM-20566](https://issues.civicrm.org/jira/browse/CRM-20566) Fatal error on
  submit of 'Edit Contribution'
  ([10343](https://github.com/civicrm/civicrm-core/pull/10343))**

- **[CRM-20392](https://issues.civicrm.org/jira/browse/CRM-20392) Credit card
  payment not recorded when contribution is partially paid
  ([10285](https://github.com/civicrm/civicrm-core/pull/10285) and
  [10271](https://github.com/civicrm/civicrm-core/pull/10271))**

- **[CRM-20558](https://issues.civicrm.org/jira/browse/CRM-20558) CiviReport:
  Contribution Summary - groupBy split personality issue
  ([10339](https://github.com/civicrm/civicrm-core/pull/10339))**

  This resolves inconsistent treatment of the variable listing the `GROUP BY`
  columns on the Contribution Summary report.

- **[CRM-20036](https://issues.civicrm.org/jira/browse/CRM-20036) Memory problem
  when updating a contribution without soft contributions
  ([10260](https://github.com/civicrm/civicrm-core/pull/10260))**

  Sites with many soft credits would run out of memory after a user edited a
  contribution without any soft credits.

- **[CRM-20526](https://issues.civicrm.org/jira/browse/CRM-20526) recent item
  generated from contribution view doesn't include currency
  ([10307](https://github.com/civicrm/civicrm-core/pull/10307))**

  Contribution amounts displayed in the recent items now display the appropriate
  currency rather than the site's default.

- **[CRM-20527](https://issues.civicrm.org/jira/browse/CRM-20527) batch data
  entry does not retain currency
  ([10310](https://github.com/civicrm/civicrm-core/pull/10310))**

  When batch editing contributions with a profile including the currency field,
  the currency value now displays the existing value for the contribution's
  currency rather than the site's default currency.

- **[CRM-20513](https://issues.civicrm.org/jira/browse/CRM-20513) Fix bugs on
  updating recurring contribution from CRM-17655
  ([10294](https://github.com/civicrm/civicrm-core/pull/10294))**

  When updating a recurring contribution, the next scheduled contribution date
  is now updated according to the contribution's receive date rather than the
  current date.  This also resolves a bug in selecting the Completed status on
  the recurring contribution record if all payments are received.

- **[CRM-20297](https://issues.civicrm.org/jira/browse/CRM-20297) Fatal error
  viewing a contribution having a line item with no price field
  ([10012](https://github.com/civicrm/civicrm-core/pull/10012))**

- **[CRM-20472](https://issues.civicrm.org/jira/browse/CRM-20472) Soft credit
  "contact" field validation errors do not display
  ([10233](https://github.com/civicrm/civicrm-core/pull/10233))**

  This fixes a bug where validation errors on soft credit fields would not
  highlight the offending field or display the validation problem message.

- **[CRM-19697](https://issues.civicrm.org/jira/browse/CRM-19697) Incorrect
  update billing details link
  ([9471](https://github.com/civicrm/civicrm-core/pull/9471))**

  This resolves a problem in listings of recurring contributions where some
  recurring contributions would display a link to edit the billing details if
  another recurring contribution's payment processor allowed it, even if the
  contributions' processors did not allow it.

### CiviEvent

- **[CRM-20604](https://issues.civicrm.org/jira/browse/CRM-20604) Registering
  additional event participants causes fatal error
  ([10468](https://github.com/civicrm/civicrm-core/pull/10468))**

- **[CRM-20581](https://issues.civicrm.org/jira/browse/CRM-20581) Civi event
  users do not have access to StateProvince entity via the API
  ([10459](https://github.com/civicrm/civicrm-core/pull/10459))**

- **[CRM-20559](https://issues.civicrm.org/jira/browse/CRM-20559) Revenue
  account is Deferred revenue rather than Revenue.
  ([10337](https://github.com/civicrm/civicrm-core/pull/10337))**

  This resolves a bug where event registrations recorded after the event would
  have deferred revenue recorded nonetheless.

- **[CRM-20518](https://issues.civicrm.org/jira/browse/CRM-20518) Default
  participant status not set when status name not matches localized string
  'Registered' ([10297](https://github.com/civicrm/civicrm-core/pull/10297))**

  If using CiviCRM in a language other than English, the participant status
  would fail to find the default value, looking a status with the translated
  value of "Registered" rather than "Registered" itself.

- **[CRM-20549](https://issues.civicrm.org/jira/browse/CRM-20549) manage events
  does not list all events
  ([10325](https://github.com/civicrm/civicrm-core/pull/10325))**

  The default API limit of 25 results was artificially limiting the number of
  visible events on the Manage Events page.

- **[CRM-20461](https://issues.civicrm.org/jira/browse/CRM-20461) post hook not
  invoked after updating status for additional participants
  ([10208](https://github.com/civicrm/civicrm-core/pull/10208))**

- **[CRM-20419](https://issues.civicrm.org/jira/browse/CRM-20419) Profile
  selector broken on event registration (some version/CMS/browser combos)
  ([10331](https://github.com/civicrm/civicrm-core/pull/10331) and
  [10152](https://github.com/civicrm/civicrm-core/pull/10152))**

  This avoids the use of the `jQuery.isEmptyObject()` method on anything but a
  plain Javascript object.  Inconsistent behavior among CMSes led many Joomla
  users to be unable to select profiles to include in event registration forms.

- **[CRM-20469](https://issues.civicrm.org/jira/browse/CRM-20469) Currency not
  set correctly in ajax call from event form
  ([10230](https://github.com/civicrm/civicrm-core/pull/10230))**

- **[CRM-20396](https://issues.civicrm.org/jira/browse/CRM-20396) Event
  participation payments not correctly recorded in financial_trxn table
  (frontend) ([10124](https://github.com/civicrm/civicrm-core/pull/10124))**

  This corrects an error in recording the payment processor for event
  participant contributions.

### CiviMail

- **[CRM-20431](https://issues.civicrm.org/jira/browse/CRM-20431) Unsubscribe
  Page shows wrong group names
  ([10165](https://github.com/civicrm/civicrm-core/pull/10165))**

  When using a past mailing's recipients, the recipient group(s) displayed
  should match those of the past mailing.

- **[CRM-17754](https://issues.civicrm.org/jira/browse/CRM-17754) Include resent
  headers into civi bulk mail reply function
  ([7499](https://github.com/civicrm/civicrm-core/pull/7499))**

  Forwarded reply messages now have the appropriate headers to indicate that the
  server is resending a message from another sender.

### CiviMember

- **[CRM-20546](https://issues.civicrm.org/jira/browse/CRM-20546) Purchasing a
  Membership online results in 5 Activities, 2 x Contribution ones, plus Renewal
  and Signup and Status change
  ([10324](https://github.com/civicrm/civicrm-core/pull/10324))**

- **[CRM-18177](https://issues.civicrm.org/jira/browse/CRM-18177) When Renewing
  an existing membership, if CC details are incorrect, Membership is set to
  Cancelled preventing contact from trying again
  ([10173](https://github.com/civicrm/civicrm-core/pull/10173))**

- **[CRM-20172](https://issues.civicrm.org/jira/browse/CRM-20172) "Separate
  Membership Payment" with Memberships enabled and additional contribution
  causes incorrect authorize.net transactions
  ([10167](https://github.com/civicrm/civicrm-core/pull/10167))**

- **[CRM-20530](https://issues.civicrm.org/jira/browse/CRM-20530) Bookkeeping
  transaction report fails at acct credit filter
  ([10313](https://github.com/civicrm/civicrm-core/pull/10313) and
  [10311](https://github.com/civicrm/civicrm-core/pull/10311))**

### WordPress Integration

- **[CRM-18799](https://issues.civicrm.org/jira/browse/CRM-18799) WordPress
  requires exec() command not be disabled
  ([108](https://github.com/civicrm/civicrm-wordpress/pull/108))**

  Code to find the present working directory used the `exec()` command, which is
  sometimes blocked for security reasons.

## <a name="misc"></a>Miscellany

- **[CRM-20238](https://issues.civicrm.org/jira/browse/CRM-20238) Hook for
  inbound SMS messages
  ([10353](https://github.com/civicrm/civicrm-core/pull/10353)) (preliminary
  work)**

  Inbound SMS processing now has unit test coverage.

- **[CRM-20570](https://issues.civicrm.org/jira/browse/CRM-20570) Add unit test
  for disabling of PCP
  ([10350](https://github.com/civicrm/civicrm-core/pull/10350))**

  Disabling personal campaign pages now has unit test coverage.

- **[CRM-20474](https://issues.civicrm.org/jira/browse/CRM-20474) Refactor
  UFField api to follow standard api / BAO format
  ([10269](https://github.com/civicrm/civicrm-core/pull/10269),
  [10236](https://github.com/civicrm/civicrm-core/pull/10236), and
  [10244](https://github.com/civicrm/civicrm-core/pull/10244))**

  The formerly non-standard API for connecting fields to CiviCRM profiles now
  works in a more standard way.

- **[CRM-20424](https://issues.civicrm.org/jira/browse/CRM-20424) Set up method
  for marking code as deprecated
  ([10259](https://github.com/civicrm/civicrm-core/pull/10259) and
  [10202](https://github.com/civicrm/civicrm-core/pull/10202))**

  Tests will now fail if a deprecated functions are called.

- **[CRM-20312](https://issues.civicrm.org/jira/browse/CRM-20312) Identify and
  fix missing indexes
  ([10241](https://github.com/civicrm/civicrm-core/pull/10241)) (follow-up)**

  A typographic error is fixed.

- **[CRM-20428](https://issues.civicrm.org/jira/browse/CRM-20428) Refactor
  CRM_Utils_File sourceSQLFile
  ([10216](https://github.com/civicrm/civicrm-core/pull/10216))**

- **[CRM-20435](https://issues.civicrm.org/jira/browse/CRM-20435) Don't use SQL
  in CRM_Activity_BAO_Activity::create() where DAO will suffice
  ([10168](https://github.com/civicrm/civicrm-core/pull/10168))**

- **[CRM-20459](https://issues.civicrm.org/jira/browse/CRM-20459) Actively
  deprecate CRM_Core_OptionGroup::getValue
  ([10200](https://github.com/civicrm/civicrm-core/pull/10200),
  [10201](https://github.com/civicrm/civicrm-core/pull/10201), and
  [10203](https://github.com/civicrm/civicrm-core/pull/10203))**

- **[CRM-20537](https://issues.civicrm.org/jira/browse/CRM-20537) Case Contact
  Index should be unique
  ([10318](https://github.com/civicrm/civicrm-core/pull/10318))**

- **[CRM-19246](https://issues.civicrm.org/jira/browse/CRM-19246) Add testing
  for use of ACLs in group
  ([10284](https://github.com/civicrm/civicrm-core/pull/10284))**

- **[CRM-20573](https://issues.civicrm.org/jira/browse/CRM-20573) User
  deprecated function: Deprecated function on View Participant form
  ([10356](https://github.com/civicrm/civicrm-core/pull/10356))**

  Removes use of deprecated `CRM_Core_OptionGroup::getValue()` method on View
  Participant form.

- **Add me to contributor-key.yml
  ([10342](https://github.com/civicrm/civicrm-core/pull/10342))**

- **Add Karen Stevenson to contributor-key.yml
  ([10345](https://github.com/civicrm/civicrm-core/pull/10345))**

- **NFC remove some unused variables.
  ([10314](https://github.com/civicrm/civicrm-core/pull/10314))**

- **[CRM-20515](https://issues.civicrm.org/jira/browse/CRM-20515) notice errors
  on dmaster for add petition
  ([10296](https://github.com/civicrm/civicrm-core/pull/10296))**

  Removes use of deprecated `CRM_Core_OptionGroup::getValue()` method on the
  Petition creation and editing form.

- **Up the deprecation on old hook
  ([10292](https://github.com/civicrm/civicrm-core/pull/10292))**

  If extensions invoke the deprecated `CRM_Utils_Hook::alterMail()` hook, a log
  entry is created explaining that it is deprecated.

- **Fix test cleanup to turn tax & invoicing off after the test.
  ([10286](https://github.com/civicrm/civicrm-core/pull/10286))**

- **Fix merge conflict
  ([10268](https://github.com/civicrm/civicrm-core/pull/10268))**

- **Remove unused var. emailActivityTypeIDs is retrieved twice, statusTitle
  never used ([10263](https://github.com/civicrm/civicrm-core/pull/10263))**

- **Minor code tidy ups.
  ([10226](https://github.com/civicrm/civicrm-core/pull/10226))**

- **[CRM-20453](https://issues.civicrm.org/jira/browse/CRM-20453) Fix
  inconsistencies in XML schema definitions
  ([10195](https://github.com/civicrm/civicrm-core/pull/10195))**

- **typo in error message
  ([181](https://github.com/civicrm/civicrm-packages/pull/181))**

- **[CRM-19643](https://issues.civicrm.org/jira/browse/CRM-19643) Remove unused
  reference to "selectedSearchContactIds"
  ([10272](https://github.com/civicrm/civicrm-core/pull/10272))**

- **[CRM-16460](https://issues.civicrm.org/jira/browse/CRM-16460) PayPal
  Standard needs two digits of cents
  ([10287](https://github.com/civicrm/civicrm-core/pull/10287)) (non-functional
  comments only)**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Australian Greens - Seamus Lee; Blackfly Solutions -
Alan Dixon; British Humanist Association - Andrew West; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Yashodha Chaku; CiviFirst - John Kirk; Coop SymbioTIC -
Mathieu Lutfy; Francesc Bassas i Bullich; Fuzion - Chris Burgess, Eileen
McNaughton, Jitendra Purohit; Ginkgo Street Labs - Frank Gómez; Greenleaf
Advancement - Karen Stevenson; JMA Consulting - Monish Deb, Pradeep Nayak;
Joinery - Allen Shaw; Jon Goldberg; Lemniscus - Noah Miller; Lighthouse Design
and Consulting - Brian Shaughnessy; Michael Hurwicz; Neuwald Tecnologia da
Informação - Arthur Almeida; Progressive Technology Project - Jamie McClelland;
Saurabh Batra; Sean Madsen; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; Alcohol Justice - Bruce Wolfe; Andrew
Cormick-Dockery; Anthony Borrow; BackOffice Thinking - Dave Schafer; Botanical
Society of America - Rob Brandt; Cath O'Connell; Circle Interactive - Dave
Jenkins; CivicActions - Fen Labalme; CiviCoop - Erik Hommel; CompuCorp -
Guanhuan Chen; Coop SymbioTIC - Samuel Vanhove; Dave Greenberg; Debre-Genet Holy
Trinity Ethiopian Orthodox Tewahedo Church - Milli Aje; DevMate - Adam
Kwiatkowski; DignityUSA - Logan Bear; Effy Elden; Electronic Frontier Foundation -
Mark Burdett; Ergon Logic Enterprises - Christopher Gervais; Emanuele Santanchè;
Fuzion - Peter Davis; JMA Consulting - Edsel Lopez, Joe Murray; Joanne Chester;
Johan Vervloet; John Kingsnorth; Kevin Reynen; Kompetenzzentrum
Technik-Diversity-Chancengleichheit - Niels Heinemann; Korlon - Stuart Gaston;
Marc Brazeau; Mathieu; MC3 - Graham Mitchell; MJW Consulting - Matthew Wire;
Nathan Brettell; Rareș Pamfil; Redfin Solutions - Chris Wells, Patrick Corbett;
Registered Nurses' Association of Ontario - Thomas Mannell; Richard van
Oosterhout; Semper IT - Karin Gerritsen; Serge Lachapelle; Third Sector Design -
Michael McAndrew; Third Sun - Troy Mumm; Thomas Bacon; Web Access - Kurund Jalmi
