#!/bin/sh
#
# Script to generate $C_FILE
#

ECHO=/usr/bin/printf
SED=/bin/sed

#MINUS_e=X`$ECHO -n -e`
#if [ $MINUS_e != "X" ] ; then
#	MINUS_e=""
#else
#	MINUS_e="-e"
#fi

#MINUS_E=X`$ECHO -n -E`
#if [ $MINUS_E != "X" ] ; then
#	MINUS_E=""
#else
#	MINUS_E="-E"
#fi


CUR_DIR=`pwd`
C_FILE="$CUR_DIR/modules_init.c"
H_FILE="$CUR_DIR/modules_init.h"
MOD_FILE="$CUR_DIR/Make_modules"
SRC_FILE="$CUR_DIR/Make_sources"
U_FILE="$CUR_DIR/modules_upgrade.c"

/usr/bin/printf "Scanning extension modules for entry points.\n"

STATIC_FIRST_MODULES="control modules euidindex msgbase nttlist database"
DYNAMIC_MODULES=`grep CTDL_MODULE_INIT modules/*/*.c |$SED 's;.*(\(.*\));\1;'`
if test -d user_modules; then 
    USER_MODULES=`grep CTDL_MODULE_INIT user_modules/*/*.c |$SED 's;.*(\(.*\));\1;'`
else
    USER_MODULES=
fi
STATIC_LAST_MODULES="netconfig"

###############################################################################
#                        start the c file                                     #
###############################################################################

cat <<EOF  >$C_FILE
/*
 * $C_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */



#include "sysdep.h"
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <libcitadel.h>
#include "citadel.h"
#include "modules_init.h"
#include "sysdep_decls.h"
#include "serv_extensions.h"


void LogPrintMessages(long err);
extern long DetailErrorFlags;

void initialise_modules (int threading)
{
    long filter;
    const char *pMod;

    syslog(LOG_DEBUG, "modules: initializing, CtdlThreads %s", (threading ? "enabled" : "not yet enabled"));

EOF


for i in ${STATIC_FIRST_MODULES} ${DYNAMIC_MODULES} ${USER_MODULES} ${STATIC_LAST_MODULES}; do 
cat <<EOF >> $C_FILE
	pMod = CTDL_INIT_CALL($i);
	syslog(LOG_DEBUG, "modules: loaded %s", pMod);
EOF

done
cat <<EOF >> $C_FILE

	for (filter = 1; filter != 0; filter = filter << 1)
		if ((filter & DetailErrorFlags) != 0)
			LogPrintMessages(filter);
}

EOF





###############################################################################
#                        start the header file                                #
###############################################################################
cat <<EOF > $H_FILE
/* 
 * $H_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */


#ifndef MODULES_INIT_H
#define MODULES_INIT_H
#include "ctdl_module.h"
extern size_t nSizErrmsg;
void initialise_modules (int threading);
void upgrade_modules(void);

EOF

for i in ${STATIC_FIRST_MODULES} ${DYNAMIC_MODULES} ${USER_MODULES} ${STATIC_LAST_MODULES}; do 
# Add this entry point to the .h file
cat <<EOF >> $H_FILE
	CTDL_MODULE_INIT($i);
EOF
done

grep CTDL_MODULE_UPGRADE *.c modules/*/*.c  |$SED 's;.*(\(.*\));\CTDL_MODULE_UPGRADE(\1)\;\n;' >> $H_FILE

cat <<EOF >> $H_FILE


#endif /* MODULES_INIT_H */

EOF


###############################################################################
#             u start the Makefile included file for $SERV_MODULES            #
###############################################################################
cat <<EOF  >$MOD_FILE
#
# Make_modules
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

SERV_MODULES = \\
EOF

echo modules/*/*.c | $SED -e "s;\.c ;.o \\\\\n;g" -e "s;\.c;.o;" >> $MOD_FILE
echo >> $MOD_FILE


###############################################################################
#       start of the files which inturn removes any existing file             #
###############################################################################


# start the Makefile included file for $SOURCES
cat <<EOF  >$SRC_FILE
#
# Make_sources
# This file is to be included by Makefile to dynamically add modules to the build process
# THIS FILE WAS AUTO GENERATED BY mk_modules_init.sh DO NOT EDIT THIS FILE
#

SOURCES = \\
EOF

echo modules/*/*.c | $SED "s;\.c ;.c \\\\\n;g" >> $SRC_FILE
echo >> $SRC_FILE



###############################################################################
#                     start the upgrade file                                  #
###############################################################################
cat <<EOF  >$U_FILE
/*
 * $U_FILE
 * Auto generated by mk_modules_init.sh DO NOT EDIT THIS FILE
 */



#include "sysdep.h"
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <libcitadel.h>
#include "citadel.h"
#include "modules_init.h"
#include "sysdep_decls.h"
#include "serv_extensions.h"



void upgrade_modules (void)
{
        const char *pMod;

        syslog(LOG_INFO, "modules: upgrading.");

EOF

# Add this entry point to the .c file

grep CTDL_MODULE_UPGRADE *.c modules/*/*.c  |$SED 's;.*(\(.*\));\tpMod = CTDL_UPGRADE_CALL(\1)\;\n\tsyslog(LOG_INFO, "modules: %s\\n", pMod)\;\n;' >> $U_FILE

#close the upgrade file
/usr/bin/printf "}\n" >> $U_FILE
